/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class ImportIdentificationTask
extends AbstractJMSTask {
    private String m_parserId;
    private HashMap<String, String> m_parserArguments;
    private String m_filePath;
    private String m_decoyRegex;
    private long m_instrumentId;
    private long m_peaklistSoftwareId;
    private long m_projectId;
    private long m_fragmentRuleSetId;
    private boolean m_saveSpectrumMatches;
    private Long[] m_resultSetId = null;

    public ImportIdentificationTask(AbstractJMSCallback callback, String parserId, HashMap<String, String> parserArguments, String filePath, String decoyRegex, long instrumentId, long peaklistSoftwareId, boolean saveSpectrumMatches, long fragmRuleSetId, long projectId, Long[] resultSetId) {
        super(callback, new TaskInfo("Import Identification " + filePath, true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_parserId = parserId;
        this.m_parserArguments = parserArguments;
        this.m_filePath = filePath;
        this.m_decoyRegex = decoyRegex;
        this.m_instrumentId = instrumentId;
        this.m_peaklistSoftwareId = peaklistSoftwareId;
        this.m_saveSpectrumMatches = saveSpectrumMatches;
        this.m_projectId = projectId;
        this.m_resultSetId = resultSetId;
        this.m_fragmentRuleSetId = fragmRuleSetId;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", "proline/dps/msi/ImportResultFiles");
        this.addSupplementaryInfo((Message)message, this.m_projectId);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("ImportIdentificationTask Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("project_id", this.m_projectId);
        ArrayList args = new ArrayList();
        HashMap<String, String> resultfile = new HashMap<String, String>();
        resultfile.put("path", this.m_filePath);
        resultfile.put("format", this.m_parserId);
        if (this.m_decoyRegex != null) {
            resultfile.put("decoy_strategy", this.m_decoyRegex);
        }
        args.add(resultfile);
        params.put("result_files", args);
        params.put("instrument_config_id", this.m_instrumentId);
        params.put("peaklist_software_id", this.m_peaklistSoftwareId);
        if (this.m_fragmentRuleSetId > 0L) {
            params.put("fragmentation_rule_set_id", this.m_fragmentRuleSetId);
        }
        params.put("save_spectrum_matches", this.m_saveSpectrumMatches);
        params.put("importer_properties", this.m_parserArguments);
        return params;
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            Object result = jsonResponse.getResult();
            if (result == null || !ArrayList.class.isInstance(result)) {
                m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No returned values");
                throw new Exception("Invalid result " + result);
            }
            ArrayList returnedValues = (ArrayList)result;
            HashMap returnedValuesMap = (HashMap)returnedValues.get(0);
            Long resultSetIdBD = (Long)returnedValuesMap.get("target_result_set_id");
            if (resultSetIdBD == null) {
                m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No returned ResultSet Id");
                throw new Exception("Import result error : No returned ResultSet Id");
            }
            this.m_resultSetId[0] = resultSetIdBD;
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }
}

