/*
 * Decompiled with CFR 0.152.
 */
package org.forester.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.forester.analysis.AncestralTaxonomyInferenceException;
import org.forester.analysis.TaxonomyDataManager;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;
import org.forester.ws.seqdb.UniProtTaxonomy;

public final class AncestralTaxonomyInference {
    public static void inferTaxonomyFromDescendents(Phylogeny phy) throws IOException, AncestralTaxonomyInferenceException {
        TaxonomyDataManager.clearCachesIfTooLarge();
        PhylogenyNodeIterator iter = phy.iteratorPostorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (node.isExternal()) continue;
            AncestralTaxonomyInference.inferTaxonomyFromDescendents(node);
        }
    }

    private static void inferTaxonomyFromDescendents(PhylogenyNode n) throws IOException, AncestralTaxonomyInferenceException {
        if (n.isExternal()) {
            throw new IllegalArgumentException("attempt to infer taxonomy from descendants of external node");
        }
        n.getNodeData().setTaxonomy(null);
        List<PhylogenyNode> descs = n.getDescendants();
        ArrayList<String[]> lineages = new ArrayList<String[]>();
        int shortest_lin_length = Integer.MAX_VALUE;
        for (PhylogenyNode desc : descs) {
            if (!(!desc.getNodeData().isHasTaxonomy() || !TaxonomyDataManager.isHasAppropriateId(desc.getNodeData().getTaxonomy()) && ForesterUtil.isEmpty(desc.getNodeData().getTaxonomy().getScientificName()) && ForesterUtil.isEmpty(desc.getNodeData().getTaxonomy().getLineage()) && ForesterUtil.isEmpty(desc.getNodeData().getTaxonomy().getTaxonomyCode()) && ForesterUtil.isEmpty(desc.getNodeData().getTaxonomy().getCommonName()))) {
                UniProtTaxonomy up_tax = TaxonomyDataManager.obtainUniProtTaxonomy(desc.getNodeData().getTaxonomy(), null, null);
                if (up_tax == null && ForesterUtil.isEmpty(desc.getNodeData().getTaxonomy().getLineage())) {
                    String desc_str = "";
                    desc_str = !ForesterUtil.isEmpty(desc.getName()) ? "\"" + desc.getName() + "\"" : "[" + desc.getId() + "]";
                    System.out.println(desc.getNodeData().getTaxonomy().toString());
                    System.out.println(ForesterUtil.stringListToString(desc.getNodeData().getTaxonomy().getLineage(), "  >  "));
                    throw new AncestralTaxonomyInferenceException("a taxonomy for node " + desc_str + " could not be established from the database");
                }
                String[] lineage = ForesterUtil.stringListToArray(desc.getNodeData().getTaxonomy().getLineage());
                if (lineage == null || lineage.length < 1) {
                    lineage = ForesterUtil.stringListToArray(up_tax.getLineage());
                }
                if (lineage == null || lineage.length < 1) {
                    throw new AncestralTaxonomyInferenceException("a taxonomic lineage for node \"" + desc.getNodeData().getTaxonomy().toString() + "\" could not be established");
                }
                if (lineage.length < shortest_lin_length) {
                    shortest_lin_length = lineage.length;
                }
                lineages.add(lineage);
                continue;
            }
            String node = "";
            node = !ForesterUtil.isEmpty(desc.getName()) ? "\"" + desc.getName() + "\"" : "[" + desc.getId() + "]";
            throw new AncestralTaxonomyInferenceException("node " + node + " has no or inappropriate taxonomic information");
        }
        ArrayList<String> last_common_lineage = new ArrayList<String>();
        String last_common = null;
        if (shortest_lin_length > 0) {
            block3: for (int i = 0; i < shortest_lin_length; ++i) {
                String lineage_0 = ((String[])lineages.get(0))[i];
                for (int j = 1; j < lineages.size(); ++j) {
                    if (!lineage_0.equals(((String[])lineages.get(j))[i])) break block3;
                }
                last_common_lineage.add(lineage_0);
                last_common = lineage_0;
            }
        }
        if (last_common_lineage.isEmpty()) {
            boolean saw_viruses = false;
            boolean saw_cellular_organism = false;
            boolean saw_x = false;
            for (String[] lineage : lineages) {
                if (lineage.length <= 0) continue;
                if (lineage[0].equalsIgnoreCase("Viruses")) {
                    saw_viruses = true;
                } else if (lineage[0].equalsIgnoreCase("cellular organisms")) {
                    saw_cellular_organism = true;
                } else if (lineage[0].equalsIgnoreCase("x")) {
                    saw_x = true;
                }
                if ((!saw_cellular_organism || !saw_viruses) && !saw_x) continue;
                break;
            }
            if (saw_cellular_organism && saw_viruses || saw_x) {
                last_common_lineage.add("x");
                last_common = "x";
            } else {
                String msg = "no common lineage for:\n";
                int counter = 0;
                for (String[] strings : lineages) {
                    msg = msg + counter + ": ";
                    ++counter;
                    for (String string : strings) {
                        msg = msg + string + " ";
                    }
                    msg = msg + "\n";
                }
                throw new AncestralTaxonomyInferenceException(msg);
            }
        }
        Taxonomy tax = new Taxonomy();
        n.getNodeData().setTaxonomy(tax);
        tax.setScientificName(last_common);
        UniProtTaxonomy up_tax = TaxonomyDataManager.obtainUniProtTaxonomyFromLineage(last_common_lineage);
        if (up_tax != null) {
            if (!ForesterUtil.isEmpty(up_tax.getRank())) {
                try {
                    tax.setRank(up_tax.getRank().toLowerCase());
                }
                catch (PhyloXmlDataFormatException ex) {
                    tax.setRank("");
                }
            }
            if (!ForesterUtil.isEmpty(up_tax.getId())) {
                tax.setIdentifier(new Identifier(up_tax.getId(), "uniprot"));
            }
            if (!ForesterUtil.isEmpty(up_tax.getCommonName())) {
                tax.setCommonName(up_tax.getCommonName());
            }
            if (!ForesterUtil.isEmpty(up_tax.getSynonym()) && !tax.getSynonyms().contains(up_tax.getSynonym())) {
                tax.getSynonyms().add(up_tax.getSynonym());
            }
            if (up_tax.getLineage() != null) {
                tax.setLineage(new ArrayList<String>());
                for (String lin : up_tax.getLineage()) {
                    if (ForesterUtil.isEmpty(lin)) continue;
                    tax.getLineage().add(lin);
                }
            }
        }
        if (ForesterUtil.isEmpty(tax.getLineage())) {
            tax.setLineage(new ArrayList<String>());
            for (String lin : last_common_lineage) {
                if (ForesterUtil.isEmpty(lin)) continue;
                tax.getLineage().add(lin);
            }
        }
        for (PhylogenyNode desc : descs) {
            if (desc.isExternal() || !desc.getNodeData().isHasTaxonomy() || !desc.getNodeData().getTaxonomy().isEqual(tax)) continue;
            desc.getNodeData().setTaxonomy(null);
        }
    }
}

