/*
 * Decompiled with CFR 0.152.
 */
package org.forester.analysis;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import javax.swing.JOptionPane;
import org.forester.analysis.AncestralTaxonomyInferenceException;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.tools.AncestralTaxonomyInferrer;
import org.forester.archaeopteryx.tools.RunnableProcess;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;
import org.forester.util.TaxonomyUtil;
import org.forester.ws.seqdb.SequenceDbWsTools;
import org.forester.ws.seqdb.UniProtTaxonomy;

public final class TaxonomyDataManager
extends RunnableProcess {
    private static final int MAX_CACHE_SIZE = 100000;
    private static final int MAX_TAXONOMIES_TO_RETURN = 2000;
    private static final HashMap<String, UniProtTaxonomy> _sn_up_cache_map = new HashMap();
    private static final HashMap<String, UniProtTaxonomy> _lineage_up_cache_map = new HashMap();
    private static final HashMap<String, UniProtTaxonomy> _code_up_cache_map = new HashMap();
    private static final HashMap<String, UniProtTaxonomy> _cn_up_cache_map = new HashMap();
    private static final HashMap<String, UniProtTaxonomy> _id_up_cache_map = new HashMap();
    private final Phylogeny _phy;
    private final MainFrameApplication _mf;
    private final TreePanel _treepanel;
    private final boolean _delete;
    private final boolean _allow_simple_names;

    public TaxonomyDataManager(MainFrameApplication mf, TreePanel treepanel, Phylogeny phy) {
        this._phy = phy;
        this._mf = mf;
        this._treepanel = treepanel;
        this._delete = false;
        this._allow_simple_names = false;
    }

    public TaxonomyDataManager(MainFrameApplication mf, TreePanel treepanel, Phylogeny phy, boolean delete, boolean allow_simple_name) {
        this._phy = phy;
        this._mf = mf;
        this._treepanel = treepanel;
        this._delete = delete;
        this._allow_simple_names = allow_simple_name;
    }

    static synchronized void clearCachesIfTooLarge() {
        if (TaxonomyDataManager.getSnTaxCacheMap().size() > 100000) {
            TaxonomyDataManager.getSnTaxCacheMap().clear();
        }
        if (TaxonomyDataManager.getLineageTaxCacheMap().size() > 100000) {
            TaxonomyDataManager.getLineageTaxCacheMap().clear();
        }
        if (TaxonomyDataManager.getCnTaxCacheMap().size() > 100000) {
            TaxonomyDataManager.getCnTaxCacheMap().clear();
        }
        if (TaxonomyDataManager.getCodeTaxCacheMap().size() > 100000) {
            TaxonomyDataManager.getCodeTaxCacheMap().clear();
        }
        if (TaxonomyDataManager.getIdTaxCacheMap().size() > 100000) {
            TaxonomyDataManager.getIdTaxCacheMap().clear();
        }
    }

    static final synchronized HashMap<String, UniProtTaxonomy> getCnTaxCacheMap() {
        return _cn_up_cache_map;
    }

    static final synchronized HashMap<String, UniProtTaxonomy> getCodeTaxCacheMap() {
        return _code_up_cache_map;
    }

    static final synchronized HashMap<String, UniProtTaxonomy> getIdTaxCacheMap() {
        return _id_up_cache_map;
    }

    static final synchronized HashMap<String, UniProtTaxonomy> getLineageTaxCacheMap() {
        return _lineage_up_cache_map;
    }

    static final synchronized HashMap<String, UniProtTaxonomy> getSnTaxCacheMap() {
        return _sn_up_cache_map;
    }

    private static final UniProtTaxonomy obtainTaxonomy(HashMap<String, UniProtTaxonomy> cache, Object query, QUERY_TYPE qt) throws IOException, AncestralTaxonomyInferenceException {
        if (cache.containsKey(query)) {
            return cache.get(query).copy();
        }
        List<UniProtTaxonomy> up_taxonomies = null;
        switch (qt) {
            case ID: {
                up_taxonomies = TaxonomyDataManager.getTaxonomiesFromId((String)query);
                break;
            }
            case CODE: {
                up_taxonomies = TaxonomyDataManager.getTaxonomiesFromTaxonomyCode((String)query);
                break;
            }
            case SN: {
                up_taxonomies = TaxonomyDataManager.getTaxonomiesFromScientificName((String)query);
                break;
            }
            case CN: {
                up_taxonomies = TaxonomyDataManager.getTaxonomiesFromCommonName((String)query);
                break;
            }
            case LIN: {
                return TaxonomyDataManager.obtainUniProtTaxonomyFromLineage((List)query);
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (up_taxonomies != null && up_taxonomies.size() == 1) {
            UniProtTaxonomy up_tax = up_taxonomies.get(0);
            if (!ForesterUtil.isEmpty(up_tax.getScientificName())) {
                TaxonomyDataManager.getSnTaxCacheMap().put(up_tax.getScientificName(), up_tax);
            }
            if (!ForesterUtil.isEmpty(up_tax.getCode())) {
                TaxonomyDataManager.getCodeTaxCacheMap().put(up_tax.getCode(), up_tax);
            }
            if (!ForesterUtil.isEmpty(up_tax.getCommonName())) {
                TaxonomyDataManager.getCnTaxCacheMap().put(up_tax.getCommonName(), up_tax);
            }
            if (!ForesterUtil.isEmpty(up_tax.getId())) {
                TaxonomyDataManager.getIdTaxCacheMap().put(up_tax.getId(), up_tax);
            }
            return up_tax;
        }
        return null;
    }

    private static final List<UniProtTaxonomy> getTaxonomiesFromCommonName(String query) throws IOException {
        return SequenceDbWsTools.getTaxonomiesFromCommonNameStrict(query, 2000);
    }

    private static final List<UniProtTaxonomy> getTaxonomiesFromId(String query) throws IOException {
        return SequenceDbWsTools.getTaxonomiesFromId(query, 2000);
    }

    private static final List<UniProtTaxonomy> getTaxonomiesFromScientificName(String query) throws IOException {
        if (query.equalsIgnoreCase("Bacteria") || query.equalsIgnoreCase("Archaea") || query.equalsIgnoreCase("Viruses") || query.equalsIgnoreCase("Eukaryota") || query.equalsIgnoreCase("x")) {
            ArrayList<UniProtTaxonomy> l = new ArrayList<UniProtTaxonomy>();
            l.add(UniProtTaxonomy.createSpecialFromScientificName(query));
            return l;
        }
        return SequenceDbWsTools.getTaxonomiesFromScientificNameStrict(query, 2000);
    }

    private static final List<UniProtTaxonomy> getTaxonomiesFromTaxonomyCode(String query) throws IOException {
        if (query.indexOf("XX") == 3 && TaxonomyUtil.isHasTaxIdFromFakeTaxCode(query) || query.equals("SPHAR")) {
            int id = TaxonomyUtil.getTaxIdFromFakeTaxCode(query);
            return SequenceDbWsTools.getTaxonomiesFromId(String.valueOf(id), 2000);
        }
        return SequenceDbWsTools.getTaxonomiesFromTaxonomyCode(query, 2000);
    }

    static final boolean isHasAppropriateId(Taxonomy tax) {
        return tax.getIdentifier() != null && !ForesterUtil.isEmpty(tax.getIdentifier().getValue()) && (tax.getIdentifier().getProvider().equalsIgnoreCase("ncbi") || tax.getIdentifier().getProvider().equalsIgnoreCase("uniprot") || tax.getIdentifier().getProvider().equalsIgnoreCase("uniprotkb"));
    }

    private static final synchronized SortedSet<String> obtainDetailedTaxonomicInformation(Phylogeny phy, boolean delete, boolean allow_to_use_basic_node_names) throws IOException, AncestralTaxonomyInferenceException {
        TaxonomyDataManager.clearCachesIfTooLarge();
        TreeSet<String> not_found = new TreeSet<String>();
        ArrayList<PhylogenyNode> not_found_external_nodes = null;
        if (delete) {
            not_found_external_nodes = new ArrayList<PhylogenyNode>();
        }
        PhylogenyNodeIterator iter = phy.iteratorPostorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            QUERY_TYPE qt = null;
            Taxonomy tax = null;
            if (node.getNodeData().isHasTaxonomy()) {
                tax = node.getNodeData().getTaxonomy();
            } else if ((!allow_to_use_basic_node_names || ForesterUtil.isEmpty(node.getName())) && node.isExternal()) {
                if (!ForesterUtil.isEmpty(node.getName())) {
                    not_found.add(node.getName());
                } else {
                    not_found.add(node.toString());
                }
                if (delete) {
                    not_found_external_nodes.add(node);
                }
            }
            UniProtTaxonomy uniprot_tax = null;
            if ((tax == null || !TaxonomyDataManager.isHasAppropriateId(tax) && ForesterUtil.isEmpty(tax.getScientificName()) && ForesterUtil.isEmpty(tax.getTaxonomyCode()) && ForesterUtil.isEmpty(tax.getCommonName())) && (!allow_to_use_basic_node_names || ForesterUtil.isEmpty(node.getName()))) continue;
            uniprot_tax = tax != null && (TaxonomyDataManager.isHasAppropriateId(tax) || !ForesterUtil.isEmpty(tax.getScientificName()) || !ForesterUtil.isEmpty(tax.getTaxonomyCode()) || !ForesterUtil.isEmpty(tax.getCommonName())) ? TaxonomyDataManager.obtainUniProtTaxonomy(tax, null, qt) : TaxonomyDataManager.obtainUniProtTaxonomy(node.getName(), qt);
            if (uniprot_tax != null) {
                if (tax == null) {
                    tax = new Taxonomy();
                    node.getNodeData().addTaxonomy(tax);
                }
                TaxonomyDataManager.updateTaxonomy(qt, node, tax, uniprot_tax);
                continue;
            }
            if (tax != null) {
                not_found.add(tax.toString());
            } else {
                not_found.add(node.getName());
            }
            if (!delete || !node.isExternal()) continue;
            not_found_external_nodes.add(node);
        }
        if (delete) {
            for (PhylogenyNode node : not_found_external_nodes) {
                phy.deleteSubtree(node, true);
            }
            phy.externalNodesHaveChanged();
            phy.clearHashIdToNodeMap();
            phy.recalculateNumberOfExternalDescendants(true);
        }
        return not_found;
    }

    public static final UniProtTaxonomy obtainUniProtTaxonomy(Taxonomy tax, Object query, QUERY_TYPE qt) throws IOException, AncestralTaxonomyInferenceException {
        if (tax == null) {
            throw new IllegalArgumentException("illegal attempt to use empty taxonomy object");
        }
        if (TaxonomyDataManager.isHasAppropriateId(tax)) {
            query = tax.getIdentifier().getValue();
            qt = QUERY_TYPE.ID;
            return TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getIdTaxCacheMap(), query, qt);
        }
        if (!ForesterUtil.isEmpty(tax.getScientificName())) {
            if (!ForesterUtil.isEmpty(tax.getLineage())) {
                query = tax.getLineage();
                qt = QUERY_TYPE.LIN;
                return TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getLineageTaxCacheMap(), query, qt);
            }
            query = tax.getScientificName();
            qt = QUERY_TYPE.SN;
            return TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getSnTaxCacheMap(), query, qt);
        }
        if (!ForesterUtil.isEmpty(tax.getTaxonomyCode())) {
            query = tax.getTaxonomyCode();
            qt = QUERY_TYPE.CODE;
            return TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getCodeTaxCacheMap(), query, qt);
        }
        query = tax.getCommonName();
        qt = QUERY_TYPE.CN;
        return TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getCnTaxCacheMap(), query, qt);
    }

    public static final UniProtTaxonomy obtainUniProtTaxonomy(String simple_name, QUERY_TYPE qt) throws IOException, AncestralTaxonomyInferenceException {
        String id;
        String sn;
        if (ForesterUtil.isEmpty(simple_name)) {
            throw new IllegalArgumentException("illegal attempt to use empty simple name");
        }
        UniProtTaxonomy ut = null;
        String code = ParserUtils.extractTaxonomyCodeFromNodeName(simple_name, NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
        if (!ForesterUtil.isEmpty(code)) {
            qt = QUERY_TYPE.CODE;
            ut = TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getCodeTaxCacheMap(), code, qt);
        }
        if (ut == null && !ForesterUtil.isEmpty(sn = ParserUtils.extractScientificNameFromNodeName(simple_name))) {
            qt = QUERY_TYPE.SN;
            ut = TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getSnTaxCacheMap(), sn, qt);
        }
        if (ut == null && !ForesterUtil.isEmpty(id = ParserUtils.extractUniprotTaxonomyIdFromNodeName(simple_name, NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_RELAXED))) {
            qt = QUERY_TYPE.ID;
            ut = TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getIdTaxCacheMap(), id, qt);
        }
        if (ut == null) {
            sn = "";
            Matcher m = ParserUtils.TAXOMONY_SN_PATTERN_GENUS.matcher(simple_name);
            if (m.matches()) {
                sn = m.group(1);
            }
            if (!ForesterUtil.isEmpty(sn)) {
                qt = QUERY_TYPE.SN;
                ut = TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getSnTaxCacheMap(), sn, qt);
            }
        }
        return ut;
    }

    static final UniProtTaxonomy obtainUniProtTaxonomyFromLineage(List<String> lineage) throws AncestralTaxonomyInferenceException, IOException {
        String lineage_str = ForesterUtil.stringListToString(lineage, ">");
        if (TaxonomyDataManager.getLineageTaxCacheMap().containsKey(lineage_str)) {
            return TaxonomyDataManager.getLineageTaxCacheMap().get(lineage_str).copy();
        }
        ArrayList<UniProtTaxonomy> matching_taxonomies = new ArrayList<UniProtTaxonomy>();
        List<UniProtTaxonomy> up_taxonomies = TaxonomyDataManager.getTaxonomiesFromScientificName(lineage.get(lineage.size() - 1));
        if (up_taxonomies != null && up_taxonomies.size() > 0) {
            for (UniProtTaxonomy up_taxonomy : up_taxonomies) {
                boolean match = true;
                for (int i = 0; i < lineage.size(); ++i) {
                    if (i != up_taxonomy.getLineage().size() && lineage.get(i).equalsIgnoreCase(up_taxonomy.getLineage().get(i))) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                matching_taxonomies.add(up_taxonomy);
            }
            if (matching_taxonomies.isEmpty()) {
                throw new AncestralTaxonomyInferenceException("lineage \"" + ForesterUtil.stringListToString(lineage, " > ") + "\" not found");
            }
            int shortest = Integer.MAX_VALUE;
            UniProtTaxonomy least_specific_up_tax = null;
            for (UniProtTaxonomy m : matching_taxonomies) {
                int s = m.getLineage().size();
                if (s >= shortest) continue;
                shortest = s;
                least_specific_up_tax = m;
            }
            TaxonomyDataManager.getLineageTaxCacheMap().put(lineage_str, least_specific_up_tax);
            if (!ForesterUtil.isEmpty(least_specific_up_tax.getScientificName())) {
                TaxonomyDataManager.getSnTaxCacheMap().put(least_specific_up_tax.getScientificName(), least_specific_up_tax);
            }
            if (!ForesterUtil.isEmpty(least_specific_up_tax.getCode())) {
                TaxonomyDataManager.getCodeTaxCacheMap().put(least_specific_up_tax.getCode(), least_specific_up_tax);
            }
            if (!ForesterUtil.isEmpty(least_specific_up_tax.getCommonName())) {
                TaxonomyDataManager.getCnTaxCacheMap().put(least_specific_up_tax.getCommonName(), least_specific_up_tax);
            }
            if (!ForesterUtil.isEmpty(least_specific_up_tax.getId())) {
                TaxonomyDataManager.getIdTaxCacheMap().put(least_specific_up_tax.getId(), least_specific_up_tax);
            }
            return least_specific_up_tax;
        }
        throw new AncestralTaxonomyInferenceException("taxonomy \"" + lineage.get(lineage.size() - 1) + "\" not found");
    }

    private static final synchronized void updateTaxonomy(QUERY_TYPE qt, PhylogenyNode node, Taxonomy tax, UniProtTaxonomy up_tax) throws PhyloXmlDataFormatException {
        if (qt != QUERY_TYPE.SN && !ForesterUtil.isEmpty(up_tax.getScientificName()) && ForesterUtil.isEmpty(tax.getScientificName())) {
            tax.setScientificName(up_tax.getScientificName());
        }
        if (node.isExternal() && qt != QUERY_TYPE.CODE && !ForesterUtil.isEmpty(up_tax.getCode()) && ForesterUtil.isEmpty(tax.getTaxonomyCode())) {
            tax.setTaxonomyCode(up_tax.getCode());
        }
        if (qt != QUERY_TYPE.CN && !ForesterUtil.isEmpty(up_tax.getCommonName()) && ForesterUtil.isEmpty(tax.getCommonName())) {
            tax.setCommonName(up_tax.getCommonName());
        }
        if (!ForesterUtil.isEmpty(up_tax.getSynonym()) && !tax.getSynonyms().contains(up_tax.getSynonym())) {
            tax.getSynonyms().add(up_tax.getSynonym());
        }
        if (!ForesterUtil.isEmpty(up_tax.getRank()) && ForesterUtil.isEmpty(tax.getRank())) {
            try {
                tax.setRank(up_tax.getRank().toLowerCase());
            }
            catch (PhyloXmlDataFormatException ex) {
                tax.setRank("");
            }
        }
        if (qt != QUERY_TYPE.ID && !ForesterUtil.isEmpty(up_tax.getId()) && (tax.getIdentifier() == null || ForesterUtil.isEmpty(tax.getIdentifier().getValue()))) {
            tax.setIdentifier(new Identifier(up_tax.getId(), "uniprot"));
        }
        if (up_tax.getLineage() != null) {
            tax.setLineage(new ArrayList<String>());
            for (String lin : up_tax.getLineage()) {
                if (ForesterUtil.isEmpty(lin)) continue;
                tax.getLineage().add(lin);
            }
        }
    }

    private final void execute() {
        this.start(this._mf, "taxonomy data");
        SortedSet<String> not_found = null;
        try {
            not_found = TaxonomyDataManager.obtainDetailedTaxonomicInformation(this._phy, this._delete, this._allow_simple_names);
        }
        catch (UnknownHostException e) {
            JOptionPane.showMessageDialog(this._mf, "Could not connect to \"" + this.getBaseUrl() + "\"", "Network error during taxonomic information gathering", 0);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this._mf, e.toString(), "Failed to obtain taxonomic information", 0);
            return;
        }
        catch (AncestralTaxonomyInferenceException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this._mf, e.toString(), "Failed to obtain taxonomic information", 0);
            return;
        }
        finally {
            this.end(this._mf);
        }
        if (this._phy == null || this._phy.isEmpty()) {
            try {
                JOptionPane.showMessageDialog(this._mf, "None of the external node taxonomies could be resolved", "Taxonomy Tool Failed", 2);
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        this._treepanel.setTree(this._phy);
        this._mf.showWhole();
        this._treepanel.setEdited(true);
        if (not_found != null && not_found.size() > 0) {
            int max = not_found.size();
            boolean more = false;
            if (max > 20) {
                more = true;
                max = 20;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Not all taxonomies could be resolved.\n");
            if (not_found.size() == 1) {
                if (this._delete) {
                    sb.append("The following taxonomy was not found and deleted (if external):\n");
                } else {
                    sb.append("The following taxonomy was not found:\n");
                }
            } else if (this._delete) {
                sb.append("The following taxonomies were not found and deleted (if external) (total: " + not_found.size() + "):\n");
            } else {
                sb.append("The following taxonomies were not found (total: " + not_found.size() + "):\n");
            }
            int i = 0;
            for (String string : not_found) {
                if (i > 19) break;
                sb.append(string);
                sb.append("\n");
                ++i;
            }
            if (more) {
                sb.append("...");
            }
            try {
                JOptionPane.showMessageDialog(this._mf, sb.toString(), "Taxonomy Tool Completed", 2);
            }
            catch (Exception exception) {}
        } else {
            try {
                JOptionPane.showMessageDialog(this._mf, "Taxonomy tool successfully completed", "Taxonomy Tool Completed", 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final String getBaseUrl() {
        return AncestralTaxonomyInferrer.getBaseUrl();
    }

    @Override
    public void run() {
        this.execute();
    }

    static enum QUERY_TYPE {
        CODE,
        SN,
        CN,
        ID,
        LIN;

    }
}

