/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.go.GoTerm;
import org.forester.go.OBOparser;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class obo_tool {
    private static final String IDS_TO_NAMES_SUFFIX = "_ids_to_names";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String GO_ID_TO_NAME_OPTION = "i";
    private static final String PRG_NAME = "obo_tool";
    private static final String PRG_VERSION = "1.00";
    private static final String PRG_DATE = "2008.11.26";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org/forester/";

    public static void main(String[] args) {
        String dissallowed_options;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2) || args.length == 0) {
            obo_tool.printHelp();
            System.exit(0);
        }
        if (args.length < 3) {
            System.out.println();
            System.out.println("[obo_tool] incorrect number of arguments");
            System.out.println();
            obo_tool.printHelp();
            System.exit(-1);
        }
        ArrayList<String> allowed_options = new ArrayList<String>();
        allowed_options.add(GO_ID_TO_NAME_OPTION);
        if (cla.getNumberOfNames() != 2) {
            System.out.println();
            System.out.println("[obo_tool] incorrect number of arguments");
            System.out.println();
            obo_tool.printHelp();
            System.exit(-1);
        }
        if ((dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options)).length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + dissallowed_options);
        }
        boolean output_ids_to_names = false;
        if (cla.isOptionSet(GO_ID_TO_NAME_OPTION)) {
            output_ids_to_names = true;
        }
        File infile = cla.getFile(0);
        File outfile = cla.getFile(1);
        OBOparser parser = new OBOparser(infile, OBOparser.ReturnType.BASIC_GO_TERM);
        List<GoTerm> go_terms = null;
        try {
            go_terms = parser.parse();
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, e.toString());
        }
        ForesterUtil.programMessage(PRG_NAME, "successfully read in " + go_terms.size() + " GO terms from [" + infile + "]");
        if (output_ids_to_names) {
            File outfile_ids_to_names = new File(outfile + IDS_TO_NAMES_SUFFIX);
            String error = ForesterUtil.isWritableFile(outfile_ids_to_names);
            if (!ForesterUtil.isEmpty(error)) {
                ForesterUtil.fatalError(PRG_NAME, error);
            }
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(outfile_ids_to_names));
                for (GoTerm go_term : go_terms) {
                    out.write(go_term.getGoId().getId());
                    out.write("\t");
                    out.write(go_term.getDefinition());
                    out.write(ForesterUtil.LINE_SEPARATOR);
                }
                ((Writer)out).close();
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, e.toString());
            }
            ForesterUtil.programMessage(PRG_NAME, "wrote: [" + outfile_ids_to_names + "]");
        }
        ForesterUtil.programMessage(PRG_NAME, "OK");
        System.out.println();
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("obo_tool <options> <obo infile> <outfile>");
        System.out.println();
        System.out.println(" options: ");
        System.out.println();
        System.out.println("   -i: output GO id to name map file");
        System.out.println();
    }
}

