/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.forester.io.writers.SequenceWriter;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public final class table2fasta {
    private static final String PRG_NAME = "table2fasta";
    private static final String PRG_VERSION = "1.00";
    private static final String PRG_DATE = "150327";

    public static void main(String[] args) {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        System.out.println();
        if (args.length != 3) {
            table2fasta.argumentsError();
        }
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        int position = Integer.parseInt(cla.getName(0));
        File intable = cla.getFile(1);
        File outfile = cla.getFile(2);
        if (outfile.exists()) {
            ForesterUtil.fatalError(PRG_NAME, outfile + " already exists");
        }
        if (!intable.exists()) {
            ForesterUtil.fatalError(PRG_NAME, intable + " does not exist");
        }
        BasicTable<String> t = null;
        try {
            t = BasicTableParser.parse(intable, '\t');
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        ArrayList<MolecularSequence> seqs = new ArrayList<MolecularSequence>();
        System.out.println("Number of rows: " + t.getNumberOfRows());
        for (int r = 0; r < t.getNumberOfRows(); ++r) {
            String id_str;
            String seq = null;
            StringBuilder id = new StringBuilder();
            for (int c = 0; c < t.getNumberOfColumns(); ++c) {
                if (c == position) {
                    seq = t.getValue(c, r);
                    continue;
                }
                if (c != 0 && c != 1) continue;
                id.append(t.getValue(c, r));
                id.append(" ");
            }
            if (id.length() < 2) {
                ForesterUtil.fatalError(PRG_NAME, "row " + r + " id is empty");
            }
            if ((id_str = id.toString().trim()).startsWith(">")) {
                id_str = id_str.substring(1);
            }
            if (ForesterUtil.isEmpty(seq) && ForesterUtil.isEmpty(seq = t.getValue(position - 1, r))) {
                ForesterUtil.fatalError(PRG_NAME, "row " + r + " seq is empty");
            }
            MolecularSequence s = null;
            try {
                s = BasicSequence.createAaSequence(id_str, seq);
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, e.getMessage());
            }
            if (s == null) continue;
            seqs.add(s);
        }
        try {
            SequenceWriter.writeSeqs(seqs, outfile, SequenceWriter.SEQ_FORMAT.FASTA, 60);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
    }

    private static void argumentsError() {
        System.out.println("table2fasta <position> <infile> <outfile>");
        System.out.println();
        System.exit(-1);
    }
}

