/*
 * Decompiled with CFR 0.152.
 */
package org.forester.applications;

import java.io.File;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;

public class get_genome_counts_per_char {
    static final boolean SIMPLE = true;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println();
            System.err.println("get_genome_counts_per_char: wrong number of arguments");
            System.err.println("Usage: \"get_subtree_specific_chars <intree>");
            System.err.println();
            System.exit(-1);
        }
        File infile = new File(args[0]);
        Phylogeny phy = null;
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            phy = factory.create(infile, ParserUtils.createParserDependingOnFileType(infile, true))[0];
        }
        catch (Exception e) {
            System.err.println(e + "\nCould not read " + infile + "\n");
            System.exit(-1);
        }
        SortedSet<String> all_chars = get_genome_counts_per_char.getAllExternalPresentAndGainedCharacters(phy.getRoot());
        SortedSet<String> human = get_genome_counts_per_char.getAllExternalPresentAndGainedCharacters(phy.getNode("HUMAN"));
        SortedSet<String> primates = get_genome_counts_per_char.getAllExternalPresentAndGainedCharacters(get_genome_counts_per_char.find("Primates", phy));
        SortedSet<String> mammalia = get_genome_counts_per_char.getAllExternalPresentAndGainedCharacters(get_genome_counts_per_char.find("Mammalia", phy));
        SortedSet<String> metazoa = get_genome_counts_per_char.getAllExternalPresentAndGainedCharacters(get_genome_counts_per_char.find("Metazoa", phy));
        SortedSet<String> fungi = get_genome_counts_per_char.getAllExternalPresentAndGainedCharacters(get_genome_counts_per_char.find("Fungi", phy));
        SortedSet<String> plants = get_genome_counts_per_char.getAllExternalPresentAndGainedCharacters(get_genome_counts_per_char.find("Viridiplantae", phy));
        System.out.println("Sum of all external characters:\t" + all_chars.size());
        System.out.println();
        List<PhylogenyNode> ext = phy.getRoot().getAllExternalDescendants();
        System.out.println("genomes\t" + ext.size());
        for (String c : all_chars) {
            int count = 0;
            for (PhylogenyNode e : ext) {
                if (!e.getNodeData().getBinaryCharacters().getGainedCharacters().contains(c) && !e.getNodeData().getBinaryCharacters().getPresentCharacters().contains(c)) continue;
                ++count;
            }
            if (count < 1) {
                System.err.println("error");
                System.exit(-1);
            }
            System.out.print(c + "\t" + count + "\t");
            if (human.contains(c)) {
                System.out.print("HUMAN\t");
            } else {
                System.out.print("\t");
            }
            if (primates.contains(c)) {
                System.out.print("PRIMATES\t");
            } else {
                System.out.print("\t");
            }
            if (mammalia.contains(c)) {
                System.out.print("MAMMALS\t");
            } else {
                System.out.print("\t");
            }
            if (metazoa.contains(c)) {
                System.out.print("METAZOA\t");
            } else {
                System.out.print("\t");
            }
            if (fungi.contains(c)) {
                System.out.print("FUNGI\t");
            } else {
                System.out.print("\t");
            }
            if (plants.contains(c)) {
                System.out.print("PLANTS\t");
            } else {
                System.out.print("\t");
            }
            System.out.println();
        }
    }

    private static PhylogenyNode find(String s, Phylogeny phy) {
        List<PhylogenyNode> l = PhylogenyMethods.searchData(s, phy, true, false, false, false, 0.0);
        if (l.size() != 1) {
            System.err.println("error: " + s);
            System.exit(-1);
        }
        return l.get(0);
    }

    private static SortedSet<String> getAllExternalPresentAndGainedCharacters(PhylogenyNode node) {
        TreeSet<String> chars = new TreeSet<String>();
        List<PhylogenyNode> descs = node.getAllExternalDescendants();
        for (PhylogenyNode desc : descs) {
            chars.addAll(desc.getNodeData().getBinaryCharacters().getGainedCharacters());
            chars.addAll(desc.getNodeData().getBinaryCharacters().getPresentCharacters());
        }
        return chars;
    }
}

