/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.io.File;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.util.ForesterUtil;

public final class Archaeopteryx {
    public static MainFrame createApplication(Phylogeny phylogeny) {
        Phylogeny[] phylogenies = new Phylogeny[]{phylogeny};
        return Archaeopteryx.createApplication(phylogenies, "", "");
    }

    public static MainFrame createApplication(Phylogeny phylogeny, Configuration config, String title) {
        Phylogeny[] phylogenies = new Phylogeny[]{phylogeny};
        return MainFrameApplication.createInstance(phylogenies, config, title);
    }

    public static MainFrame createApplication(Phylogeny[] phylogenies) {
        return Archaeopteryx.createApplication(phylogenies, "", "");
    }

    public static MainFrame createApplication(Phylogeny[] phylogenies, String config_file_name, String title) {
        return MainFrameApplication.createInstance(phylogenies, config_file_name, title);
    }

    public static void main(String[] args) {
        Phylogeny[] phylogenies = null;
        String config_filename = null;
        Configuration conf = null;
        File f = null;
        try {
            int filename_index = 0;
            if (args.length == 0) {
                conf = new Configuration(null, false, false, true);
            } else if (args.length > 0) {
                if (args[0].startsWith("-c")) {
                    config_filename = args[1];
                    filename_index += 2;
                }
                if (args[0].startsWith("-open")) {
                    ++filename_index;
                }
                conf = new Configuration(config_filename, false, false, true);
                if (args.length > filename_index) {
                    f = new File(args[filename_index]);
                    String err = ForesterUtil.isReadableFile(f);
                    if (!ForesterUtil.isEmpty(err)) {
                        ForesterUtil.fatalError("Archaeopteryx", err);
                    }
                    boolean nhx_or_nexus = false;
                    PhylogenyParser p = ParserUtils.createParserDependingOnFileType(f, conf.isValidatePhyloXmlAgainstSchema());
                    if (p instanceof NHXParser) {
                        nhx_or_nexus = true;
                        NHXParser nhx = (NHXParser)p;
                        nhx.setReplaceUnderscores(conf.isReplaceUnderscoresInNhParsing());
                        nhx.setIgnoreQuotes(false);
                        nhx.setTaxonomyExtraction(conf.getTaxonomyExtraction());
                    } else if (p instanceof NexusPhylogeniesParser) {
                        nhx_or_nexus = true;
                        NexusPhylogeniesParser nex = (NexusPhylogeniesParser)p;
                        nex.setReplaceUnderscores(conf.isReplaceUnderscoresInNhParsing());
                        nex.setIgnoreQuotes(false);
                    } else if (p instanceof PhyloXmlParser) {
                        MainFrameApplication.warnIfNotPhyloXmlValidation(conf);
                    }
                    phylogenies = PhylogenyMethods.readPhylogenies(p, f);
                    if (nhx_or_nexus && conf.isInternalNumberAreConfidenceForNhParsing()) {
                        for (Phylogeny phy : phylogenies) {
                            PhylogenyMethods.transferInternalNodeNamesToConfidence(phy, "");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            ForesterUtil.fatalError("Archaeopteryx", "failed to start: " + e.getLocalizedMessage());
        }
        String title = "";
        if (f != null) {
            title = f.getName();
        }
        File current_dir = null;
        if (phylogenies != null && phylogenies.length > 0) {
            current_dir = new File(".");
        }
        try {
            MainFrameApplication.createInstance(phylogenies, conf, title, current_dir);
        }
        catch (OutOfMemoryError e) {
            AptxUtil.outOfMemoryError(e);
        }
        catch (Exception e) {
            AptxUtil.unexpectedException(e);
        }
        catch (Error e) {
            AptxUtil.unexpectedError(e);
        }
    }
}

