/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.tools.ImageLoader;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.BranchWidth;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Date;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.MultipleUris;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Point;
import org.forester.phylogeny.data.Reference;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.data.Uri;
import org.forester.util.FailedConditionCheckException;
import org.forester.util.ForesterUtil;

class NodeEditPanel
extends JPanel {
    private static final long serialVersionUID = 5120159904388100771L;
    private final JTree _tree;
    private final JEditorPane _pane;
    private final PhylogenyNode _my_node;
    private final TreePanel _tree_panel;
    private final Map<DefaultMutableTreeNode, TagNumber> _map = new HashMap<DefaultMutableTreeNode, TagNumber>();

    public NodeEditPanel(PhylogenyNode phylogeny_node, TreePanel tree_panel) {
        this._my_node = phylogeny_node;
        this._tree_panel = tree_panel;
        String node_name = "";
        if (!ForesterUtil.isEmpty(phylogeny_node.getName())) {
            node_name = phylogeny_node.getName() + " ";
        }
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Node " + node_name);
        this.createNodes(top, phylogeny_node);
        this._tree = new JTree(top);
        this.getJTree().setEditable(true);
        this.getJTree().setFocusable(true);
        this.getJTree().setToggleClickCount(1);
        this.getJTree().setInvokesStopCellEditing(true);
        JScrollPane tree_view = new JScrollPane(this.getJTree());
        this._pane = new JEditorPane();
        this._pane.setEditable(true);
        JScrollPane data_view = new JScrollPane(this._pane);
        JSplitPane split_pane = new JSplitPane(0);
        split_pane.setTopComponent(tree_view);
        data_view.setMinimumSize(Constants.NODE_PANEL_SPLIT_MINIMUM_SIZE);
        tree_view.setMinimumSize(Constants.NODE_PANEL_SPLIT_MINIMUM_SIZE);
        split_pane.setPreferredSize(Constants.NODE_PANEL_SIZE);
        this.add(split_pane);
        this.getJTree().getSelectionModel().setSelectionMode(1);
        this.getJTree().addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                NodeEditPanel.this.keyEvent(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                NodeEditPanel.this.keyEvent(e);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                NodeEditPanel.this.keyEvent(e);
            }
        });
        for (int i = 0; i < this.getJTree().getRowCount(); ++i) {
            this.getJTree().expandRow(i);
        }
        this.collapsePath("Basic");
        this.collapsePath("Taxonomy");
        this.collapsePath("Sequence");
        this.collapsePath("Events");
        this.collapsePath("Date");
        this.collapsePath("Distribution");
        this.collapsePath("Reference");
        this.getJTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath new_path = e.getNewLeadSelectionPath();
                TreePath old_path = e.getOldLeadSelectionPath();
                if (new_path != null) {
                    NodeEditPanel.this.writeBack((DefaultMutableTreeNode)new_path.getLastPathComponent());
                }
                if (old_path != null) {
                    NodeEditPanel.this.writeBack((DefaultMutableTreeNode)old_path.getLastPathComponent());
                }
            }
        });
    }

    private void addBasics(DefaultMutableTreeNode top, PhylogenyNode phylogeny_node, String name) {
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(name);
        top.add(category);
        this.addSubelementEditable(category, "Name", phylogeny_node.getName(), PHYLOXML_TAG.NODE_NAME);
        String bl = "";
        if (phylogeny_node.getDistanceToParent() != -1024.0) {
            bl = ForesterUtil.FORMATTER_6.format(phylogeny_node.getDistanceToParent());
        }
        this.addSubelementEditable(category, "Branch length", bl, PHYLOXML_TAG.NODE_BRANCH_LENGTH);
        int counter = 0;
        if (phylogeny_node.getBranchData().isHasConfidences()) {
            for (int i = phylogeny_node.getBranchData().getConfidences().size() - 1; i >= 0; --i) {
                if (phylogeny_node.getBranchData().getConfidences().get(i).getValue() != -9999.0) continue;
                phylogeny_node.getBranchData().getConfidences().remove(i);
            }
            for (PhylogenyData phylogenyData : phylogeny_node.getBranchData().getConfidences()) {
                Confidence my_conf = (Confidence)phylogenyData;
                this.addSubelementEditable(category, "Confidence [" + counter + "]", ForesterUtil.FORMATTER_6.format(my_conf.getValue()), PHYLOXML_TAG.CONFIDENCE_VALUE, "type", my_conf.getType(), PHYLOXML_TAG.CONFIDENCE_TYPE, counter++);
            }
        }
        this.addSubelementEditable(category, "Confidence [" + counter + "]", "", PHYLOXML_TAG.CONFIDENCE_VALUE, "type", "", PHYLOXML_TAG.CONFIDENCE_TYPE, counter);
        String bw = "1";
        if (phylogeny_node.getBranchData().getBranchWidth() != null && phylogeny_node.getBranchData().getBranchWidth().getValue() != 1.0) {
            bw = ForesterUtil.FORMATTER_3.format(phylogeny_node.getBranchData().getBranchWidth().getValue());
        }
        this.addSubelementEditable(category, "Branch width", bw, PHYLOXML_TAG.NODE_BRANCH_WIDTH);
    }

    private void addDate(DefaultMutableTreeNode top, Date date, String name) {
        if (date == null) {
            date = new Date();
        }
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(name);
        top.add(category);
        this.addSubelementEditable(category, "Description", date.getDesc(), PHYLOXML_TAG.DATE_DESCRIPTION);
        this.addSubelementEditable(category, "Value", String.valueOf(date.getValue() != null ? date.getValue() : ""), PHYLOXML_TAG.DATE_VALUE);
        this.addSubelementEditable(category, "Min", String.valueOf(date.getMin() != null ? date.getMin() : ""), PHYLOXML_TAG.DATE_MIN);
        this.addSubelementEditable(category, "Max", String.valueOf(date.getMax() != null ? date.getMax() : ""), PHYLOXML_TAG.DATE_MAX);
        this.addSubelementEditable(category, "Unit", date.getUnit(), PHYLOXML_TAG.DATE_UNIT);
    }

    private void addDistribution(DefaultMutableTreeNode top, Distribution dist, String name) {
        if (dist == null) {
            dist = new Distribution("");
        }
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(name);
        top.add(category);
        Point p0 = null;
        p0 = dist.getPoints() != null && dist.getPoints().size() > 0 ? dist.getPoints().get(0) : new Point();
        this.addSubelementEditable(category, "Description", dist.getDesc(), PHYLOXML_TAG.DIST_DESC);
        this.addSubelementEditable(category, "Geodetic datum", p0.getGeodeticDatum(), PHYLOXML_TAG.DIST_GEODETIC);
        this.addSubelementEditable(category, "Latitude", String.valueOf(p0.getLatitude() != null ? p0.getLatitude() : ""), PHYLOXML_TAG.DIST_LAT);
        this.addSubelementEditable(category, "Longitude", String.valueOf(p0.getLongitude() != null ? p0.getLongitude() : ""), PHYLOXML_TAG.DIST_LONG);
        this.addSubelementEditable(category, "Altitude", String.valueOf(p0.getAltitude() != null ? p0.getAltitude() : ""), PHYLOXML_TAG.DIST_ALT);
        this.addSubelementEditable(category, "Altitude unit", String.valueOf(p0.getAltiudeUnit() != null ? p0.getAltiudeUnit() : ""), PHYLOXML_TAG.DIST_ALT_UNIT);
    }

    private void addEvents(DefaultMutableTreeNode top, Event events, String name) {
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(name);
        if (events == null) {
            events = new Event();
        }
        top.add(category);
        this.addSubelementEditable(category, "Duplications", String.valueOf(events.getNumberOfDuplications() >= 0 ? events.getNumberOfDuplications() : 0), PHYLOXML_TAG.EVENTS_DUPLICATIONS);
        this.addSubelementEditable(category, "Speciations", String.valueOf(events.getNumberOfSpeciations() >= 0 ? events.getNumberOfSpeciations() : 0), PHYLOXML_TAG.EVENTS_SPECIATIONS);
        this.addSubelementEditable(category, "Gene losses", String.valueOf(events.getNumberOfGeneLosses() >= 0 ? events.getNumberOfGeneLosses() : 0), PHYLOXML_TAG.EVENTS_GENE_LOSSES);
    }

    private void addMapping(DefaultMutableTreeNode mtn, TagNumber tag) {
        if (this.getMap().containsKey(mtn)) {
            throw new IllegalArgumentException("key " + mtn + " already present");
        }
        if (this.getMap().containsValue(tag)) {
            throw new IllegalArgumentException("value " + tag + " already present");
        }
        this.getMap().put(mtn, tag);
    }

    private void addReference(DefaultMutableTreeNode top, Reference ref, String name) {
        if (ref == null) {
            ref = new Reference("");
        }
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(name);
        top.add(category);
        this.addSubelementEditable(category, "Description", ref.getDescription(), PHYLOXML_TAG.LIT_REFERENCE_DESC);
        this.addSubelementEditable(category, "DOI", ref.getDoi(), PHYLOXML_TAG.LIT_REFERENCE_DOI);
    }

    private void addSequence(DefaultMutableTreeNode top, Sequence seq, String name) {
        if (seq == null) {
            seq = new Sequence();
        }
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(name);
        top.add(category);
        Accession acc = seq.getAccession();
        if (acc == null) {
            acc = new Accession("", "");
        }
        this.addSubelementEditable(category, "Name", seq.getName(), PHYLOXML_TAG.SEQ_NAME);
        this.addSubelementEditable(category, "Symbol", seq.getSymbol(), PHYLOXML_TAG.SEQ_SYMBOL);
        this.addSubelementEditable(category, "Gene name", seq.getGeneName(), PHYLOXML_TAG.SEQ_GENE_NAME);
        this.addSubelementEditable(category, "Accession", acc.getValue(), PHYLOXML_TAG.SEQ_ACC_VALUE, "Source", acc.getSource(), PHYLOXML_TAG.SEQ_ACC_SOURCE);
        this.addSubelementEditable(category, "Location", seq.getLocation(), PHYLOXML_TAG.SEQ_LOCATION);
        this.addSubelementEditable(category, "Type", seq.getType(), PHYLOXML_TAG.SEQ_TYPE);
        this.addSubelementEditable(category, "Mol seq", seq.getMolecularSequence(), PHYLOXML_TAG.SEQ_MOL_SEQ);
        int uri_counter = 0;
        if (seq.getUris() != null) {
            for (Uri uri : seq.getUris()) {
                if (uri == null) continue;
                this.addSubelementEditable(category, "URI [" + uri_counter + "]", uri.getValue().toString(), PHYLOXML_TAG.SEQ_URI, uri_counter++);
            }
        }
        this.addSubelementEditable(category, "URI [" + uri_counter + "]", "", PHYLOXML_TAG.SEQ_URI, uri_counter);
    }

    private void addSubelementEditable(DefaultMutableTreeNode node, String name, String value, PHYLOXML_TAG phyloxml_tag) {
        this.addSubelementEditable(node, name, value, phyloxml_tag, 0);
    }

    private void addSubelementEditable(DefaultMutableTreeNode node, String name, String value, PHYLOXML_TAG phyloxml_tag, int number) {
        String my_value = value;
        if (ForesterUtil.isEmpty(my_value)) {
            my_value = "";
        }
        DefaultMutableTreeNode name_node = new DefaultMutableTreeNode(name);
        DefaultMutableTreeNode value_node = new DefaultMutableTreeNode(my_value);
        name_node.add(value_node);
        node.add(name_node);
        this.addMapping(name_node, new TagNumber(phyloxml_tag, number));
    }

    private void addSubelementEditable(DefaultMutableTreeNode node, String name, String value, PHYLOXML_TAG phyloxml_value_tag, String source_name, String source_value, PHYLOXML_TAG phyloxml_source_tag) {
        this.addSubelementEditable(node, name, value, phyloxml_value_tag, source_name, source_value, phyloxml_source_tag, 0);
    }

    private void addSubelementEditable(DefaultMutableTreeNode node, String name, String value, PHYLOXML_TAG phyloxml_value_tag, String source_name, String source_value, PHYLOXML_TAG phyloxml_source_tag, int number) {
        String my_source_value;
        String my_value = value;
        if (ForesterUtil.isEmpty(my_value)) {
            my_value = "";
        }
        if (ForesterUtil.isEmpty(my_source_value = source_value)) {
            my_source_value = "";
        }
        DefaultMutableTreeNode name_node = new DefaultMutableTreeNode(name);
        DefaultMutableTreeNode source_name_node = new DefaultMutableTreeNode(source_name);
        DefaultMutableTreeNode source_value_node = new DefaultMutableTreeNode(my_source_value);
        DefaultMutableTreeNode value_node = new DefaultMutableTreeNode(my_value);
        name_node.add(source_name_node);
        source_name_node.add(source_value_node);
        name_node.add(value_node);
        node.add(name_node);
        this.addMapping(name_node, new TagNumber(phyloxml_value_tag, number));
        this.addMapping(source_name_node, new TagNumber(phyloxml_source_tag, number));
    }

    private void addTaxonomy(DefaultMutableTreeNode top, Taxonomy tax, String name) {
        if (tax == null) {
            tax = new Taxonomy();
        }
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(name);
        top.add(category);
        Identifier id = tax.getIdentifier();
        if (id == null) {
            id = new Identifier();
        }
        this.addSubelementEditable(category, "Identifier", id.getValue(), PHYLOXML_TAG.TAXONOMY_ID_VALUE, "Provider", id.getProvider(), PHYLOXML_TAG.TAXONOMY_ID_PROVIDER);
        this.addSubelementEditable(category, "Code", tax.getTaxonomyCode(), PHYLOXML_TAG.TAXONOMY_CODE);
        this.addSubelementEditable(category, "Scientific name", tax.getScientificName(), PHYLOXML_TAG.TAXONOMY_SCIENTIFIC_NAME);
        this.addSubelementEditable(category, "Authority", tax.getAuthority(), PHYLOXML_TAG.TAXONOMY_AUTHORITY);
        this.addSubelementEditable(category, "Common name", tax.getCommonName(), PHYLOXML_TAG.TAXONOMY_COMMON_NAME);
        for (int i = tax.getSynonyms().size() - 1; i >= 0; --i) {
            if (!ForesterUtil.isEmpty(tax.getSynonyms().get(i))) continue;
            tax.getSynonyms().remove(i);
        }
        int syn_counter = 0;
        for (String syn : tax.getSynonyms()) {
            this.addSubelementEditable(category, "Synonym [" + syn_counter + "]", syn, PHYLOXML_TAG.TAXONOMY_SYNONYM, syn_counter++);
        }
        this.addSubelementEditable(category, "Synonym [" + syn_counter + "]", "", PHYLOXML_TAG.TAXONOMY_SYNONYM, syn_counter);
        this.addSubelementEditable(category, "Rank", tax.getRank(), PHYLOXML_TAG.TAXONOMY_RANK);
        int uri_counter = 0;
        if (tax.getUris() != null) {
            for (Uri uri : tax.getUris()) {
                if (uri == null) continue;
                this.addSubelementEditable(category, "URI [" + uri_counter + "]", uri.getValue().toString(), PHYLOXML_TAG.TAXONOMY_URI, uri_counter++);
            }
        }
        this.addSubelementEditable(category, "URI [" + uri_counter + "]", "", PHYLOXML_TAG.TAXONOMY_URI, uri_counter);
    }

    private void addUri(DefaultMutableTreeNode mtn, Uri uri, int number, MultipleUris mu) {
        if (uri != null && mu.getUris() == null) {
            mu.setUris(new ArrayList<Uri>());
        }
        if (uri != null && mu.getUris() == null) {
            mu.setUris(new ArrayList<Uri>());
        }
        if (uri != null && mu.getUris().size() == number) {
            mu.getUris().add(uri);
        }
        if (mu.getUris() != null && mu.getUris().size() != number) {
            mu.getUris().set(number, uri);
        }
        ImageLoader il = new ImageLoader(this.getTreePanel());
        new Thread(il).start();
    }

    private void collapsePath(String name) {
        TreePath tp = this.getJTree().getNextMatch(name, 0, Position.Bias.Forward);
        if (tp != null) {
            this.getJTree().collapsePath(tp);
        }
    }

    private void createNodes(DefaultMutableTreeNode top, PhylogenyNode phylogeny_node) {
        if (!phylogeny_node.getNodeData().isHasTaxonomy()) {
            phylogeny_node.getNodeData().addTaxonomy(new Taxonomy());
        }
        if (!phylogeny_node.getNodeData().isHasSequence()) {
            phylogeny_node.getNodeData().addSequence(new Sequence());
        }
        if (!phylogeny_node.getNodeData().isHasDistribution()) {
            phylogeny_node.getNodeData().addDistribution(new Distribution(""));
        }
        if (!phylogeny_node.getNodeData().isHasReference()) {
            phylogeny_node.getNodeData().addReference(new Reference(""));
        }
        this.addBasics(top, phylogeny_node, "Basic");
        this.addTaxonomy(top, phylogeny_node.getNodeData().getTaxonomy(), "Taxonomy");
        this.addSequence(top, phylogeny_node.getNodeData().getSequence(), "Sequence");
        if (!phylogeny_node.isExternal()) {
            this.addEvents(top, phylogeny_node.getNodeData().getEvent(), "Events");
        }
        this.addDate(top, phylogeny_node.getNodeData().getDate(), "Date");
        this.addDistribution(top, phylogeny_node.getNodeData().getDistribution(), "Distribution");
        this.addReference(top, phylogeny_node.getNodeData().getReference(), "Reference");
    }

    private void formatError(DefaultMutableTreeNode mtn, PhyloXmlDataFormatException e) {
        JOptionPane.showMessageDialog(this, e.getMessage(), "Format error", 0);
        mtn.setUserObject("");
        this.getJTree().repaint();
    }

    private JTree getJTree() {
        return this._tree;
    }

    private Map<DefaultMutableTreeNode, TagNumber> getMap() {
        return this._map;
    }

    private TagNumber getMapping(DefaultMutableTreeNode mtn) {
        return this.getMap().get(mtn);
    }

    private DefaultMutableTreeNode getSelectedTreeNode() {
        Object[] path;
        TreePath selectionPath = this.getJTree().getSelectionPath();
        if (selectionPath != null && (path = selectionPath.getPath()).length > 0) {
            return (DefaultMutableTreeNode)path[path.length - 1];
        }
        return null;
    }

    private TreePanel getTreePanel() {
        return this._tree_panel;
    }

    private void keyEvent(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.writeBack(this.getSelectedTreeNode());
        }
    }

    private List<Point> obtainPoints() {
        List<Point> ps;
        ForesterUtil.ensurePresenceOfDistribution(this.getMyNode());
        Distribution d = this.getMyNode().getNodeData().getDistribution();
        if (d.getPoints() == null) {
            d = new Distribution(d.getDesc(), new ArrayList<Point>(), d.getPolygons());
            this.getMyNode().getNodeData().setDistribution(d);
        }
        if ((ps = d.getPoints()).isEmpty()) {
            ps.add(new Point());
        } else if (ps.get(0) == null) {
            ps.set(0, new Point());
        }
        return ps;
    }

    private BigDecimal parseBigDecimal(DefaultMutableTreeNode mtn, String value) {
        if (ForesterUtil.isEmpty(value)) {
            return new BigDecimal(0);
        }
        BigDecimal i = null;
        try {
            i = new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "illegal value: " + value, "Error", 0);
            mtn.setUserObject("");
        }
        return i;
    }

    private int parsePositiveInt(DefaultMutableTreeNode mtn, String value) {
        if (ForesterUtil.isEmpty(value)) {
            return 0;
        }
        int i = -1;
        try {
            i = ForesterUtil.parseInt(value);
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(this, "illegal value: " + value, "Error", 0);
            mtn.setUserObject("");
        }
        if (i < 0) {
            JOptionPane.showMessageDialog(this, "illegal value: " + value, "Error", 0);
            mtn.setUserObject("");
        }
        return i;
    }

    private void writeBack(DefaultMutableTreeNode mtn) {
        if (!this.getMap().containsKey(mtn)) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)mtn.getParent();
            if (this.getMap().containsKey(parent)) {
                this.writeBack(mtn, this.getMapping(parent));
            }
        }
    }

    private void writeBack(DefaultMutableTreeNode mtn, TagNumber tag_number) {
        if (tag_number == null) {
            return;
        }
        String value = mtn.toString();
        if (value == null) {
            value = "";
        }
        value = value.replaceAll("\\s+", " ");
        value = value.trim();
        mtn.setUserObject(value);
        this.getJTree().repaint();
        PHYLOXML_TAG tag = tag_number.getTag();
        int number = tag_number.getNumber();
        switch (tag) {
            case NODE_NAME: {
                this.getMyNode().setName(value);
                break;
            }
            case NODE_BRANCH_LENGTH: {
                if (ForesterUtil.isEmpty(value)) {
                    this.getMyNode().setDistanceToParent(-1024.0);
                    break;
                }
                try {
                    this.getMyNode().setDistanceToParent(ForesterUtil.parseDouble(value));
                }
                catch (ParseException e) {
                    JOptionPane.showMessageDialog(this, "failed to parse branch length from: " + value, "Error", 0);
                    mtn.setUserObject("");
                }
                break;
            }
            case NODE_BRANCH_WIDTH: {
                if (ForesterUtil.isEmpty(value) || value.equals("1")) {
                    if (this.getMyNode().getBranchData().getBranchWidth() == null) break;
                    this.getMyNode().getBranchData().setBranchWidth(new BranchWidth());
                    break;
                }
                try {
                    double bw = ForesterUtil.parseDouble(value);
                    if (!(bw >= 0.0)) break;
                    this.getMyNode().getBranchData().setBranchWidth(new BranchWidth(bw));
                }
                catch (ParseException e) {
                    JOptionPane.showMessageDialog(this, "failed to parse branch width from: " + value, "Error", 0);
                    mtn.setUserObject("");
                }
                break;
            }
            case CONFIDENCE_VALUE: {
                double confidence = -9999.0;
                if (!ForesterUtil.isEmpty(value)) {
                    try {
                        confidence = ForesterUtil.parseDouble(value);
                    }
                    catch (ParseException e) {
                        JOptionPane.showMessageDialog(this, "failed to parse confidence value from: " + value, "Error", 0);
                        mtn.setUserObject("");
                        break;
                    }
                }
                if (this.getMyNode().getBranchData().getConfidences().size() < number) {
                    throw new FailedConditionCheckException();
                }
                if (this.getMyNode().getBranchData().getConfidences().size() == number) {
                    if (!(confidence >= 0.0)) break;
                    this.getMyNode().getBranchData().getConfidences().add(new Confidence(confidence, "unknown"));
                    break;
                }
                String type = this.getMyNode().getBranchData().getConfidences().get(number).getType();
                double sd = this.getMyNode().getBranchData().getConfidences().get(number).getStandardDeviation();
                this.getMyNode().getBranchData().getConfidences().set(number, new Confidence(confidence, type, sd));
                break;
            }
            case CONFIDENCE_TYPE: {
                if (this.getMyNode().getBranchData().getConfidences().size() < number) {
                    throw new FailedConditionCheckException();
                }
                if (this.getMyNode().getBranchData().getConfidences().size() == number) {
                    if (ForesterUtil.isEmpty(value)) break;
                    this.getMyNode().getBranchData().getConfidences().add(new Confidence(0.0, value));
                    break;
                }
                double v = this.getMyNode().getBranchData().getConfidences().get(number).getValue();
                double sd = this.getMyNode().getBranchData().getConfidences().get(number).getStandardDeviation();
                this.getMyNode().getBranchData().getConfidences().set(number, new Confidence(v, value, sd));
                break;
            }
            case TAXONOMY_CODE: {
                ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                try {
                    this.getMyNode().getNodeData().getTaxonomy().setTaxonomyCode(value);
                }
                catch (PhyloXmlDataFormatException e) {
                    this.formatError(mtn, e);
                }
                break;
            }
            case TAXONOMY_SCIENTIFIC_NAME: {
                ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                this.getMyNode().getNodeData().getTaxonomy().setScientificName(value);
                break;
            }
            case TAXONOMY_COMMON_NAME: {
                ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                this.getMyNode().getNodeData().getTaxonomy().setCommonName(value);
                break;
            }
            case TAXONOMY_RANK: {
                ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                try {
                    this.getMyNode().getNodeData().getTaxonomy().setRank(value.toLowerCase());
                }
                catch (PhyloXmlDataFormatException e) {
                    this.formatError(mtn, e);
                }
                break;
            }
            case TAXONOMY_AUTHORITY: {
                ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                this.getMyNode().getNodeData().getTaxonomy().setAuthority(value);
                break;
            }
            case TAXONOMY_URI: {
                Uri uri = null;
                if (!ForesterUtil.isEmpty(value)) {
                    try {
                        uri = new Uri(new URL(value).toURI());
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, "failed to parse URL from: " + value, "Error", 0);
                        mtn.setUserObject("");
                    }
                }
                if (uri != null) {
                    ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                }
                this.addUri(mtn, uri, number, this.getMyNode().getNodeData().getTaxonomy());
                break;
            }
            case TAXONOMY_SYNONYM: {
                if (this.getMyNode().getNodeData().getTaxonomy().getSynonyms().size() < number) {
                    throw new FailedConditionCheckException();
                }
                if (this.getMyNode().getNodeData().getTaxonomy().getSynonyms().size() == number) {
                    if (ForesterUtil.isEmpty(value)) break;
                    ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                    this.getMyNode().getNodeData().getTaxonomy().getSynonyms().add(value);
                    break;
                }
                this.getMyNode().getNodeData().getTaxonomy().getSynonyms().set(number, value);
                break;
            }
            case TAXONOMY_ID_VALUE: {
                ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                if (this.getMyNode().getNodeData().getTaxonomy().getIdentifier() == null) {
                    this.getMyNode().getNodeData().getTaxonomy().setIdentifier(new Identifier(value));
                    break;
                }
                String provider = this.getMyNode().getNodeData().getTaxonomy().getIdentifier().getProvider();
                this.getMyNode().getNodeData().getTaxonomy().setIdentifier(new Identifier(value, provider));
                break;
            }
            case TAXONOMY_ID_PROVIDER: {
                ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                if (this.getMyNode().getNodeData().getTaxonomy().getIdentifier() == null) {
                    this.getMyNode().getNodeData().getTaxonomy().setIdentifier(new Identifier("", value));
                    break;
                }
                String v = this.getMyNode().getNodeData().getTaxonomy().getIdentifier().getValue();
                this.getMyNode().getNodeData().getTaxonomy().setIdentifier(new Identifier(v, value));
                break;
            }
            case SEQ_LOCATION: {
                ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                this.getMyNode().getNodeData().getSequence().setLocation(value);
                break;
            }
            case SEQ_MOL_SEQ: {
                ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                this.getMyNode().getNodeData().getSequence().setMolecularSequence(value.replaceAll("[^a-zA-Z-]", ""));
                break;
            }
            case SEQ_NAME: {
                ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                this.getMyNode().getNodeData().getSequence().setName(value);
                break;
            }
            case SEQ_SYMBOL: {
                ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                try {
                    this.getMyNode().getNodeData().getSequence().setSymbol(value);
                }
                catch (PhyloXmlDataFormatException e) {
                    this.formatError(mtn, e);
                }
                break;
            }
            case SEQ_GENE_NAME: {
                ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                this.getMyNode().getNodeData().getSequence().setGeneName(value);
                break;
            }
            case SEQ_TYPE: {
                ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                try {
                    this.getMyNode().getNodeData().getSequence().setType(value.toLowerCase());
                }
                catch (PhyloXmlDataFormatException e) {
                    this.formatError(mtn, e);
                }
                break;
            }
            case SEQ_ACC_SOURCE: {
                ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                if (this.getMyNode().getNodeData().getSequence().getAccession() == null) {
                    this.getMyNode().getNodeData().getSequence().setAccession(new Accession("", value));
                    break;
                }
                String v = this.getMyNode().getNodeData().getSequence().getAccession().getValue();
                this.getMyNode().getNodeData().getSequence().setAccession(new Accession(v, value));
                break;
            }
            case SEQ_ACC_VALUE: {
                ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                if (this.getMyNode().getNodeData().getSequence().getAccession() == null) {
                    this.getMyNode().getNodeData().getSequence().setAccession(new Accession(value, ""));
                    break;
                }
                String source = this.getMyNode().getNodeData().getSequence().getAccession().getSource();
                this.getMyNode().getNodeData().getSequence().setAccession(new Accession(value, source));
                break;
            }
            case SEQ_URI: {
                Uri uri = null;
                if (!ForesterUtil.isEmpty(value)) {
                    try {
                        uri = new Uri(new URL(value).toURI());
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, "failed to parse URL from: " + value, "Error", 0);
                        mtn.setUserObject("");
                    }
                }
                if (uri != null) {
                    ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                }
                this.addUri(mtn, uri, number, this.getMyNode().getNodeData().getSequence());
                break;
            }
            case LIT_REFERENCE_DESC: {
                if (!this.getMyNode().getNodeData().isHasReference()) {
                    this.getMyNode().getNodeData().setReference(new Reference(""));
                }
                this.getMyNode().getNodeData().getReference().setValue(value);
                break;
            }
            case LIT_REFERENCE_DOI: {
                if (!this.getMyNode().getNodeData().isHasReference()) {
                    this.getMyNode().getNodeData().setReference(new Reference(""));
                }
                try {
                    this.getMyNode().getNodeData().getReference().setDoi(value);
                }
                catch (PhyloXmlDataFormatException e) {
                    this.formatError(mtn, e);
                }
                break;
            }
            case EVENTS_DUPLICATIONS: {
                if (!this.getMyNode().getNodeData().isHasEvent()) {
                    this.getMyNode().getNodeData().setEvent(new Event());
                }
                this.getMyNode().getNodeData().getEvent().setDuplications(this.parsePositiveInt(mtn, value));
                break;
            }
            case EVENTS_SPECIATIONS: {
                if (!this.getMyNode().getNodeData().isHasEvent()) {
                    this.getMyNode().getNodeData().setEvent(new Event());
                }
                this.getMyNode().getNodeData().getEvent().setSpeciations(this.parsePositiveInt(mtn, value));
                break;
            }
            case EVENTS_GENE_LOSSES: {
                if (!this.getMyNode().getNodeData().isHasEvent()) {
                    this.getMyNode().getNodeData().setEvent(new Event());
                }
                this.getMyNode().getNodeData().getEvent().setGeneLosses(this.parsePositiveInt(mtn, value));
                break;
            }
            case DATE_DESCRIPTION: {
                ForesterUtil.ensurePresenceOfDate(this.getMyNode());
                this.getMyNode().getNodeData().getDate().setDesc(value);
                break;
            }
            case DATE_MAX: {
                ForesterUtil.ensurePresenceOfDate(this.getMyNode());
                this.getMyNode().getNodeData().getDate().setMax(this.parseBigDecimal(mtn, value));
                break;
            }
            case DATE_MIN: {
                ForesterUtil.ensurePresenceOfDate(this.getMyNode());
                this.getMyNode().getNodeData().getDate().setMin(this.parseBigDecimal(mtn, value));
                break;
            }
            case DATE_UNIT: {
                ForesterUtil.ensurePresenceOfDate(this.getMyNode());
                this.getMyNode().getNodeData().getDate().setUnit(value);
                break;
            }
            case DATE_VALUE: {
                ForesterUtil.ensurePresenceOfDate(this.getMyNode());
                this.getMyNode().getNodeData().getDate().setValue(this.parseBigDecimal(mtn, value));
                break;
            }
            case DIST_ALT: {
                BigDecimal new_value = this.parseBigDecimal(mtn, value);
                if (new_value == null) break;
                List<Point> ps = this.obtainPoints();
                Point p = ps.get(0);
                Point p_new = new Point(p.getGeodeticDatum(), p.getLatitude(), p.getLongitude(), new_value, ForesterUtil.isEmpty(p.getAltiudeUnit()) ? "?" : p.getAltiudeUnit());
                ps.set(0, p_new);
                break;
            }
            case DIST_DESC: {
                ForesterUtil.ensurePresenceOfDistribution(this.getMyNode());
                Distribution d = this.getMyNode().getNodeData().getDistribution();
                this.getMyNode().getNodeData().setDistribution(new Distribution(value, d.getPoints(), d.getPolygons()));
                break;
            }
            case DIST_GEODETIC: {
                if (ForesterUtil.isEmpty(value)) break;
                List<Point> ps = this.obtainPoints();
                Point p = ps.get(0);
                Point p_new = new Point(value, p.getLatitude(), p.getLongitude(), p.getAltitude(), p.getAltiudeUnit());
                ps.set(0, p_new);
                break;
            }
            case DIST_ALT_UNIT: {
                if (ForesterUtil.isEmpty(value)) break;
                List<Point> ps = this.obtainPoints();
                Point p = ps.get(0);
                Point p_new = new Point(p.getGeodeticDatum(), p.getLatitude(), p.getLongitude(), p.getAltitude(), value);
                ps.set(0, p_new);
                break;
            }
            case DIST_LAT: {
                BigDecimal new_value = this.parseBigDecimal(mtn, value);
                if (new_value == null) break;
                List<Point> ps = this.obtainPoints();
                Point p = ps.get(0);
                Point p_new = new Point(p.getGeodeticDatum(), new_value, p.getLongitude(), p.getAltitude(), p.getAltiudeUnit());
                ps.set(0, p_new);
                break;
            }
            case DIST_LONG: {
                BigDecimal new_value = this.parseBigDecimal(mtn, value);
                if (new_value == null) break;
                List<Point> ps = this.obtainPoints();
                Point p = ps.get(0);
                Point p_new = new Point(p.getGeodeticDatum(), p.getLatitude(), new_value, p.getAltitude(), p.getAltiudeUnit());
                ps.set(0, p_new);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown: " + (Object)((Object)tag));
            }
        }
        this.getJTree().repaint();
        this.getTreePanel().setEdited(true);
        this.getTreePanel().repaint();
    }

    PhylogenyNode getMyNode() {
        return this._my_node;
    }

    void writeAll() {
        for (int i = 0; i < this.getJTree().getRowCount(); ++i) {
            TreePath p = this.getJTree().getPathForRow(i);
            this.writeBack((DefaultMutableTreeNode)p.getLastPathComponent());
        }
    }

    private class TagNumber {
        private final PHYLOXML_TAG _tag;
        private final int _number;

        TagNumber(PHYLOXML_TAG tag, int number) {
            this._tag = tag;
            this._number = number;
        }

        public String toString() {
            return (Object)((Object)this.getTag()) + "_" + this.getNumber();
        }

        int getNumber() {
            return this._number;
        }

        PHYLOXML_TAG getTag() {
            return this._tag;
        }
    }

    private static enum PHYLOXML_TAG {
        NODE_NAME,
        NODE_BRANCH_LENGTH,
        NODE_BRANCH_WIDTH,
        TAXONOMY_CODE,
        TAXONOMY_SCIENTIFIC_NAME,
        TAXONOMY_AUTHORITY,
        TAXONOMY_COMMON_NAME,
        TAXONOMY_SYNONYM,
        TAXONOMY_RANK,
        TAXONOMY_URI,
        SEQ_SYMBOL,
        SEQ_NAME,
        SEQ_GENE_NAME,
        SEQ_LOCATION,
        SEQ_TYPE,
        SEQ_MOL_SEQ,
        SEQ_URI,
        DATE_DESCRIPTION,
        DATE_VALUE,
        DATE_MIN,
        DATE_MAX,
        DATE_UNIT,
        TAXONOMY_ID_VALUE,
        TAXONOMY_ID_PROVIDER,
        SEQ_ACC_VALUE,
        SEQ_ACC_SOURCE,
        CONFIDENCE_VALUE,
        CONFIDENCE_TYPE,
        LIT_REFERENCE_DESC,
        LIT_REFERENCE_DOI,
        EVENTS_DUPLICATIONS,
        EVENTS_SPECIATIONS,
        EVENTS_GENE_LOSSES,
        DIST_DESC,
        DIST_GEODETIC,
        DIST_LAT,
        DIST_LONG,
        DIST_ALT,
        DIST_ALT_UNIT;

    }
}

