/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Color;
import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import org.forester.analysis.TaxonomyDataManager;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.NodeDataField;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.ForesterUtil;
import org.forester.util.SequenceAccessionTools;
import org.forester.util.StringInt;
import org.forester.ws.seqdb.UniProtTaxonomy;

public class TreePanelUtil {
    public static final String createUriForSeqWeb(PhylogenyNode node, Configuration conf, TreePanel tp) {
        String v;
        String uri_str = null;
        String upkb = SequenceAccessionTools.obtainUniProtAccessorFromDataFields(node);
        if (!ForesterUtil.isEmpty(upkb)) {
            try {
                uri_str = "http://www.uniprot.org/uniprot/" + URLEncoder.encode(upkb, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                AptxUtil.showErrorMessage(tp, e.toString());
                e.printStackTrace();
            }
        }
        if (ForesterUtil.isEmpty(uri_str) && !ForesterUtil.isEmpty(v = SequenceAccessionTools.obtainGenbankAccessorFromDataFields(node))) {
            try {
                uri_str = SequenceAccessionTools.isProteinDbQuery(v) ? "http://www.ncbi.nlm.nih.gov/protein/" + URLEncoder.encode(v, "UTF-8") : "http://www.ncbi.nlm.nih.gov/nuccore/" + URLEncoder.encode(v, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                AptxUtil.showErrorMessage(tp, e.toString());
                e.printStackTrace();
            }
        }
        if (ForesterUtil.isEmpty(uri_str) && !ForesterUtil.isEmpty(v = SequenceAccessionTools.obtainRefSeqAccessorFromDataFields(node))) {
            try {
                uri_str = SequenceAccessionTools.isProteinDbQuery(v) ? "http://www.ncbi.nlm.nih.gov/protein/" + URLEncoder.encode(v, "UTF-8") : "http://www.ncbi.nlm.nih.gov/nuccore/" + URLEncoder.encode(v, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                AptxUtil.showErrorMessage(tp, e.toString());
                e.printStackTrace();
            }
        }
        if (ForesterUtil.isEmpty(uri_str) && !ForesterUtil.isEmpty(v = SequenceAccessionTools.obtainGiNumberFromDataFields(node))) {
            try {
                uri_str = "http://www.ncbi.nlm.nih.gov/protein/gi:" + URLEncoder.encode(v, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                AptxUtil.showErrorMessage(tp, e.toString());
                e.printStackTrace();
            }
        }
        return uri_str;
    }

    public static List<String> createUrisForPdbWeb(PhylogenyNode node, List<Accession> pdb_accs, Configuration configuration, TreePanel treePanel) {
        ArrayList<String> uris = new ArrayList<String>();
        if (!ForesterUtil.isEmpty(pdb_accs)) {
            for (Accession pdb_acc : pdb_accs) {
                if (ForesterUtil.isEmpty(pdb_acc.getValue())) continue;
                uris.add("http://www.pdb.org/pdb/explore/explore.do?pdbId=" + pdb_acc.getValue());
            }
        }
        return uris;
    }

    public static Set<Taxonomy> obtainDistinctTaxonomies(PhylogenyNode node) {
        List<PhylogenyNode> descs = node.getAllExternalDescendants();
        HashSet<Taxonomy> tax_set = new HashSet<Taxonomy>();
        for (PhylogenyNode n : descs) {
            if (!n.getNodeData().isHasTaxonomy() || n.getNodeData().getTaxonomy().isEmpty()) {
                return null;
            }
            tax_set.add(n.getNodeData().getTaxonomy());
        }
        return tax_set;
    }

    public static final void showExtDescNodeDataUserSelectedHelper(ControlPanel cp, PhylogenyNode node, List<String> data) {
        String s;
        StringBuilder sb = new StringBuilder();
        if (cp.isShowNodeNames() && !ForesterUtil.isEmpty(node.getName())) {
            TreePanelUtil.showExtDescNodeDataUserSelectedHelperHelper(node.getName(), sb);
        }
        if (cp.isShowSeqNames() && node.getNodeData().isHasSequence() && !ForesterUtil.isEmpty(node.getNodeData().getSequence().getName())) {
            TreePanelUtil.showExtDescNodeDataUserSelectedHelperHelper(node.getNodeData().getSequence().getName(), sb);
        }
        if (cp.isShowSeqSymbols() && node.getNodeData().isHasSequence() && !ForesterUtil.isEmpty(node.getNodeData().getSequence().getSymbol())) {
            TreePanelUtil.showExtDescNodeDataUserSelectedHelperHelper(node.getNodeData().getSequence().getSymbol(), sb);
        }
        if (cp.isShowGeneNames() && node.getNodeData().isHasSequence() && !ForesterUtil.isEmpty(node.getNodeData().getSequence().getGeneName())) {
            TreePanelUtil.showExtDescNodeDataUserSelectedHelperHelper(node.getNodeData().getSequence().getGeneName(), sb);
        }
        if (cp.isShowSequenceAcc() && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(node.getNodeData().getSequence().getAccession().toString())) {
            TreePanelUtil.showExtDescNodeDataUserSelectedHelperHelper(node.getNodeData().getSequence().getAccession().toString(), sb);
        }
        if (cp.isShowTaxonomyCode() && node.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getTaxonomyCode())) {
            TreePanelUtil.showExtDescNodeDataUserSelectedHelperHelper(node.getNodeData().getTaxonomy().getTaxonomyCode(), sb);
        }
        if (cp.isShowTaxonomyScientificNames() && node.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getScientificName())) {
            TreePanelUtil.showExtDescNodeDataUserSelectedHelperHelper(node.getNodeData().getTaxonomy().getScientificName(), sb);
        }
        if (cp.isShowTaxonomyCommonNames() && node.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getCommonName())) {
            TreePanelUtil.showExtDescNodeDataUserSelectedHelperHelper(node.getNodeData().getTaxonomy().getCommonName(), sb);
        }
        if (!ForesterUtil.isEmpty(s = sb.toString().trim())) {
            data.add(s);
        }
    }

    public static final void showExtDescNodeDataUserSelectedHelperHelper(String s, StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append("\t");
        }
        sb.append(s);
    }

    public static final void showInformationMessage(Component parent, String title, String msg) {
        JOptionPane.showMessageDialog(parent, msg, title, 1);
    }

    static final void collapseSpeciesSpecificSubtrees(Phylogeny phy) {
        boolean inferred = false;
        PhylogenyNodeIterator it = phy.iteratorPreorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (n.isExternal() || n.isCollapse() || n.getNumberOfDescendants() <= 1) continue;
            Set<Taxonomy> taxs = TreePanelUtil.obtainDistinctTaxonomies(n);
            if (taxs != null && taxs.size() == 1) {
                TreePanelUtil.collapseSubtree(n, true);
                if (!n.getNodeData().isHasTaxonomy()) {
                    n.getNodeData().setTaxonomy((Taxonomy)n.getAllExternalDescendants().get(0).getNodeData().getTaxonomy().copy());
                }
                inferred = true;
                continue;
            }
            n.setCollapse(false);
        }
        if (inferred) {
            phy.setRerootable(false);
        }
    }

    static final void collapseSubtree(PhylogenyNode node, boolean collapse) {
        node.setCollapse(collapse);
        if (node.isExternal()) {
            return;
        }
        PreorderTreeIterator it = new PreorderTreeIterator(node);
        while (it.hasNext()) {
            it.next().setCollapse(collapse);
        }
    }

    static void colorizeSubtree(PhylogenyNode node, BranchColor c) {
        node.getBranchData().setBranchColor(c);
        List<PhylogenyNode> descs = PhylogenyMethods.getAllDescendants(node);
        for (PhylogenyNode desc : descs) {
            desc.getBranchData().setBranchColor(c);
        }
    }

    static final void colorPhylogenyAccordingToConfidenceValues(Phylogeny tree, TreePanel tree_panel) {
        double max_conf = 0.0;
        PhylogenyNodeIterator it = tree.iteratorPreorder();
        while (it.hasNext()) {
            double conf;
            PhylogenyNode n = it.next();
            n.getBranchData().setBranchColor(null);
            if (!n.getBranchData().isHasConfidences() || !((conf = PhylogenyMethods.getConfidenceValue(n)) > max_conf)) continue;
            max_conf = conf;
        }
        if (max_conf > 0.0) {
            Color bg = tree_panel.getTreeColorSet().getBackgroundColor();
            Color br = tree_panel.getTreeColorSet().getBranchColor();
            PhylogenyNodeIterator it2 = tree.iteratorPreorder();
            while (it2.hasNext()) {
                PhylogenyNode n = it2.next();
                if (!n.getBranchData().isHasConfidences()) continue;
                double conf = PhylogenyMethods.getConfidenceValue(n);
                BranchColor c = new BranchColor(ForesterUtil.calcColor(conf, 0.0, max_conf, bg, br));
                TreePanelUtil.colorizeSubtree(n, c);
            }
        }
    }

    static final void colorPhylogenyAccordingToExternalTaxonomy(Phylogeny tree, TreePanel tree_panel) {
        PhylogenyNodeIterator it = tree.iteratorPreorder();
        while (it.hasNext()) {
            it.next().getBranchData().setBranchColor(null);
        }
        it = tree.iteratorPreorder();
        while (it.hasNext()) {
            Taxonomy tax;
            PhylogenyNode n = it.next();
            if (n.getBranchData().isHasBranchColor() || (tax = PhylogenyMethods.getExternalDescendantsTaxonomy(n)) == null) continue;
            n.getBranchData().setBranchColor(new BranchColor(tree_panel.calculateTaxonomyBasedColor(tax)));
            List<PhylogenyNode> descs = PhylogenyMethods.getAllDescendants(n);
            for (PhylogenyNode desc : descs) {
                desc.getBranchData().setBranchColor(new BranchColor(tree_panel.calculateTaxonomyBasedColor(tax)));
            }
        }
    }

    static final int colorPhylogenyAccordingToRanks(Phylogeny tree, String rank, TreePanel tree_panel) {
        HashMap<String, Color> true_lineage_to_color_map = new HashMap<String, Color>();
        int colorizations = 0;
        PhylogenyNodeIterator it = tree.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (!n.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getScientificName()) && ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getCommonName()) && ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getTaxonomyCode()) || ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getRank()) || !n.getNodeData().getTaxonomy().getRank().equalsIgnoreCase(rank)) continue;
            BranchColor c = new BranchColor(tree_panel.calculateTaxonomyBasedColor(n.getNodeData().getTaxonomy()));
            TreePanelUtil.colorizeSubtree(n, c);
            ++colorizations;
            if (ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getScientificName())) continue;
            true_lineage_to_color_map.put(n.getNodeData().getTaxonomy().getScientificName(), c.getValue());
        }
        it = tree.iteratorPostorder();
        block3: while (it.hasNext()) {
            PhylogenyNode node = it.next();
            if (node.getBranchData().getBranchColor() != null || !node.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getLineage())) continue;
            boolean success = false;
            if (!true_lineage_to_color_map.isEmpty()) {
                for (String lin : node.getNodeData().getTaxonomy().getLineage()) {
                    if (!true_lineage_to_color_map.containsKey(lin)) continue;
                    TreePanelUtil.colorizeSubtree(node, new BranchColor((Color)true_lineage_to_color_map.get(lin)));
                    ++colorizations;
                    success = true;
                    break;
                }
            }
            if (success) continue;
            Map<String, String> lineage_to_rank_map = MainPanel.getLineageToRankMap();
            for (String lin : node.getNodeData().getTaxonomy().getLineage()) {
                Taxonomy temp_tax = new Taxonomy();
                temp_tax.setScientificName(lin);
                if (lineage_to_rank_map.containsKey(lin) && !ForesterUtil.isEmpty(lineage_to_rank_map.get(lin)) && lineage_to_rank_map.get(lin).equalsIgnoreCase(rank)) {
                    BranchColor c = new BranchColor(tree_panel.calculateTaxonomyBasedColor(temp_tax));
                    TreePanelUtil.colorizeSubtree(node, c);
                    ++colorizations;
                    true_lineage_to_color_map.put(lin, c.getValue());
                    continue block3;
                }
                UniProtTaxonomy up = null;
                try {
                    up = TaxonomyDataManager.obtainUniProtTaxonomy(temp_tax, null, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (up == null || ForesterUtil.isEmpty(up.getRank())) continue;
                lineage_to_rank_map.put(lin, up.getRank());
                if (!up.getRank().equalsIgnoreCase(rank)) continue;
                BranchColor c = new BranchColor(tree_panel.calculateTaxonomyBasedColor(temp_tax));
                TreePanelUtil.colorizeSubtree(node, c);
                ++colorizations;
                true_lineage_to_color_map.put(lin, c.getValue());
                continue block3;
            }
        }
        return colorizations;
    }

    static final String createAnnotationString(SortedSet<Annotation> annotations, boolean show_ref_sources) {
        TreeMap m = new TreeMap();
        for (Annotation an : annotations) {
            String ref_source;
            String string = ref_source = ForesterUtil.isEmpty(an.getRefSource()) ? "?" : an.getRefSource();
            if (!m.containsKey(ref_source)) {
                m.put(ref_source, new ArrayList());
            }
            ((List)m.get(ref_source)).add(an);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : m.entrySet()) {
            String ref_source = (String)e.getKey();
            List ans = (List)e.getValue();
            if (m.size() > 1) {
                sb.append("[");
            }
            if (show_ref_sources && !ref_source.equals("?")) {
                sb.append(ref_source);
                sb.append(": ");
            }
            for (int i = 0; i < ans.size(); ++i) {
                Annotation an = (Annotation)ans.get(i);
                if (!ForesterUtil.isEmpty(an.getRefValue())) {
                    sb.append(an.getRefValue());
                    sb.append(" ");
                }
                if (!ForesterUtil.isEmpty(an.getDesc())) {
                    sb.append(an.getDesc());
                }
                if (sb.charAt(sb.length() - 1) == ' ') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                if (i >= ans.size() - 1) continue;
                sb.append(", ");
            }
            if (m.size() <= 1) continue;
            sb.append("] ");
        }
        return sb.toString();
    }

    static final String getPartAfterColon(String s) {
        int i = s.indexOf(58);
        if (i < 1 || i == s.length() - 1) {
            return s;
        }
        return s.substring(i + 1, s.length());
    }

    static final boolean isHasAssignedEvent(PhylogenyNode node) {
        if (!node.getNodeData().isHasEvent()) {
            return false;
        }
        return !node.getNodeData().getEvent().isUnassigned();
    }

    static final boolean isSequenceEmpty(Sequence seq) {
        return seq.getAccession() == null && ForesterUtil.isEmpty(seq.getName()) && ForesterUtil.isEmpty(seq.getGeneName()) && ForesterUtil.isEmpty(seq.getSymbol());
    }

    static final boolean isTaxonomyEmpty(Taxonomy tax) {
        return tax.getIdentifier() == null && ForesterUtil.isEmpty(tax.getTaxonomyCode()) && ForesterUtil.isEmpty(tax.getCommonName()) && ForesterUtil.isEmpty(tax.getScientificName()) && tax.getSynonyms().isEmpty();
    }

    static final int nodeDataIntoStringBuffer(List<String> data, Options optz, StringBuilder sb) {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        int size = 0;
        if (optz.getExtDescNodeDataToReturn() != NodeDataField.SEQUENCE_MOL_SEQ_FASTA && optz.getExtDescNodeDataToReturn() != NodeDataField.GO_TERM_IDS) {
            for (String string : data) {
                if (ForesterUtil.isEmpty(string)) continue;
                if (map.containsKey(string)) {
                    map.put(string, (Integer)map.get(string) + 1);
                    continue;
                }
                map.put(string, 1);
            }
            if (optz.getExtDescNodeDataToReturn() == NodeDataField.DOMAINS_ALL || optz.getExtDescNodeDataToReturn() == NodeDataField.DOMAINS_COLLAPSED_PER_PROTEIN || optz.getExtDescNodeDataToReturn() == NodeDataField.SEQ_ANNOTATIONS) {
                ArrayList<StringInt> sis = new ArrayList<StringInt>();
                for (Map.Entry entry : map.entrySet()) {
                    sis.add(new StringInt((String)entry.getKey(), (Integer)entry.getValue()));
                }
                Collections.sort(sis, new StringInt.DescendingIntComparator());
                for (StringInt stringInt : sis) {
                    sb.append(stringInt.getString());
                    sb.append("\t");
                    sb.append(stringInt.getInt());
                    sb.append(ForesterUtil.LINE_SEPARATOR);
                }
            } else {
                for (Map.Entry entry : map.entrySet()) {
                    String string = (String)entry.getKey();
                    Object c = entry.getValue();
                    sb.append(string);
                    sb.append("\t");
                    sb.append(c);
                    sb.append(ForesterUtil.LINE_SEPARATOR);
                }
            }
            size = map.size();
        } else {
            for (String string : data) {
                if (ForesterUtil.isEmpty(string)) continue;
                sb.append(string);
                sb.append(ForesterUtil.LINE_SEPARATOR);
            }
            size = data.size();
        }
        return size;
    }

    static final String pdbAccToString(List<Accession> accs, int i) {
        if (ForesterUtil.isEmpty(accs.get(i).getComment())) {
            return accs.get(i).getValue();
        }
        return accs.get(i).getValue() + " (" + accs.get(i).getComment().toLowerCase() + ")";
    }

    static final Phylogeny subTree(PhylogenyNode new_root, Phylogeny source_phy) {
        Phylogeny new_phy = new Phylogeny();
        new_phy.setRooted(true);
        new_phy.setName(source_phy.getName());
        new_phy.setDescription(source_phy.getDescription());
        new_phy.setType(source_phy.getType());
        new_phy.setDistanceUnit(source_phy.getDistanceUnit());
        new_phy.setConfidence(source_phy.getConfidence());
        new_phy.setIdentifier(source_phy.getIdentifier());
        new_phy.setRoot(new_root.copyNodeDataShallow());
        int i = 0;
        for (PhylogenyNode n : new_root.getDescendants()) {
            new_phy.getRoot().setChildNode(i++, n);
        }
        return new_phy;
    }
}

