/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.BasicDescriptiveStatistics;

public final class Time {
    public static void main(String[] args) {
        try {
            BasicDescriptiveStatistics parse_stats = new BasicDescriptiveStatistics();
            BasicDescriptiveStatistics post_stats = new BasicDescriptiveStatistics();
            BasicDescriptiveStatistics pre_stats = new BasicDescriptiveStatistics();
            File f = new File(args[0]);
            Phylogeny phy = null;
            for (int i = 0; i < 10; ++i) {
                long start_time = new Date().getTime();
                phy = ParserBasedPhylogenyFactory.getInstance().create(f, new NHXParser())[0];
                System.out.println(phy.getNumberOfExternalNodes());
                parse_stats.addValue(new Date().getTime() - start_time);
                PhylogenyNode n = null;
                long start_time_post = new Date().getTime();
                PhylogenyNodeIterator post = phy.iteratorPostorder();
                while (post.hasNext()) {
                    n = post.next();
                }
                post_stats.addValue(new Date().getTime() - start_time_post);
                long start_time_pre = new Date().getTime();
                PhylogenyNodeIterator pre = phy.iteratorPreorder();
                while (pre.hasNext()) {
                    n = pre.next();
                }
                pre_stats.addValue(new Date().getTime() - start_time_pre);
            }
            System.out.println("Parsing [ms]:");
            System.out.println(parse_stats.toString());
            System.out.println("Post-order [ms]:");
            System.out.println(post_stats.toString());
            System.out.println("Pre-order [ms]:");
            System.out.println(pre_stats.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

