/*
 * Decompiled with CFR 0.152.
 */
package org.forester.pccx;

import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.pccx.BasicExternalNodeBasedCoverageExtender;
import org.forester.pccx.Coverage;
import org.forester.pccx.CoverageCalculator;
import org.forester.pccx.ExternalNodeBasedCoverageMethod;
import org.forester.pccx.ExternalNodeBasedCoverageMethodOptions;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;

public class TestPccx {
    private static final double ZERO_DIFF = 1.0E-6;

    private static boolean isEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-6;
    }

    public static boolean test() {
        return TestPccx.testExternalNodeBasedCoverage();
    }

    private static boolean testExternalNodeBasedCoverage() {
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            String ps1 = "((((A:0.1,B:0.7):0.2,C:1.0):2.0,D:1.7):1.3,((E:0.3,F:0.4):1.1,(G:0.5,H:0.6):1.2):1.4,X:2.0)";
            Phylogeny p1 = factory.create("((((A:0.1,B:0.7):0.2,C:1.0):2.0,D:1.7):1.3,((E:0.3,F:0.4):1.1,(G:0.5,H:0.6):1.2):1.4,X:2.0)", new NHXParser())[0];
            ArrayList<Phylogeny> phylogenies = new ArrayList<Phylogeny>();
            ArrayList<String> names = new ArrayList<String>();
            phylogenies.add(p1);
            names.add("A");
            names.add("A");
            ExternalNodeBasedCoverageMethodOptions options = new ExternalNodeBasedCoverageMethodOptions("org.forester.pccx.BranchCountingBasedScoringMethod");
            CoverageCalculator cc = CoverageCalculator.getInstance(new ExternalNodeBasedCoverageMethod(), options);
            Coverage cov = cc.calculateCoverage(phylogenies, names, false);
            if (!TestPccx.isEqual(cov.getScore(), 0.31719576719576714)) {
                return false;
            }
            names.add("B");
            names.add("B");
            cov = cc.calculateCoverage(phylogenies, names, false);
            if (!TestPccx.isEqual(cov.getScore(), 0.3727513227513228)) {
                return false;
            }
            names.add("G");
            cov = cc.calculateCoverage(phylogenies, names, false);
            if (!TestPccx.isEqual(cov.getScore(), 0.5370370370370371)) {
                return false;
            }
            names.add("E");
            cov = cc.calculateCoverage(phylogenies, names, false);
            if (!TestPccx.isEqual(cov.getScore(), 0.6481481481481483)) {
                return false;
            }
            names.add("X");
            cov = cc.calculateCoverage(phylogenies, names, false);
            if (!TestPccx.isEqual(cov.getScore(), 0.7407407407407408)) {
                return false;
            }
            names.add("C");
            names.add("C");
            names.add("C");
            cov = cc.calculateCoverage(phylogenies, names, false);
            if (!TestPccx.isEqual(cov.getScore(), 0.8148148148148149)) {
                return false;
            }
            names.add("D");
            cov = cc.calculateCoverage(phylogenies, names, false);
            if (!TestPccx.isEqual(cov.getScore(), 0.8888888888888888)) {
                return false;
            }
            names.add("F");
            cov = cc.calculateCoverage(phylogenies, names, false);
            if (!TestPccx.isEqual(cov.getScore(), 0.9444444444444444)) {
                return false;
            }
            names.add("H");
            cov = cc.calculateCoverage(phylogenies, names, false);
            if (!TestPccx.isEqual(cov.getScore(), 1.0)) {
                return false;
            }
            BasicExternalNodeBasedCoverageExtender ce = new BasicExternalNodeBasedCoverageExtender();
            List<String> l = ce.find(phylogenies, null, 0, new ExternalNodeBasedCoverageMethodOptions("org.forester.pccx.BranchCountingBasedScoringMethod"), null);
            if (!l.get(0).equals("X")) {
                return false;
            }
            if (!l.get(1).equals("A")) {
                return false;
            }
            if (!l.get(2).equals("E")) {
                return false;
            }
            if (!l.get(3).equals("G")) {
                return false;
            }
            if (!l.get(4).equals("C")) {
                return false;
            }
            if (!l.get(5).equals("D")) {
                return false;
            }
            if (!l.get(6).equals("B")) {
                return false;
            }
            if (!l.get(7).equals("F")) {
                return false;
            }
            if (!l.get(8).equals("H")) {
                return false;
            }
            ArrayList<String> already_covered = new ArrayList<String>();
            already_covered.add("A");
            already_covered.add("X");
            already_covered.add("H");
            already_covered.add("C");
            l = ce.find(phylogenies, already_covered, 0, new ExternalNodeBasedCoverageMethodOptions("org.forester.pccx.BranchCountingBasedScoringMethod"), null);
            if (!l.get(0).equals("E")) {
                return false;
            }
            if (!l.get(1).equals("D")) {
                return false;
            }
            if (!l.get(2).equals("B")) {
                return false;
            }
            if (!l.get(3).equals("F")) {
                return false;
            }
            if (!l.get(4).equals("G")) {
                return false;
            }
            String ps2 = "((((A:0.1,B:0.7):0.2,C:1.0):2.0,D:1.7):1.3,((E:0.3,F:0.4):1.1,(G:0.5,H:0.6):1.2):1.4,X:2.0)";
            String ps3 = "((((A:0.1,B:0.1):0.2,C:1.0):2.0,D:1.7):1.3,((E:0.3,F:0.4):1.1,(G:0.5,H:0.6):1.2):1.4,X:2.0)";
            String ps4 = "((((A:0.1,B:0.05):0.2,C:1.0):2.0,D:1.7):1.3,((E:0.3,F:0.4):1.1,(G:0.5,H:0.6):1.2):1.4,X:2.0)";
            Phylogeny p2 = factory.create("((((A:0.1,B:0.7):0.2,C:1.0):2.0,D:1.7):1.3,((E:0.3,F:0.4):1.1,(G:0.5,H:0.6):1.2):1.4,X:2.0)", new NHXParser())[0];
            Phylogeny p3 = factory.create("((((A:0.1,B:0.1):0.2,C:1.0):2.0,D:1.7):1.3,((E:0.3,F:0.4):1.1,(G:0.5,H:0.6):1.2):1.4,X:2.0)", new NHXParser())[0];
            Phylogeny p4 = factory.create("((((A:0.1,B:0.05):0.2,C:1.0):2.0,D:1.7):1.3,((E:0.3,F:0.4):1.1,(G:0.5,H:0.6):1.2):1.4,X:2.0)", new NHXParser())[0];
            ArrayList<Phylogeny> phylogenies2 = new ArrayList<Phylogeny>();
            ArrayList<String> names2 = new ArrayList<String>();
            phylogenies2.add(p2);
            phylogenies2.add(p3);
            phylogenies2.add(p4);
            names2.add("A");
            names2.add("A");
            ExternalNodeBasedCoverageMethodOptions options2 = new ExternalNodeBasedCoverageMethodOptions("org.forester.pccx.BranchLengthBasedScoringMethod");
            CoverageCalculator cc2 = CoverageCalculator.getInstance(new ExternalNodeBasedCoverageMethod(), options2);
            Coverage cov2 = cc2.calculateCoverage(phylogenies2, names2, false);
            double nf = 0.043446513326031395;
            if (!TestPccx.isEqual(cov2.getScore(), 0.6999131832738648)) {
                return false;
            }
            names2.add("C");
            cov2 = cc2.calculateCoverage(phylogenies2, names2, false);
            if (!TestPccx.isEqual(cov2.getScore(), 0.7099393017337181)) {
                return false;
            }
            names2.add("E");
            cov2 = cc2.calculateCoverage(phylogenies2, names2, false);
            if (!TestPccx.isEqual(cov2.getScore(), 0.9193662070896815)) {
                return false;
            }
            ExternalNodeBasedCoverageMethodOptions options_log = new ExternalNodeBasedCoverageMethodOptions("org.forester.pccx.LogBranchLengthBasedScoringMethod");
            CoverageCalculator cclog = CoverageCalculator.getInstance(new ExternalNodeBasedCoverageMethod(), options_log);
            Coverage cov_log = cclog.calculateCoverage(phylogenies2, names2, false);
            if (!TestPccx.isEqual(cov_log.getScore(), 0.8534252108361485)) {
                return false;
            }
            String ps10 = "((((A:0.1,B:0.7):0.2,C:1.0):2.0,D:1.7):1.3,((E:0.3,F:0.4):1.1,(G:0.5,H:0.6):1.2):1.4,((((I:0.1,J:0.7):0.2,K:1.0):2.0,L:1.7):1.3,((M:0.3,N:0.4,O:0.1,P:0.2):1.1,(Q:0.5,R:0.6):1.2):1.4,S:2.0):2.0)";
            Phylogeny p10 = factory.create("((((A:0.1,B:0.7):0.2,C:1.0):2.0,D:1.7):1.3,((E:0.3,F:0.4):1.1,(G:0.5,H:0.6):1.2):1.4,((((I:0.1,J:0.7):0.2,K:1.0):2.0,L:1.7):1.3,((M:0.3,N:0.4,O:0.1,P:0.2):1.1,(Q:0.5,R:0.6):1.2):1.4,S:2.0):2.0)", new NHXParser())[0];
            ArrayList<Phylogeny> phylogenies10 = new ArrayList<Phylogeny>();
            ArrayList<String> names10 = new ArrayList<String>();
            phylogenies10.add(p10);
            names10.add("A");
            names10.add("B");
            names10.add("N");
            names10.add("O");
            ExternalNodeBasedCoverageMethodOptions options10 = new ExternalNodeBasedCoverageMethodOptions("org.forester.pccx.BranchCountingBasedScoringMethod");
            CoverageCalculator cc10 = CoverageCalculator.getInstance(new ExternalNodeBasedCoverageMethod(), options10);
            cc10.calculateCoverage(phylogenies10, names10, true);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }
}

