/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class BinaryCharacters
implements PhylogenyData {
    public static final int COUNT_DEFAULT = -1;
    private final SortedSet<String> _present;
    private final SortedSet<String> _gained;
    private final SortedSet<String> _lost;
    private final int _present_count;
    private final int _gained_count;
    private final int _lost_count;
    private String _type;

    public BinaryCharacters() {
        this._present = new TreeSet<String>();
        this._gained = new TreeSet<String>();
        this._lost = new TreeSet<String>();
        this._present_count = -1;
        this._gained_count = -1;
        this._lost_count = -1;
    }

    public BinaryCharacters(SortedSet<String> present_characters, SortedSet<String> gained_characters, SortedSet<String> lost_characters, String type) {
        this._present = present_characters;
        this._gained = gained_characters;
        this._lost = lost_characters;
        this._type = type;
        this._present_count = -1;
        this._gained_count = -1;
        this._lost_count = -1;
    }

    public BinaryCharacters(SortedSet<String> present_characters, SortedSet<String> gained_characters, SortedSet<String> lost_characters, String type, int present_count, int gained_count, int lost_count) {
        this._present = present_characters;
        this._gained = gained_characters;
        this._lost = lost_characters;
        this._type = type;
        this._present_count = present_count;
        this._gained_count = gained_count;
        this._lost_count = lost_count;
        this.validate();
    }

    private void addCharacters(String indentation, Writer w, String[] present) throws IOException {
        for (String string : present) {
            PhylogenyDataUtil.appendElement(w, "bc", string, indentation);
        }
    }

    public void addGainedCharacter(String binary_character) {
        if (this.getLostCharacters().contains(binary_character)) {
            throw new IllegalArgumentException("attempt to add binary character [" + binary_character + "] to gained characters but is already listed as lost");
        }
        this.getGainedCharacters().add(binary_character);
    }

    public void addLostCharacter(String binary_character) {
        if (this.getPresentCharacters().contains(binary_character)) {
            throw new IllegalArgumentException("attempt to add binary character [" + binary_character + "] to lost characters but is already listed as present");
        }
        if (this.getGainedCharacters().contains(binary_character)) {
            throw new IllegalArgumentException("attempt to add binary character [" + binary_character + "] to lost characters but is already listed as gained");
        }
        this.getLostCharacters().add(binary_character);
    }

    public void addPresentCharacter(String binary_character) {
        if (this.getLostCharacters().contains(binary_character)) {
            throw new IllegalArgumentException("attempt to add binary character [" + binary_character + "] to present characters but is already listed as lost");
        }
        this.getPresentCharacters().add(binary_character);
    }

    @Override
    public StringBuffer asSimpleText() {
        return this.asText();
    }

    @Override
    public StringBuffer asText() {
        this.validate();
        StringBuffer sb = new StringBuffer();
        sb.append("present [");
        sb.append(this.getPresentCount());
        sb.append("]: ");
        sb.append(this.getPresentCharactersAsStringBuffer());
        sb.append(ForesterUtil.LINE_SEPARATOR);
        sb.append("gained  [ ");
        sb.append(this.getGainedCount());
        sb.append("]: ");
        sb.append(this.getGainedCharactersAsStringBuffer());
        sb.append(ForesterUtil.LINE_SEPARATOR);
        sb.append("lost    [");
        sb.append(this.getLostCount());
        sb.append("]: ");
        sb.append(this.getLostCharactersAsStringBuffer());
        return sb;
    }

    @Override
    public PhylogenyData copy() {
        this.validate();
        return new BinaryCharacters(this.getPresentCharacters(), this.getGainedCharacters(), this.getLostCharacters(), this.getType(), this.getPresentCount(), this.getGainedCount(), this.getLostCount());
    }

    public SortedSet<String> getGainedCharacters() {
        return this._gained;
    }

    public String[] getGainedCharactersAsStringArray() {
        return BinaryCharacters.sortedSetToStringArray(this.getGainedCharacters());
    }

    public StringBuffer getGainedCharactersAsStringBuffer() {
        return BinaryCharacters.sortedSetToStringBuffer(this.getGainedCharacters(), " ");
    }

    public int getGainedCount() {
        return this._gained_count;
    }

    public SortedSet<String> getLostCharacters() {
        return this._lost;
    }

    public String[] getLostCharactersAsStringArray() {
        return BinaryCharacters.sortedSetToStringArray(this.getLostCharacters());
    }

    public StringBuffer getLostCharactersAsStringBuffer() {
        return BinaryCharacters.sortedSetToStringBuffer(this.getLostCharacters(), " ");
    }

    public int getLostCount() {
        return this._lost_count;
    }

    public SortedSet<String> getPresentCharacters() {
        return this._present;
    }

    public String[] getPresentCharactersAsStringArray() {
        return BinaryCharacters.sortedSetToStringArray(this.getPresentCharacters());
    }

    public StringBuffer getPresentCharactersAsStringBuffer() {
        return BinaryCharacters.sortedSetToStringBuffer(this.getPresentCharacters(), " ");
    }

    public int getPresentCount() {
        return this._present_count;
    }

    public String getType() {
        return this._type;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        throw new UnsupportedOperationException();
    }

    public void setType(String type) {
        this._type = type;
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        this.validate();
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendOpen(writer, "binary_characters", "type", this.getType(), "gained_count", this.getGainedCount() != -1 ? String.valueOf(this.getGainedCount()) : "", "lost_count", this.getLostCount() != -1 ? String.valueOf(this.getLostCount()) : "", "present_count", this.getPresentCount() != -1 ? String.valueOf(this.getPresentCount()) : "");
        String my_ind = indentation + "  ";
        if (this.getGainedCharacters().size() > 0) {
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(my_ind);
            PhylogenyDataUtil.appendOpen(writer, "gained");
            this.addCharacters(my_ind, writer, this.getGainedCharactersAsStringArray());
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(my_ind);
            PhylogenyDataUtil.appendClose(writer, "gained");
        }
        if (this.getLostCharacters().size() > 0) {
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(my_ind);
            PhylogenyDataUtil.appendOpen(writer, "lost");
            this.addCharacters(my_ind, writer, this.getLostCharactersAsStringArray());
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(my_ind);
            PhylogenyDataUtil.appendClose(writer, "lost");
        }
        if (this.getPresentCharacters().size() > 0) {
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(my_ind);
            PhylogenyDataUtil.appendOpen(writer, "present");
            this.addCharacters(my_ind, writer, this.getPresentCharactersAsStringArray());
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(my_ind);
            PhylogenyDataUtil.appendClose(writer, "present");
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendClose(writer, "binary_characters");
    }

    public String toString() {
        return this.asText().toString();
    }

    private void validate() {
        if (this.getPresentCount() != -1 && this.getPresentCharacters().size() > 0 && this.getPresentCount() != this.getPresentCharacters().size()) {
            throw new RuntimeException("present characters size and count are unequal");
        }
        if (this.getGainedCount() != -1 && this.getGainedCharacters().size() > 0 && this.getGainedCount() != this.getGainedCharacters().size()) {
            throw new RuntimeException("gained characters size and count are unequal");
        }
        if (this.getLostCount() != -1 && this.getLostCharacters().size() > 0 && this.getLostCount() != this.getLostCharacters().size()) {
            throw new RuntimeException("lost characters size and count are unequal");
        }
    }

    private static String[] sortedSetToStringArray(SortedSet<String> set) {
        String[] chars = new String[set.size()];
        Iterator it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            chars[i++] = (String)it.next();
        }
        return chars;
    }

    private static StringBuffer sortedSetToStringBuffer(SortedSet<String> set, String separator) {
        StringBuffer sb = new StringBuffer();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(separator);
        }
        return sb;
    }
}

