/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public final class Identifier
implements PhylogenyData {
    private final String _value;
    private final String _provider;
    private final String _value_provider;

    public Identifier() {
        this._value = "";
        this._provider = "";
        this._value_provider = "";
    }

    public Identifier(String value) {
        this._value = value;
        this._provider = "";
        this._value_provider = value;
    }

    public Identifier(String value, String provider) {
        this._value = value;
        this._provider = provider;
        this._value_provider = provider != null ? value + provider : value;
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getValue());
    }

    @Override
    public StringBuffer asText() {
        StringBuffer sb = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getProvider())) {
            sb.append("[");
            sb.append(this.getProvider());
            sb.append("] ");
        }
        sb.append(this.getValue());
        return sb;
    }

    public String getValuePlusProvider() {
        return this._value_provider;
    }

    @Override
    public PhylogenyData copy() {
        return new Identifier(this.getValue(), this.getProvider());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + o + " [" + o.getClass() + "]");
        }
        return this.isEqual((Identifier)o);
    }

    public String getProvider() {
        return this._provider;
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        return this._value_provider.hashCode();
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        if (this == data) {
            return true;
        }
        if (data == null || this.getValue() == null) {
            return false;
        }
        Identifier a = (Identifier)data;
        if (this.getProvider() != null && a.getProvider() != null) {
            return a.getValue().equals(this.getValue()) && a.getProvider().equals(this.getProvider());
        }
        return a.getValue().equals(this.getValue());
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (!ForesterUtil.isEmpty(this.getProvider())) {
            PhylogenyDataUtil.appendElement(writer, "id", this.getValue(), "provider", this.getProvider(), indentation);
        } else {
            PhylogenyDataUtil.appendElement(writer, "id", this.getValue(), indentation);
        }
    }

    public String toString() {
        return this.asText().toString();
    }
}

