/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Point
implements PhylogenyData {
    private final String _geodetic_datum;
    private final BigDecimal _lat;
    private final BigDecimal _long;
    private final BigDecimal _alt;
    private final String _alt_unit;
    public static final String UNKNOWN_GEODETIC_DATUM = "?";

    public Point() {
        this(UNKNOWN_GEODETIC_DATUM, null, null, null, "");
    }

    public Point(String geodetic_datum, BigDecimal lat, BigDecimal longitude) {
        this(geodetic_datum, lat, longitude, null, "");
    }

    public boolean isEmpty() {
        return this._lat == null && this._long == null && this._alt == null;
    }

    public Point(String geodetic_datum, BigDecimal lat, BigDecimal longitude, BigDecimal alt, String alt_unit) {
        if (ForesterUtil.isEmpty(geodetic_datum)) {
            throw new IllegalArgumentException("illegal attempt to use empty geodetic datum");
        }
        if (alt != null && ForesterUtil.isEmpty(alt_unit)) {
            throw new IllegalArgumentException("altitude must hava a unit");
        }
        this._geodetic_datum = geodetic_datum;
        this._lat = lat;
        this._long = longitude;
        this._alt = alt;
        this._alt_unit = alt_unit;
    }

    @Override
    public StringBuffer asSimpleText() {
        if (this.isEmpty()) {
            return new StringBuffer();
        }
        if (this.getAltitude() == null) {
            return new StringBuffer("[" + this.getLatitude().toPlainString() + ", " + this.getLongitude() + "]");
        }
        return new StringBuffer("[" + this.getLatitude().toPlainString() + ", " + this.getLongitude() + ", " + this.getAltitude() + this.getAltiudeUnit() + "]");
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public PhylogenyData copy() {
        return new Point(this.getGeodeticDatum(), this.getLatitude() == null ? null : new BigDecimal(this.getLatitude().toPlainString()), this.getLongitude() == null ? null : new BigDecimal(this.getLongitude().toPlainString()), this.getAltitude() == null ? null : new BigDecimal(this.getAltitude().toPlainString()), this.getAltiudeUnit());
    }

    public BigDecimal getAltitude() {
        return this._alt;
    }

    public String getAltiudeUnit() {
        return this._alt_unit;
    }

    public String getGeodeticDatum() {
        return this._geodetic_datum;
    }

    public BigDecimal getLatitude() {
        return this._lat;
    }

    public BigDecimal getLongitude() {
        return this._long;
    }

    @Override
    public boolean isEqual(PhylogenyData point) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        if (this.getAltitude() != null) {
            PhylogenyDataUtil.appendOpen(writer, "point", "geodetic_datum", this.getGeodeticDatum(), "alt_unit", this.getAltiudeUnit());
        } else {
            PhylogenyDataUtil.appendOpen(writer, "point", "geodetic_datum", this.getGeodeticDatum());
        }
        PhylogenyDataUtil.appendElement(writer, "lat", this.getLatitude().toPlainString(), indentation);
        PhylogenyDataUtil.appendElement(writer, "long", this.getLongitude().toPlainString(), indentation);
        if (this.getAltitude() != null) {
            PhylogenyDataUtil.appendElement(writer, "alt", this.getAltitude().toPlainString(), indentation);
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendClose(writer, "point");
    }

    public String toString() {
        return this.asSimpleText().toString();
    }

    public static final boolean isSeemsEmpty(Point p) {
        return !(p.getAltitude() != null && p.getAltitude().compareTo(BigDecimal.ZERO) > 0 || p.getLongitude() != null && p.getLongitude().compareTo(BigDecimal.ZERO) > 0 || p.getLatitude() != null && p.getLatitude().compareTo(BigDecimal.ZERO) > 0 || !ForesterUtil.isEmpty(p.getGeodeticDatum()) && !p.getGeodeticDatum().equalsIgnoreCase(UNKNOWN_GEODETIC_DATUM) || !ForesterUtil.isEmpty(p.getAltiudeUnit()) && !p.getAltiudeUnit().equalsIgnoreCase(UNKNOWN_GEODETIC_DATUM));
    }
}

