/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Property;
import org.forester.util.ForesterUtil;

public class PropertiesMap
implements PhylogenyData {
    private final SortedMap<String, Property> _properties = new TreeMap<String, Property>();

    public int size() {
        return this._properties.size();
    }

    public void addProperty(Property property) throws IllegalArgumentException {
        if (this.getProperties().containsKey(property.getRef())) {
            throw new IllegalArgumentException("ref [" + property.getRef() + "] is already present");
        }
        this.getProperties().put(property.getRef(), property);
    }

    @Override
    public StringBuffer asSimpleText() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String ref : this.getPropertyRefs()) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(this.getProperty(ref).asText());
        }
        return sb;
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public PhylogenyData copy() {
        PropertiesMap new_one = new PropertiesMap();
        for (String r : this.getProperties().keySet()) {
            new_one.addProperty((Property)this.getProperties().get(r));
        }
        return new_one;
    }

    public SortedMap<String, Property> getProperties() {
        return this._properties;
    }

    public Property[] getPropertiesArray() {
        Property[] a = new Property[this.getProperties().size()];
        int i = 0;
        for (String ref : this.getProperties().keySet()) {
            a[i++] = (Property)this.getProperties().get(ref);
        }
        return a;
    }

    public List<Property> getPropertiesWithGivenReferencePrefix(String ref_prefix) throws IllegalArgumentException {
        if (ForesterUtil.isEmpty(ref_prefix)) {
            throw new IllegalArgumentException("reference prefix is null or empty");
        }
        String my_ref_prefix = new String(ref_prefix.trim());
        ArrayList<Property> props = new ArrayList<Property>();
        for (String ref : this.getProperties().keySet()) {
            if (!ref.startsWith(my_ref_prefix)) continue;
            props.add(this.getProperty(ref));
        }
        return props;
    }

    public Property getProperty(String ref) throws IllegalArgumentException {
        if (this.getProperties().containsKey(ref)) {
            return (Property)this.getProperties().get(ref);
        }
        throw new IllegalArgumentException("reference [" + ref + "] is not present");
    }

    public String[] getPropertyRefs() {
        if (this.getProperties() == null) {
            return new String[0];
        }
        Property[] properties = this.getPropertiesArray();
        String[] refs = new String[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            refs[i] = properties[i].getRef();
        }
        return refs;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        throw new UnsupportedOperationException();
    }

    public boolean refExists(String ref) {
        if (this.getProperties() != null) {
            for (String r : this.getProperties().keySet()) {
                if (!r.equalsIgnoreCase(ref)) continue;
                return true;
            }
        }
        return false;
    }

    public Property removeProperty(String ref) throws IllegalArgumentException {
        if (this.getProperties().containsKey(ref)) {
            return (Property)this.getProperties().remove(ref);
        }
        throw new IllegalArgumentException("reference [" + ref + "] is not present");
    }

    public List<String> removePropertiesWithGivenReferencePrefix(String ref_prefix) throws IllegalArgumentException {
        if (ForesterUtil.isEmpty(ref_prefix)) {
            throw new IllegalArgumentException("reference prefix is null or empty");
        }
        String my_ref_prefix = new String(ref_prefix.trim());
        ArrayList<String> to_remove = new ArrayList<String>();
        for (String ref : this.getProperties().keySet()) {
            if (!ref.startsWith(my_ref_prefix)) continue;
            to_remove.add(ref);
        }
        for (String ref : to_remove) {
            this.getProperties().remove(ref);
        }
        return to_remove;
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (this.getProperties() != null) {
            for (String ref : this.getProperties().keySet()) {
                ((Property)this.getProperties().get(ref)).toPhyloXML(writer, level, indentation);
            }
        }
    }

    public String toString() {
        return this.asSimpleText().toString();
    }
}

