/*
 * Decompiled with CFR 0.152.
 */
package org.forester.protein;

import org.forester.util.ForesterUtil;

public class ProteinId
implements Comparable<ProteinId> {
    private final String _id;

    public ProteinId(String id) {
        if (ForesterUtil.isEmpty(id)) {
            throw new IllegalArgumentException("attempt to create new protein id from empty or null string");
        }
        this._id = id.trim();
    }

    @Override
    public int compareTo(ProteinId protein_id) {
        if (this == protein_id) {
            return 0;
        }
        return this.getId().toLowerCase().compareTo(protein_id.getId().toLowerCase());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            throw new IllegalArgumentException("attempt to check protein id equality to null");
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check protein id equality to " + o + " [" + o.getClass() + "]");
        }
        return this.getId().equals(((ProteinId)o).getId());
    }

    public String getId() {
        return this._id;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }
}

