/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.util.HashMap;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.SDIException;
import org.forester.sdi.SDIutil;
import org.forester.util.ForesterUtil;

public class SDI {
    final Phylogeny _gene_tree;
    final Phylogeny _species_tree;
    int _duplications_sum;
    int _mapping_cost;

    public SDI(Phylogeny gene_tree, Phylogeny species_tree) throws SDIException {
        if (species_tree.isEmpty() || gene_tree.isEmpty()) {
            throw new IllegalArgumentException("attempt to infer duplications using empty tree(s)");
        }
        if (!species_tree.isRooted()) {
            throw new IllegalArgumentException("attempt to infer duplications on unrooted species tree");
        }
        this._gene_tree = gene_tree;
        this._species_tree = species_tree;
        this._mapping_cost = -1;
        this._duplications_sum = 0;
        PhylogenyMethods.preOrderReId(this.getSpeciesTree());
        this.linkNodesOfG();
        this.geneTreePostOrderTraversal(this.getGeneTree().getRoot());
    }

    public int computeMappingCostL() {
        this._species_tree.levelOrderReID();
        this._mapping_cost = 0;
        this.computeMappingCostHelper(this._gene_tree.getRoot());
        return this._mapping_cost;
    }

    public int getDuplicationsSum() {
        return this._duplications_sum;
    }

    public Phylogeny getGeneTree() {
        return this._gene_tree;
    }

    public Phylogeny getSpeciesTree() {
        return this._species_tree;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass());
        sb.append(ForesterUtil.LINE_SEPARATOR);
        sb.append("Duplications sum                   : " + this.getDuplicationsSum());
        sb.append(ForesterUtil.LINE_SEPARATOR);
        sb.append("mapping cost L                     : " + this.computeMappingCostL());
        return sb.toString();
    }

    void geneTreePostOrderTraversal(PhylogenyNode g) {
        if (!g.isExternal()) {
            this.geneTreePostOrderTraversal(g.getChildNode(0));
            this.geneTreePostOrderTraversal(g.getChildNode(1));
            PhylogenyNode a = g.getChildNode(0).getLink();
            PhylogenyNode b = g.getChildNode(1).getLink();
            while (a != b) {
                if (a.getId() > b.getId()) {
                    a = a.getParent();
                    continue;
                }
                b = b.getParent();
            }
            g.setLink(a);
            Event event = null;
            if (a == g.getChildNode(0).getLink() || a == g.getChildNode(1).getLink()) {
                event = Event.createSingleDuplicationEvent();
                ++this._duplications_sum;
            } else {
                event = Event.createSingleSpeciationEvent();
            }
            g.getNodeData().setEvent(event);
        }
    }

    final void linkNodesOfG() throws SDIException {
        String tax_str;
        HashMap<String, PhylogenyNode> speciestree_ext_nodes = new HashMap<String, PhylogenyNode>();
        SDIutil.TaxonomyComparisonBase tax_comp_base = this.determineTaxonomyComparisonBase();
        PhylogenyNodeIterator iter = this._species_tree.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode s = iter.next();
            tax_str = SDIutil.taxonomyToString(s, tax_comp_base);
            if (speciestree_ext_nodes.containsKey(tax_str)) {
                throw new IllegalArgumentException("taxonomy [" + s.getNodeData().getTaxonomy() + "] is not unique in species phylogeny");
            }
            speciestree_ext_nodes.put(tax_str, s);
        }
        iter = this._gene_tree.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode g = iter.next();
            tax_str = SDIutil.taxonomyToString(g, tax_comp_base);
            PhylogenyNode s = (PhylogenyNode)speciestree_ext_nodes.get(tax_str);
            if (s == null) {
                throw new IllegalArgumentException("taxonomy [" + g.getNodeData().getTaxonomy() + "] not present in species tree");
            }
            g.setLink(s);
        }
    }

    int updateM(boolean prev_root_was_dup, PhylogenyNode prev_root_c1, PhylogenyNode prev_root_c2) {
        PhylogenyNode root = this.getGeneTree().getRoot();
        if (root.getChildNode1() == prev_root_c1 || root.getChildNode2() == prev_root_c1) {
            this.calculateMforNode(prev_root_c1);
        } else {
            this.calculateMforNode(prev_root_c2);
        }
        Event event = null;
        event = prev_root_was_dup ? Event.createSingleDuplicationEvent() : Event.createSingleSpeciationEvent();
        root.getNodeData().setEvent(event);
        this.calculateMforNode(root);
        return this.getDuplicationsSum();
    }

    private void calculateMforNode(PhylogenyNode n) {
        if (!n.isExternal()) {
            boolean was_duplication = n.isDuplication();
            PhylogenyNode a = n.getChildNode1().getLink();
            PhylogenyNode b = n.getChildNode2().getLink();
            while (a != b) {
                if (a.getId() > b.getId()) {
                    a = a.getParent();
                    continue;
                }
                b = b.getParent();
            }
            n.setLink(a);
            Event event = null;
            if (a == n.getChildNode1().getLink() || a == n.getChildNode2().getLink()) {
                event = Event.createSingleDuplicationEvent();
                if (!was_duplication) {
                    ++this._duplications_sum;
                }
            } else {
                event = Event.createSingleSpeciationEvent();
                if (was_duplication) {
                    --this._duplications_sum;
                }
            }
            n.getNodeData().setEvent(event);
        }
    }

    private void computeMappingCostHelper(PhylogenyNode g) {
        if (!g.isExternal()) {
            this.computeMappingCostHelper(g.getChildNode1());
            this.computeMappingCostHelper(g.getChildNode2());
            this._mapping_cost = g.getLink() != g.getChildNode1().getLink() && g.getLink() != g.getChildNode2().getLink() ? (int)((long)this._mapping_cost + (g.getChildNode1().getLink().getId() + g.getChildNode2().getLink().getId() - 2L * g.getLink().getId() - 2L)) : (g.getLink() != g.getChildNode1().getLink() && g.getLink() == g.getChildNode2().getLink() ? (int)((long)this._mapping_cost + (g.getChildNode1().getLink().getId() - g.getLink().getId() + 1L)) : (g.getLink() == g.getChildNode1().getLink() && g.getLink() != g.getChildNode2().getLink() ? (int)((long)this._mapping_cost + (g.getChildNode2().getLink().getId() - g.getLink().getId() + 1L)) : ++this._mapping_cost));
        }
    }

    private SDIutil.TaxonomyComparisonBase determineTaxonomyComparisonBase() {
        Taxonomy tax;
        PhylogenyNode n;
        SDIutil.TaxonomyComparisonBase base = null;
        boolean all_have_id = true;
        boolean all_have_code = true;
        boolean all_have_sn = true;
        PhylogenyNodeIterator iter = this._species_tree.iteratorExternalForward();
        while (iter.hasNext()) {
            n = iter.next();
            if (n.getNodeData().isHasTaxonomy()) {
                tax = n.getNodeData().getTaxonomy();
                if (tax.getIdentifier() == null || ForesterUtil.isEmpty(tax.getIdentifier().getValue())) {
                    all_have_id = false;
                }
                if (ForesterUtil.isEmpty(tax.getTaxonomyCode())) {
                    all_have_code = false;
                }
                if (!ForesterUtil.isEmpty(tax.getScientificName())) continue;
                all_have_sn = false;
                continue;
            }
            throw new IllegalArgumentException("species tree node [" + n + "] has no taxonomic data");
        }
        iter = this._gene_tree.iteratorExternalForward();
        while (iter.hasNext()) {
            n = iter.next();
            if (n.getNodeData().isHasTaxonomy()) {
                tax = n.getNodeData().getTaxonomy();
                if (tax.getIdentifier() == null || ForesterUtil.isEmpty(tax.getIdentifier().getValue())) {
                    all_have_id = false;
                }
                if (ForesterUtil.isEmpty(tax.getTaxonomyCode())) {
                    all_have_code = false;
                }
                if (!ForesterUtil.isEmpty(tax.getScientificName())) continue;
                all_have_sn = false;
                continue;
            }
            throw new IllegalArgumentException("gene tree node [" + n + "] has no taxonomic data");
        }
        if (all_have_id) {
            base = SDIutil.TaxonomyComparisonBase.ID;
        } else if (all_have_code) {
            base = SDIutil.TaxonomyComparisonBase.CODE;
        } else if (all_have_sn) {
            base = SDIutil.TaxonomyComparisonBase.SCIENTIFIC_NAME;
        } else {
            throw new IllegalArgumentException("gene tree and species tree have incomparable taxonomies");
        }
        return base;
    }

    private final void linkNodesOfGByTaxonomyIdentifier() {
        PhylogenyNodeIterator iter;
        HashMap<String, PhylogenyNode> speciestree_ext_nodes = new HashMap<String, PhylogenyNode>();
        if (this._species_tree.getFirstExternalNode().isRoot()) {
            speciestree_ext_nodes.put(this._species_tree.getFirstExternalNode().getNodeData().getTaxonomy().getIdentifier().getValue(), this._species_tree.getFirstExternalNode());
        } else {
            iter = this._species_tree.iteratorExternalForward();
            while (iter.hasNext()) {
                PhylogenyNode s = iter.next();
                speciestree_ext_nodes.put(s.getNodeData().getTaxonomy().getIdentifier().getValue(), s);
            }
        }
        iter = this._gene_tree.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode g = iter.next();
            PhylogenyNode s = (PhylogenyNode)speciestree_ext_nodes.get(g.getNodeData().getTaxonomy().getIdentifier().getValue());
            if (s == null) {
                String message = "species [" + g.getNodeData().getTaxonomy().getIdentifier().getValue();
                message = message + "] not present in species tree";
                throw new IllegalArgumentException(message);
            }
            g.setLink(s);
        }
    }
}

