/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.forester.util.ThreadedStreamHandler;

public class SystemCommandExecutor {
    private final List<String> _command_information;
    private ThreadedStreamHandler _input_stream_handler;
    private ThreadedStreamHandler _error_stream_handler;
    private static final boolean DEBUG = false;

    public SystemCommandExecutor(List<String> command_information) {
        if (command_information == null || command_information.isEmpty()) {
            throw new IllegalArgumentException("command information is required");
        }
        SystemCommandExecutor.checkCmdFile(new File(command_information.get(0)));
        this._command_information = command_information;
    }

    public static boolean isExecuteableFile(File path_to_cmd_f) {
        if (!path_to_cmd_f.exists()) {
            return false;
        }
        if (path_to_cmd_f.isDirectory()) {
            return false;
        }
        return path_to_cmd_f.canExecute();
    }

    private static void checkCmdFile(File path_to_cmd_f) {
        if (!path_to_cmd_f.exists()) {
            throw new IllegalArgumentException("[" + path_to_cmd_f.getAbsolutePath() + "] does not exist");
        }
        if (path_to_cmd_f.isDirectory()) {
            throw new IllegalArgumentException("[" + path_to_cmd_f.getAbsolutePath() + "] is a directory");
        }
        if (!path_to_cmd_f.canExecute()) {
            throw new IllegalArgumentException("[" + path_to_cmd_f.getAbsolutePath() + "] is not executeable");
        }
    }

    public int executeCommand() throws IOException, InterruptedException {
        int exit_value = -99;
        try {
            ProcessBuilder pb = new ProcessBuilder(this._command_information);
            Process process = pb.start();
            OutputStream stdOutput = process.getOutputStream();
            InputStream inputStream = process.getInputStream();
            InputStream errorStream = process.getErrorStream();
            this._input_stream_handler = new ThreadedStreamHandler(inputStream, stdOutput);
            this._error_stream_handler = new ThreadedStreamHandler(errorStream);
            this._input_stream_handler.start();
            this._error_stream_handler.start();
            exit_value = process.waitFor();
            this._input_stream_handler.interrupt();
            this._error_stream_handler.interrupt();
            this._input_stream_handler.join();
            this._error_stream_handler.join();
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        return exit_value;
    }

    public StringBuilder getStandardErrorFromCommand() {
        return this._error_stream_handler.getOutputBuffer();
    }

    public StringBuilder getStandardOutputFromCommand() {
        return this._input_stream_handler.getOutputBuffer();
    }
}

