/*
 * Decompiled with CFR 0.152.
 */
package com.github.mzdb4s.io.writer;

import com.github.mzdb4s.Logging;
import com.github.mzdb4s.db.model.InstrumentConfiguration;
import com.github.mzdb4s.db.model.MzDbHeader;
import com.github.mzdb4s.db.model.MzDbMetaData;
import com.github.mzdb4s.db.model.ProcessingMethod;
import com.github.mzdb4s.db.model.Run;
import com.github.mzdb4s.db.model.Sample;
import com.github.mzdb4s.db.model.Software;
import com.github.mzdb4s.db.model.SourceFile;
import com.github.mzdb4s.db.model.SpectrumXmlMetaData;
import com.github.mzdb4s.db.model.params.ParamTree;
import com.github.mzdb4s.db.model.params.param.UserParam;
import com.github.mzdb4s.db.table.BoundingBoxTable$;
import com.github.mzdb4s.db.table.DataEncodingTable$;
import com.github.mzdb4s.db.table.DataProcessingTable$;
import com.github.mzdb4s.db.table.InstrumentConfigurationTable$;
import com.github.mzdb4s.db.table.MzdbTable$;
import com.github.mzdb4s.db.table.ProcessingMethodTable$;
import com.github.mzdb4s.db.table.RunSliceTable$;
import com.github.mzdb4s.db.table.RunTable$;
import com.github.mzdb4s.db.table.SampleTable$;
import com.github.mzdb4s.db.table.SharedParamTreeTable$;
import com.github.mzdb4s.db.table.SoftwareTable$;
import com.github.mzdb4s.db.table.SourceFileTable$;
import com.github.mzdb4s.io.serialization.XmlSerializer$;
import com.github.mzdb4s.io.writer.AbstractMzDbWriter$;
import com.github.mzdb4s.io.writer.BoundingBox;
import com.github.mzdb4s.io.writer.BoundingBoxWriterCache;
import com.github.mzdb4s.io.writer.DataEncodingRegistry;
import com.github.mzdb4s.io.writer.MzDbSchema$;
import com.github.mzdb4s.io.writer.RunSliceStructureFactory;
import com.github.mzdb4s.io.writer.SpectrumSliceIndex;
import com.github.mzdb4s.msdata.BBSizes;
import com.github.mzdb4s.msdata.DataEncoding;
import com.github.mzdb4s.msdata.IDataEncoding;
import com.github.mzdb4s.msdata.ISpectrumData;
import com.github.mzdb4s.msdata.IsolationWindow;
import com.github.mzdb4s.msdata.PeakEncoding$;
import com.github.mzdb4s.msdata.RunSliceHeader;
import com.github.mzdb4s.msdata.Spectrum;
import com.github.mzdb4s.msdata.SpectrumHeader;
import com.github.mzdb4s.util.collection.package;
import com.github.sqlite4s.ISQLiteConnection;
import com.github.sqlite4s.ISQLiteFactory;
import com.github.sqlite4s.ISQLiteStatement;
import java.io.File;
import java.util.Date;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import slogging.LazyLogging;
import slogging.LoggerHolder;
import slogging.UnderlyingLogger;

@ScalaSignature(bytes="\u0006\u0001\tUr!B\u0001\u0003\u0011\u0003i\u0011AE!cgR\u0014\u0018m\u0019;Nu\u0012\u0013wK]5uKJT!a\u0001\u0003\u0002\r]\u0014\u0018\u000e^3s\u0015\t)a!\u0001\u0002j_*\u0011q\u0001C\u0001\u0007[j$'\rN:\u000b\u0005%Q\u0011AB4ji\",(MC\u0001\f\u0003\r\u0019w.\\\u0002\u0001!\tqq\"D\u0001\u0003\r\u0015\u0001\"\u0001#\u0001\u0012\u0005I\t%m\u001d;sC\u000e$XJ\u001f#c/JLG/\u001a:\u0014\u0005=\u0011\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\rC\u0003\u001a\u001f\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001b!9Ad\u0004b\u0001\n\u0003i\u0012!D'P\t\u0016cuLV#S'&{e*F\u0001\u001f!\t\u0019r$\u0003\u0002!)\t1Ai\\;cY\u0016DaAI\b!\u0002\u0013q\u0012AD'P\t\u0016cuLV#S'&{e\n\t\u0004\u0006!\t\t\t\u0001J\n\u0004GI)\u0003C\u0001\u0014(\u001b\u00051\u0011B\u0001\u0015\u0007\u0005\u001daunZ4j]\u001eDQ!G\u0012\u0005\u0002)\"\u0012a\u000b\t\u0003\u001d\rBq!L\u0012C\u0002\u001b\u0005a&\u0001\u0006eE2{7-\u0019;j_:,\u0012a\f\t\u0003aQj\u0011!\r\u0006\u0003\u000bIR\u0011aM\u0001\u0005U\u00064\u0018-\u0003\u00026c\t!a)\u001b7f\u0011\u001d94E1A\u0007\u0002a\n\u0001\"\\3uC\u0012\u000bG/Y\u000b\u0002sA\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0006[>$W\r\u001c\u0006\u0003}\u0019\t!\u0001\u001a2\n\u0005\u0001[$\u0001D'{\t\nlU\r^1ECR\f\u0007b\u0002\"$\u0005\u00045\taQ\u0001\bE\n\u001c\u0016N_3t+\u0005!\u0005CA#I\u001b\u00051%BA$\u0007\u0003\u0019i7\u000fZ1uC&\u0011\u0011J\u0012\u0002\b\u0005\n\u001b\u0016N_3t\u0011\u001dY5E1A\u0007\u00021\u000bQ![:E\u0013\u0006+\u0012!\u0014\t\u0003'9K!a\u0014\u000b\u0003\u000f\t{w\u000e\\3b]\"9\u0011k\tb\u0001\u000e'\u0011\u0016AA:g+\u0005\u0019\u0006C\u0001+X\u001b\u0005)&B\u0001,\t\u0003!\u0019\u0018\u000f\\5uKR\u001a\u0018B\u0001-V\u00059I5+\u0015'ji\u00164\u0015m\u0019;pefDqAW\u0012C\u0002\u0013%1,\u0001\b`q6d7+\u001a:jC2L'0\u001a:\u0016\u0003qs!!X6\u000f\u0005yKgBA0i\u001d\t\u0001wM\u0004\u0002bM:\u0011!-Z\u0007\u0002G*\u0011A\rD\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\tQG!A\u0007tKJL\u0017\r\\5{CRLwN\\\u0005\u0003Y6\fQ\u0002W7m'\u0016\u0014\u0018.\u00197ju\u0016\u0014(B\u00016\u0005\u0011\u0019y7\u0005)A\u00059\u0006yq\f_7m'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0005C\u0005rG\u0001\u0007\t\u0019!C\u0005e\u0006YqlY8o]\u0016\u001cG/[8o+\u0005\u0019\bC\u0001+u\u0013\t)XKA\tJ'Fc\u0015\u000e^3D_:tWm\u0019;j_:D\u0011b^\u0012A\u0002\u0003\u0007I\u0011\u0002=\u0002\u001f}\u001bwN\u001c8fGRLwN\\0%KF$\"!\u001f?\u0011\u0005MQ\u0018BA>\u0015\u0005\u0011)f.\u001b;\t\u000fu4\u0018\u0011!a\u0001g\u0006\u0019\u0001\u0010J\u0019\t\r}\u001c\u0003\u0015)\u0003t\u00031y6m\u001c8oK\u000e$\u0018n\u001c8!\u0011-\t\u0019a\ta\u0001\u0002\u0004%I!!\u0002\u0002\u001f}\u0013'm\u001c=J]N,'\u000f^*u[R,\"!a\u0002\u0011\u0007Q\u000bI!C\u0002\u0002\fU\u0013\u0001#S*R\u0019&$Xm\u0015;bi\u0016lWM\u001c;\t\u0017\u0005=1\u00051AA\u0002\u0013%\u0011\u0011C\u0001\u0014?\n\u0014w\u000e_%og\u0016\u0014Ho\u0015;ni~#S-\u001d\u000b\u0004s\u0006M\u0001\"C?\u0002\u000e\u0005\u0005\t\u0019AA\u0004\u0011!\t9b\tQ!\n\u0005\u001d\u0011\u0001E0cE>D\u0018J\\:feR\u001cF/\u001c;!\u0011-\tYb\ta\u0001\u0002\u0004%I!!\u0002\u0002!}\u0013HO]3f\u0013:\u001cXM\u001d;Ti6$\bbCA\u0010G\u0001\u0007\t\u0019!C\u0005\u0003C\tAc\u0018:ue\u0016,\u0017J\\:feR\u001cF/\u001c;`I\u0015\fHcA=\u0002$!IQ0!\b\u0002\u0002\u0003\u0007\u0011q\u0001\u0005\t\u0003O\u0019\u0003\u0015)\u0003\u0002\b\u0005\trL\u001d;sK\u0016Len]3siN#X\u000e\u001e\u0011\t\u0017\u0005-2\u00051AA\u0002\u0013%\u0011QA\u0001\u0014?6\u001chN\u0015;sK\u0016Len]3siN#X\u000e\u001e\u0005\f\u0003_\u0019\u0003\u0019!a\u0001\n\u0013\t\t$A\f`[Nt'\u000b\u001e:fK&s7/\u001a:u'RlGo\u0018\u0013fcR\u0019\u00110a\r\t\u0013u\fi#!AA\u0002\u0005\u001d\u0001\u0002CA\u001cG\u0001\u0006K!a\u0002\u0002)}k7O\u001c*ue\u0016,\u0017J\\:feR\u001cF/\u001c;!\u0011-\tYd\ta\u0001\u0002\u0004%I!!\u0002\u0002'}\u001b\b/Z2ueVl\u0017J\\:feR\u001cF/\u001c;\t\u0017\u0005}2\u00051AA\u0002\u0013%\u0011\u0011I\u0001\u0018?N\u0004Xm\u0019;sk6Len]3siN#X\u000e^0%KF$2!_A\"\u0011%i\u0018QHA\u0001\u0002\u0004\t9\u0001\u0003\u0005\u0002H\r\u0002\u000b\u0015BA\u0004\u0003Qy6\u000f]3diJ,X.\u00138tKJ$8\u000b^7uA!I\u00111J\u0012A\u0002\u0013%\u0011QJ\u0001\u0016?&t7/\u001a:uK\u0012\u001c\u0006/Z2ue\u0006\u001cu.\u001e8u+\t\ty\u0005E\u0002\u0014\u0003#J1!a\u0015\u0015\u0005\rIe\u000e\u001e\u0005\n\u0003/\u001a\u0003\u0019!C\u0005\u00033\n\u0011dX5og\u0016\u0014H/\u001a3Ta\u0016\u001cGO]1D_VtGo\u0018\u0013fcR\u0019\u00110a\u0017\t\u0013u\f)&!AA\u0002\u0005=\u0003\u0002CA0G\u0001\u0006K!a\u0014\u0002-}Kgn]3si\u0016$7\u000b]3diJ\f7i\\;oi\u0002B\u0011\"a\u0019$\u0005\u0004%I!!\u001a\u0002+}#\u0017\r^1F]\u000e|G-\u001b8h%\u0016<\u0017n\u001d;ssV\u0011\u0011q\r\t\u0004\u001d\u0005%\u0014bAA6\u0005\t!B)\u0019;b\u000b:\u001cw\u000eZ5oOJ+w-[:uefD\u0001\"a\u001c$A\u0003%\u0011qM\u0001\u0017?\u0012\fG/Y#oG>$\u0017N\\4SK\u001eL7\u000f\u001e:zA!I\u00111O\u0012C\u0002\u0013%\u0011QO\u0001\t?\n\u00147)Y2iKV\u0011\u0011q\u000f\t\u0004\u001d\u0005e\u0014bAA>\u0005\t1\"i\\;oI&twMQ8y/JLG/\u001a:DC\u000eDW\r\u0003\u0005\u0002\u0000\r\u0002\u000b\u0011BA<\u0003%y&MY\"bG\",\u0007\u0005C\u0005\u0002\u0004\u000e\u0012\r\u0011\"\u0003\u0002\u0006\u0006IrL];o'2L7-Z*ueV\u001cG/\u001e:f\r\u0006\u001cGo\u001c:z+\t\t9\tE\u0002\u000f\u0003\u0013K1!a#\u0003\u0005a\u0011VO\\*mS\u000e,7\u000b\u001e:vGR,(/\u001a$bGR|'/\u001f\u0005\t\u0003\u001f\u001b\u0003\u0015!\u0003\u0002\b\u0006QrL];o'2L7-Z*ueV\u001cG/\u001e:f\r\u0006\u001cGo\u001c:zA!9\u00111S\u0012\u0005\u0012\u0005\u0015\u0011A\u00042c_bLen]3siN#X\u000e\u001e\u0005\b\u0003/\u001bC\u0011AAM\u000359W\r^\"p]:,7\r^5p]R\t1\u000fC\u0004\u0002\u001e\u000e\"\t!a(\u0002\t=\u0004XM\u001c\u000b\u0002s\"9\u00111U\u0012\u0005\u0002\u0005}\u0015!B2m_N,\u0007bBATG\u0011%\u0011\u0011V\u0001\u0010?&t7/\u001a:u\u001b\u0016$\u0018\rR1uCR\u0019\u00110a+\t\r]\n)\u000b1\u0001:\u0011\u001d\tyk\tC\u0001\u0003c\u000ba\"\u001b8tKJ$8\u000b]3diJ,X\u000eF\u0004z\u0003g\u000bi,a2\t\u0011\u0005U\u0016Q\u0016a\u0001\u0003o\u000b\u0001b\u001d9fGR\u0014X/\u001c\t\u0004\u000b\u0006e\u0016bAA^\r\nA1\u000b]3diJ,X\u000e\u0003\u0005\u0002@\u00065\u0006\u0019AAa\u00039iW\r^1ECR\f\u0017i\u001d+fqR\u00042AOAb\u0013\r\t)m\u000f\u0002\u0014'B,7\r\u001e:v[bkG.T3uC\u0012\u000bG/\u0019\u0005\t\u0003\u0013\fi\u000b1\u0001\u0002L\u0006aA-\u0019;b\u000b:\u001cw\u000eZ5oOB\u0019Q)!4\n\u0007\u0005=gI\u0001\u0007ECR\fWI\\2pI&tw\rC\u0004\u0002T\u000e\"I!!6\u00027};W\r\u001e\"C/&$\bNT3yiN\u0003Xm\u0019;sk6\u001cF.[2f)9\t9.!=\u0002t\u0006u(\u0011\u0001B\u0003\u0005\u0013!\u0002\"!7\u0002`\u0006\r\u0018Q\u001e\t\u0004\u001d\u0005m\u0017bAAo\u0005\tY!i\\;oI&twMQ8y\u0011!\t\t/!5A\u0002\u0005=\u0013a\u00029fC.LE\r\u001f\u0005\t\u0003K\f\t\u000e1\u0001\u0002h\u0006)Q.\u001b8NuB\u00191#!;\n\u0007\u0005-HCA\u0003GY>\fG\u000f\u0003\u0005\u0002p\u0006E\u0007\u0019AAt\u0003\u0015i\u0017\r_'{\u0011!\t),!5A\u0002\u0005]\u0006\u0002CA{\u0003#\u0004\r!a>\u0002\u0015M\u0004Xm\u0019;sk6LE\rE\u0002\u0014\u0003sL1!a?\u0015\u0005\u0011auN\\4\t\u0011\u0005}\u0018\u0011\u001ba\u0001\u0003O\fAb\u001d9fGR\u0014X/\u001c+j[\u0016D\u0001Ba\u0001\u0002R\u0002\u0007\u0011qJ\u0001\b[NdUM^3m\u0011!\u00119!!5A\u0002\u0005-\u0017a\u00023bi\u0006,en\u0019\u0005\t\u0005\u0017\t\t\u000e1\u0001\u0003\u000e\u0005\u0011\u0012n]8mCRLwN\\,j]\u0012|wo\u00149u!\u0015\u0019\"q\u0002B\n\u0013\r\u0011\t\u0002\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\u0015\u0013)\"C\u0002\u0003\u0018\u0019\u0013q\"S:pY\u0006$\u0018n\u001c8XS:$wn\u001e\u0005\b\u00057\u0019C\u0011\u0002B\u000f\u0003-yf\r\\;tQ\n\u0013%k\\<\u0015\u000be\u0014yB!\t\t\u0011\t\r!\u0011\u0004a\u0001\u0003\u001fB\u0001Ba\u0003\u0003\u001a\u0001\u0007!Q\u0002\u0005\b\u0005K\u0019c\u0011\u0003B\u0014\u0003EIgn]3si\n{WO\u001c3j]\u001e\u0014u\u000e\u001f\u000b\u0005\u0003o\u0014I\u0003\u0003\u0005\u0003,\t\r\u0002\u0019AAm\u0003\t\u0011'\rC\u0004\u00030\r\"IA!\r\u00025}Kgn]3si\u0006sG-\u00138eKb\u0014u.\u001e8eS:<'i\u001c=\u0015\u0007e\u0014\u0019\u0004\u0003\u0005\u0003,\t5\u0002\u0019AAm\u0001")
public abstract class AbstractMzDbWriter
implements Logging {
    private final XmlSerializer$ com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_xmlSerializer;
    private ISQLiteConnection com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection;
    private ISQLiteStatement _bboxInsertStmt;
    private ISQLiteStatement _rtreeInsertStmt;
    private ISQLiteStatement _msnRtreeInsertStmt;
    private ISQLiteStatement _spectrumInsertStmt;
    private int _insertedSpectraCount;
    private final DataEncodingRegistry _dataEncodingRegistry;
    private final BoundingBoxWriterCache _bbCache;
    private final RunSliceStructureFactory _runSliceStructureFactory;
    private final UnderlyingLogger logger;
    private final String loggerName;
    private volatile boolean bitmap$0;

    public static double MODEL_VERSION() {
        return AbstractMzDbWriter$.MODULE$.MODEL_VERSION();
    }

    private UnderlyingLogger logger$lzycompute() {
        AbstractMzDbWriter abstractMzDbWriter = this;
        synchronized (abstractMzDbWriter) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public UnderlyingLogger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public final String loggerName() {
        return this.loggerName;
    }

    public final void slogging$LoggerHolder$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public abstract File dbLocation();

    public abstract MzDbMetaData metaData();

    public abstract BBSizes bbSizes();

    public abstract boolean isDIA();

    public abstract ISQLiteFactory sf();

    public XmlSerializer$ com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_xmlSerializer() {
        return this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_xmlSerializer;
    }

    public ISQLiteConnection com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection() {
        return this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection;
    }

    private void com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection_$eq(ISQLiteConnection x$1) {
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection = x$1;
    }

    private ISQLiteStatement _bboxInsertStmt() {
        return this._bboxInsertStmt;
    }

    private void _bboxInsertStmt_$eq(ISQLiteStatement x$1) {
        this._bboxInsertStmt = x$1;
    }

    private ISQLiteStatement _rtreeInsertStmt() {
        return this._rtreeInsertStmt;
    }

    private void _rtreeInsertStmt_$eq(ISQLiteStatement x$1) {
        this._rtreeInsertStmt = x$1;
    }

    private ISQLiteStatement _msnRtreeInsertStmt() {
        return this._msnRtreeInsertStmt;
    }

    private void _msnRtreeInsertStmt_$eq(ISQLiteStatement x$1) {
        this._msnRtreeInsertStmt = x$1;
    }

    private ISQLiteStatement _spectrumInsertStmt() {
        return this._spectrumInsertStmt;
    }

    private void _spectrumInsertStmt_$eq(ISQLiteStatement x$1) {
        this._spectrumInsertStmt = x$1;
    }

    private int _insertedSpectraCount() {
        return this._insertedSpectraCount;
    }

    private void _insertedSpectraCount_$eq(int x$1) {
        this._insertedSpectraCount = x$1;
    }

    private DataEncodingRegistry _dataEncodingRegistry() {
        return this._dataEncodingRegistry;
    }

    private BoundingBoxWriterCache _bbCache() {
        return this._bbCache;
    }

    private RunSliceStructureFactory _runSliceStructureFactory() {
        return this._runSliceStructureFactory;
    }

    public ISQLiteStatement bboxInsertStmt() {
        return this._bboxInsertStmt();
    }

    public ISQLiteConnection getConnection() {
        return this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection();
    }

    public void open() {
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection_$eq(this.sf().newSQLiteConnection(this.dbLocation()));
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().open(true);
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("PRAGMA encoding='UTF-8';");
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("PRAGMA synchronous=OFF;");
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("PRAGMA journal_mode=OFF;");
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("PRAGMA temp_store=2;");
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("PRAGMA cache_size=-100000;");
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("PRAGMA automatic_index=OFF;");
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("PRAGMA locking_mode=EXCLUSIVE;");
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("PRAGMA ignore_check_constraints=ON;");
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("BEGIN TRANSACTION;");
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"auto commit:").append((Object)BoxesRunTime.boxToBoolean((boolean)this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().getAutoCommit())).toString());
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec(MzDbSchema$.MODULE$.getDDLString());
        this._bboxInsertStmt_$eq(this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " VALUES (NULL, ?, ?, ?, ?)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoundingBoxTable$.MODULE$.tableName()})), false));
        this._rtreeInsertStmt_$eq(this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO bounding_box_rtree VALUES (?, ?, ?, ?, ?)"})).s((Seq)Nil$.MODULE$), false));
        this._msnRtreeInsertStmt_$eq(this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO bounding_box_msn_rtree VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)"})).s((Seq)Nil$.MODULE$), false));
        String placeHolders = ((TraversableOnce)List$.MODULE$.fill(24, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "?";
            }
        })).mkString(", ");
        this._spectrumInsertStmt_$eq(this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO tmp_spectrum VALUES (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{placeHolders})), false));
        this._insertMetaData(this.metaData());
    }

    public void close() {
        block10: {
            if (this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection() == null) {
                throw new IllegalStateException("The method open() must first be called");
            }
            try {
                this._bbCache().getBBRowsKeys().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AbstractMzDbWriter $outer;

                    public final void apply(Tuple2<Object, Option<IsolationWindow>> x0$1) {
                        Tuple2<Object, Option<IsolationWindow>> tuple2 = x0$1;
                        if (tuple2 != null) {
                            int msLevel = tuple2._1$mcI$sp();
                            Option isoWinOpt = (Option)tuple2._2();
                            int n = msLevel;
                            if (isoWinOpt != null) {
                                Option option = isoWinOpt;
                                this.$outer.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_flushBBRow(n, (Option<IsolationWindow>)option);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE TABLE spectrum AS SELECT * FROM tmp_spectrum;");
                ObjectRef stmt = ObjectRef.create((Object)this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " VALUES (?, ?, ?, ?, ?, ?, NULL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataEncodingTable$.MODULE$.tableName()})), false));
                Seq<DataEncoding> dataEncs = this._dataEncodingRegistry().getDistinctDataEncodings();
                dataEncs.foreach((Function1)new Serializable(this, stmt){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef stmt$1;

                    public final ISQLiteStatement apply(DataEncoding dataEnc) {
                        Enumeration.Value peakEnc;
                        int mzPrecision = 64;
                        int intPrecision = 32;
                        Enumeration.Value value = peakEnc = dataEnc.getPeakEncoding();
                        Enumeration.Value value2 = PeakEncoding$.MODULE$.LOW_RES_PEAK();
                        if (!(value != null ? !value.equals(value2) : value2 != null)) {
                            mzPrecision = 32;
                        } else {
                            Enumeration.Value value3 = peakEnc;
                            Enumeration.Value value4 = PeakEncoding$.MODULE$.NO_LOSS_PEAK();
                            if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                                intPrecision = 64;
                            }
                        }
                        ((ISQLiteStatement)this.stmt$1.elem).bind(1, dataEnc.getId());
                        ((ISQLiteStatement)this.stmt$1.elem).bind(2, dataEnc.getMode().toString());
                        ((ISQLiteStatement)this.stmt$1.elem).bind(3, dataEnc.getCompression());
                        ((ISQLiteStatement)this.stmt$1.elem).bind(4, dataEnc.getByteOrder().toString().toLowerCase());
                        ((ISQLiteStatement)this.stmt$1.elem).bind(5, mzPrecision);
                        ((ISQLiteStatement)this.stmt$1.elem).bind(6, intPrecision);
                        ((ISQLiteStatement)this.stmt$1.elem).step();
                        return ((ISQLiteStatement)this.stmt$1.elem).reset();
                    }
                    {
                        this.stmt$1 = stmt$1;
                    }
                });
                ((ISQLiteStatement)stmt.elem).dispose();
                stmt.elem = this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " VALUES (?, ?, ?, ?, ?, NULL, ?)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunSliceTable$.MODULE$.tableName()})), false);
                this._runSliceStructureFactory().getAllRunSlices().foreach((Function1)new Serializable(this, stmt){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef stmt$1;

                    public final ISQLiteStatement apply(RunSliceHeader runSlice) {
                        ((ISQLiteStatement)this.stmt$1.elem).bind(1, runSlice.id());
                        ((ISQLiteStatement)this.stmt$1.elem).bind(2, runSlice.msLevel());
                        ((ISQLiteStatement)this.stmt$1.elem).bind(3, runSlice.number());
                        ((ISQLiteStatement)this.stmt$1.elem).bind(4, runSlice.beginMz());
                        ((ISQLiteStatement)this.stmt$1.elem).bind(5, runSlice.endMz());
                        ((ISQLiteStatement)this.stmt$1.elem).bind(6, runSlice.runId());
                        ((ISQLiteStatement)this.stmt$1.elem).step();
                        return ((ISQLiteStatement)this.stmt$1.elem).reset();
                    }
                    {
                        this.stmt$1 = stmt$1;
                    }
                });
                ((ISQLiteStatement)stmt.elem).dispose();
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE UNIQUE INDEX spectrum_initial_id_idx ON spectrum (initial_id ASC,run_id ASC);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE INDEX spectrum_ms_level_idx ON spectrum (ms_level ASC,run_id ASC);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE UNIQUE INDEX run_name_idx ON run (name);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE UNIQUE INDEX run_slice_mz_range_idx ON run_slice (begin_mz ASC,end_mz ASC,ms_level ASC,run_id ASC);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE INDEX bounding_box_run_slice_idx ON bounding_box (run_slice_id ASC);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE INDEX bounding_box_first_spectrum_idx ON bounding_box (first_spectrum_id ASC); ");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE UNIQUE INDEX controlled_vocabulary_full_name_idx ON cv (full_name);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE INDEX controlled_vocabulary_uri_idx ON cv (uri);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE UNIQUE INDEX source_file_name_idx ON source_file (name);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE UNIQUE INDEX sample_name_idx ON sample (name);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE UNIQUE INDEX software_name_idx ON software (name);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE UNIQUE INDEX instrument_configuration_name_idx ON instrument_configuration (name);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE UNIQUE INDEX processing_method_number_idx ON processing_method (number ASC);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE UNIQUE INDEX data_processing_name_idx ON data_processing (name);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE UNIQUE INDEX chromatogram_name_idx ON chromatogram (name);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE UNIQUE INDEX cv_term_name_idx ON cv_term (name ASC);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE UNIQUE INDEX user_term_name_idx ON user_term (name ASC);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE UNIQUE INDEX cv_unit_name_idx ON cv_unit (name ASC);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("CREATE INDEX spectrum_bb_first_spectrum_id_idx ON spectrum (bb_first_spectrum_id ASC);");
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec("COMMIT TRANSACTION;");
                if (this._bboxInsertStmt() == null) break block10;
            }
            catch (Throwable throwable) {
                if (this._bboxInsertStmt() != null) {
                    this._bboxInsertStmt().dispose();
                }
                if (this._rtreeInsertStmt() != null) {
                    this._rtreeInsertStmt().dispose();
                }
                if (this._msnRtreeInsertStmt() != null) {
                    this._msnRtreeInsertStmt().dispose();
                }
                if (this._spectrumInsertStmt() != null) {
                    this._spectrumInsertStmt().dispose();
                }
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().dispose();
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection_$eq(this.sf().newSQLiteConnection(this.dbLocation()));
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().open(false);
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO sqlite_sequence VALUES ('spectrum',", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this._insertedSpectraCount())})));
                this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().dispose();
                throw throwable;
            }
            this._bboxInsertStmt().dispose();
        }
        if (this._rtreeInsertStmt() != null) {
            this._rtreeInsertStmt().dispose();
        }
        if (this._msnRtreeInsertStmt() != null) {
            this._msnRtreeInsertStmt().dispose();
        }
        if (this._spectrumInsertStmt() != null) {
            this._spectrumInsertStmt().dispose();
        }
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().dispose();
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection_$eq(this.sf().newSQLiteConnection(this.dbLocation()));
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().open(false);
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().exec(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO sqlite_sequence VALUES ('spectrum',", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this._insertedSpectraCount())})));
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().dispose();
    }

    private void _insertMetaData(MzDbMetaData metaData) {
        if (this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection() == null) {
            throw new IllegalStateException("The method open() must first be called");
        }
        ObjectRef stmt = ObjectRef.create((Object)this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " VALUES (NULL, ?)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataProcessingTable$.MODULE$.tableName()})), false));
        Seq procMethods = metaData.getProcessingMethods();
        Seq dpNames = (Seq)((SeqLike)procMethods.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ProcessingMethod x$1) {
                return x$1.dataProcessingName();
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        Map dpIdByName = ((TraversableOnce)dpNames.map((Function1)new Serializable(this, stmt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractMzDbWriter $outer;
            private final ObjectRef stmt$2;

            public final Tuple2<String, Object> apply(String dpName) {
                ((ISQLiteStatement)this.stmt$2.elem).bind(1, dpName);
                ((ISQLiteStatement)this.stmt$2.elem).step();
                long dpId = this.$outer.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().getLastInsertId();
                ((ISQLiteStatement)this.stmt$2.elem).reset();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)dpName), (Object)BoxesRunTime.boxToLong((long)dpId));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.stmt$2 = stmt$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ((ISQLiteStatement)stmt.elem).dispose();
        stmt.elem = this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " VALUES (NULL, ?, ?, ?, ?, ?)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ProcessingMethodTable$.MODULE$.tableName()})), false);
        procMethods.foreach((Function1)new Serializable(this, stmt, dpIdByName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractMzDbWriter $outer;
            private final ObjectRef stmt$2;
            private final Map dpIdByName$1;

            public final ISQLiteStatement apply(ProcessingMethod procMethod) {
                ((ISQLiteStatement)this.stmt$2.elem).bind(1, procMethod.getNumber());
                ISQLiteStatement iSQLiteStatement = procMethod.getParamTree().isEmpty() ? ((ISQLiteStatement)this.stmt$2.elem).bindNull(2) : ((ISQLiteStatement)this.stmt$2.elem).bind(2, this.$outer.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_xmlSerializer().serializeParamTree((ParamTree)procMethod.getParamTree().get()));
                ((ISQLiteStatement)this.stmt$2.elem).bindNull(3);
                ((ISQLiteStatement)this.stmt$2.elem).bind(4, BoxesRunTime.unboxToLong((Object)this.dpIdByName$1.apply((Object)procMethod.getDataProcessingName())));
                ((ISQLiteStatement)this.stmt$2.elem).bind(5, procMethod.getSoftwareId());
                ((ISQLiteStatement)this.stmt$2.elem).step();
                return ((ISQLiteStatement)this.stmt$2.elem).reset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.stmt$2 = stmt$2;
                this.dpIdByName$1 = dpIdByName$1;
            }
        });
        ((ISQLiteStatement)stmt.elem).dispose();
        stmt.elem = this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().prepare(new StringBuilder().append((Object)"INSERT INTO ").append((Object)SharedParamTreeTable$.MODULE$.tableName()).append((Object)" VALUES (NULL, ?, ?)").toString(), false);
        ((ISQLiteStatement)stmt.elem).bind(1, this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_xmlSerializer().serializeParamTree(metaData.getCommonInstrumentParams().getParamTree()));
        ((ISQLiteStatement)stmt.elem).bind(2, "CommonInstrumentParams");
        ((ISQLiteStatement)stmt.elem).step();
        ((ISQLiteStatement)stmt.elem).reset();
        ((ISQLiteStatement)stmt.elem).dispose();
        stmt.elem = this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().prepare(new StringBuilder().append((Object)"INSERT INTO ").append((Object)InstrumentConfigurationTable$.MODULE$.tableName()).append((Object)" VALUES (NULL, ?, NULL, ?, NULL,  ?)").toString(), false);
        Seq instConfigs = metaData.getInstrumentConfigurations();
        instConfigs.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(InstrumentConfiguration instConfig) {
                return instConfig.getComponentList() != null;
            }
        }).foreach((Function1)new Serializable(this, stmt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractMzDbWriter $outer;
            private final ObjectRef stmt$2;

            public final ISQLiteStatement apply(InstrumentConfiguration instConfig) {
                ((ISQLiteStatement)this.stmt$2.elem).bind(1, instConfig.getName());
                ((ISQLiteStatement)this.stmt$2.elem).bind(2, this.$outer.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_xmlSerializer().serializeComponentList(instConfig.getComponentList()));
                ((ISQLiteStatement)this.stmt$2.elem).bind(3, instConfig.getSoftwareId());
                ((ISQLiteStatement)this.stmt$2.elem).step();
                return ((ISQLiteStatement)this.stmt$2.elem).reset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.stmt$2 = stmt$2;
            }
        });
        ((ISQLiteStatement)stmt.elem).dispose();
        stmt.elem = this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " VALUES (?, ?, ?, ?, ?)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MzdbTable$.MODULE$.tableName()})), false);
        MzDbHeader mzDbHeader = metaData.getMzDbHeader();
        ParamTree mzdbHeaderParams = (ParamTree)mzDbHeader.getParamTree().get();
        Set bbSizesKeySet = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ms1_bb_mz_width", "ms1_bb_time_width", "msn_bb_mz_width", "msn_bb_time_width"}));
        Seq userExtraParams = (Seq)mzdbHeaderParams.getUserParams().filterNot((Function1)new Serializable(this, bbSizesKeySet){
            public static final long serialVersionUID = 0L;
            private final Set bbSizesKeySet$1;

            public final boolean apply(UserParam p) {
                return this.bbSizesKeySet$1.contains((Object)p.name());
            }
            {
                this.bbSizesKeySet$1 = bbSizesKeySet$1;
            }
        });
        Seq updatedUserParams = (Seq)userExtraParams.$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UserParam[]{new UserParam("ms1_bb_mz_width", ((Object)BoxesRunTime.boxToDouble((double)this.bbSizes().BB_MZ_HEIGHT_MS1())).toString(), "xsd:float"), new UserParam("ms1_bb_time_width", ((Object)BoxesRunTime.boxToFloat((float)this.bbSizes().BB_RT_WIDTH_MS1())).toString(), "xsd:float"), new UserParam("msn_bb_mz_width", ((Object)BoxesRunTime.boxToDouble((double)this.bbSizes().BB_MZ_HEIGHT_MSn())).toString(), "xsd:float"), new UserParam("msn_bb_time_width", ((Object)BoxesRunTime.boxToFloat((float)this.bbSizes().BB_RT_WIDTH_MSn())).toString(), "xsd:float")})), Seq$.MODULE$.canBuildFrom());
        mzdbHeaderParams.setUserParams(updatedUserParams);
        ((ISQLiteStatement)stmt.elem).bind(1, AbstractMzDbWriter$.MODULE$.MODEL_VERSION());
        ((ISQLiteStatement)stmt.elem).bind(2, (int)(new Date().getTime() / 1000L));
        ((ISQLiteStatement)stmt.elem).bind(3, "");
        ((ISQLiteStatement)stmt.elem).bind(4, "");
        String serializedMzDbParamTree = this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_xmlSerializer().serializeParamTree(mzdbHeaderParams);
        ((ISQLiteStatement)stmt.elem).bind(5, serializedMzDbParamTree);
        ((ISQLiteStatement)stmt.elem).step();
        ((ISQLiteStatement)stmt.elem).reset();
        ((ISQLiteStatement)stmt.elem).dispose();
        stmt.elem = this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " VALUES (NULL,?,?,?,?,?,?,?,?,?)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunTable$.MODULE$.tableName()})), false);
        Seq runs = metaData.getRuns();
        runs.foreach((Function1)new Serializable(this, stmt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractMzDbWriter $outer;
            private final ObjectRef stmt$2;

            public final ISQLiteStatement apply(Run run) {
                ((ISQLiteStatement)this.stmt$2.elem).bind(1, run.getName());
                ((ISQLiteStatement)this.stmt$2.elem).bind(2, "2015-02-05T19:30:47Z");
                ISQLiteStatement iSQLiteStatement = run.getParamTree().isEmpty() ? ((ISQLiteStatement)this.stmt$2.elem).bind(3, "<params />") : ((ISQLiteStatement)this.stmt$2.elem).bind(3, this.$outer.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_xmlSerializer().serializeParamTree((ParamTree)run.getParamTree().get()));
                ((ISQLiteStatement)this.stmt$2.elem).bindNull(4);
                ((ISQLiteStatement)this.stmt$2.elem).bind(5, 1);
                ((ISQLiteStatement)this.stmt$2.elem).bind(6, 1);
                ((ISQLiteStatement)this.stmt$2.elem).bind(7, 1);
                ((ISQLiteStatement)this.stmt$2.elem).bind(8, 1);
                ((ISQLiteStatement)this.stmt$2.elem).bind(9, 1);
                ((ISQLiteStatement)this.stmt$2.elem).step();
                return ((ISQLiteStatement)this.stmt$2.elem).reset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.stmt$2 = stmt$2;
            }
        });
        ((ISQLiteStatement)stmt.elem).dispose();
        stmt.elem = this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " VALUES (NULL, ?, ?, NULL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SampleTable$.MODULE$.tableName()})), false);
        Seq samples = metaData.getSamples();
        samples.foreach((Function1)new Serializable(this, stmt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractMzDbWriter $outer;
            private final ObjectRef stmt$2;

            public final ISQLiteStatement apply(Sample sample) {
                ((ISQLiteStatement)this.stmt$2.elem).bind(1, sample.getName());
                ISQLiteStatement iSQLiteStatement = sample.getParamTree().isEmpty() ? ((ISQLiteStatement)this.stmt$2.elem).bind(2, "<params />") : ((ISQLiteStatement)this.stmt$2.elem).bind(2, this.$outer.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_xmlSerializer().serializeParamTree((ParamTree)sample.getParamTree().get()));
                ((ISQLiteStatement)this.stmt$2.elem).step();
                return ((ISQLiteStatement)this.stmt$2.elem).reset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.stmt$2 = stmt$2;
            }
        });
        ((ISQLiteStatement)stmt.elem).dispose();
        stmt.elem = this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " VALUES (NULL, ?, ?, ?, NULL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SoftwareTable$.MODULE$.tableName()})), false);
        Seq softwareList = metaData.getSoftwareList();
        softwareList.foreach((Function1)new Serializable(this, stmt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractMzDbWriter $outer;
            private final ObjectRef stmt$2;

            public final ISQLiteStatement apply(Software software) {
                ((ISQLiteStatement)this.stmt$2.elem).bind(1, software.getName());
                ((ISQLiteStatement)this.stmt$2.elem).bind(2, software.getVersion());
                ISQLiteStatement iSQLiteStatement = software.getParamTree().isEmpty() ? ((ISQLiteStatement)this.stmt$2.elem).bind(3, "") : ((ISQLiteStatement)this.stmt$2.elem).bind(3, this.$outer.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_xmlSerializer().serializeParamTree((ParamTree)software.getParamTree().get()));
                ((ISQLiteStatement)this.stmt$2.elem).step();
                return ((ISQLiteStatement)this.stmt$2.elem).reset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.stmt$2 = stmt$2;
            }
        });
        ((ISQLiteStatement)stmt.elem).dispose();
        stmt.elem = this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_connection().prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " VALUES (NULL, ?, ?, ?, NULL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SourceFileTable$.MODULE$.tableName()})), false);
        Seq sourceFiles = metaData.getSourceFiles();
        sourceFiles.foreach((Function1)new Serializable(this, stmt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractMzDbWriter $outer;
            private final ObjectRef stmt$2;

            public final ISQLiteStatement apply(SourceFile sourceFile) {
                ((ISQLiteStatement)this.stmt$2.elem).bind(1, sourceFile.getName());
                ((ISQLiteStatement)this.stmt$2.elem).bind(2, sourceFile.getLocation());
                ISQLiteStatement iSQLiteStatement = sourceFile.getParamTree().isEmpty() ? ((ISQLiteStatement)this.stmt$2.elem).bind(3, "") : ((ISQLiteStatement)this.stmt$2.elem).bind(3, this.$outer.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_xmlSerializer().serializeParamTree((ParamTree)sourceFile.getParamTree().get()));
                ((ISQLiteStatement)this.stmt$2.elem).step();
                return ((ISQLiteStatement)this.stmt$2.elem).reset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.stmt$2 = stmt$2;
            }
        });
        ((ISQLiteStatement)stmt.elem).dispose();
    }

    public void insertSpectrum(Spectrum spectrum, SpectrumXmlMetaData metaDataAsText, DataEncoding dataEncoding) {
        boolean isTimeForNewBBRow;
        this._insertedSpectraCount_$eq(this._insertedSpectraCount() + 1);
        SpectrumHeader sh = spectrum.getHeader();
        ISpectrumData sd = spectrum.getData();
        SpectrumXmlMetaData smd = metaDataAsText;
        int peaksCount2 = sd.getPeaksCount();
        int msLevel = sh.getMsLevel();
        None$ isolationWindowOpt = this.isDIA() && msLevel == 2 ? sh.isolationWindow() : None$.MODULE$;
        int spectrumId = this._insertedSpectraCount();
        float spectrumTime = sh.getElutionTime();
        DataEncoding dataEnc = this._dataEncodingRegistry().getOrAddDataEncoding((IDataEncoding)dataEncoding);
        float curMinMz = (float)((int)package$.MODULE$.round(sd.getMzAt(0) / this.bbSizes().BB_MZ_HEIGHT_MS1())) * (float)this.bbSizes().BB_MZ_HEIGHT_MS1();
        float mzInc = (float)(msLevel == 1 ? this.bbSizes().BB_MZ_HEIGHT_MS1() : this.bbSizes().BB_MZ_HEIGHT_MSn());
        float curMaxMz = curMinMz + mzInc;
        if (msLevel == 2 && !this.isDIA()) {
            curMinMz = 0.0f;
            curMaxMz = (float)this.bbSizes().BB_MZ_HEIGHT_MSn();
        }
        if (isTimeForNewBBRow = this._bbCache().isTimeForNewBBRow(msLevel, (Option<IsolationWindow>)isolationWindowOpt, spectrumTime)) {
            this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_flushBBRow(msLevel, (Option<IsolationWindow>)isolationWindowOpt);
        }
        BoundingBox curBB = null;
        long bbFirstSpectrumId = 0L;
        for (int i = 0; i < peaksCount2; ++i) {
            double mz = sd.getMzAt(i);
            if (i == 0) {
                curBB = this._getBBWithNextSpectrumSlice(spectrum, spectrumId, spectrumTime, msLevel, dataEnc, (Option<IsolationWindow>)isolationWindowOpt, i, curMinMz, curMaxMz);
                bbFirstSpectrumId = BoxesRunTime.unboxToLong((Object)curBB.spectrumIds().head());
            } else if (mz > (double)curMaxMz) {
                while (mz > (double)curMaxMz) {
                    Tuple3 runSliceBoundaries = new Tuple3((Object)BoxesRunTime.boxToInteger((int)msLevel), (Object)BoxesRunTime.boxToFloat((float)(curMinMz += mzInc)), (Object)BoxesRunTime.boxToFloat((float)(curMaxMz += mzInc)));
                    Object object = this._runSliceStructureFactory().hasRunSlice((Tuple3<Object, Object, Object>)runSliceBoundaries) ? BoxedUnit.UNIT : this._runSliceStructureFactory().addRunSlice((Tuple3<Object, Object, Object>)runSliceBoundaries);
                }
                curBB = this._getBBWithNextSpectrumSlice(spectrum, spectrumId, spectrumTime, msLevel, dataEnc, (Option<IsolationWindow>)isolationWindowOpt, i, curMinMz, curMaxMz);
            }
            if (!((Option)curBB.spectrumSlices().last()).isDefined()) continue;
            SpectrumSliceIndex lastSpectrumSlice = (SpectrumSliceIndex)((Option)curBB.spectrumSlices().last()).get();
            lastSpectrumSlice.lastPeakIdx_$eq(i);
        }
        ISQLiteStatement stmt = this._spectrumInsertStmt();
        stmt.bind(1, spectrumId);
        stmt.bind(2, sh.getInitialId());
        stmt.bind(3, sh.title());
        stmt.bind(4, sh.getCycle());
        stmt.bind(5, (double)sh.getTime());
        stmt.bind(6, msLevel);
        ISQLiteStatement iSQLiteStatement = sh.activationType().isEmpty() ? stmt.bindNull(7) : stmt.bind(7, sh.activationType().get().toString());
        stmt.bind(8, (double)sh.getTic());
        stmt.bind(9, sh.getBasePeakMz());
        stmt.bind(10, (double)sh.getBasePeakIntensity());
        ISQLiteStatement iSQLiteStatement2 = sh.getPrecursorMz().isEmpty() ? stmt.bindNull(11) : stmt.bind(11, BoxesRunTime.unboxToDouble((Object)sh.getPrecursorMz().get()));
        ISQLiteStatement iSQLiteStatement3 = sh.getPrecursorCharge().isEmpty() ? stmt.bindNull(12) : stmt.bind(12, BoxesRunTime.unboxToInt((Object)sh.getPrecursorCharge().get()));
        stmt.bind(13, sh.getPeaksCount());
        stmt.bind(14, smd.paramTree());
        stmt.bind(15, smd.scanList());
        ISQLiteStatement iSQLiteStatement4 = smd.precursorList().isEmpty() ? stmt.bindNull(16) : stmt.bind(16, (String)smd.precursorList().get());
        ISQLiteStatement iSQLiteStatement5 = smd.productList().isEmpty() ? stmt.bindNull(17) : stmt.bind(17, (String)smd.productList().get());
        stmt.bind(18, 1);
        stmt.bind(19, 1);
        stmt.bind(20, 1);
        stmt.bind(21, 1);
        stmt.bind(22, 1);
        stmt.bind(23, dataEnc.getId());
        stmt.bind(24, bbFirstSpectrumId);
        stmt.step();
        stmt.reset();
    }

    private BoundingBox _getBBWithNextSpectrumSlice(Spectrum spectrum, long spectrumId, float spectrumTime, int msLevel, DataEncoding dataEnc, Option<IsolationWindow> isolationWindowOpt, int peakIdx, float minMz, float maxMz) {
        BoundingBox boundingBox;
        Tuple3 runSliceBoundaries = new Tuple3((Object)BoxesRunTime.boxToInteger((int)msLevel), (Object)BoxesRunTime.boxToFloat((float)minMz), (Object)BoxesRunTime.boxToFloat((float)maxMz));
        Option<Object> runSliceIdOpt = this._runSliceStructureFactory().getRunSliceId((Tuple3<Object, Object, Object>)runSliceBoundaries);
        int runSliceId = runSliceIdOpt.isDefined() ? BoxesRunTime.unboxToInt((Object)runSliceIdOpt.get()) : this._runSliceStructureFactory().addRunSlice((Tuple3<Object, Object, Object>)runSliceBoundaries).id();
        Option<BoundingBox> cachedBBOpt = this._bbCache().getCachedBoundingBox(runSliceId, isolationWindowOpt);
        if (cachedBBOpt.isEmpty()) {
            int sliceSlicesCountHint = msLevel == 2 ? 1 : this._runSliceStructureFactory().getRunSlicesCount();
            boundingBox = this._bbCache().createBoundingBox(spectrumTime, runSliceId, msLevel, dataEnc, isolationWindowOpt, sliceSlicesCountHint);
        } else {
            BoundingBox cachedBB = (BoundingBox)cachedBBOpt.get();
            cachedBB.lastTime_$eq(spectrumTime);
            boundingBox = cachedBB;
        }
        BoundingBox bb = boundingBox;
        bb.spectrumIds().$plus$eq((Object)BoxesRunTime.boxToLong((long)spectrumId));
        bb.spectrumSlices().$plus$eq((Object)new Some((Object)new SpectrumSliceIndex(spectrum.data(), peakIdx, peakIdx)));
        return bb;
    }

    public void com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_flushBBRow(int msLevel, Option<IsolationWindow> isolationWindowOpt) {
        ArrayBuffer spectraIds = new ArrayBuffer();
        this._bbCache().forEachCachedBB(msLevel, isolationWindowOpt, (Function1<BoundingBox, BoxedUnit>)new Serializable(this, spectraIds){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer spectraIds$1;

            public final void apply(BoundingBox bb) {
                this.spectraIds$1.$plus$plus$eq(bb.spectrumIds());
            }
            {
                this.spectraIds$1 = spectraIds$1;
            }
        });
        ArrayBuffer distinctBBRowSpectraIds = (ArrayBuffer)((SeqLike)spectraIds.distinct()).sorted((Ordering)Ordering.Long$.MODULE$);
        this._bbCache().forEachCachedBB(msLevel, isolationWindowOpt, (Function1<BoundingBox, BoxedUnit>)new Serializable(this, distinctBBRowSpectraIds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractMzDbWriter $outer;
            private final ArrayBuffer distinctBBRowSpectraIds$1;

            public final void apply(BoundingBox bb) {
                LongMap specSliceById = package.LongMapBuilderFromTraversableTuples$.MODULE$.toLongMap$extension(com.github.mzdb4s.util.collection.package$.MODULE$.traversableTuples2longMapBuilder((TraversableOnce)((TraversableLike)bb.spectrumIds().zip(bb.spectrumSlices(), ArrayBuffer$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Option<SpectrumSliceIndex>> x$2) {
                        return ((Option)x$2._2()).isDefined();
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, SpectrumSliceIndex> apply(Tuple2<Object, Option<SpectrumSliceIndex>> kv) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)kv._1$mcJ$sp()), ((Option)kv._2()).get());
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())));
                ArrayBuffer spectraSlices = (ArrayBuffer)this.distinctBBRowSpectraIds$1.map((Function1)new Serializable(this, specSliceById){
                    public static final long serialVersionUID = 0L;
                    private final LongMap specSliceById$1;

                    public final Option<SpectrumSliceIndex> apply(long specId) {
                        return this.specSliceById$1.get(specId);
                    }
                    {
                        this.specSliceById$1 = specSliceById$1;
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom());
                bb.spectrumIds().clear();
                bb.spectrumIds().$plus$plus$eq((TraversableOnce)this.distinctBBRowSpectraIds$1);
                bb.spectrumSlices().clear();
                bb.spectrumSlices().$plus$plus$eq((TraversableOnce)spectraSlices);
                this.$outer.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_insertAndIndexBoundingBox(bb);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.distinctBBRowSpectraIds$1 = distinctBBRowSpectraIds$1;
            }
        });
        this._bbCache().removeBBRow(msLevel, isolationWindowOpt);
    }

    public abstract long insertBoundingBox(BoundingBox var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_insertAndIndexBoundingBox(BoundingBox bb) {
        BoxedUnit boxedUnit;
        boolean isRTreeIndexInserted;
        ISQLiteStatement stmt;
        int msLevel;
        block9: {
            boolean bl;
            msLevel = bb.msLevel();
            long bbId = this.insertBoundingBox(bb);
            RunSliceHeader runSlice = (RunSliceHeader)this._runSliceStructureFactory().getRunSlice(bb.runSliceId()).get();
            stmt = null;
            if (msLevel == 1) {
                stmt = this._rtreeInsertStmt();
                stmt.bind(1, bbId);
                stmt.bind(2, runSlice.beginMz());
                stmt.bind(3, runSlice.endMz());
                stmt.bind(4, (double)bb.firstTime());
                stmt.bind(5, (double)bb.lastTime());
                bl = true;
            } else if (msLevel == 2 && this.isDIA()) {
                try {
                    Option<IsolationWindow> isolationWindowOpt = bb.isolationWindow();
                    if (isolationWindowOpt.isEmpty()) {
                        bl = false;
                        break block9;
                    }
                    stmt = this._msnRtreeInsertStmt();
                    stmt.bind(1, bbId);
                    stmt.bind(2, msLevel);
                    stmt.bind(3, msLevel);
                    stmt.bind(4, (double)((IsolationWindow)isolationWindowOpt.get()).minMz());
                    stmt.bind(5, (double)((IsolationWindow)isolationWindowOpt.get()).maxMz());
                    stmt.bind(6, runSlice.beginMz());
                    stmt.bind(7, runSlice.endMz());
                    stmt.bind(8, (double)bb.firstTime());
                    stmt.bind(9, (double)bb.lastTime());
                    bl = true;
                }
                catch (Throwable throwable) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Can't parse <selectedIon> XML String because: ").append((Object)throwable.getMessage()).toString());
                    bl = false;
                }
            } else {
                bl = isRTreeIndexInserted = false;
            }
        }
        if (isRTreeIndexInserted) {
            stmt.step();
            boxedUnit = stmt.reset();
            return;
        }
        if (this.isDIA()) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No R*Tree index inserted for BB with id = ", " ; MS level = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bb.id()), BoxesRunTime.boxToInteger((int)msLevel)})));
        }
        boxedUnit = BoxedUnit.UNIT;
    }

    public AbstractMzDbWriter() {
        LoggerHolder.class.$init$((LoggerHolder)this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.com$github$mzdb4s$io$writer$AbstractMzDbWriter$$_xmlSerializer = XmlSerializer$.MODULE$;
        this._insertedSpectraCount = 0;
        this._dataEncodingRegistry = new DataEncodingRegistry();
        this._bbCache = new BoundingBoxWriterCache(this.bbSizes());
        this._runSliceStructureFactory = new RunSliceStructureFactory(1);
    }
}

