/*
 * Decompiled with CFR 0.152.
 */
package com.github.mzdb4s.io.writer;

import com.github.mzdb4s.db.model.MzDbMetaData;
import com.github.mzdb4s.io.writer.AbstractMzDbWriter;
import com.github.mzdb4s.io.writer.BoundingBox;
import com.github.mzdb4s.io.writer.MzDbWriter$;
import com.github.mzdb4s.io.writer.SpectrumSliceIndex;
import com.github.mzdb4s.msdata.BBSizes;
import com.github.mzdb4s.msdata.DataEncoding;
import com.github.mzdb4s.msdata.DataMode$;
import com.github.mzdb4s.msdata.ISpectrumData;
import com.github.mzdb4s.msdata.PeakEncoding$;
import com.github.sqlite4s.ISQLiteFactory;
import com.github.sqlite4s.ISQLiteStatement;
import java.io.File;
import java.nio.ByteBuffer;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u00015\u0011!\"\u0014>EE^\u0013\u0018\u000e^3s\u0015\t\u0019A!\u0001\u0004xe&$XM\u001d\u0006\u0003\u000b\u0019\t!![8\u000b\u0005\u001dA\u0011AB7{I\n$4O\u0003\u0002\n\u0015\u00051q-\u001b;ik\nT\u0011aC\u0001\u0004G>l7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003%\u0005\u00137\u000f\u001e:bGRl%\u0010\u00122Xe&$XM\u001d\u0005\t'\u0001\u0011)\u0019!C\u0001)\u0005QAM\u0019'pG\u0006$\u0018n\u001c8\u0016\u0003U\u0001\"A\u0006\u000e\u000e\u0003]Q!!\u0002\r\u000b\u0003e\tAA[1wC&\u00111d\u0006\u0002\u0005\r&dW\r\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u0016\u0003-!'\rT8dCRLwN\u001c\u0011\t\u0011}\u0001!Q1A\u0005\u0002\u0001\n\u0001\"\\3uC\u0012\u000bG/Y\u000b\u0002CA\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0006[>$W\r\u001c\u0006\u0003M\u0019\t!\u0001\u001a2\n\u0005!\u001a#\u0001D'{\t\nlU\r^1ECR\f\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\u00135,G/\u0019#bi\u0006\u0004\u0003\u0002\u0003\u0017\u0001\u0005\u000b\u0007I\u0011A\u0017\u0002\u000f\t\u00147+\u001b>fgV\ta\u0006\u0005\u00020e5\t\u0001G\u0003\u00022\r\u00051Qn\u001d3bi\u0006L!a\r\u0019\u0003\u000f\t\u00135+\u001b>fg\"AQ\u0007\u0001B\u0001B\u0003%a&\u0001\u0005cENK'0Z:!\u0011!9\u0004A!b\u0001\n\u0003A\u0014!B5t\t&\u000bU#A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\u000f\t{w\u000e\\3b]\"A\u0001\t\u0001B\u0001B\u0003%\u0011(\u0001\u0004jg\u0012K\u0015\t\t\u0005\t\u0005\u0002\u0011)\u0019!C\u0002\u0007\u0006\u00111OZ\u000b\u0002\tB\u0011Q\tS\u0007\u0002\r*\u0011q\tC\u0001\tgFd\u0017\u000e^35g&\u0011\u0011J\u0012\u0002\u000f\u0013N\u000bF*\u001b;f\r\u0006\u001cGo\u001c:z\u0011!Y\u0005A!A!\u0002\u0013!\u0015aA:gA!)Q\n\u0001C\u0001\u001d\u00061A(\u001b8jiz\"Ra\u0014*T)V#\"\u0001U)\u0011\u0005=\u0001\u0001\"\u0002\"M\u0001\b!\u0005\"B\nM\u0001\u0004)\u0002\"B\u0010M\u0001\u0004\t\u0003\"\u0002\u0017M\u0001\u0004q\u0003bB\u001cM!\u0003\u0005\r!\u000f\u0005\u0006\u001b\u0002!\ta\u0016\u000b\u00051j\u001bG\r\u0006\u0002Q3\")!I\u0016a\u0002\t\")1L\u0016a\u00019\u00061AM\u0019)bi\"\u0004\"!\u00181\u000f\u0005ir\u0016BA0<\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011M\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}[\u0004\"B\u0010W\u0001\u0004\t\u0003\"\u0002\u0017W\u0001\u0004q\u0003\"\u00024\u0001\t#9\u0017!E5og\u0016\u0014HOQ8v]\u0012Lgn\u001a\"pqR\u0011\u0001n\u001b\t\u0003u%L!A[\u001e\u0003\t1{gn\u001a\u0005\u0006Y\u0016\u0004\r!\\\u0001\u0003E\n\u0004\"a\u00048\n\u0005=\u0014!a\u0003\"pk:$\u0017N\\4C_b<q!\u001d\u0002\u0002\u0002#\u0005!/\u0001\u0006Nu\u0012\u0013wK]5uKJ\u0004\"aD:\u0007\u000f\u0005\u0011\u0011\u0011!E\u0001iN\u00111/\u001e\t\u0003uYL!a^\u001e\u0003\r\u0005s\u0017PU3g\u0011\u0015i5\u000f\"\u0001z)\u0005\u0011\bbB>t#\u0003%\t\u0001`\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0003uT#!\u000f@,\u0003}\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011B\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u000e\u0005\r!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class MzDbWriter
extends AbstractMzDbWriter {
    private final File dbLocation;
    private final MzDbMetaData metaData;
    private final BBSizes bbSizes;
    private final boolean isDIA;
    private final ISQLiteFactory sf;

    public static boolean $lessinit$greater$default$4() {
        return MzDbWriter$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public File dbLocation() {
        return this.dbLocation;
    }

    @Override
    public MzDbMetaData metaData() {
        return this.metaData;
    }

    @Override
    public BBSizes bbSizes() {
        return this.bbSizes;
    }

    @Override
    public boolean isDIA() {
        return this.isDIA;
    }

    @Override
    public ISQLiteFactory sf() {
        return this.sf;
    }

    @Override
    public long insertBoundingBox(BoundingBox bb) {
        Enumeration.Value pe;
        ArrayBuffer<Object> spectrumIds = bb.spectrumIds();
        ArrayBuffer<Option<SpectrumSliceIndex>> spectrumSlices = bb.spectrumSlices();
        int slicesCount = spectrumSlices.length();
        int bbPeaksCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)spectrumSlices.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(Option<SpectrumSliceIndex> x$1) {
                return Option$.MODULE$.option2Iterable(x$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(SpectrumSliceIndex x$2) {
                        return x$2.peaksCount();
                    }
                }));
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        DataEncoding dataEnc = bb.dataEncoding();
        Enumeration.Value value = pe = dataEnc.getPeakEncoding();
        Enumeration.Value value2 = PeakEncoding$.MODULE$.NO_LOSS_PEAK();
        Predef$.MODULE$.assert(value != null ? !value.equals(value2) : value2 != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The NO_LOSS_PEAK encoding is no yet supported!";
            }
        });
        int peakStructSize = dataEnc.getPeakStructSize();
        long bbLen = 8L * (long)slicesCount + (long)(peakStructSize * bbPeaksCount);
        byte[] bbBytes = new byte[(int)bbLen];
        ByteBuffer bytesBuffer = ByteBuffer.wrap(bbBytes).order(dataEnc.byteOrder());
        for (int sliceIdx = 0; sliceIdx < slicesCount; ++sliceIdx) {
            ByteBuffer byteBuffer;
            long spectrumId = BoxesRunTime.unboxToLong((Object)spectrumIds.apply(sliceIdx));
            bytesBuffer.putInt((int)spectrumId);
            Option spectrumSliceOpt = (Option)spectrumSlices.apply(sliceIdx);
            if (spectrumSliceOpt.isEmpty()) {
                byteBuffer = bytesBuffer.putInt(0);
                continue;
            }
            SpectrumSliceIndex spectrumSliceIdx = (SpectrumSliceIndex)spectrumSliceOpt.get();
            ISpectrumData spectrumData = spectrumSliceIdx.spectrumData();
            int firstPeakIdx = spectrumSliceIdx.firstPeakIdx();
            int lastPeakIdx = spectrumSliceIdx.lastPeakIdx();
            int slicePeaksCount = spectrumSliceIdx.peaksCount();
            bytesBuffer.putInt(slicePeaksCount);
            for (int i = firstPeakIdx; i <= lastPeakIdx; ++i) {
                Object object;
                Enumeration.Value value3 = pe;
                Enumeration.Value value4 = PeakEncoding$.MODULE$.HIGH_RES_PEAK();
                ByteBuffer byteBuffer2 = !(value3 != null ? !value3.equals(value4) : value4 != null) ? bytesBuffer.putDouble(spectrumData.getMzAt(i)) : bytesBuffer.putFloat((float)spectrumData.getMzAt(i));
                bytesBuffer.putFloat(spectrumData.getIntensityAt(i));
                Enumeration.Value value5 = dataEnc.mode();
                Enumeration.Value value6 = DataMode$.MODULE$.FITTED();
                if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                    bytesBuffer.putFloat(BoxesRunTime.unboxToFloat((Object)spectrumData.getLeftHwhmAt(i).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final float apply() {
                            return this.apply$mcF$sp();
                        }

                        public float apply$mcF$sp() {
                            return 0.0f;
                        }
                    })));
                    object = bytesBuffer.putFloat(BoxesRunTime.unboxToFloat((Object)spectrumData.getRightHwhmAt(i).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final float apply() {
                            return this.apply$mcF$sp();
                        }

                        public float apply$mcF$sp() {
                            return 0.0f;
                        }
                    })));
                    continue;
                }
                object = BoxedUnit.UNIT;
            }
            byteBuffer = BoxedUnit.UNIT;
        }
        ISQLiteStatement stmt = this.bboxInsertStmt();
        stmt.bind(1, bbBytes);
        stmt.bind(2, bb.runSliceId());
        stmt.bind(3, BoxesRunTime.unboxToLong((Object)spectrumIds.head()));
        stmt.bind(4, BoxesRunTime.unboxToLong((Object)spectrumIds.last()));
        stmt.step();
        long bbId = this.getConnection().getLastInsertId();
        stmt.reset();
        return bbId;
    }

    public MzDbWriter(File dbLocation, MzDbMetaData metaData, BBSizes bbSizes, boolean isDIA, ISQLiteFactory sf) {
        this.dbLocation = dbLocation;
        this.metaData = metaData;
        this.bbSizes = bbSizes;
        this.isDIA = isDIA;
        this.sf = sf;
    }

    public MzDbWriter(String dbPath, MzDbMetaData metaData, BBSizes bbSizes, ISQLiteFactory sf) {
        this(new File(dbPath), metaData, bbSizes, MzDbWriter$.MODULE$.$lessinit$greater$default$4(), sf);
    }
}

