/*
 * Decompiled with CFR 0.152.
 */
package com.github.mzdb4s.io.reader.bb;

import com.github.mzdb4s.io.reader.bb.AbstractBlobReader;
import com.github.mzdb4s.msdata.DataEncoding;
import com.github.mzdb4s.msdata.SpectrumData;
import com.github.mzdb4s.msdata.SpectrumHeader;
import com.github.mzdb4s.msdata.SpectrumSlice;
import com.github.mzdb4s.util.primitive.BytesUtils$;
import com.github.sqlite4s.ISQLiteBlob;
import java.nio.ByteBuffer;
import java.util.Arrays;
import scala.collection.mutable.LongMap;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001=\u0011\u0001cU)MSR,'\t\\8c%\u0016\fG-\u001a:\u000b\u0005\r!\u0011A\u00012c\u0015\t)a!\u0001\u0004sK\u0006$WM\u001d\u0006\u0003\u000f!\t!![8\u000b\u0005%Q\u0011AB7{I\n$4O\u0003\u0002\f\u0019\u00051q-\u001b;ik\nT\u0011!D\u0001\u0004G>l7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003%\u0005\u00137\u000f\u001e:bGR\u0014En\u001c2SK\u0006$WM\u001d\u0005\t+\u0001\u0011\t\u0019!C\u0005-\u0005)qL\u00197pEV\tq\u0003\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u0015\u0005A1/\u001d7ji\u0016$4/\u0003\u0002\u001d3\tY\u0011jU)MSR,'\t\\8c\u0011!q\u0002A!a\u0001\n\u0013y\u0012!C0cY>\u0014w\fJ3r)\t\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0003V]&$\bbB\u0014\u001e\u0003\u0003\u0005\raF\u0001\u0004q\u0012\n\u0004\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0015B\f\u0002\r}\u0013Gn\u001c2!\u0011!Y\u0003A!b\u0001\n\u0003a\u0013a\u00044jeN$8\u000b]3diJ,X.\u00133\u0016\u00035\u0002\"!\t\u0018\n\u0005=\u0012#\u0001\u0002'p]\u001eD\u0001\"\r\u0001\u0003\u0002\u0003\u0006I!L\u0001\u0011M&\u00148\u000f^*qK\u000e$(/^7JI\u0002B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001L\u0001\u000fY\u0006\u001cHo\u00159fGR\u0014X/\\%e\u0011!)\u0004A!A!\u0002\u0013i\u0013a\u00047bgR\u001c\u0006/Z2ueVl\u0017\n\u001a\u0011\t\u0011]\u0002!Q1A\u0005\u0002a\n!c\u001d9fGR\u0014X/\u001c%fC\u0012,'OQ=JIV\t\u0011\bE\u0002;\u007f\u0005k\u0011a\u000f\u0006\u0003yu\nq!\\;uC\ndWM\u0003\u0002?E\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0001[$a\u0002'p]\u001el\u0015\r\u001d\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\"\ta!\\:eCR\f\u0017B\u0001$D\u00059\u0019\u0006/Z2ueVl\u0007*Z1eKJD\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!O\u0001\u0014gB,7\r\u001e:v[\"+\u0017\rZ3s\u0005fLE\r\t\u0005\t\u0015\u0002\u0011)\u0019!C\u0001\u0017\u0006AB-\u0019;b\u000b:\u001cw\u000eZ5oO\nK8\u000b]3diJ,X.\u00133\u0016\u00031\u00032AO N!\t\u0011e*\u0003\u0002P\u0007\naA)\u0019;b\u000b:\u001cw\u000eZ5oO\"A\u0011\u000b\u0001B\u0001B\u0003%A*A\reCR\fWI\\2pI&twMQ=Ta\u0016\u001cGO];n\u0013\u0012\u0004\u0003\"B*\u0001\t\u0003!\u0016A\u0002\u001fj]&$h\b\u0006\u0004V-^C\u0016L\u0017\t\u0003#\u0001AQ!\u0006*A\u0002]AQa\u000b*A\u00025BQa\r*A\u00025BQa\u000e*A\u0002eBQA\u0013*A\u00021CQ\u0001\u0018\u0001\u0005Bu\u000b1\u0002Z5ta>\u001cXM\u00117pER\t\u0001\u0005C\u0003`\u0001\u0011\u0005\u0001-A\u0006hKR\u0014En\u001c2TSj,G#A1\u0011\u0005\u0005\u0012\u0017BA2#\u0005\rIe\u000e\u001e\u0005\u0006K\u0002!\t\u0005Y\u0001\u0010O\u0016$8\u000b]3diJ\f7i\\;oi\")q\r\u0001C\tQ\u0006!r,\u001b8eKb\u001c\u0006/Z2ueVl7\u000b\\5dKN$\"\u0001I5\t\u000b)4\u0007\u0019A1\u0002+\u0015\u001cH/[7bi\u0016$7\u000b]3diJ\f7i\\;oi\")A\u000e\u0001C![\u0006yq-\u001a;Ta\u0016\u001cGO];n\u0013\u0012\fE\u000f\u0006\u0002.]\")qn\u001ba\u0001C\u0006\u0019\u0011\u000e\u001a=\t\u000bE\u0004A\u0011\u0002:\u0002!};W\r^*qK\u000e$(/^7JI\u0006#HCA\u0017t\u0011\u0015y\u0007\u000f1\u0001b\u0011\u0015)\b\u0001\"\u0003w\u0003=yv-\u001a;J]R4%o\\7CY>\u0014GcA1xs\")\u0001\u0010\u001ea\u0001/\u0005!!\r\\8c\u0011\u0015yG\u000f1\u0001b\u0011\u0015Y\b\u0001\"\u0011}\u0003M\u0011X-\u00193Ta\u0016\u001cGO];n'2L7-Z!u)\ri\u0018\u0011\u0001\t\u0003\u0005zL!a`\"\u0003\u001bM\u0003Xm\u0019;sk6\u001cF.[2f\u0011\u0015y'\u00101\u0001b\u0011\u001d\t)\u0001\u0001C!\u0003\u000f\tqC]3bIN\u0003Xm\u0019;sk6\u001cF.[2f\t\u0006$\u0018-\u0011;\u0015\t\u0005%\u0011q\u0002\t\u0004\u0005\u0006-\u0011bAA\u0007\u0007\na1\u000b]3diJ,X\u000eR1uC\"1q.a\u0001A\u0002\u0005Dq!a\u0005\u0001\t\u0003\n)\"A\u0010sK\u0006$g)\u001b7uKJ,Gm\u00159fGR\u0014X/\\*mS\u000e,G)\u0019;b\u0003R$\u0002\"!\u0003\u0002\u0018\u0005e\u00111\u0005\u0005\u0007_\u0006E\u0001\u0019A1\t\u0011\u0005m\u0011\u0011\u0003a\u0001\u0003;\tQ!\\5o\u001bj\u00042!IA\u0010\u0013\r\t\tC\t\u0002\u0007\t>,(\r\\3\t\u0011\u0005\u0015\u0012\u0011\u0003a\u0001\u0003;\tQ!\\1y\u001bjDq!!\u000b\u0001\t\u0013\tY#\u0001\u0011`e\u0016\fGMR5mi\u0016\u0014X\rZ*qK\u000e$(/^7TY&\u001cW\rR1uC\u0006#HCCA\u0005\u0003[\ty#a\r\u00026!1q.a\nA\u0002\u0005Dq!!\r\u0002(\u0001\u0007Q&\u0001\u0006ta\u0016\u001cGO];n\u0013\u0012D\u0001\"a\u0007\u0002(\u0001\u0007\u0011Q\u0004\u0005\t\u0003K\t9\u00031\u0001\u0002\u001e\u0001")
public class SQLiteBlobReader
extends AbstractBlobReader {
    private ISQLiteBlob _blob;
    private final long firstSpectrumId;
    private final long lastSpectrumId;
    private final LongMap<SpectrumHeader> spectrumHeaderById;
    private final LongMap<DataEncoding> dataEncodingBySpectrumId;

    private ISQLiteBlob _blob() {
        return this._blob;
    }

    private void _blob_$eq(ISQLiteBlob x$1) {
        this._blob = x$1;
    }

    @Override
    public long firstSpectrumId() {
        return this.firstSpectrumId;
    }

    @Override
    public long lastSpectrumId() {
        return this.lastSpectrumId;
    }

    @Override
    public LongMap<SpectrumHeader> spectrumHeaderById() {
        return this.spectrumHeaderById;
    }

    @Override
    public LongMap<DataEncoding> dataEncodingBySpectrumId() {
        return this.dataEncodingBySpectrumId;
    }

    @Override
    public void disposeBlob() {
        this._blob().dispose();
    }

    public int getBlobSize() {
        try {
            return this._blob().getSize();
        }
        catch (Exception exception) {
            throw new Exception("can't get the SQLite blob size", exception);
        }
    }

    @Override
    public int getSpectraCount() {
        return this._spectraCount();
    }

    public void _indexSpectrumSlices(int estimatedSpectraCount) {
        int[] spectrumSliceStartPositions = new int[estimatedSpectraCount];
        int[] peaksCounts = new int[estimatedSpectraCount];
        int size = this.getBlobSize();
        int spectrumSliceIdx = 0;
        int byteIdx = 0;
        while (byteIdx < size) {
            int peaksCount;
            long spectrumId = this._getIntFromBlob(this._blob(), byteIdx);
            this._spectrumSliceStartPositions()[spectrumSliceIdx] = byteIdx;
            this._peaksCounts()[spectrumSliceIdx] = peaksCount = this._getIntFromBlob(this._blob(), byteIdx += 4);
            byteIdx += 4;
            DataEncoding de = (DataEncoding)this.dataEncodingBySpectrumId().apply(spectrumId);
            this.checkDataEncodingIsNotNull(de, spectrumId);
            byteIdx += peaksCount * de.getPeakStructSize();
            ++spectrumSliceIdx;
        }
        this._spectraCount_$eq(spectrumSliceIdx);
        this._spectrumSliceStartPositions_$eq(Arrays.copyOf(spectrumSliceStartPositions, this._spectraCount()));
        this._peaksCounts_$eq(Arrays.copyOf(peaksCounts, this._spectraCount()));
    }

    @Override
    public long getSpectrumIdAt(int idx) {
        this.checkSpectrumIndexRange(idx);
        return this._getSpectrumIdAt(idx);
    }

    private long _getSpectrumIdAt(int idx) {
        return this._getIntFromBlob(this._blob(), idx);
    }

    private int _getIntFromBlob(ISQLiteBlob blob, int idx) {
        byte[] byteBuffer = new byte[4];
        try {
            blob.read(idx, byteBuffer, 0, 4);
            return BytesUtils$.MODULE$.bytesToInt(byteBuffer, 0);
        }
        catch (Exception exception) {
            throw new Exception("can't read bytes from the SQLite blob", exception);
        }
    }

    @Override
    public SpectrumSlice readSpectrumSliceAt(int idx) {
        long spectrumId = this._getSpectrumIdAt(idx);
        SpectrumData spectrumSliceData = this._readFilteredSpectrumSliceDataAt(idx, spectrumId, -1.0, -1.0);
        SpectrumHeader sh = (SpectrumHeader)this.spectrumHeaderById().apply(spectrumId);
        return new SpectrumSlice(sh, spectrumSliceData);
    }

    @Override
    public SpectrumData readSpectrumSliceDataAt(int idx) {
        return this._readFilteredSpectrumSliceDataAt(idx, this._getSpectrumIdAt(idx), -1.0, -1.0);
    }

    @Override
    public SpectrumData readFilteredSpectrumSliceDataAt(int idx, double minMz, double maxMz) {
        return this._readFilteredSpectrumSliceDataAt(idx, this._getSpectrumIdAt(idx), minMz, maxMz);
    }

    private SpectrumData _readFilteredSpectrumSliceDataAt(int idx, long spectrumId, double minMz, double maxMz) {
        DataEncoding de = (DataEncoding)this.dataEncodingBySpectrumId().apply(spectrumId);
        int peaksBytesSize = this._peaksCounts()[idx] * de.getPeakStructSize();
        int spectrumSliceStartPos = this._spectrumSliceStartPositions()[idx] + 8;
        byte[] peaksBytes = new byte[peaksBytesSize];
        try {
            this._blob().read(spectrumSliceStartPos, peaksBytes, 0, peaksBytesSize);
        }
        catch (Exception exception) {
            throw new Exception("can't read bytes from the SQLiteBlob", exception);
        }
        return this.readSpectrumSliceData(ByteBuffer.wrap(peaksBytes), spectrumSliceStartPos, peaksBytesSize, de, minMz, maxMz);
    }

    public SQLiteBlobReader(ISQLiteBlob _blob, long firstSpectrumId, long lastSpectrumId, LongMap<SpectrumHeader> spectrumHeaderById, LongMap<DataEncoding> dataEncodingBySpectrumId) {
        this._blob = _blob;
        this.firstSpectrumId = firstSpectrumId;
        this.lastSpectrumId = lastSpectrumId;
        this.spectrumHeaderById = spectrumHeaderById;
        this.dataEncodingBySpectrumId = dataEncodingBySpectrumId;
        this._indexSpectrumSlices((int)(1L + lastSpectrumId - firstSpectrumId));
    }
}

