/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.jms.service.misc;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.util.StringUtils;
import fr.proline.jms.ServiceEvent;
import fr.proline.jms.ServiceEvent$;
import fr.proline.jms.ServiceRunner$;
import fr.proline.jms.service.misc.ResourceResult;
import fr.proline.jms.util.IServiceMonitoringNotifier;
import fr.proline.jms.util.JMSConstants$;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u001b\ty!+Z:pkJ\u001cWmU3sm&\u001cWM\u0003\u0002\u0004\t\u0005!Q.[:d\u0015\t)a!A\u0004tKJ4\u0018nY3\u000b\u0005\u001dA\u0011a\u00016ng*\u0011\u0011BC\u0001\baJ|G.\u001b8f\u0015\u0005Y\u0011A\u00014s\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011Q\u0003H\u0007\u0002-)\u0011q\u0003G\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u00033i\t\u0001\u0002^=qKN\fg-\u001a\u0006\u00027\u0005\u00191m\\7\n\u0005u1\"a\u0003'bufdunZ4j]\u001eDQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"\u0001\u0002\t\u000f\u0011\u0002!\u0019!C\u0001K\u0005ir)\u0012+`%\u0016\u001bv*\u0016*D\u000b~\u000b5kX*U%\u0016\u000bUjX'F)\"{E)F\u0001'!\t9C&D\u0001)\u0015\tI#&\u0001\u0003mC:<'\"A\u0016\u0002\t)\fg/Y\u0005\u0003[!\u0012aa\u0015;sS:<\u0007BB\u0018\u0001A\u0003%a%\u0001\u0010H\u000bR{&+R*P+J\u001bUiX!T?N#&+R!N?6+E\u000bS(EA!9\u0011\u0007\u0001b\u0001\n\u0003)\u0013a\u0005$J\u0019\u0016{\u0006+\u0011+I?B\u000b%+Q'`\u0017\u0016K\u0006BB\u001a\u0001A\u0003%a%\u0001\u000bG\u00132+u\fU!U\u0011~\u0003\u0016IU!N?.+\u0015\f\t\u0005\bk\u0001\u0011\r\u0011\"\u0001&\u0003-\u0019XM\u001d<jG\u0016t\u0015-\\3\t\r]\u0002\u0001\u0015!\u0003'\u00031\u0019XM\u001d<jG\u0016t\u0015-\\3!\u0011\u0015I\u0004\u0001\"\u0001;\u00035A\u0017M\u001c3mK6+7o]1hKR)1HP$M#B\u0011q\u0002P\u0005\u0003{A\u0011A!\u00168ji\")q\b\u000fa\u0001\u0001\u000691/Z:tS>t\u0007CA!F\u001b\u0005\u0011%BA\u0004D\u0015\u0005!\u0015!\u00026bm\u0006D\u0018B\u0001$C\u0005\u001d\u0019Vm]:j_:DQ\u0001\u0013\u001dA\u0002%\u000bq!\\3tg\u0006<W\r\u0005\u0002B\u0015&\u00111J\u0011\u0002\b\u001b\u0016\u001c8/Y4f\u0011\u0015i\u0005\b1\u0001O\u00035\u0011X\r\u001d7z!J|G-^2feB\u0011\u0011iT\u0005\u0003!\n\u0013q\"T3tg\u0006<W\r\u0015:pIV\u001cWM\u001d\u0005\u0006%b\u0002\raU\u0001\u001ag\u0016\u0014h/[2f\u001b>t\u0017\u000e^8sS:<gj\u001c;jM&,'\u000f\u0005\u0002U/6\tQK\u0003\u0002W\r\u0005!Q\u000f^5m\u0013\tAVK\u0001\u000eJ'\u0016\u0014h/[2f\u001b>t\u0017\u000e^8sS:<gj\u001c;jM&,'\u000fC\u0003\u0006\u0001\u0011%!\f\u0006\u0003\\=~k\u0007C\u0001\u0012]\u0013\ti&A\u0001\bSKN|WO]2f%\u0016\u001cX\u000f\u001c;\t\u000b}J\u0006\u0019\u0001!\t\u000b\u0001L\u0006\u0019A1\u0002#)l7/T3tg\u0006<WmQ8oi\u0016DH\u000f\u0005\u0003cK\"TgBA\bd\u0013\t!\u0007#\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001e\u00141!T1q\u0015\t!\u0007\u0003\u0005\u0002cS&\u0011Qf\u001a\t\u0003\u001f-L!\u0001\u001c\t\u0003\u0007\u0005s\u0017\u0010C\u0003o3\u0002\u0007q.A\u0002sKF\u0004\"\u0001];\u000e\u0003ET!A]:\u0002\u0011)\u001cxN\u001c:qGJR!\u0001\u001e\u000e\u0002+QDW\r\u001e:b]N\f7\r^5p]\u000e|W\u000e]1os&\u0011a/\u001d\u0002\u0010\u0015N{eJ\u0015)DeI+\u0017/^3ti\")\u0001\u0010\u0001C\u0005s\u0006\u0019r-\u001a;SKN|WO]2f\u0003N\u001cFO]3b[R!1L_>}\u0011\u0015yt\u000f1\u0001A\u0011\u0015\u0001w\u000f1\u0001b\u0011\u0015qw\u000f1\u0001p\u0001")
public class ResourceService
implements LazyLogging {
    private final String GET_RESOURCE_AS_STREAM_METHOD;
    private final String FILE_PATH_PARAM_KEY;
    private final String serviceName;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ResourceService resourceService = this;
        synchronized (resourceService) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String GET_RESOURCE_AS_STREAM_METHOD() {
        return this.GET_RESOURCE_AS_STREAM_METHOD;
    }

    public String FILE_PATH_PARAM_KEY() {
        return this.FILE_PATH_PARAM_KEY;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public void handleMessage(Session session, Message message, MessageProducer replyProducer, IServiceMonitoringNotifier serviceMonitoringNotifier) {
        Option serviceDescrOpt;
        Option serviceSourceOpt;
        Option serviceVersionOpt;
        JSONRPC2Response jsonResponse;
        Object jsonRequestId;
        JSONRPC2Request jsonRequest;
        TextMessage responseJMSMessage;
        String jmsMessageId;
        block40: {
            BoxedUnit boxedUnit;
            Predef$.MODULE$.require(session != null, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Session is null";
                }
            });
            Predef$.MODULE$.require(message != null, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Message is null";
                }
            });
            Predef$.MODULE$.require(replyProducer != null, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "ReplyProducer is null";
                }
            });
            jmsMessageId = message.getJMSMessageID();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Handling ResourceService JMS Message [{}]", new Object[]{jmsMessageId});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            responseJMSMessage = null;
            jsonRequest = null;
            jsonRequestId = null;
            jsonResponse = new JSONRPC2Response(JSONRPC2Error.INVALID_REQUEST, jsonRequestId);
            serviceVersionOpt = Option$.MODULE$.empty();
            serviceSourceOpt = Option$.MODULE$.empty();
            serviceDescrOpt = Option$.MODULE$.empty();
            try {
                try {
                    BoxedUnit boxedUnit2;
                    if (message instanceof TextMessage) {
                        String requestString = ((TextMessage)message).getText();
                        jsonRequest = JSONRPC2Request.parse((String)requestString);
                        jsonRequestId = jsonRequest.getID();
                        jsonResponse.setID(jsonRequestId);
                        if (Thread.interrupted()) {
                            BoxedUnit boxedUnit3;
                            String errorMessage = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Thread interrupted before calling Service [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.serviceName()}));
                            if (this.logger().underlying().isErrorEnabled()) {
                                this.logger().underlying().error(errorMessage);
                                boxedUnit3 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit3 = BoxedUnit.UNIT;
                            }
                            jsonResponse.setError(ServiceRunner$.MODULE$.buildJSONRPC2Error(JMSConstants$.MODULE$.SERVICE_ERROR_CODE(), new Exception(errorMessage)));
                        } else {
                            String serviceDescr;
                            String serviceSource;
                            Map<String, Object> jmsMessageContext = ServiceRunner$.MODULE$.buildJMSMessageContext(message);
                            String serviceVersion = message.getStringProperty(JMSConstants$.MODULE$.PROLINE_SERVICE_VERSION_KEY());
                            if (StringUtils.isNotEmpty((String)serviceVersion)) {
                                serviceVersionOpt = new Some((Object)serviceVersion);
                            }
                            if (StringUtils.isNotEmpty((String)(serviceSource = message.getStringProperty(JMSConstants$.MODULE$.PROLINE_SERVICE_SOURCE_KEY())))) {
                                serviceSourceOpt = new Some((Object)serviceSource);
                            }
                            if (StringUtils.isNotEmpty((String)(serviceDescr = message.getStringProperty(JMSConstants$.MODULE$.PROLINE_SERVICE_DESCR_KEY())))) {
                                serviceDescrOpt = new Some((Object)serviceDescr);
                            }
                            ServiceEvent serviceEvent = new ServiceEvent(jmsMessageId, jsonRequestId, this.serviceName(), ServiceEvent$.MODULE$.EVENT_START(), (Option<String>)serviceVersionOpt, (Option<String>)serviceSourceOpt, (Option<String>)serviceDescrOpt);
                            serviceEvent.setComplementaryInfo(requestString);
                            serviceMonitoringNotifier.sendNotification((JSONRPC2Message)serviceEvent.toJSONRPCNotification(), null);
                            ResourceResult resourceResult = this.service(session, jmsMessageContext, jsonRequest);
                            responseJMSMessage = resourceResult.responseJMSMessage();
                            jsonResponse = resourceResult.jsonResponse();
                        }
                        break block40;
                    }
                    String errorMessage = "Invalid ResourceService JMS Message type";
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(errorMessage);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    jsonResponse.setError(ServiceRunner$.MODULE$.buildJSONRPC2Error(JMSConstants$.MODULE$.MESSAGE_ERROR_CODE(), new Exception(errorMessage)));
                }
                catch (Throwable throwable) {
                    BoxedUnit boxedUnit4;
                    String errorMessage = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error handling ResourceService JMS Message [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jmsMessageId}));
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(errorMessage, throwable);
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    jsonResponse = new JSONRPC2Response(ServiceRunner$.MODULE$.buildJSONRPC2Error(JMSConstants$.MODULE$.MESSAGE_ERROR_CODE(), throwable), jsonRequestId);
                }
            }
            catch (Throwable throwable) {
                Destination replyDestination = message.getJMSReplyTo();
                if (replyDestination == null) {
                    BoxedUnit boxedUnit5;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("ResourceService JMS Message has no 'JMSReplyTo' destination: cannot send JMS response to the client");
                        boxedUnit5 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit5 = BoxedUnit.UNIT;
                    }
                } else {
                    BoxedUnit boxedUnit6;
                    BoxedUnit boxedUnit7;
                    ServiceEvent serviceEvent = null;
                    if (responseJMSMessage == null) {
                        serviceEvent = new ServiceEvent(jmsMessageId, jsonRequestId, this.serviceName(), ServiceEvent$.MODULE$.EVENT_FAIL(), (Option<String>)serviceVersionOpt, (Option<String>)serviceSourceOpt, (Option<String>)serviceDescrOpt);
                        responseJMSMessage = session.createTextMessage();
                        responseJMSMessage.setJMSCorrelationID(jmsMessageId);
                        if (jsonResponse == null) {
                            jsonResponse = new JSONRPC2Response(JSONRPC2Error.INTERNAL_ERROR, jsonRequestId);
                        }
                        responseJMSMessage.setText(jsonResponse.toJSONString());
                    } else {
                        serviceEvent = new ServiceEvent(jmsMessageId, jsonRequestId, this.serviceName(), ServiceEvent$.MODULE$.EVENT_SUCCESS(), (Option<String>)serviceVersionOpt, (Option<String>)serviceSourceOpt, (Option<String>)serviceDescrOpt);
                    }
                    serviceEvent.setComplementaryInfo(jsonRequest.toJSONString());
                    serviceMonitoringNotifier.sendNotification((JSONRPC2Message)serviceEvent.toJSONRPCNotification(), null);
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Sending JMS Response to ResourceService JMS Message [{}] on Destination [{}]", new Object[]{jmsMessageId, replyDestination});
                        boxedUnit7 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit7 = BoxedUnit.UNIT;
                    }
                    replyProducer.send(replyDestination, (Message)responseJMSMessage);
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("JMS Response to ResourceService JMS Message [{}] sent", new Object[]{jmsMessageId});
                        boxedUnit6 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit6 = BoxedUnit.UNIT;
                    }
                }
                throw throwable;
            }
        }
        Destination replyDestination = message.getJMSReplyTo();
        if (replyDestination == null) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("ResourceService JMS Message has no 'JMSReplyTo' destination: cannot send JMS response to the client");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit8;
            ServiceEvent serviceEvent = null;
            if (responseJMSMessage == null) {
                serviceEvent = new ServiceEvent(jmsMessageId, jsonRequestId, this.serviceName(), ServiceEvent$.MODULE$.EVENT_FAIL(), (Option<String>)serviceVersionOpt, (Option<String>)serviceSourceOpt, (Option<String>)serviceDescrOpt);
                responseJMSMessage = session.createTextMessage();
                responseJMSMessage.setJMSCorrelationID(jmsMessageId);
                if (jsonResponse == null) {
                    jsonResponse = new JSONRPC2Response(JSONRPC2Error.INTERNAL_ERROR, jsonRequestId);
                }
                responseJMSMessage.setText(jsonResponse.toJSONString());
            } else {
                serviceEvent = new ServiceEvent(jmsMessageId, jsonRequestId, this.serviceName(), ServiceEvent$.MODULE$.EVENT_SUCCESS(), (Option<String>)serviceVersionOpt, (Option<String>)serviceSourceOpt, (Option<String>)serviceDescrOpt);
            }
            serviceEvent.setComplementaryInfo(jsonRequest.toJSONString());
            serviceMonitoringNotifier.sendNotification((JSONRPC2Message)serviceEvent.toJSONRPCNotification(), null);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Sending JMS Response to ResourceService JMS Message [{}] on Destination [{}]", new Object[]{jmsMessageId, replyDestination});
                boxedUnit8 = BoxedUnit.UNIT;
            } else {
                boxedUnit8 = BoxedUnit.UNIT;
            }
            replyProducer.send(replyDestination, (Message)responseJMSMessage);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("JMS Response to ResourceService JMS Message [{}] sent", new Object[]{jmsMessageId});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private ResourceResult service(Session session, Map<String, Object> jmsMessageContext, JSONRPC2Request req) {
        String method;
        Predef$.MODULE$.require(req != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "service() req is null";
            }
        });
        Object jsonRequestId = req.getID();
        String string = method = req.getMethod();
        String string2 = this.GET_RESOURCE_AS_STREAM_METHOD();
        String string3 = string;
        ResourceResult resourceResult = !(string2 != null ? !string2.equals(string3) : string3 != null) ? this.getResourceAsStream(session, jmsMessageContext, req) : new ResourceResult(null, new JSONRPC2Response(JSONRPC2Error.METHOD_NOT_FOUND, jsonRequestId));
        return resourceResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResourceResult getResourceAsStream(Session session, Map<String, Object> jmsMessageContext, JSONRPC2Request req) {
        BoxedUnit boxedUnit;
        String string;
        Object value;
        Predef$.MODULE$.require(session != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "getResourceAsStream() session is null";
            }
        });
        Predef$.MODULE$.require(req != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "getResourceAsStream() req is null";
            }
        });
        Object jsonRequestId = req.getID();
        BytesMessage responseJMSMessage = null;
        JSONRPC2Response jsonResponse = null;
        java.util.Map namedParams = req.getNamedParams();
        Object v = value = namedParams.get(this.FILE_PATH_PARAM_KEY());
        String string2 = v instanceof String ? (string = (String)v) : null;
        String filePath = string2;
        if (StringUtils.isEmpty((String)filePath)) {
            BoxedUnit boxedUnit2;
            String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid '", "' JSON-RPC named param"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.FILE_PATH_PARAM_KEY()}));
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(errorMsg);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Exception ex = new Exception(errorMsg);
            jsonResponse = new JSONRPC2Response(ServiceRunner$.MODULE$.buildJSONRPC2Error(JMSConstants$.MODULE$.SERVICE_ERROR_CODE(), ex), jsonRequestId);
            return new ResourceResult((Message)responseJMSMessage, jsonResponse);
        }
        File file = new File(filePath);
        if (file.isFile()) {
            String absolutePathname = file.getAbsolutePath();
            BufferedInputStream br = null;
            try {
                BoxedUnit boxedUnit3;
                br = new BufferedInputStream(new FileInputStream(file));
                responseJMSMessage = session.createBytesMessage();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Sending InputStream from File [{}] to JMS BytesMessage", new Object[]{absolutePathname});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                responseJMSMessage.setObjectProperty("JMS_HQ_InputStream", (Object)br);
                return new ResourceResult((Message)responseJMSMessage, jsonResponse);
            }
            catch (Exception exception) {
                block17: {
                    BoxedUnit boxedUnit4;
                    BoxedUnit boxedUnit5;
                    String errorMessage = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading [", "] InputStream"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{absolutePathname}));
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(errorMessage, (Throwable)exception);
                        boxedUnit5 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit5 = BoxedUnit.UNIT;
                    }
                    if (br == null) {
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        try {
                            br.close();
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        catch (IOException iOException) {
                            if (this.logger().underlying().isErrorEnabled()) {
                                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error closing [", "] InputStream"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{absolutePathname})), (Throwable)iOException);
                                boxedUnit4 = BoxedUnit.UNIT;
                                break block17;
                            }
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                    }
                }
                jsonResponse = new JSONRPC2Response(ServiceRunner$.MODULE$.buildJSONRPC2Error(JMSConstants$.MODULE$.SERVICE_ERROR_CODE(), exception), jsonRequestId);
                return new ResourceResult((Message)responseJMSMessage, jsonResponse);
            }
        }
        String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown '", "' file pathname"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath}));
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error(errorMsg);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Exception ex = new Exception(errorMsg);
        jsonResponse = new JSONRPC2Response(ServiceRunner$.MODULE$.buildJSONRPC2Error(JMSConstants$.MODULE$.SERVICE_ERROR_CODE(), ex), jsonRequestId);
        return new ResourceResult((Message)responseJMSMessage, jsonResponse);
    }

    public ResourceService() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.GET_RESOURCE_AS_STREAM_METHOD = "get_resource_as_stream";
        this.FILE_PATH_PARAM_KEY = "file_path";
        this.serviceName = "proline/misc/ResourceService";
    }
}

