/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.chemistry.model;

import fr.profi.chemistry.model.AbundanceMapOps$;
import fr.profi.chemistry.model.IMolecularEntity;
import scala.Function1;
import scala.Option$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00054Q!\u0001\u0002\u0002\u0002-\u0011!%\u00112tiJ\f7\r^'pY\u0016\u001cW\u000f\\1s\u000b:$\u0018\u000e^=D_6\u0004xn]5uS>t'BA\u0002\u0005\u0003\u0015iw\u000eZ3m\u0015\t)a!A\u0005dQ\u0016l\u0017n\u001d;ss*\u0011q\u0001C\u0001\u0006aJ|g-\u001b\u0006\u0002\u0013\u0005\u0011aM]\u0002\u0001+\ta!d\u0005\u0002\u0001\u001bA\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001aDQ\u0001\u0006\u0001\u0005\u0002U\ta\u0001P5oSRtD#\u0001\f\u0011\u0007]\u0001\u0001$D\u0001\u0003!\tI\"\u0004\u0004\u0001\u0005\u000bm\u0001!\u0019\u0001\u000f\u0003\u00035\u000b\"!\b\u0011\u0011\u00059q\u0012BA\u0010\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aF\u0011\n\u0005\t\u0012!\u0001E%N_2,7-\u001e7be\u0016sG/\u001b;z\u0011\u0015!\u0003A\"\u0001&\u00031\t'-\u001e8eC:\u001cW-T1q+\u00051\u0003\u0003B\u0014-19j\u0011\u0001\u000b\u0006\u0003S)\nq!\\;uC\ndWM\u0003\u0002,\u001f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00055B#a\u0002%bg\"l\u0015\r\u001d\t\u0003\u001d=J!\u0001M\b\u0003\u000b\u0019cw.\u0019;\t\u000bI\u0002A\u0011A\u001a\u0002%\u001d,GoU;n\u001f\u001a\f%-\u001e8eC:\u001cWm\u001d\u000b\u0002]!)Q\u0007\u0001C\u0001g\u0005Qr-\u001a;Tk6|e-\u00112t_2,H/Z!ck:$\u0017M\\2fg\")q\u0007\u0001C\u0001q\u0005Yq-\u001a;N_:|W*Y:t)\u0005I\u0004C\u0001\b;\u0013\tYtB\u0001\u0004E_V\u0014G.\u001a\u0005\u0006{\u0001!\t\u0001O\u0001\u000fO\u0016$\u0018I^3sC\u001e,W*Y:t\u0011\u0015y\u0004\u0001\"\u0001A\u0003%!C/[7fg\u0012*\u0017\u000f\u0006\u0002\u0017\u0003\")!I\u0010a\u0001]\u00051a.^7cKJDQ\u0001\u0012\u0001\u0005\u0002\u0015\u000bq\u0001\n3jm\u0012*\u0017\u000f\u0006\u0002\u0017\r\")!i\u0011a\u0001]!)\u0001\n\u0001C\u0001\u0013\u0006AA\u0005\u001d7vg\u0012*\u0017\u000f\u0006\u0002\u0017\u0015\")1j\u0012a\u0001-\u0005\u0001r\u000e\u001e5fe\u000e{W\u000e]8tSRLwN\u001c\u0005\u0006\u001b\u0002!\tAT\u0001\bCZ,'/Y4f)\t1r\nC\u0003L\u0019\u0002\u0007a\u0003C\u0003R\u0001\u0011\u0005!+A\u0007gSR$v.T8o_6\u000b7o\u001d\u000b\u0003sMCQ\u0001\u0016)A\u0002e\n\u0001\"\\8o_6\u000b7o\u001d\u0005\u0006-\u0002!\t!F\u0001\n]>\u0014X.\u00197ju\u0016DQ\u0001\u0017\u0001\u0005\u0002e\u000b\u0011\u0002^8G_JlW\u000f\\1\u0015\u0003i\u0003\"a\u00170\u000f\u00059a\u0016BA/\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011q\f\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u{\u0001")
public abstract class AbstractMolecularEntityComposition<M extends IMolecularEntity> {
    public abstract HashMap<M, Object> abundanceMap();

    public float getSumOfAbundances() {
        return AbundanceMapOps$.MODULE$.sumAbundances(this.abundanceMap());
    }

    public float getSumOfAbsoluteAbundances() {
        return AbundanceMapOps$.MODULE$.sumAbsoluteAbundances(this.abundanceMap());
    }

    public double getMonoMass() {
        return AbundanceMapOps$.MODULE$.calcMonoMass(this.abundanceMap());
    }

    public double getAverageMass() {
        return AbundanceMapOps$.MODULE$.calcAverageMass(this.abundanceMap());
    }

    public AbstractMolecularEntityComposition<M> $times$eq(float number) {
        AbundanceMapOps$.MODULE$.multiplyBy(this.abundanceMap(), number);
        return this;
    }

    public AbstractMolecularEntityComposition<M> $div$eq(float number) {
        AbundanceMapOps$.MODULE$.divideBy(this.abundanceMap(), number);
        return this;
    }

    public synchronized AbstractMolecularEntityComposition<M> $plus$eq(AbstractMolecularEntityComposition<M> otherComposition) {
        AbundanceMapOps$.MODULE$.addAbundanceMap(this.abundanceMap(), otherComposition.abundanceMap());
        return this;
    }

    public AbstractMolecularEntityComposition<M> average(AbstractMolecularEntityComposition<M> otherComposition) {
        return this.$plus$eq(otherComposition).$div$eq(2.0f);
    }

    public double fitToMonoMass(double monoMass) {
        this.$times$eq((float)(monoMass / this.getMonoMass()));
        return this.getMonoMass() - monoMass;
    }

    public AbstractMolecularEntityComposition<M> normalize() {
        return this.$div$eq(this.getSumOfAbundances());
    }

    public String toFormula() {
        List sortedAtoms = (List)this.abundanceMap().keys().toList().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(M x$7) {
                return x$7.symbol();
            }
        }, (Ordering)Ordering.String$.MODULE$);
        List strings = (List)sortedAtoms.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractMolecularEntityComposition $outer;

            public final Iterable<String> apply(M entity) {
                return Option$.MODULE$.option2Iterable(this.$outer.abundanceMap().get(entity).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(float x$8) {
                        return this.apply$mcIF$sp(x$8);
                    }

                    public int apply$mcIF$sp(float x$8) {
                        return (int)x$8;
                    }
                }).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int abundance) {
                        return this.apply$mcZI$sp(abundance);
                    }

                    public boolean apply$mcZI$sp(int abundance) {
                        return abundance != 0;
                    }
                }).map((Function1)new Serializable(this, entity){
                    public static final long serialVersionUID = 0L;
                    private final IMolecularEntity entity$2;

                    public final String apply(int abundance) {
                        Object object;
                        StringBuilder sb = new StringBuilder();
                        if (abundance != 0) {
                            sb.append(this.entity$2.symbol());
                            object = abundance != 1 ? sb.append("(").append(abundance).append(")") : BoxedUnit.UNIT;
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        return sb.toString();
                    }
                    {
                        this.entity$2 = entity$2;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        return strings.mkString(" ");
    }
}

