/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.export;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.WindowManager;
import fr.proline.studio.export.ExportManager;
import fr.proline.studio.export.ExporterFactory;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jdesktop.swingx.JXTable;
import org.jfree.graphics2d.svg.SVGGraphics2D;
import org.jfree.graphics2d.svg.SVGUtils;
import org.slf4j.LoggerFactory;

public class ExportDialog
extends DefaultDialog {
    private static ExportDialog m_singletonImageDialog = null;
    private static ExportDialog m_singletonExcelDialog = null;
    private static ExportDialog m_singletonServerDialog = null;
    private int m_exportType;
    private JTextField m_fileTextField;
    private JComboBox m_exporTypeCombobox;
    private JCheckBox m_exportAllPSMsChB;
    private Boolean m_showExportAllPSMsChB;
    private JXTable m_table = null;
    private JPanel m_panel = null;
    private JFileChooser m_fchooser;
    private final List<FileNameExtensionFilter> m_filterList = new ArrayList<FileNameExtensionFilter>();
    private DefaultDialog.ProgressTask m_task = null;
    private String m_exportName = null;
    private JPanel m_decoratedPanel;
    private ParameterList m_parameterList;
    private static final String PARAMETER_LIST_NAME = "General Application Settings";
    private BooleanParameter m_exportParameter;
    private ExportManager m_exportManager = null;

    public static ExportDialog getDialog(Window parent, JXTable table, String exportName) {
        if (m_singletonExcelDialog == null) {
            m_singletonExcelDialog = new ExportDialog(parent, 1);
        }
        ExportDialog.m_singletonExcelDialog.m_table = table;
        ExportDialog.m_singletonExcelDialog.m_exportName = exportName;
        m_singletonExcelDialog.updateExportDecoration();
        return m_singletonExcelDialog;
    }

    public static ExportDialog getDialog(Window parent, JPanel panel, String exportName) {
        if (m_singletonImageDialog == null) {
            m_singletonImageDialog = new ExportDialog(parent, 2);
        }
        ExportDialog.m_singletonImageDialog.m_panel = panel;
        ExportDialog.m_singletonImageDialog.m_exportName = exportName;
        return m_singletonImageDialog;
    }

    public static ExportDialog getDialog(Window parent, Boolean showExportAllPSMsOption) {
        if (m_singletonServerDialog == null) {
            m_singletonServerDialog = new ExportDialog(parent, 3, showExportAllPSMsOption);
        } else if (!ExportDialog.m_singletonServerDialog.m_showExportAllPSMsChB.equals(showExportAllPSMsOption)) {
            m_singletonServerDialog = new ExportDialog(parent, 3, showExportAllPSMsOption);
        }
        return m_singletonServerDialog;
    }

    public static ExportDialog getDialog(Window parent, Boolean showExportAllPSMsOption, int exportType) {
        if (m_singletonServerDialog == null) {
            m_singletonServerDialog = new ExportDialog(parent, exportType, showExportAllPSMsOption);
        } else if (ExportDialog.m_singletonServerDialog.m_exportType != exportType || !ExportDialog.m_singletonServerDialog.m_showExportAllPSMsChB.equals(showExportAllPSMsOption)) {
            m_singletonServerDialog = new ExportDialog(parent, exportType, showExportAllPSMsOption);
        }
        return m_singletonServerDialog;
    }

    public void setTask(DefaultDialog.ProgressTask task) {
        this.m_task = task;
    }

    private ExportDialog(Window parent, int type) {
        this(parent, type, null);
    }

    private ExportDialog(Window parent, int type, Boolean showExportAllPSMsOption) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        String defaultExportPath;
        this.m_showExportAllPSMsChB = showExportAllPSMsOption;
        this.m_exportType = type;
        this.setTitle("Export");
        this.setDocumentationSuffix("id.37m2jsg");
        Preferences preferences = NbPreferences.root();
        if (this.m_exportType == 1 || this.m_exportType == 3 || this.m_exportType == 4 || this.m_exportType == 6 || this.m_exportType == 7) {
            defaultExportPath = preferences.get("DefaultExcelExportPath", System.getProperty("user.home"));
        } else if (this.m_exportType == 2) {
            defaultExportPath = preferences.get("DefaultImageExportPath", System.getProperty("user.home"));
        } else {
            throw new IllegalArgumentException("Unknow export type specified " + this.m_exportType);
        }
        this.setInternalComponent(this.createExportPanel(defaultExportPath));
        this.setButtonName(0, this.m_exportType == 2 ? "Export Image" : "Export");
        this.m_fchooser = new JFileChooser(new File(defaultExportPath));
        this.m_fchooser.setMultiSelectionEnabled(false);
    }

    private JPanel createDecoratedRadioPanel() {
        this.m_decoratedPanel = new JPanel();
        this.m_decoratedPanel.setBorder(BorderFactory.createTitledBorder(" Settings "));
        this.m_decoratedPanel.setLayout(new FlowLayout(0));
        this.m_parameterList = new ParameterList(PARAMETER_LIST_NAME);
        this.m_exportParameter = new BooleanParameter("Export_Decorated", "Export Decorated", JCheckBox.class, (Boolean)true);
        this.m_parameterList.add(this.m_exportParameter);
        this.m_decoratedPanel.add(this.m_parameterList.getPanel());
        return this.m_decoratedPanel;
    }

    private void updateExportDecoration() {
        this.m_parameterList.loadParameters(NbPreferences.root());
    }

    public final JPanel createExportPanel(String defaultExportPath) {
        JPanel exportPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.m_fileTextField = new JTextField(30);
        this.m_fileTextField.setText(defaultExportPath);
        exportPanel.add((Component)this.m_fileTextField, c);
        final JButton addFileButton = new JButton(IconManager.getIcon(IconManager.IconType.OPEN_FILE));
        addFileButton.setMargin(new Insets(2, 2, 2, 2));
        addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result;
                String textFile;
                ExporterFactory.ExporterInfo exporterInfo = (ExporterFactory.ExporterInfo)ExportDialog.this.m_exporTypeCombobox.getSelectedItem();
                if (exporterInfo != null) {
                    FileNameExtensionFilter filter = new FileNameExtensionFilter(exporterInfo.getName(), exporterInfo.getFileExtension());
                    FileNameExtensionFilter existFilter = ExportDialog.this.getFilterWithSameExtensions(filter);
                    if (existFilter == null) {
                        ExportDialog.this.m_fchooser.addChoosableFileFilter(filter);
                        ExportDialog.this.m_filterList.add(filter);
                        ExportDialog.this.m_fchooser.setFileFilter(filter);
                    } else {
                        ExportDialog.this.m_fchooser.setFileFilter(existFilter);
                    }
                }
                if ((textFile = ExportDialog.this.m_fileTextField.getText().trim()).length() > 0) {
                    File currentFile = new File(textFile);
                    if (currentFile.isDirectory()) {
                        ExportDialog.this.m_fchooser.setCurrentDirectory(currentFile);
                    } else {
                        ExportDialog.this.m_fchooser.setSelectedFile(currentFile);
                    }
                }
                if ((result = ExportDialog.this.m_fchooser.showOpenDialog(addFileButton)) == 0) {
                    File file = ExportDialog.this.m_fchooser.getSelectedFile();
                    String absolutePath = file.getAbsolutePath();
                    String fileName = file.getName();
                    if (fileName.indexOf(46) == -1 && exporterInfo != null) {
                        absolutePath = absolutePath + "." + exporterInfo.getFileExtension();
                    }
                    ExportDialog.this.m_fileTextField.setText(absolutePath);
                }
            }
        });
        c.gridx += 2;
        c.gridwidth = 1;
        exportPanel.add((Component)addFileButton, c);
        if ((this.m_exportType == 3 || this.m_exportType == 4) && this.m_showExportAllPSMsChB.booleanValue()) {
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 2;
            this.m_exportAllPSMsChB = new JCheckBox("Export all PSMs");
            exportPanel.add((Component)this.m_exportAllPSMsChB, c);
        }
        this.m_exporTypeCombobox = new JComboBox<Object>(ExporterFactory.getList(this.m_exportType).toArray());
        this.m_exporTypeCombobox.setSelectedIndex(0);
        if (this.m_exportType == 1) {
            this.m_exporTypeCombobox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (ExportDialog.this.m_decoratedPanel == null) {
                        return;
                    }
                    if (ie.getItem().toString().contains("CSV")) {
                        ExportDialog.this.m_decoratedPanel.setVisible(false);
                    } else {
                        ExportDialog.this.m_decoratedPanel.setVisible(true);
                    }
                    ExportDialog.this.repack();
                }
            });
        }
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        exportPanel.add((Component)new JLabel("Export Type:"), c);
        ++c.gridx;
        c.gridwidth = 2;
        exportPanel.add((Component)this.m_exporTypeCombobox, c);
        if (this.m_exportType == 1) {
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 3;
            exportPanel.add((Component)this.createDecoratedRadioPanel(), c);
        }
        ++c.gridy;
        c.weighty = 1.0;
        exportPanel.add(Box.createVerticalGlue());
        return exportPanel;
    }

    public String getFileName() {
        return this.m_fileTextField.getText().trim();
    }

    public Boolean exportAllPSMs() {
        if (this.m_exportType == 3 || this.m_exportType == 4) {
            return this.m_exportAllPSMsChB.isSelected();
        }
        return null;
    }

    public Boolean exportDecorated() {
        if (this.m_exportType == 1) {
            return (boolean)((Boolean)this.m_exportParameter.getObjectValue());
        }
        return null;
    }

    public ExporterFactory.ExporterInfo getExporterInfo() {
        return (ExporterFactory.ExporterInfo)this.m_exporTypeCombobox.getSelectedItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean okCalled() {
        Object[] options2;
        String title;
        String message;
        int reply2;
        File f;
        String fileName = this.m_fileTextField.getText().trim();
        if (fileName.length() == 0) {
            this.setStatus(true, "You must fill the file name.");
            this.highlight(this.m_fileTextField);
            return false;
        }
        ExporterFactory.ExporterInfo exporterInfo = this.getExporterInfo();
        String extension = exporterInfo.getFileExtension();
        if (!fileName.endsWith("." + extension)) {
            fileName = fileName + "." + extension;
            this.m_fileTextField.setText(fileName);
        }
        if ((f = new File(fileName)).exists() && (reply2 = JOptionPane.showOptionDialog(this, message = "The file already exists. Do you want to overwrite it ?", title = "Overwrite ?", 0, 1, null, options2 = new String[]{"Yes", "No"}, "Yes")) != 0) {
            this.setStatus(true, "File already exists.");
            return false;
        }
        FileWriter fw = null;
        try {
            fw = new FileWriter(f);
            fw.write("t");
        }
        catch (Exception e) {
            this.setStatus(true, fileName + " is not writable.");
            this.highlight(this.m_fileTextField);
            boolean options2 = false;
            return options2;
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
                f.delete();
            }
            catch (Exception reply2) {}
        }
        if (this.m_exportType == 1) {
            this.m_exportManager = new ExportManager((JTable)this.m_table);
            ExportManager.ExportWorker exportTask = this.m_exportManager.getTask(exporterInfo.getExporter(), this.m_exportName, fileName, this.exportDecorated());
            this.startTask(exportTask);
            Preferences preferences = NbPreferences.root();
            preferences.put("DefaultExcelExportPath", f.getAbsoluteFile().getParentFile().getAbsolutePath());
        } else if (this.m_exportType == 3 || this.m_exportType == 4 || this.m_exportType == 6 || this.m_exportType == 7) {
            this.startTask(ExportDialog.m_singletonServerDialog.m_task);
            Preferences preferences = NbPreferences.root();
            preferences.put("DefaultExcelExportPath", f.getAbsoluteFile().getParentFile().getAbsolutePath());
        } else if (this.m_exportType == 2) {
            ExporterFactory.ExporterType exporterType = exporterInfo.geType();
            String absolutePath = f.getAbsolutePath();
            if (absolutePath.endsWith(".png")) {
                exporterType = ExporterFactory.ExporterType.PNG;
                this.m_exporTypeCombobox.setSelectedItem(ExporterFactory.EXPORTER_INFO_PNG);
            } else if (absolutePath.endsWith(".svg")) {
                exporterType = ExporterFactory.ExporterType.SVG;
                this.m_exporTypeCombobox.setSelectedItem(ExporterFactory.EXPORTER_INFO_SVG);
            } else if (exporterType == ExporterFactory.ExporterType.PNG) {
                f = new File(absolutePath + ".png");
            } else if (exporterType == ExporterFactory.ExporterType.SVG) {
                f = new File(absolutePath + ".svg");
            }
            this.m_fileTextField.setText(f.getAbsolutePath());
            if (exporterType == ExporterFactory.ExporterType.PNG) {
                BufferedImage bi = new BufferedImage(this.m_panel.getSize().width, this.m_panel.getSize().height, 2);
                Graphics2D g = bi.createGraphics();
                this.m_panel.paint(g);
                g.dispose();
                try {
                    ImageIO.write((RenderedImage)bi, "png", f);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger((String)"ProlineStudio.Commons").error("Error exporting png", (Throwable)e);
                }
                Preferences preferences = NbPreferences.root();
                preferences.put("DefaultExcelImagePath", f.getAbsoluteFile().getParentFile().getAbsolutePath());
            } else if (exporterType == ExporterFactory.ExporterType.SVG) {
                SVGGraphics2D g2 = new SVGGraphics2D(this.m_panel.getWidth(), this.m_panel.getHeight());
                this.m_panel.paint((Graphics)g2);
                try {
                    SVGUtils.writeToSVG((File)f, (String)g2.getSVGElement());
                }
                catch (Exception ex) {
                    LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer").error("Error exporting svg", (Throwable)ex);
                }
                g2.dispose();
                Preferences preferences = NbPreferences.root();
                preferences.put("DefaultExcelImagePath", f.getAbsoluteFile().getParentFile().getAbsolutePath());
            }
            return true;
        }
        return false;
    }

    @Override
    public void setVisible(boolean v) {
        if (!v) {
            Exception e;
            if (this.m_exportManager != null && (e = this.m_exportManager.getException()) != null) {
                LoggerFactory.getLogger((String)"ProlineStudio.Commons").error("Error during table export", (Throwable)e);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String message = sw.toString();
                InfoDialog errorDialog = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "Error", message);
                errorDialog.setButtonVisible(1, false);
                errorDialog.centerToWindow(WindowManager.getDefault().getMainWindow());
                errorDialog.setVisible(true);
            }
            this.m_table = null;
            this.m_panel = null;
            this.m_exportName = null;
            this.m_exportManager = null;
        }
        super.setVisible(v);
    }

    @Override
    protected boolean cancelCalled() {
        return true;
    }

    private FileNameExtensionFilter getFilterWithSameExtensions(FileNameExtensionFilter filter) {
        return ExportDialog.getFilterWithSameExtensions(filter, this.m_filterList);
    }

    public static FileNameExtensionFilter getFilterWithSameExtensions(FileNameExtensionFilter filter, List<FileNameExtensionFilter> filterList) {
        FileNameExtensionFilter existFilter = null;
        String[] newExtension = filter.getExtensions();
        int nbNew = newExtension.length;
        for (FileNameExtensionFilter f : filterList) {
            String[] extensions = f.getExtensions();
            boolean sameExt = true;
            int nbE = extensions.length;
            if (nbE == nbNew) {
                for (int k = 0; k < nbE; ++k) {
                    if (extensions[k].equals(newExtension[k])) continue;
                    sameExt = false;
                    break;
                }
            }
            if (!sameExt) continue;
            existFilter = f;
            break;
        }
        return existFilter;
    }
}

