/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.filter;

import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterStatus;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class ValueFilter
extends Filter {
    private static final Integer VALUE = 0;
    private Object[] m_values = null;
    private ImageIcon[] m_displayIcons = null;
    private int m_index = 0;
    private final ValueFilterType m_type;

    public ValueFilter(String variableName, Object[] values, ImageIcon[] displayIcons, ValueFilterType type, ConvertValueInterface convertValueInterface, int modelColumn) {
        super(variableName, convertValueInterface, modelColumn);
        this.m_values = values;
        this.m_displayIcons = displayIcons;
        this.m_type = type;
    }

    @Override
    public Filter cloneFilter4Search() {
        ValueFilter clone = new ValueFilter(this.m_variableName, this.m_values, this.m_displayIcons, this.m_type, this.m_convertValueInterface, this.m_modelColumn);
        clone.m_index = this.m_index;
        this.setValuesForClone(clone);
        return clone;
    }

    @Override
    public boolean filter(Object v1, Object v2) {
        int index = (Integer)v1;
        if (this.m_type == ValueFilterType.GREATER_EQUAL) {
            return index >= this.m_index;
        }
        return this.m_index == index;
    }

    @Override
    public FilterStatus checkValues() {
        return null;
    }

    @Override
    public boolean registerValues() {
        boolean hasChanged = false;
        if (this.isDefined()) {
            int lastIndex = this.m_index;
            this.m_index = ((JComboBox)this.getComponent(VALUE)).getSelectedIndex();
            hasChanged = this.m_index != lastIndex;
        }
        this.registerDefinedAsUsed();
        return hasChanged;
    }

    @Override
    public void createComponents(JPanel p, GridBagConstraints c) {
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        JLabel nameLabel = new JLabel(this.getName());
        p.add((Component)nameLabel, c);
        c.gridx += 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        if (this.m_type == ValueFilterType.GREATER_EQUAL) {
            p.add((Component)new JLabel(">="), c);
        } else {
            p.add((Component)new JLabel(":"), c);
        }
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        JComboBox<Object> vCombobox = (JComboBox<Object>)this.getComponent(VALUE);
        if (vCombobox == null) {
            vCombobox = new JComboBox<Object>(this.m_values);
            vCombobox.setSelectedIndex(this.m_index);
            this.registerComponent(VALUE, vCombobox);
            if (this.m_displayIcons != null) {
                vCombobox.setRenderer(new IconValueRenderer());
            }
        }
        p.add((Component)vCombobox, c);
        c.gridx += 3;
    }

    @Override
    public void reset() {
        this.m_index = -1;
    }

    private class IconValueRenderer
    extends DefaultListCellRenderer {
        private IconValueRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel l = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (index < 0) {
                for (int i = 0; i < ValueFilter.this.m_values.length; ++i) {
                    if (ValueFilter.this.m_values[i] != value) continue;
                    index = i;
                }
            }
            if (ValueFilter.this.m_displayIcons != null && index >= 0) {
                l.setIcon(ValueFilter.this.m_displayIcons[index]);
            } else {
                l.setIcon(null);
            }
            return l;
        }
    }

    public static enum ValueFilterType {
        GREATER_EQUAL,
        EQUAL;

    }
}

