/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.WindowManager;
import fr.proline.studio.graphics.ColorButton;
import fr.proline.studio.graphics.ColorButtonAndPalettePanel;
import fr.proline.studio.graphics.ColorOrGradient;
import fr.proline.studio.graphics.ReferenceIdName;
import fr.proline.studio.graphics.colorpicker.ColorPickerDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ColorOrGradientChooserPanel
extends JPanel {
    private JRadioButton m_colorRadioButton = null;
    private JRadioButton m_gradientRadioButton = null;
    private InternalColorButton m_colorSelectionButton = null;
    private GradientSelectorPanel m_gradientSelector = null;
    private ColorOrGradient m_colorOrGradient;
    private JComboBox m_gradientParamComboBox = null;
    private static final int SQUARE_SIZE = 10;

    public ColorOrGradientChooserPanel(ColorOrGradient color, ArrayList<ReferenceIdName> gradientParam) {
        this.setLayout(new GridBagLayout());
        this.m_colorOrGradient = color;
        this.m_colorRadioButton = new JRadioButton();
        this.m_gradientRadioButton = new JRadioButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_colorRadioButton);
        group.add(this.m_gradientRadioButton);
        JComboBox jComboBox = this.m_gradientParamComboBox = gradientParam == null ? null : new JComboBox(gradientParam.toArray());
        if (color.isColorSelected()) {
            this.m_colorRadioButton.setSelected(true);
        } else {
            this.m_gradientRadioButton.setSelected(true);
        }
        this.m_colorSelectionButton = new InternalColorButton();
        this.m_colorSelectionButton.initActionListener();
        this.m_colorSelectionButton.setBackground(color.getColor());
        this.m_gradientSelector = new GradientSelectorPanel();
        this.m_gradientSelector.setLinearGradient(color.getGradient());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.m_colorRadioButton, c);
        ++c.gridx;
        c.gridy = 0;
        c.weightx = 1.0;
        this.add((Component)new ColorButtonAndPalettePanel(this.m_colorSelectionButton), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)this.m_gradientRadioButton, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.m_gradientSelector, c);
        if (this.m_gradientParamComboBox != null) {
            ++c.gridy;
            this.add((Component)this.m_gradientParamComboBox, c);
        }
    }

    public ReferenceIdName getSelectedReferenceIdName() {
        return (ReferenceIdName)this.m_gradientParamComboBox.getSelectedItem();
    }

    public ColorOrGradient getColor() {
        this.m_colorOrGradient.setColor(this.m_colorSelectionButton.getBackground());
        this.m_colorOrGradient.setGradient(this.m_gradientSelector.getGradient());
        if (this.m_colorRadioButton.isSelected()) {
            this.m_colorOrGradient.setColorSelected();
        } else {
            this.m_colorOrGradient.setGradientSelected();
        }
        return this.m_colorOrGradient;
    }

    public void setColor(ColorOrGradient c) {
        this.m_colorOrGradient = c;
        this.m_colorSelectionButton.setBackground(c.getColor());
        this.m_gradientSelector.setLinearGradient(c.getGradient());
    }

    private static void drawGraySquares(Graphics g, int x1, int y1, int x2, int y2) {
        g.setColor(Color.gray);
        int y = 0;
        do {
            int x = 0;
            do {
                if ((x + y) % 2 != 0) continue;
                g.fillRect(x1 + x * 10, y1 + y * 10, 10, 10);
            } while (x1 + ++x * 10 <= x2);
        } while (y1 + ++y * 10 <= y2);
    }

    public static LinearGradientPaint getGradientForPanel(Color[] colors, float[] fractions) {
        return new LinearGradientPaint(0.0f, 0.0f, 100.0f, 100.0f, fractions, colors);
    }

    public static LinearGradientPaint getGradientForPanel(Color[] colors, float[] fractions, int x, int y, int width, int height) {
        return new LinearGradientPaint(x, y, width, height, fractions, colors);
    }

    public class GradientSelectorPanel
    extends JPanel
    implements MouseListener {
        private final Dimension m_dimension = new Dimension(100, 35);
        private static final int WIDTH = 100;
        private static final int HEIGHT = 35;
        private static final int DELTA_X = 10;
        private static final int DELTA_Y_TOP = 5;
        private static final int DELTA_Y_BOTTOM = 10;
        private Color[] m_gradientColors = null;
        private float[] m_gradientFractions = null;
        private final ArrayList<ColorSelector> m_colorSelectors = new ArrayList();

        public GradientSelectorPanel() {
            this.addMouseListener(this);
        }

        public void setLinearGradient(LinearGradientPaint linearGradientPaint) {
            this.m_gradientColors = linearGradientPaint.getColors();
            this.m_gradientFractions = linearGradientPaint.getFractions();
            this.m_colorSelectors.clear();
            for (int i = 0; i < this.m_gradientColors.length; ++i) {
                ColorSelector colorSelector = new ColorSelector(this.m_gradientColors[i], this.m_gradientFractions[i]);
                this.m_colorSelectors.add(colorSelector);
            }
            this.repaint();
        }

        public LinearGradientPaint getGradient() {
            return ColorOrGradientChooserPanel.getGradientForPanel(this.m_gradientColors, this.m_gradientFractions);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.m_dimension;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int width = this.getWidth();
            int height = this.getHeight();
            g.setColor(Color.white);
            g.fillRect(0, 0, width, height);
            ColorOrGradientChooserPanel.drawGraySquares(g, 10, 5, width - 10, height - 10);
            g.setColor(Color.darkGray);
            g.drawRect(0, 0, width - 1, height - 1);
            if (this.m_gradientColors != null) {
                Rectangle2D.Double r2d = new Rectangle2D.Double(10.0, 5.0, width - 20, height - 5 - 10);
                g2D.setPaint(ColorOrGradientChooserPanel.getGradientForPanel(this.m_gradientColors, this.m_gradientFractions, (int)((RectangularShape)r2d).getX(), (int)((RectangularShape)r2d).getY(), (int)((RectangularShape)r2d).getWidth(), (int)((RectangularShape)r2d).getHeight()));
                g2D.fill(r2d);
            }
            g.setColor(Color.darkGray);
            g.drawRect(10, 5, width - 20, height - 5 - 10);
            for (int i = 0; i < this.m_colorSelectors.size(); ++i) {
                this.m_colorSelectors.get(i).paint(g, 10, width - 10, height - 10);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!ColorOrGradientChooserPanel.this.m_gradientRadioButton.isSelected()) {
                ColorOrGradientChooserPanel.this.m_gradientRadioButton.setSelected(true);
            }
            for (int i = 0; i < this.m_colorSelectors.size(); ++i) {
                if (!this.m_colorSelectors.get(i).contains(e.getX(), e.getY())) continue;
                this.m_gradientColors[i] = this.m_colorSelectors.get(i).getColor();
                this.repaint();
                return;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        public class ColorSelector {
            private Color m_color;
            private float m_fraction;
            private Polygon m_p;
            private static final int TRIANGLE_SIZE = 10;

            public ColorSelector(Color c, float f) {
                this.m_color = c;
                this.m_fraction = f;
                this.m_p = new Polygon();
            }

            public boolean contains(int x, int y) {
                if (this.m_p == null) {
                    return false;
                }
                if (this.m_p.contains(x, y)) {
                    ColorPickerDialog colorPickerDialog = new ColorPickerDialog((Window)WindowManager.getDefault().getMainWindow(), this.m_color);
                    colorPickerDialog.setLocationRelativeTo(ColorOrGradientChooserPanel.this.m_gradientSelector);
                    colorPickerDialog.setVisible(true);
                    if (colorPickerDialog.getButtonClicked() == 0) {
                        this.m_color = colorPickerDialog.getColor();
                    }
                    return true;
                }
                return false;
            }

            public void setColor(Color c) {
                this.m_color = c;
            }

            public Color getColor() {
                return this.m_color;
            }

            public void setFraction(float f) {
                this.m_fraction = f;
                this.m_p.reset();
            }

            public void paint(Graphics g, int x0, int x1, int yBase) {
                g.setColor(this.m_color);
                if (this.m_p.npoints == 0) {
                    int x = Math.round((float)x0 + (float)(x1 - x0) * this.m_fraction);
                    this.m_p.addPoint(x, yBase - 5);
                    this.m_p.addPoint(x + 5, yBase + 5);
                    this.m_p.addPoint(x - 5, yBase + 5);
                }
                g.setColor(Color.white);
                g.fillPolygon(this.m_p);
                g.setColor(this.m_color);
                g.fillPolygon(this.m_p);
                g.setColor(Color.darkGray);
                g.drawPolygon(this.m_p);
            }
        }
    }

    public class InternalColorButton
    extends ColorButton {
        @Override
        protected ActionListener getActionListener() {
            ActionListener a = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!ColorOrGradientChooserPanel.this.m_colorRadioButton.isSelected()) {
                        ColorOrGradientChooserPanel.this.m_colorRadioButton.setSelected(true);
                    }
                    ColorPickerDialog colorPickerDialog = new ColorPickerDialog((Window)WindowManager.getDefault().getMainWindow(), ColorOrGradientChooserPanel.this.m_colorSelectionButton.getBackground());
                    colorPickerDialog.setLocationRelativeTo(ColorOrGradientChooserPanel.this.m_colorSelectionButton);
                    colorPickerDialog.setVisible(true);
                    if (colorPickerDialog.getButtonClicked() == 0) {
                        ColorOrGradientChooserPanel.this.m_colorSelectionButton.setBackground(colorPickerDialog.getColor());
                        InternalColorButton.this.colorChangedToListeners();
                    }
                }
            };
            return a;
        }

        @Override
        public void propagateColorChanged(int r, int g, int b) {
            super.propagateColorChanged(r, g, b);
            if (!ColorOrGradientChooserPanel.this.m_colorRadioButton.isSelected()) {
                ColorOrGradientChooserPanel.this.m_colorRadioButton.setSelected(true);
            }
        }
    }
}

