/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.graphics.ExtendableButtonPanelGroup;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ExtendableButtonPanel
extends JPanel {
    private AbstractButton m_currentButton = null;
    private final ArrayList<AbstractButton> m_buttonList = new ArrayList();
    private final JPanel m_buttonPanel;
    private boolean m_isExpanded = false;
    private ExtendableButtonPanelGroup m_group = null;
    private final JButton m_expandButton;
    private int m_positionY = -1;

    public ExtendableButtonPanel(AbstractButton currentButton) {
        this.setBorder(null);
        this.setOpaque(true);
        this.setLayout(new FlowLayout(4, 0, 0));
        this.m_currentButton = currentButton;
        this.m_expandButton = new JButton(IconManager.getIcon(IconManager.IconType.EXPAND));
        this.m_expandButton.setAlignmentY(0.0f);
        this.m_expandButton.setMargin(new Insets(0, 0, 0, 0));
        this.m_expandButton.setFocusPainted(false);
        this.m_expandButton.setBorder(null);
        this.m_expandButton.setContentAreaFilled(false);
        this.m_expandButton.setOpaque(false);
        this.add(this.m_expandButton);
        this.m_expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExtendableButtonPanel.this.m_isExpanded) {
                    ExtendableButtonPanel.this.collapse();
                } else {
                    ExtendableButtonPanel.this.expand();
                }
            }
        });
        this.m_buttonPanel = new JPanel(new FlowLayout(0, 1, 1));
        this.m_buttonPanel.setBorder(BorderFactory.createLineBorder(Color.gray, 1, true));
        this.m_buttonPanel.setBackground(Color.white);
        this.add(this.m_buttonPanel);
        Dimension d = this.getPreferredSize();
        this.setSize((int)d.getWidth(), (int)d.getHeight());
    }

    protected void addedToGroup(ExtendableButtonPanelGroup g) {
        this.m_group = g;
    }

    @Override
    public void paint(Graphics g) {
        if (this.getYForExpandedPanel() != this.m_positionY) {
            this.calculatePosition();
            this.repaint();
            return;
        }
        super.paint(g);
    }

    private void calculatePosition() {
        this.m_positionY = this.getYForExpandedPanel();
        this.setLocation(this.getXForExpandedPanel(), this.getYForExpandedPanel());
        Dimension d = this.getPreferredSize();
        this.setSize((int)d.getWidth(), (int)d.getHeight());
    }

    private int getXForExpandedPanel() {
        return this.m_currentButton.getX() + this.m_currentButton.getWidth() - this.m_expandButton.getWidth();
    }

    private int getYForExpandedPanel() {
        int buttonMiddleY = this.m_currentButton.getY() + this.m_currentButton.getHeight() / 2;
        int expandedPanelY = buttonMiddleY - this.getHeight() / 2;
        return expandedPanelY;
    }

    public void expand() {
        this.m_isExpanded = true;
        this.m_buttonPanel.setVisible(true);
        if (this.m_group != null) {
            this.m_group.beingExpanded(this);
        }
        this.calculatePosition();
        this.repaint();
    }

    public void collapse() {
        this.m_isExpanded = false;
        this.m_buttonPanel.setVisible(false);
        this.calculatePosition();
        this.repaint();
    }

    public void registerButton(final AbstractButton button) {
        if (this.m_buttonList.isEmpty()) {
            this.initCurrentButton(button);
        }
        this.m_buttonList.add(button);
        button.setMargin(new Insets(2, 2, 2, 2));
        button.setFocusPainted(false);
        button.setBorder(null);
        button.setContentAreaFilled(false);
        this.m_buttonPanel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtendableButtonPanel.this.initCurrentButton(button);
            }
        });
    }

    private void initCurrentButton(AbstractButton button) {
        this.m_currentButton.setIcon(button.getIcon());
        this.m_currentButton.setText(button.getText());
        this.m_currentButton.setToolTipText(button.getToolTipText());
        for (ActionListener a : this.m_currentButton.getActionListeners()) {
            this.m_currentButton.removeActionListener(a);
        }
        for (ActionListener a : button.getActionListeners()) {
            this.m_currentButton.addActionListener(a);
        }
        if (this.m_currentButton instanceof JToggleButton && !((JToggleButton)this.m_currentButton).isSelected()) {
            ((JToggleButton)this.m_currentButton).doClick();
        }
        this.collapse();
    }
}

