/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.graphics.AbstractSelectionGesture;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Path2D;

public class SelectionGestureLasso
extends AbstractSelectionGesture {
    private final Polygon m_selectionPolygon = new Polygon();
    private final Rectangle m_selectionRectangle = new Rectangle();
    private boolean m_selectionIsSquare = true;

    public void setSelectionIsSquare(boolean selectionIsSquare) {
        this.m_selectionIsSquare = selectionIsSquare;
    }

    @Override
    public void startSelection(int x, int y) {
        if (this.m_selectionIsSquare) {
            this.m_selectionRectangle.x = x;
            this.m_selectionRectangle.y = y;
            this.m_selectionRectangle.height = 0;
            this.m_selectionRectangle.width = 0;
        } else {
            this.m_selectionPolygon.reset();
            this.m_selectionPolygon.addPoint(x, y);
        }
        this.m_isSelecting = true;
        this.m_action = 0;
    }

    @Override
    public void continueSelection(int x, int y) {
        if (this.m_selectionIsSquare) {
            this.m_selectionRectangle.height = y - this.m_selectionRectangle.y;
            this.m_selectionRectangle.width = x - this.m_selectionRectangle.x;
        } else {
            int lastIndex = this.m_selectionPolygon.npoints - 1;
            if (this.m_selectionPolygon.xpoints[lastIndex] != x || this.m_selectionPolygon.ypoints[lastIndex] != y) {
                this.m_selectionPolygon.addPoint(x, y);
            }
        }
    }

    @Override
    public void stopSelection(int x, int y) {
        this.continueSelection(x, y);
        this.m_isSelecting = false;
        if (this.m_selectionIsSquare) {
            this.m_minX = this.m_selectionRectangle.x;
            this.m_maxX = this.m_selectionRectangle.x + this.m_selectionRectangle.width;
            this.m_minY = this.m_selectionRectangle.y;
            this.m_maxY = this.m_selectionRectangle.y + this.m_selectionRectangle.height;
        } else {
            this.m_maxX = this.m_minX = this.m_selectionPolygon.xpoints[0];
            this.m_maxY = this.m_minY = this.m_selectionPolygon.ypoints[0];
            for (int i = 1; i < this.m_selectionPolygon.npoints; ++i) {
                int xCur = this.m_selectionPolygon.xpoints[i];
                int yCur = this.m_selectionPolygon.ypoints[i];
                if (xCur < this.m_minX) {
                    this.m_minX = xCur;
                } else if (xCur > this.m_maxX) {
                    this.m_maxX = xCur;
                }
                if (yCur < this.m_minY) {
                    this.m_minY = yCur;
                    continue;
                }
                if (yCur <= this.m_maxY) continue;
                this.m_maxY = yCur;
            }
        }
        this.m_action = this.m_maxY - this.m_minY < 10 && this.m_maxX - this.m_minX < 10 ? 1 : 2;
    }

    @Override
    public Point getClickPoint() {
        if (this.m_selectionIsSquare) {
            return new Point(this.m_selectionRectangle.x, this.m_selectionRectangle.y);
        }
        return new Point(this.m_selectionPolygon.xpoints[this.m_selectionPolygon.npoints - 1], this.m_selectionPolygon.ypoints[this.m_selectionPolygon.npoints - 1]);
    }

    @Override
    public Path2D.Double getSelectionPath() {
        Path2D.Double path = new Path2D.Double();
        if (this.m_selectionIsSquare) {
            path.moveTo(this.m_selectionRectangle.x, this.m_selectionRectangle.y);
            path.lineTo(this.m_selectionRectangle.x + this.m_selectionRectangle.width, this.m_selectionRectangle.y);
            path.lineTo(this.m_selectionRectangle.x + this.m_selectionRectangle.width, this.m_selectionRectangle.y + this.m_selectionRectangle.height);
            path.lineTo(this.m_selectionRectangle.x, this.m_selectionRectangle.y + this.m_selectionRectangle.height);
        } else {
            path.moveTo(this.m_selectionPolygon.xpoints[0], this.m_selectionPolygon.xpoints[0]);
            for (int i = 1; i < this.m_selectionPolygon.npoints; ++i) {
                path.lineTo(this.m_selectionPolygon.xpoints[i], this.m_selectionPolygon.ypoints[i]);
            }
        }
        path.closePath();
        return path;
    }

    public Polygon getSelectionPolygon() {
        if (this.m_selectionIsSquare) {
            this.m_selectionPolygon.reset();
            this.m_selectionPolygon.addPoint(this.m_selectionRectangle.x, this.m_selectionRectangle.y);
            this.m_selectionPolygon.addPoint(this.m_selectionRectangle.x + this.m_selectionRectangle.width, this.m_selectionRectangle.y);
            this.m_selectionPolygon.addPoint(this.m_selectionRectangle.x + this.m_selectionRectangle.width, this.m_selectionRectangle.y + this.m_selectionRectangle.height);
            this.m_selectionPolygon.addPoint(this.m_selectionRectangle.x, this.m_selectionRectangle.y + this.m_selectionRectangle.height);
        }
        return this.m_selectionPolygon;
    }

    @Override
    public void paint(Graphics g) {
        if (!this.m_isSelecting) {
            return;
        }
        g.setColor(CyclicColorPalette.BLUE_SELECTION_ZONE);
        if (this.m_selectionIsSquare) {
            g.fillRect(this.m_selectionRectangle.x, this.m_selectionRectangle.y, this.m_selectionRectangle.width, this.m_selectionRectangle.height);
        } else {
            if (this.m_selectionPolygon.npoints < 3) {
                return;
            }
            g.fillPolygon(this.m_selectionPolygon);
        }
    }

    @Override
    public int getAction() {
        return this.m_action;
    }

    public int getMinX() {
        return this.m_minX;
    }

    public int getMaxX() {
        return this.m_maxX;
    }

    public int getMinY() {
        return this.m_minY;
    }

    public int getMaxY() {
        return this.m_maxY;
    }
}

