/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ParameterError;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ParameterDialog
extends DefaultDialog {
    private AbstractParameter m_parameter;
    private Object m_value;

    public ParameterDialog(Window parent, String title, AbstractParameter parameter) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.m_parameter = parameter;
        this.setStatusVisible(false);
        this.setTitle(title);
        this.setButtonVisible(5, false);
        this.setInternalComponent(this.initInternalPanel());
    }

    private JPanel initInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new FlowLayout());
        internalPanel.add(this.m_parameter.getComponent());
        this.m_parameter.getComponent().setToolTipText("Selection only affects current renaming.");
        internalPanel.setPreferredSize(new Dimension(240, 80));
        internalPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createTitledBorder("According to")));
        return internalPanel;
    }

    @Override
    protected boolean okCalled() {
        ParameterError error = this.m_parameter.checkParameter();
        if (error != null) {
            this.setStatus(true, "Parameter Error Encountered");
            this.highlight(this.m_parameter.getComponent());
            return false;
        }
        this.m_value = this.m_parameter.getObjectValue();
        return true;
    }

    public Object getParameterValue() {
        return this.m_value;
    }
}

