/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.info;

import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class InfoFloatingPanel
extends JPanel {
    private JToggleButton m_infoButton = null;
    private JButton m_closeButton;
    private JButton m_retryButton;
    private JLabel m_hourGlassLabel;
    private JLabel m_infoLabel = null;

    public InfoFloatingPanel() {
        this.setBorder(BorderFactory.createLineBorder(Color.darkGray, 1, true));
        this.setOpaque(true);
        this.setLayout(new FlowLayout());
        this.m_closeButton = new JButton(IconManager.getIcon(IconManager.IconType.CROSS_SMALL7));
        this.m_closeButton.setMargin(new Insets(0, 0, 0, 0));
        this.m_closeButton.setFocusPainted(false);
        this.m_closeButton.setContentAreaFilled(false);
        this.m_closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoFloatingPanel.this.setVisible(false);
                if (InfoFloatingPanel.this.m_infoButton != null) {
                    InfoFloatingPanel.this.m_infoButton.setSelected(false);
                }
            }
        });
        this.m_hourGlassLabel = new JLabel(IconManager.getIcon(IconManager.IconType.HOUR_GLASS_MINI11));
        this.m_hourGlassLabel.setVisible(false);
        this.m_retryButton = new JButton(IconManager.getIcon(IconManager.IconType.REFRESH11));
        this.m_retryButton.setMargin(new Insets(0, 0, 0, 0));
        this.m_retryButton.setFocusPainted(false);
        this.m_retryButton.setContentAreaFilled(false);
        this.m_retryButton.setVisible(false);
        this.m_infoLabel = new JLabel();
        this.add(this.m_closeButton);
        this.add(this.m_hourGlassLabel);
        this.add(this.m_retryButton);
        this.add(this.m_infoLabel);
        Dimension d = this.getPreferredSize();
        this.setBounds(0, 0, (int)d.getWidth(), (int)d.getHeight());
        MouseAdapter dragGestureAdapter = new MouseAdapter(){
            int dX;
            int dY;

            @Override
            public void mouseDragged(MouseEvent e) {
                int parentY;
                Component panel = e.getComponent();
                int newX = e.getLocationOnScreen().x - this.dX;
                int newY = e.getLocationOnScreen().y - this.dY;
                Container parentComponent = panel.getParent();
                int parentX = parentComponent.getX();
                if (newX < parentX) {
                    newX = parentX;
                }
                if (newY < (parentY = parentComponent.getY())) {
                    newY = parentY;
                }
                int parentWidth = parentComponent.getWidth();
                if (newX + panel.getWidth() > parentWidth - parentX) {
                    newX = parentWidth - parentX - panel.getWidth();
                }
                int parentHeight = parentComponent.getHeight();
                if (newY + panel.getHeight() > parentHeight - parentY) {
                    newY = parentHeight - parentY - panel.getHeight();
                }
                panel.setLocation(newX, newY);
                this.dX = e.getLocationOnScreen().x - panel.getX();
                this.dY = e.getLocationOnScreen().y - panel.getY();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JPanel panel = (JPanel)e.getComponent();
                panel.setCursor(Cursor.getPredefinedCursor(13));
                this.dX = e.getLocationOnScreen().x - panel.getX();
                this.dY = e.getLocationOnScreen().y - panel.getY();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JPanel panel = (JPanel)e.getComponent();
                panel.setCursor(null);
            }
        };
        this.addMouseMotionListener(dragGestureAdapter);
        this.addMouseListener(dragGestureAdapter);
        this.setVisible(false);
    }

    public void switchToHourGlass() {
        this.m_hourGlassLabel.setVisible(true);
        this.m_closeButton.setVisible(false);
        this.m_retryButton.setVisible(false);
    }

    public void switchToClose() {
        this.m_hourGlassLabel.setVisible(false);
        this.m_closeButton.setVisible(true);
        this.m_retryButton.setVisible(false);
    }

    public void switchToRetry(ActionListener a) {
        this.m_hourGlassLabel.setVisible(false);
        this.m_closeButton.setVisible(false);
        this.m_retryButton.setVisible(true);
        if (a != null) {
            this.m_retryButton.addActionListener(a);
        }
    }

    public void setInfo(String info) {
        this.m_infoLabel.setText(info);
        Dimension d = this.getPreferredSize();
        this.setSize((int)d.getWidth(), (int)d.getHeight());
    }

    public void setToggleButton(JToggleButton srcButton) {
        this.m_infoButton = srcButton;
    }
}

