/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table;

import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.table.LazyData;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanTableModel<T>
extends AbstractTableModel
implements GlobalTableModelInterface {
    private static final Logger logger = LoggerFactory.getLogger(BeanTableModel.class);
    private String m_name;
    private PropertyDescriptor[] m_descriptors;
    private List<T> m_entities = new ArrayList<T>();
    private int[] m_columnIndexConverter = null;
    private HashMap<String, Integer> m_columnIndexMap = new HashMap();
    private HashMap<String, String> m_columnNameMap = new HashMap();
    private HashMap<String, TableCellRenderer> m_columnRendererMap = new HashMap();
    private HashMap<Integer, Filter> m_columnFilterMap = new HashMap();

    public BeanTableModel(Class<T> type) {
        this(type, Collections.singletonList("class"));
    }

    public BeanTableModel(Class<T> type, List<String> exclusionList) {
        try {
            this.m_name = type.getName() + " table";
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(type, 1).getPropertyDescriptors();
            ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
            for (PropertyDescriptor property : propertyDescriptors) {
                if (exclusionList.contains(property.getName())) continue;
                descriptors.add(property);
            }
            this.m_descriptors = descriptors.toArray(new PropertyDescriptor[0]);
        }
        catch (IntrospectionException ex) {
            logger.info("cannot infer getters from " + type, (Throwable)ex);
        }
    }

    public void addProperties(String columnKey, Integer columnIndex) {
        this.addProperties(columnKey, columnIndex, null, null, null);
    }

    public void addProperties(String columnKey, Integer columnIndex, String columnName) {
        this.addProperties(columnKey, columnIndex, columnName, null, null);
    }

    public void addProperties(String columnKey, Integer columnIndex, String columnName, TableCellRenderer renderer, Filter f) {
        if (columnIndex != null) {
            this.m_columnIndexMap.put(columnKey, columnIndex);
        }
        if (columnName != null) {
            this.m_columnNameMap.put(columnKey, columnName);
        }
        if (renderer != null) {
            this.m_columnRendererMap.put(columnKey, renderer);
        }
        if (f != null) {
            this.m_columnFilterMap.put(columnIndex, f);
        }
    }

    public void firePropertiesChanged() {
        int i;
        int nbColumns = this.getColumnCount();
        if (this.m_columnIndexConverter == null) {
            this.m_columnIndexConverter = new int[nbColumns];
        }
        for (i = 0; i < nbColumns; ++i) {
            this.m_columnIndexConverter[i] = -1;
        }
        for (i = 0; i < nbColumns; ++i) {
            String columnKey = this.getColumnKey(i);
            Integer indexForUser = this.m_columnIndexMap.get(columnKey);
            if (indexForUser == null) continue;
            this.m_columnIndexConverter[indexForUser.intValue()] = i;
        }
        int firstFreePotentialIndex = 0;
        block2: for (int i2 = 0; i2 < nbColumns; ++i2) {
            String columnKey = this.getColumnKey(i2);
            Integer indexForUser = this.m_columnIndexMap.get(columnKey);
            if (indexForUser != null) continue;
            for (int j = firstFreePotentialIndex; j < nbColumns; ++j) {
                if (this.m_columnIndexConverter[j] != -1) continue;
                this.m_columnIndexConverter[j] = i2;
                firstFreePotentialIndex = j;
                continue block2;
            }
        }
        this.fireTableDataChanged();
    }

    public void setData(List<T> data) {
        this.m_entities = data;
        this.fireTableDataChanged();
    }

    public List<T> getData() {
        return this.m_entities;
    }

    @Override
    public int getRowCount() {
        return this.m_entities.size();
    }

    @Override
    public int getColumnCount() {
        return this.m_descriptors.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.m_columnIndexConverter != null) {
            columnIndex = this.m_columnIndexConverter[columnIndex];
        }
        try {
            Object obj = this.m_descriptors[columnIndex].getReadMethod().invoke(this.m_entities.get(rowIndex), new Object[0]);
            if (obj != null && obj.getClass().isArray()) {
                int k;
                int arrayLength = Array.getLength(obj);
                int length = Math.min(arrayLength, 10);
                StringBuilder buffer = new StringBuilder("[");
                for (k = 0; k < length; ++k) {
                    buffer.append(Array.get(obj, k).toString()).append(",");
                }
                if (k < arrayLength) {
                    buffer.append("...");
                } else {
                    buffer.deleteCharAt(buffer.length() - 1);
                }
                buffer.append("]");
                obj = buffer.toString();
            }
            return obj;
        }
        catch (Exception ex) {
            logger.info("cannot get read method for property " + this.m_descriptors[columnIndex].getName(), (Throwable)ex);
            return null;
        }
    }

    public String getColumnKey(int column) {
        return this.m_descriptors[column].getDisplayName();
    }

    @Override
    public String getColumnName(int columnIndex) {
        String columnKey;
        String columnName;
        if (this.m_columnIndexConverter != null) {
            columnIndex = this.m_columnIndexConverter[columnIndex];
        }
        if ((columnName = this.m_columnNameMap.get(columnKey = this.getColumnKey(columnIndex))) != null) {
            return columnName;
        }
        return columnKey;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class<Object> cl;
        if (this.m_columnIndexConverter != null) {
            columnIndex = this.m_columnIndexConverter[columnIndex];
        }
        if ((cl = this.m_descriptors[columnIndex].getPropertyType()).isPrimitive()) {
            switch (cl.getSimpleName()) {
                case "double": {
                    cl = Double.class;
                    break;
                }
                case "int": {
                    cl = Integer.class;
                    break;
                }
                case "long": {
                    cl = Long.class;
                    break;
                }
                case "float": {
                    cl = Float.class;
                    break;
                }
                case "boolean": {
                    cl = Boolean.class;
                }
            }
        } else if (cl.isArray()) {
            cl = String.class;
        }
        return cl;
    }

    @Override
    public String getToolTipForHeader(int columnIndex) {
        if (this.m_columnIndexConverter != null) {
            columnIndex = this.m_columnIndexConverter[columnIndex];
        }
        return this.m_descriptors[columnIndex].getShortDescription();
    }

    @Override
    public String getTootlTipValue(int row, int col) {
        return null;
    }

    @Override
    public TableCellRenderer getRenderer(int rowIndex, int columnIndex) {
        if (this.m_columnIndexConverter != null) {
            columnIndex = this.m_columnIndexConverter[columnIndex];
        }
        String columnKey = this.getColumnKey(columnIndex);
        return this.m_columnRendererMap.get(columnKey);
    }

    @Override
    public Long getTaskId() {
        return -1L;
    }

    @Override
    public LazyData getLazyData(int row, int col) {
        return null;
    }

    @Override
    public void givePriorityTo(Long taskId, int row, int col) {
    }

    @Override
    public void sortingChanged(int col) {
    }

    @Override
    public int getSubTaskId(int col) {
        return -1;
    }

    @Override
    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    @Override
    public Class getDataColumnClass(int columnIndex) {
        return this.getColumnClass(columnIndex);
    }

    @Override
    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public int[] getKeysColumn() {
        return null;
    }

    @Override
    public int getInfoColumn() {
        return 0;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public Map<String, Object> getExternalData() {
        return null;
    }

    @Override
    public PlotInformation getPlotInformation() {
        return null;
    }

    @Override
    public long row2UniqueId(int rowIndex) {
        return rowIndex;
    }

    @Override
    public int uniqueId2Row(long id) {
        return (int)id;
    }

    @Override
    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        block12: for (int columnIndex = 0; columnIndex < this.m_descriptors.length; ++columnIndex) {
            Filter f = this.m_columnFilterMap.get(columnIndex);
            if (f != null) {
                filtersMap.put(columnIndex, f);
                return;
            }
            int descriptorIndex = columnIndex;
            if (this.m_columnIndexConverter != null) {
                descriptorIndex = this.m_columnIndexConverter[columnIndex];
            }
            switch (this.m_descriptors[descriptorIndex].getPropertyType().getSimpleName()) {
                case "String": {
                    filtersMap.put(columnIndex, new StringDiffFilter(this.getColumnName(columnIndex), null, columnIndex));
                    continue block12;
                }
                case "Double": 
                case "double": {
                    filtersMap.put(columnIndex, new DoubleFilter(this.getColumnName(columnIndex), null, columnIndex));
                    continue block12;
                }
                case "Integer": 
                case "int": {
                    filtersMap.put(columnIndex, new IntegerFilter(this.getColumnName(columnIndex), null, columnIndex));
                    continue block12;
                }
                default: {
                    System.out.println("no filter for type : " + this.m_descriptors[descriptorIndex].getPropertyType().getSimpleName());
                }
            }
        }
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public int getLoadingPercentage() {
        return 100;
    }

    @Override
    public PlotType getBestPlotType() {
        return PlotType.SCATTER_PLOT;
    }

    @Override
    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    @Override
    public String getExportRowCell(int row, int col) {
        return null;
    }

    @Override
    public String getExportColumnName(int col) {
        return this.getColumnName(col);
    }

    @Override
    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    @Override
    public Object getValue(Class c) {
        return null;
    }

    @Override
    public void addSingleValue(Object v) {
    }

    @Override
    public Object getSingleValue(Class c) {
        return null;
    }

    @Override
    public Object getRowValue(Class c, int row) {
        return null;
    }

    @Override
    public Object getColValue(Class c, int col) {
        return null;
    }

    @Override
    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    @Override
    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    @Override
    public PlotDataSpec getDataSpecAt(int i) {
        return null;
    }
}

