/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table;

import fr.proline.studio.table.renderer.PropertiesRenderer;
import java.awt.Color;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public abstract class DataGroup {
    public static final String[] COLUMN_NAMES = new String[]{"Group", "Type"};
    public static final int COLTYPE_GROUP_NAME = 0;
    public static final int COLTYPE_PROPERTY_NAME = 1;
    private final String m_name;
    protected int m_rowStart;
    private PropertiesRenderer m_groupRenderer = null;
    private PropertiesRenderer m_groupSubRenderer = null;

    public DataGroup(String name, int rowStart) {
        this.m_name = name;
        this.m_rowStart = rowStart;
        this.m_groupRenderer = new PropertiesRenderer(false);
        this.m_groupSubRenderer = new PropertiesRenderer(false);
    }

    private GroupObject getName(int row) {
        if (row == this.m_rowStart) {
            GroupObject object = new GroupObject(this.m_name, this);
            object.setColoredRow();
            return object;
        }
        JTable table = this.m_groupRenderer.getTable();
        if (table == null || table.getRowSorter().getSortKeys().isEmpty()) {
            return new GroupObject("", this.m_name, this);
        }
        return new GroupObject(this.m_name, this);
    }

    public TableCellRenderer getRenderer(int row) {
        if (row == this.m_rowStart) {
            return this.m_groupRenderer;
        }
        return this.m_groupSubRenderer;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.getName(rowIndex);
        }
        if (rowIndex == this.m_rowStart) {
            GroupObject object = new GroupObject("", this);
            object.setColoredRow();
            return object;
        }
        if (columnIndex == 1) {
            return this.getGroupNameAt(rowIndex - this.m_rowStart - 1);
        }
        return this.getGroupValueAt(rowIndex - this.m_rowStart - 1, columnIndex - 2);
    }

    public boolean isFirstRow(int row) {
        return row == this.m_rowStart;
    }

    public abstract GroupObject getGroupValueAt(int var1, int var2);

    public abstract GroupObject getGroupNameAt(int var1);

    public abstract Color getGroupColor(int var1);

    public int getRowCount() {
        return this.getRowCountImpl() + 1;
    }

    public abstract int getRowCountImpl();

    public class GroupObject {
        public String m_valueRendering;
        public String m_valueFiltering;
        public DataGroup m_group;
        public boolean m_coloredRow = false;

        public GroupObject(String value, DataGroup group) {
            this.m_valueRendering = value;
            this.m_valueFiltering = value;
            this.m_group = group;
        }

        public void setColoredRow() {
            this.m_coloredRow = true;
        }

        public GroupObject(String valueRendering, String valueFiltering, DataGroup group) {
            this.m_valueRendering = valueRendering;
            this.m_valueFiltering = valueFiltering;
            this.m_group = group;
        }

        public String stringForFilter() {
            return this.m_valueFiltering;
        }

        public String stringForRendering() {
            return this.m_valueRendering;
        }

        public String toString() {
            return this.m_valueRendering;
        }
    }
}

