/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.utils;

import fr.proline.studio.utils.GlobalValues;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;

public class HelpUtils {
    public static String convertURLToCurrentHelp(String helpURL) {
        if (helpURL == null) {
            return null;
        }
        String START_URL = "http://biodev.extra.cea.fr/docs/proline/doku.php";
        String START_URL_WITH_PARAMETER = "http://biodev.extra.cea.fr/docs/proline/doku.php?id=";
        String NEW_URL = "http://www.profiproteomics.fr/software/doc/1.6/";
        if (GlobalValues.PUBLIC_RELEASE_VERSION.booleanValue() && helpURL.startsWith("http://biodev.extra.cea.fr/docs/proline/doku.php")) {
            helpURL = helpURL.startsWith("http://biodev.extra.cea.fr/docs/proline/doku.php?id=") ? "http://www.profiproteomics.fr/software/doc/1.6/" + helpURL.substring("http://biodev.extra.cea.fr/docs/proline/doku.php?id=".length()).replaceAll(" ", "_").replaceAll(":", "/") + ".html" : "http://www.profiproteomics.fr/software/doc/1.6/start.html";
        }
        return helpURL;
    }

    public static String getFileName(String path, String[] suffixes) {
        if ((path = path.toLowerCase()).contains("/")) {
            path = path.substring(path.lastIndexOf("/") + 1);
        }
        if (path.contains("\\")) {
            path = path.substring(path.lastIndexOf("\\") + 1);
        }
        for (String suffix : suffixes) {
            if (!path.contains(suffix.toLowerCase())) continue;
            path = path.substring(0, path.indexOf(suffix.toLowerCase()));
        }
        return path;
    }

    public static String createRedirectPage(String url) {
        return "<html><head><meta http-equiv=\"refresh\" content=\"0;url=" + url + "\" /></head></html>";
    }

    public static URI createRedirectTempFile(String documentationSuffix) {
        BufferedWriter writer = null;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("redirect", ".html", null);
            tmpFile.deleteOnExit();
            writer = new BufferedWriter(new FileWriter(tmpFile));
            writer.write(HelpUtils.createRedirectPage(new File(".").getCanonicalPath() + File.separatorChar + "documentation" + File.separatorChar + "Proline_UserGuide.docx.html#" + documentationSuffix));
            writer.close();
        }
        catch (IOException e) {
            return null;
        }
        return tmpFile.toURI();
    }
}

