/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.utils;

import fr.proline.studio.table.LazyData;
import java.awt.Component;
import java.awt.Graphics2D;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.PainterHighlighter;
import org.jdesktop.swingx.painter.AbstractLayoutPainter;
import org.jdesktop.swingx.painter.Painter;

public class RelativePainterHighlighter
extends PainterHighlighter {
    private Relativizer m_relativizer;

    public RelativePainterHighlighter() {
        this(null);
    }

    public RelativePainterHighlighter(Painter delegate) {
        super(delegate);
    }

    public void setHorizontalAlignment(AbstractLayoutPainter.HorizontalAlignment align) {
        this.getPainter().setHorizontalAlignment(align);
        this.fireStateChanged();
    }

    public AbstractLayoutPainter.HorizontalAlignment getHorizontalAlignment() {
        return this.getPainter().getHorizontalAlignment();
    }

    public void setRelativizer(Relativizer relativizer) {
        this.m_relativizer = relativizer;
        this.fireStateChanged();
    }

    public Relativizer getRelativizer() {
        return this.m_relativizer;
    }

    protected Component doHighlight(Component component, ComponentAdapter adapter) {
        float xPercent = this.m_relativizer.getRelativeValue(adapter);
        this.getPainter().setXFactor(xPercent);
        this.getPainter().setVisible(xPercent != 0.0f);
        return super.doHighlight(component, adapter);
    }

    public void setPainter(Painter painter) {
        if (!(painter instanceof RelativePainter)) {
            painter = new RelativePainter(painter);
        }
        super.setPainter(painter);
    }

    public RelativePainter getPainter() {
        return (RelativePainter)super.getPainter();
    }

    protected boolean canHighlight(Component component, ComponentAdapter adapter) {
        return this.m_relativizer != null && super.canHighlight(component, adapter);
    }

    public static class RelativePainter<T>
    extends AbstractLayoutPainter<T> {
        private Painter<? super T> m_painter;
        private double m_xFactor;
        private double m_yFactor;
        private boolean m_visible;

        public RelativePainter() {
            this(null);
            this.setHorizontalAlignment(AbstractLayoutPainter.HorizontalAlignment.RIGHT);
        }

        public RelativePainter(Painter<? super T> delegate) {
            this.m_painter = delegate;
            this.setHorizontalAlignment(AbstractLayoutPainter.HorizontalAlignment.RIGHT);
        }

        public RelativePainter(Painter<? super T> delegate, double xPercent) {
            this(delegate);
            this.m_xFactor = xPercent;
            this.setHorizontalAlignment(AbstractLayoutPainter.HorizontalAlignment.RIGHT);
        }

        public void setPainter(Painter<? super T> painter) {
            Painter<T> old = this.getPainter();
            this.m_painter = painter;
            this.firePropertyChange("painter", old, this.getPainter());
        }

        public Painter<? super T> getPainter() {
            return this.m_painter;
        }

        public void setXFactor(double xPercent) {
            double old = this.getXFactor();
            this.m_xFactor = xPercent;
            this.firePropertyChange("xFactor", old, this.getXFactor());
        }

        public double getXFactor() {
            return this.m_xFactor;
        }

        public void setYFactor(double yPercent) {
            this.m_yFactor = yPercent;
        }

        protected void doPaint(Graphics2D g, T object, int width, int height) {
            if (this.m_painter == null) {
                return;
            }
            if (this.m_xFactor != 0.0) {
                int oldWidth = width;
                width = (int)(this.m_xFactor * (double)width);
                if (this.getHorizontalAlignment() == AbstractLayoutPainter.HorizontalAlignment.RIGHT) {
                    g.translate(oldWidth - width, 0);
                }
            }
            if (this.m_yFactor != 0.0) {
                int oldHeight = height;
                height = (int)(this.m_yFactor * (double)height);
                if (this.getVerticalAlignment() == AbstractLayoutPainter.VerticalAlignment.BOTTOM) {
                    g.translate(0, oldHeight - height);
                }
            }
            this.m_painter.paint(g, object, width, height);
        }

        public boolean isVisible() {
            return this.m_visible;
        }

        public void setVisible(boolean visible) {
            if (this.isVisible() == visible) {
                return;
            }
            this.m_visible = visible;
            this.firePropertyChange("visible", !visible, this.isVisible());
        }
    }

    public static class NumberRelativizer
    implements Relativizer {
        private Number m_min;
        private Number m_max;
        private int m_valueColumn;

        public NumberRelativizer(int column, Number min, Number max) {
            this.m_min = min;
            this.m_max = max;
            this.m_valueColumn = column;
        }

        public void setMin(Number min) {
            this.m_min = min;
        }

        public void setMax(Number max) {
            this.m_max = max;
        }

        @Override
        public float getRelativeValue(ComponentAdapter adapter) {
            Object value = adapter.getValue(this.m_valueColumn);
            if (value instanceof LazyData) {
                value = ((LazyData)value).getData();
            }
            float floatValue = value instanceof String ? Float.valueOf((String)value).floatValue() : ((Number)value).floatValue();
            float percent = floatValue / this.m_max.floatValue() - this.m_min.floatValue();
            return percent;
        }
    }

    public static interface Relativizer {
        public static final float ZERO = 0.0f;
        public static final float ONE = 1.0f;

        public float getRelativeValue(ComponentAdapter var1);
    }
}

