/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.utilities.ols.web.service.client;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import uk.ac.ebi.pride.utilities.ols.web.service.client.Client;
import uk.ac.ebi.pride.utilities.ols.web.service.config.AbstractOLSWsConfig;
import uk.ac.ebi.pride.utilities.ols.web.service.model.FieldList;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Href;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Identifier;
import uk.ac.ebi.pride.utilities.ols.web.service.model.OBOXRef;
import uk.ac.ebi.pride.utilities.ols.web.service.model.OboDefinitionCitation;
import uk.ac.ebi.pride.utilities.ols.web.service.model.ObsoleteTerm;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Ontology;
import uk.ac.ebi.pride.utilities.ols.web.service.model.OntologyQuery;
import uk.ac.ebi.pride.utilities.ols.web.service.model.QueryFields;
import uk.ac.ebi.pride.utilities.ols.web.service.model.RetrieveTermQuery;
import uk.ac.ebi.pride.utilities.ols.web.service.model.SearchQuery;
import uk.ac.ebi.pride.utilities.ols.web.service.model.SearchResult;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Term;
import uk.ac.ebi.pride.utilities.ols.web.service.model.TermQuery;

public class OLSClient
implements Client {
    private RestTemplate restTemplate;
    private AbstractOLSWsConfig config;
    private String queryField;
    private String fieldList;
    private int searchPageSize;
    private int searchPageNum;
    private static int TIME_OUT = 5000;
    private static final String DEFAULT_QUERY_FIELD = new QueryFields.QueryFieldBuilder().setLabel().setSynonym().build().toString();
    private static final String DEFAULT_FIELD_LIST = new FieldList.FieldListBuilder().setLabel().setIri().setScore().setOntologyName().setOboId().setOntologyIri().setIsDefiningOntology().setShortForm().setOntologyPrefix().setDescription().setType().build().toString();
    Logger logger = LoggerFactory.getLogger(OLSClient.class);

    public String getQueryField() {
        if (this.queryField == null) {
            this.queryField = DEFAULT_QUERY_FIELD;
        }
        return this.queryField;
    }

    public void setQueryField(String queryField) {
        this.queryField = queryField;
    }

    public String getFieldList() {
        if (this.fieldList == null) {
            this.fieldList = DEFAULT_FIELD_LIST;
        }
        return this.fieldList;
    }

    public int getSearchPageSize() {
        return this.searchPageSize;
    }

    public void setSearchPageSize(int searchPageSize) {
        this.searchPageSize = searchPageSize;
    }

    public int getSearchPageNum() {
        return this.searchPageNum;
    }

    public void setSearchPageNum(int searchPageNum) {
        this.searchPageNum = searchPageNum;
    }

    public void setFieldList(String fieldList) {
        this.fieldList = fieldList;
    }

    public OLSClient(AbstractOLSWsConfig config) {
        this.config = config;
        this.restTemplate = new RestTemplate();
        this.restTemplate = new RestTemplate();
        this.searchPageSize = 100;
        this.searchPageNum = -1;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public AbstractOLSWsConfig getConfig() {
        return this.config;
    }

    public void setConfig(AbstractOLSWsConfig config) {
        this.config = config;
    }

    @Override
    public Term getTermById(Identifier termId, String ontologyId) throws RestClientException {
        if (termId != null && termId.getIdentifier() != null) {
            if (termId.getType() == Identifier.IdentifierType.OBO) {
                return this.getTermByOBOId(termId.getIdentifier(), ontologyId);
            }
            if (termId.getType() == Identifier.IdentifierType.OWL) {
                return this.getTermByShortName(termId.getIdentifier(), ontologyId);
            }
            if (termId.getType() == Identifier.IdentifierType.IRI) {
                return this.getTermByIRIId(termId.getIdentifier(), ontologyId);
            }
        }
        return null;
    }

    public Term getTermByOBOId(String termOBOId, String ontologyId) throws RestClientException {
        String query = String.format("obo_id=%s", termOBOId);
        this.logger.debug(query);
        URI uri = this.encodeURL("/api/ontologies/" + ontologyId + "/terms", query);
        TermQuery result = (TermQuery)this.restTemplate.getForObject(uri, TermQuery.class);
        if (result != null && result.getTerms() != null && result.getTerms().length == 1) {
            return result.getTerms()[0];
        }
        return null;
    }

    public Term getTermByShortName(String shortForm, String ontologyId) throws RestClientException {
        String query = String.format("short_form=%s", shortForm);
        this.logger.debug(query);
        URI uri = this.encodeURL("/api/ontologies/" + ontologyId + "/terms", query);
        TermQuery result = (TermQuery)this.restTemplate.getForObject(uri, TermQuery.class);
        if (result != null && result.getTerms() != null && result.getTerms().length == 1) {
            return result.getTerms()[0];
        }
        return null;
    }

    public Term getTermByIRIId(String iriId, String ontologyId) throws RestClientException {
        String query = String.format("iri=%s", iriId);
        this.logger.debug(query);
        URI uri = this.encodeURL("/api/ontologies/" + ontologyId + "/terms", query);
        TermQuery result = (TermQuery)this.restTemplate.getForObject(uri, TermQuery.class);
        if (result != null && result.getTerms() != null && result.getTerms().length == 1) {
            return result.getTerms()[0];
        }
        return null;
    }

    @Override
    public List<String> getTermDescription(Identifier termId, String ontologyId) throws RestClientException {
        Term term = this.getTermById(termId, ontologyId);
        ArrayList<String> description = new ArrayList<String>();
        if (term != null && term.getDescription() != null) {
            for (String subDescription : term.getDescription()) {
                if (subDescription == null || subDescription.isEmpty()) continue;
                description.add(subDescription);
            }
        }
        return description;
    }

    @Override
    public Map<String, List<String>> getAnnotations(Identifier termId, String ontologyId) throws RestClientException {
        Term term = this.getTermById(termId, ontologyId);
        if (term != null && term.getAnnotation() != null) {
            return term.getAnnotation().getAnnotation();
        }
        return null;
    }

    @Override
    public List<Ontology> getOntologies() throws RestClientException {
        OntologyQuery currentOntologyQuery = this.getOntologyQuery(0);
        ArrayList<Ontology> ontologies = new ArrayList<Ontology>();
        ontologies.addAll(Arrays.asList(currentOntologyQuery.getOntolgoies()));
        if (currentOntologyQuery != null && currentOntologyQuery.getOntolgoies().length < currentOntologyQuery.getPage().getTotalElements()) {
            for (int i = 1; i < currentOntologyQuery.getPage().getTotalElements() / currentOntologyQuery.getOntolgoies().length + 1; ++i) {
                OntologyQuery ontologyQuery = this.getOntologyQuery(i);
                if (ontologyQuery == null || ontologyQuery.getOntolgoies() == null) continue;
                ontologies.addAll(Arrays.asList(ontologyQuery.getOntolgoies()));
            }
        }
        return ontologies;
    }

    public Ontology getOntologyFromId(URI id) {
        List<Ontology> ontologyList = this.getOntologies();
        for (Ontology ontology : ontologyList) {
            this.logger.debug(ontology.getConfig().getId());
            if (!ontology.getConfig().getId().equals(id.toString())) continue;
            return ontology;
        }
        return null;
    }

    @Override
    public List<Term> getTermChildren(Identifier termId, String ontologyId, int distance) throws RestClientException {
        List<Term> terms = new ArrayList<Term>();
        Term term = this.getTermById(termId, ontologyId);
        if (term != null && term.getLink() != null && term.getLink().getAllChildrenRef() != null) {
            terms = this.getTermChildrenMap(term.getLink().getAllChildrenRef(), distance);
        }
        return terms;
    }

    @Override
    public List<Term> getTermParents(Identifier termId, String ontologyId, int distance) throws RestClientException {
        List<Term> terms = new ArrayList<Term>();
        Term term = this.getTermById(termId, ontologyId);
        if (term != null && term.getLink() != null && term.getLink().getAllParentsRef() != null) {
            terms = this.getTermParentsMap(term.getLink().getAllParentsRef(), distance);
        }
        return terms;
    }

    @Override
    public Boolean isObsolete(Identifier termId, String ontologyId) throws RestClientException {
        Term term = this.getTermById(termId, ontologyId);
        return this.isObsolete(term);
    }

    @Override
    public List<Term> searchTermById(String identifier, String ontologyID) throws RestClientException {
        ArrayList<Term> termResults = new ArrayList<Term>();
        SearchQuery currentTermQuery = this.searchIdQuery(identifier, ontologyID, 0);
        ArrayList<SearchResult> terms = new ArrayList<SearchResult>();
        if (currentTermQuery != null && currentTermQuery.getResponse() != null && currentTermQuery.getResponse().getSearchResults() != null) {
            terms.addAll(Arrays.asList(currentTermQuery.getResponse().getSearchResults()));
            if (currentTermQuery.getResponse().getSearchResults().length < currentTermQuery.getResponse().getNumFound()) {
                for (int i = 1; i < currentTermQuery.getResponse().getNumFound() / currentTermQuery.getResponse().getSearchResults().length + 1; ++i) {
                    SearchQuery termQuery = this.searchIdQuery(identifier, ontologyID, i);
                    if (termQuery == null || termQuery.getResponse() == null || termQuery.getResponse().getSearchResults() == null) continue;
                    terms.addAll(Arrays.asList(termQuery.getResponse().getSearchResults()));
                }
            }
        }
        for (SearchResult term : terms) {
            if (term.getName() == null) continue;
            termResults.add(new Term(term.getIri(), term.getName(), term.getDescription(), term.getShortName(), term.getOboId(), term.getOntologyName(), term.getScore(), term.getOntologyIri(), term.getIsDefiningOntology(), term.getOboDefinitionCitation()));
        }
        return termResults;
    }

    private SearchQuery searchIdQuery(String identifier, String ontologyID, int page) throws RestClientException {
        String query = String.format("q=*%s*&" + this.getFieldList() + "&rows=%s&start=%s", identifier, 100, page);
        if (ontologyID != null && !ontologyID.isEmpty()) {
            query = String.format("q=%s&exact=on&" + this.getFieldList() + "&rows=%s&start=%s&ontology=%s", identifier, 100, page, ontologyID);
        }
        this.logger.debug(query);
        URI uri = this.encodeURL("/api/search", query);
        return (SearchQuery)this.restTemplate.getForObject(uri, SearchQuery.class);
    }

    public List<String> getTermDescription(String termId, String ontologyId) throws RestClientException {
        Term term = this.getTermByOBOIdString(termId, ontologyId);
        if (term != null) {
            return Arrays.asList(term.getDescription());
        }
        return null;
    }

    public Term getTermByOBOIdString(String termOBOId, String ontologyId) {
        return this.getTermById(new Identifier(termOBOId, Identifier.IdentifierType.OBO), ontologyId);
    }

    public Map<String, String> getTermXrefs(Identifier termId, String ontologyId) throws RestClientException {
        Term term = this.getTermById(termId, ontologyId);
        HashMap<String, String> xrefs = new HashMap<String, String>();
        if (term != null && term.getOboXRefs() != null) {
            for (OBOXRef xref : term.getOboXRefs()) {
                if (xref.getDatabase() == null) continue;
                xrefs.put(xref.getDatabase(), xref.getDescription());
            }
        }
        if (term != null && term.getOboDefinitionCitation() != null) {
            xrefs.putAll(this.getOboDefinitionCitationXRef(term));
        }
        return xrefs;
    }

    public Map<String, String> getOBOSynonyms(Identifier identifier, String ontology) throws RestClientException {
        Term term = this.getTermById(identifier, ontology);
        HashMap<String, String> xrefs = new HashMap<String, String>();
        if (term != null && term.getOboSynonyms() != null) {
            xrefs.putAll(term.getOboSynonyms());
        }
        return xrefs;
    }

    private OntologyQuery getOntologyQuery(int page) throws RestClientException {
        String query = String.format("page=%s&size=%s", page, 100);
        this.logger.debug(query);
        URI uri = this.encodeURL("/api/ontologies", query);
        return (OntologyQuery)this.restTemplate.getForObject(uri, OntologyQuery.class);
    }

    @Override
    public List<Term> getAllTermsFromOntology(String ontologyID) throws RestClientException {
        return this.getAllOBOTermsFromOntology(ontologyID);
    }

    private List<Term> getAllOBOTermsFromOntology(String ontologyID) throws RestClientException {
        TermQuery currentTermQuery = this.getTermQuery(0, ontologyID);
        ArrayList<Term> terms = new ArrayList<Term>();
        if (currentTermQuery != null && currentTermQuery.getTerms() != null) {
            terms.addAll(Arrays.asList(currentTermQuery.getTerms()));
            if (currentTermQuery.getTerms().length < currentTermQuery.getPage().getTotalElements()) {
                for (int i = 1; i < currentTermQuery.getPage().getTotalElements() / currentTermQuery.getTerms().length + 1; ++i) {
                    TermQuery termQuery = this.getTermQuery(i, ontologyID);
                    if (termQuery == null || termQuery.getTerms() == null) continue;
                    terms.addAll(Arrays.asList(termQuery.getTerms()));
                }
            }
        }
        return terms;
    }

    private TermQuery getRootQuery(int page, String ontologyID) {
        String query = String.format("page=%s&size=%s", page, 1000);
        this.logger.debug(query);
        URI uri = this.encodeURL("/api/ontologies/" + ontologyID + "/terms/roots/", query);
        return (TermQuery)this.restTemplate.getForObject(uri, TermQuery.class);
    }

    private TermQuery getTermQuery(int page, String ontologyID) {
        String query = String.format("page=%s&size=%s", page, 1000);
        this.logger.debug(query);
        URI uri = this.encodeURL("/api/ontologies/" + ontologyID + "/terms", query);
        return (TermQuery)this.restTemplate.getForObject(uri, TermQuery.class);
    }

    @Override
    public List<Term> getRootTerms(String ontologyID) {
        return this.getAllRootTerns(ontologyID);
    }

    private List<Term> getAllRootTerns(String ontologyID) {
        TermQuery currentTermQuery = this.getRootQuery(0, ontologyID);
        ArrayList<Term> terms = new ArrayList<Term>();
        if (currentTermQuery != null && currentTermQuery.getTerms() != null) {
            terms.addAll(Arrays.asList(currentTermQuery.getTerms()));
            if (currentTermQuery.getTerms().length < currentTermQuery.getPage().getTotalElements()) {
                for (int i = 1; i < currentTermQuery.getPage().getTotalElements() / currentTermQuery.getTerms().length + 1; ++i) {
                    TermQuery termQuery = this.getRootQuery(i, ontologyID);
                    if (termQuery == null || termQuery.getTerms() == null) continue;
                    terms.addAll(Arrays.asList(termQuery.getTerms()));
                }
            }
        }
        return terms;
    }

    @Override
    public List<Term> getTermsByName(String partialName, String ontologyID, boolean reverseKeyOrder) {
        return this.getTermsByName(partialName, ontologyID, reverseKeyOrder, null);
    }

    public List<Term> getTermsByNameFromParent(String partialName, String ontologyID, boolean reverseKeyOrder, String childrenOf) {
        return this.getTermsByName(partialName, ontologyID, reverseKeyOrder, childrenOf);
    }

    private List<Term> getTermsByName(String partialName, String ontologyID, boolean reverseKeyOrder, String childrenOf) {
        if (partialName == null || partialName.isEmpty()) {
            return Collections.emptyList();
        }
        List<Term> resultTerms = this.searchByPartialTerm(partialName, ontologyID, childrenOf);
        if (reverseKeyOrder) {
            TreeSet newMap = new TreeSet(Collections.reverseOrder());
            newMap.addAll(resultTerms);
            resultTerms = new ArrayList(newMap);
        }
        return resultTerms;
    }

    public List<Term> getExactTermsByNameFromParent(String exactName, String ontologyId, String childrenOf) {
        return this.getExactTermsByName(exactName, ontologyId, childrenOf);
    }

    public List<Term> getExactTermsByName(String exactName, String ontologyId) {
        return this.getExactTermsByName(exactName, ontologyId, null);
    }

    public List<Term> getExactTermsByNameWithObsolete(String exactName, String ontologyId) {
        return this.getExactTermsByNameWithObsolete(exactName, ontologyId, null);
    }

    private List<Term> getExactTermsByName(String exactName, String ontologyId, String childrenOf) {
        if (exactName == null || exactName.isEmpty()) {
            return null;
        }
        return this.searchByExactTerm(exactName, ontologyId, childrenOf);
    }

    private List<Term> getExactTermsByNameWithObsolete(String exactName, String ontologyId, String childrenOf) {
        if (exactName == null || exactName.isEmpty()) {
            return null;
        }
        if (ontologyId == null || ontologyId.isEmpty()) {
            return this.searchByExactTermWithObsolete(exactName, null, childrenOf);
        }
        return this.searchByExactTermWithObsolete(exactName, ontologyId, childrenOf);
    }

    @Override
    public Term getExactTermByName(String exactName, String ontologyId) {
        if (exactName == null || exactName.isEmpty()) {
            return null;
        }
        List<Term> termResults = this.searchByExactTerm(exactName, ontologyId, null);
        if (termResults != null && !termResults.isEmpty()) {
            return termResults.get(0);
        }
        return null;
    }

    public List<Term> getExactTermsByIriString(String iri) {
        String customQueryField = new QueryFields.QueryFieldBuilder().setIri().build().toString();
        this.setQueryField(customQueryField);
        List<Term> terms = this.getExactTermsByName(iri, null);
        this.setQueryField(DEFAULT_QUERY_FIELD);
        return terms;
    }

    public List<Term> getExactTermsByIriStringWithObsolete(String iri) {
        String customQueryField = new QueryFields.QueryFieldBuilder().setIri().build().toString();
        this.setQueryField(customQueryField);
        List<Term> terms = this.getExactTermsByNameWithObsolete(iri, null);
        this.setQueryField(DEFAULT_QUERY_FIELD);
        return terms;
    }

    private List<Term> searchByPartialTerm(String partialName, String ontology, String childrenOf) throws RestClientException {
        return this.searchByTerm(partialName, ontology, false, childrenOf, false);
    }

    private List<Term> searchByExactTerm(String exactName, String ontologyId, String childrenOf) throws RestClientException {
        return this.searchByTerm(exactName, ontologyId, true, childrenOf, false);
    }

    private List<Term> searchByExactTermWithObsolete(String exactName, String ontologyId, String childrenOf) throws RestClientException {
        return this.searchByTerm(exactName, ontologyId, true, childrenOf, true);
    }

    private List<Term> searchByTerm(String termToSearch, String ontology, boolean exact, String childrenOf, boolean obsolete) throws RestClientException {
        ArrayList<Term> termResults = new ArrayList<Term>();
        ArrayList<SearchResult> terms = new ArrayList<SearchResult>();
        int pageSize = this.getSearchPageSize();
        if (pageSize <= 0) {
            pageSize = 100;
        }
        SearchQuery currentTermQuery = this.getSearchQuery(0, termToSearch, ontology, exact, childrenOf, obsolete, pageSize);
        int pageNum = this.getSearchPageNum();
        if (pageNum < 0) {
            pageNum = new Integer(currentTermQuery.getResponse().getNumFound() / pageSize);
        }
        if (currentTermQuery != null && currentTermQuery.getResponse() != null && currentTermQuery.getResponse().getSearchResults() != null) {
            terms.addAll(Arrays.asList(currentTermQuery.getResponse().getSearchResults()));
            if (currentTermQuery.getResponse().getSearchResults().length < currentTermQuery.getResponse().getNumFound()) {
                int start = 0;
                for (int i = 0; i < pageNum; ++i) {
                    SearchQuery termQuery = this.getSearchQuery(start += pageSize, termToSearch, ontology, exact, childrenOf, obsolete, pageSize);
                    if (termQuery == null || termQuery.getResponse() == null || termQuery.getResponse().getSearchResults() == null) continue;
                    if (termQuery.getResponse().getSearchResults().length == 0) break;
                    terms.addAll(Arrays.asList(termQuery.getResponse().getSearchResults()));
                }
            }
        }
        for (SearchResult term : terms) {
            if (term.getName() == null) continue;
            termResults.add(new Term(term.getIri(), term.getName(), term.getDescription(), term.getShortName(), term.getOboId(), term.getOntologyName(), term.getScore(), term.getOntologyIri(), term.getIsDefiningOntology(), term.getOboDefinitionCitation()));
        }
        return termResults;
    }

    public Term retrieveTerm(String id, String ontology) throws RestClientException {
        RetrieveTermQuery currentTermQuery = this.getRetrieveQuery(id, ontology);
        ArrayList<SearchResult> terms = new ArrayList<SearchResult>();
        if (currentTermQuery != null && currentTermQuery.getResponse() != null && currentTermQuery.getResponse().getSearchResults() != null) {
            terms.addAll(Arrays.asList(currentTermQuery.getResponse().getSearchResults()));
        }
        Term term = null;
        for (SearchResult term1 : terms) {
            if (term1.getName() == null) continue;
            if (term1.isObsolete()) {
                term = new ObsoleteTerm(term1.getIri(), term1.getName(), term1.getDescription(), term1.getShortName(), term1.getOboId(), term1.getOntologyName(), term1.getScore(), term1.getOntologyIri(), term1.getIsDefiningOntology(), term1.getOboDefinitionCitation(), term1.getAnnotation(), true, term1.getTermReplacedBy());
                continue;
            }
            term = new Term(term1.getIri(), term1.getName(), term1.getDescription(), term1.getShortName(), term1.getOboId(), term1.getOntologyName(), term1.getScore(), term1.getOntologyIri(), term1.getIsDefiningOntology(), term1.getOboDefinitionCitation(), term1.getAnnotation());
        }
        if (ontology != null && !ontology.isEmpty() && term != null && term.getOntologyName() != null && !term.getOntologyName().equalsIgnoreCase(ontology)) {
            return null;
        }
        return term;
    }

    public ObsoleteTerm retrieveObsoleteTerm(String id) throws RestClientException {
        RetrieveTermQuery currentTermQuery = this.getRetrieveQuery(id);
        ArrayList<SearchResult> terms = new ArrayList<SearchResult>();
        if (currentTermQuery != null && currentTermQuery.getResponse() != null && currentTermQuery.getResponse().getSearchResults() != null) {
            terms.addAll(Arrays.asList(currentTermQuery.getResponse().getSearchResults()));
        }
        Object term = null;
        for (SearchResult term1 : terms) {
            if (term1.getName() == null || !term1.isObsolete() || !term1.getIsDefiningOntology()) continue;
            return new ObsoleteTerm(term1.getIri(), term1.getName(), term1.getDescription(), term1.getShortName(), term1.getOboId(), term1.getOntologyName(), term1.getScore(), term1.getOntologyIri(), term1.getIsDefiningOntology(), term1.getOboDefinitionCitation(), term1.getAnnotation(), true, term1.getTermReplacedBy());
        }
        return null;
    }

    public boolean isObsolete(Term term) throws RestClientException {
        if (term == null || term.getIri() == null) {
            return false;
        }
        Term obsoleteTerm = this.retrieveTerm(term.getIri().getIdentifier(), term.getOntologyName());
        return obsoleteTerm != null && obsoleteTerm instanceof ObsoleteTerm;
    }

    public Term getReplacedBy(String termId, String ontology) {
        if (this.isObsolete(termId, ontology).booleanValue()) {
            Term term = this.retrieveTerm(termId, ontology);
            String termReplacedBy = ((ObsoleteTerm)term).getTermReplacedBy();
            if (termReplacedBy == null || termReplacedBy.isEmpty()) {
                return null;
            }
            return this.retrieveTerm(termReplacedBy, term.getOntologyName());
        }
        return null;
    }

    public Term getReplacedBy(String termId) {
        ObsoleteTerm term = this.retrieveObsoleteTerm(termId);
        String termReplacedBy = null;
        if (term != null) {
            termReplacedBy = term.getTermReplacedBy();
        }
        if (termReplacedBy == null || termReplacedBy.isEmpty()) {
            return null;
        }
        return this.retrieveTerm(termReplacedBy.trim(), term.getOntologyName());
    }

    private Term searchByExactTerm(String exactName, String ontologyId) throws RestClientException {
        SearchQuery currentTermQuery = this.getSearchQuery(0, exactName, ontologyId, true, null, false, 100);
        if (currentTermQuery.getResponse().getNumFound() != 0) {
            SearchResult termResult = Arrays.asList(currentTermQuery.getResponse().getSearchResults()).get(0);
            return new Term(termResult.getIri(), termResult.getName(), termResult.getDescription(), termResult.getShortName(), termResult.getOboId(), termResult.getOntologyName(), termResult.getScore(), termResult.getOntologyIri(), termResult.getIsDefiningOntology(), termResult.getOboDefinitionCitation());
        }
        return null;
    }

    public SearchQuery getSearchQuery(int page, String name, String ontology, boolean exactMatch, String childrenOf, boolean obsolete, int size) throws RestClientException {
        String query = String.format("q=%s&" + this.getQueryField() + "&rows=%s&start=%s&" + this.getFieldList(), name, size, page);
        if (ontology != null && !ontology.isEmpty()) {
            query = query + "&ontology=" + ontology;
        }
        if (exactMatch) {
            query = query + "&exact=true";
        }
        if (childrenOf != null && !childrenOf.isEmpty()) {
            query = query + "&childrenOf=" + childrenOf;
        }
        if (obsolete) {
            query = query + "&obsoletes=true";
        }
        this.logger.debug(query);
        URI uri = this.encodeURL("/api/search", query);
        return (SearchQuery)this.restTemplate.getForObject(uri, SearchQuery.class);
    }

    private RetrieveTermQuery getRetrieveQuery(String id, String ontology) throws RestClientException {
        if (ontology == null || ontology.isEmpty()) {
            throw new IllegalArgumentException("The term's ontology must not be null or empty!");
        }
        String iri = null;
        if (!id.contains("http") && !id.contains("/")) {
            iri = this.resolveIri(id);
        }
        if (iri == null) {
            iri = id;
        }
        String query = String.format("iri=%s", iri);
        this.logger.debug(query);
        URI uri = this.encodeURL("/api/ontologies/" + ontology + "/terms", query);
        return (RetrieveTermQuery)this.restTemplate.getForObject(uri, RetrieveTermQuery.class);
    }

    private RetrieveTermQuery getRetrieveQuery(String id) throws RestClientException {
        String query = String.format("id=%s", id);
        this.logger.debug(query);
        URI uri = this.encodeURL("/api/terms", query);
        return (RetrieveTermQuery)this.restTemplate.getForObject(uri, RetrieveTermQuery.class);
    }

    private String resolveIri(String id) throws RestClientException {
        RetrieveTermQuery currentTermQuery = this.getRetrieveQuery(id);
        ArrayList<SearchResult> terms = new ArrayList<SearchResult>();
        if (currentTermQuery != null && currentTermQuery.getResponse() != null && currentTermQuery.getResponse().getSearchResults() != null) {
            terms.addAll(Arrays.asList(currentTermQuery.getResponse().getSearchResults()));
        }
        for (SearchResult term : terms) {
            if (term.getName() == null) continue;
            return term.getIri().getIdentifier();
        }
        return null;
    }

    private List<Term> getTermChildrenMap(Href childrenHRef, int distance) {
        ArrayList<Term> children = new ArrayList<Term>();
        if (distance == 0) {
            return Collections.emptyList();
        }
        List<Term> childTerms = this.getTermChildren(childrenHRef, distance);
        children.addAll(childTerms);
        return children;
    }

    private List<Term> getTermParentsMap(Href parentsHRef, int distance) {
        ArrayList<Term> parents = new ArrayList<Term>();
        if (distance == 0) {
            return Collections.emptyList();
        }
        List<Term> parentTerms = this.getTermParents(parentsHRef, distance);
        parents.addAll(parentTerms);
        return parents;
    }

    private List<Term> getTermChildren(Href hrefChildren, int distance) {
        if (distance == 0) {
            return new ArrayList<Term>();
        }
        ArrayList<Term> childTerms = new ArrayList<Term>();
        childTerms.addAll(this.getTermQuery(hrefChildren));
        --distance;
        ArrayList<Term> currentChild = new ArrayList<Term>();
        for (Term child : childTerms) {
            currentChild.addAll(this.getTermChildren(child.getLink().getAllChildrenRef(), distance));
        }
        childTerms.addAll(currentChild);
        return childTerms;
    }

    private List<Term> getTermParents(Href hrefParents, int distance) {
        if (distance == 0) {
            return new ArrayList<Term>();
        }
        ArrayList<Term> parentTerms = new ArrayList<Term>();
        parentTerms.addAll(this.getTermQuery(hrefParents));
        --distance;
        ArrayList<Term> currentParent = new ArrayList<Term>();
        for (Term parent : parentTerms) {
            currentParent.addAll(this.getTermParents(parent.getLink().getAllParentsRef(), distance));
        }
        parentTerms.addAll(currentParent);
        return parentTerms;
    }

    private List<Term> getTermQuery(Href href) throws RestClientException {
        if (href == null) {
            return new ArrayList<Term>();
        }
        ArrayList<Term> terms = new ArrayList<Term>();
        try {
            String query = href.getHref();
            String url = URLDecoder.decode(query, "UTF-8");
            TermQuery termQuery = (TermQuery)this.restTemplate.getForObject(url, TermQuery.class, new Object[0]);
            if (termQuery != null && termQuery.getTerms() != null) {
                terms.addAll(Arrays.asList(termQuery.getTerms()));
            }
            if (termQuery != null && termQuery.getLink() != null && termQuery.getLink().next() != null) {
                terms.addAll(this.getTermQuery(termQuery.getLink().next()));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return terms;
    }

    public Boolean isObsolete(String termId, String ontologyID) throws RestClientException {
        Term term = this.retrieveTerm(termId, ontologyID);
        return this.isObsolete(term);
    }

    public Boolean isObsolete(String termId) throws RestClientException {
        ObsoleteTerm term = this.retrieveObsoleteTerm(termId);
        return term != null;
    }

    @Override
    public List<Term> getTermsByAnnotationData(String ontologyID, String annotationType, String strValue) {
        return Collections.emptyList();
    }

    @Override
    public List<Term> getTermsByAnnotationData(String ontologyID, String annotationType, double fromDblValue, double toDblValue) {
        List<Term> terms = this.getAllOBOTermsFromOntology(ontologyID);
        ArrayList<Term> termResult = new ArrayList<Term>();
        for (Term term : terms) {
            String termValue;
            if (term == null || term.getOboXRefs() == null || !term.containsXref(annotationType) || !NumberUtils.isNumber((String)(termValue = term.getXRefValue(annotationType))) || !(Double.parseDouble(termValue) >= fromDblValue) || !(Double.parseDouble(termValue) <= toDblValue)) continue;
            termResult.add(term);
        }
        return termResult;
    }

    @Override
    public Ontology getOntology(String ontologyId) throws RestClientException {
        URI uri = this.encodeURL("/api/ontologies/" + ontologyId, null);
        Ontology ontology = (Ontology)this.restTemplate.getForObject(uri, Ontology.class);
        if (ontology != null) {
            return ontology;
        }
        return null;
    }

    @Override
    public Set<String> getSynonyms(Identifier identifier, String ontology) throws RestClientException {
        HashSet<String> synonyms = new HashSet<String>();
        Term term = this.getTermById(identifier, ontology);
        if (term != null && term.getSynonyms() != null) {
            Collections.addAll(synonyms, term.getSynonyms());
        }
        return synonyms;
    }

    public Map getMetaData(Identifier identifier, String ontologyId) {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        Map synonym = this.getOBOSynonyms(identifier, ontologyId) == null ? Collections.emptyMap() : this.getOBOSynonyms(identifier, ontologyId);
        String definition = this.getFirstTermDescription(identifier, ontologyId);
        String comment = this.getComment(identifier, ontologyId);
        if (synonym != null && !synonym.isEmpty()) {
            metaData.put("synonym", synonym);
        }
        if (definition != null && !definition.isEmpty()) {
            metaData.put("definition", definition);
        }
        if (comment != null && !comment.isEmpty()) {
            metaData.put("comment", comment);
        }
        if (metaData.isEmpty()) {
            return new HashMap();
        }
        return metaData;
    }

    public String getComment(Identifier identifier, String ontologyId) {
        Map<String, List<String>> annotations = this.getAnnotations(identifier, ontologyId);
        if (!annotations.isEmpty() && annotations.keySet().contains("comment")) {
            return annotations.get("comment").get(0);
        }
        return null;
    }

    public String getFirstTermDescription(Identifier termId, String ontologyId) throws RestClientException {
        Term term = this.getTermById(termId, ontologyId);
        String description = null;
        if (term != null) {
            if (term.getDescription() != null) {
                description = term.getDescription()[0];
            } else if (term.getAnnotation() != null && term.getAnnotation().containsAnnotation("definition")) {
                description = term.getAnnotation().getAnnotation("definition").get(0);
            }
        }
        return description;
    }

    private Map<String, String> getOboDefinitionCitationXRef(Term term) {
        HashMap<String, String> xrefs = new HashMap<String, String>();
        for (OboDefinitionCitation citation : term.getOboDefinitionCitation()) {
            OBOXRef[] oboxRef;
            for (OBOXRef xref : oboxRef = citation.getOboXrefs()) {
                if (xref.getId() == null || xref.getId().isEmpty()) continue;
                if (xref.getDatabase() != null) {
                    xrefs.put("xref_definition_" + xref.getId(), xref.getDatabase() + ":" + xref.getId());
                    continue;
                }
                xrefs.put("xref_definition_" + xref.getId(), xref.getId());
            }
        }
        return xrefs;
    }

    private URI encodeURL(String path, String query) {
        try {
            String hostname = this.config.getHostName().split("/")[0];
            String hostnamePath = this.config.getHostName().split("/")[1];
            URI uri = new URI(this.config.getProtocol(), hostname, "/" + hostnamePath + path, query, null);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new RestClientException("The query could not be encoded");
        }
    }
}

