/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.utilities.ols.web.service.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Href;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Link {
    private Map<String, Href> links = new HashMap<String, Href>();

    @JsonAnyGetter
    public Map<String, Href> any() {
        return this.links;
    }

    @JsonAnySetter
    public void set(String name, Href value) {
        this.links.put(name, value);
    }

    public boolean hasUnknowProperties() {
        return !this.links.isEmpty();
    }

    public Href getChildrenRef() {
        if (this.links.containsKey(LinkOption.CHILDREN.getValue())) {
            return this.links.get(LinkOption.CHILDREN.getValue());
        }
        return null;
    }

    public Href getParentsRef() {
        if (this.links.containsKey(LinkOption.PARENTS.getValue())) {
            return this.links.get(LinkOption.PARENTS.getValue());
        }
        return null;
    }

    public Href getAllParentsRef() {
        if (this.links.containsKey(LinkOption.ALL_PARENTS.getValue())) {
            return this.links.get(LinkOption.ALL_PARENTS.getValue());
        }
        return null;
    }

    public Href getAllChildrenRef() {
        if (this.links.containsKey(LinkOption.ALL_CHILDREN.getValue())) {
            return this.links.get(LinkOption.ALL_CHILDREN.getValue());
        }
        return null;
    }

    public Href next() {
        if (this.links.containsKey(LinkOption.NEXT.getValue())) {
            return this.links.get(LinkOption.NEXT.getValue());
        }
        return null;
    }

    public Href previous() {
        if (this.links.containsKey(LinkOption.PREV.getValue())) {
            return this.links.get(LinkOption.PREV.getValue());
        }
        return null;
    }

    public static enum LinkOption {
        SELF("self"),
        PARENTS("parents"),
        ALL_PARENTS("hierarchicalParents"),
        ANCESTORS("ancestors"),
        CHILDREN("children"),
        ALL_CHILDREN("hierarchicalChildren"),
        DESCENDANTS("descendants"),
        GRAPH("graph"),
        NEXT("next"),
        LAST("last"),
        FIRST("first"),
        PREV("prev");

        private String value;

        private LinkOption(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return "LinkOption{value='" + this.value + '\'' + '}';
        }
    }
}

