/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.brucker.timstof;

import fr.profi.brucker.timstof.converter.SpectrumGeneratingMethod;
import fr.profi.brucker.timstof.io.TimstofReader;
import fr.profi.brucker.timstof.model.AbstractTimsFrame;
import fr.profi.brucker.timstof.model.MsMsCallbacks;
import fr.profi.brucker.timstof.model.PasefMsMsData;
import fr.profi.brucker.timstof.model.Precursor;
import fr.profi.brucker.timstof.model.Spectrum;
import fr.profi.brucker.timstof.model.TimsMSFrame;
import fr.profi.brucker.timstof.model.TimsPASEFFrame;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimsTofApp {
    static String MY_SAMPLE_DIR = "C:\\vero\\DEV\\TimsTof\\example_data\\200ngHela_compressed\\200ngHeLaPASEF_2min_compressed.d";
    private static Logger LOG = LoggerFactory.getLogger(TimsTofApp.class);

    public static void readSeqFrame(Long fileHdl, List<AbstractTimsFrame> frames) {
        TimstofReader reader = TimstofReader.getTimstofReader();
        ArrayList<TimsPASEFFrame> pasefFrames = new ArrayList<TimsPASEFFrame>();
        block4: for (AbstractTimsFrame fr : frames) {
            AbstractTimsFrame.ScanMode scanMode = fr.getScanMode();
            LOG.info(" Reading " + (Object)((Object)scanMode) + " Frame " + fr.getId() + ": peaks = " + fr.getNbrPeaks() + " at " + fr.getTime());
            AbstractTimsFrame.MsMsType msMsType = fr.getMsmsType();
            switch (msMsType) {
                case MS: {
                    LOG.info(" MS : BPC " + fr.getMaxIntensity() + " / TIC " + fr.getSummedIntensity());
                    if (pasefFrames.size() <= 0) continue block4;
                    reader.fillFramesWithMsMsInfo(fileHdl, pasefFrames);
                    LOG.info(" Read " + pasefFrames.size() + " since last MS Frame : ");
                    for (TimsPASEFFrame pasefFr : pasefFrames) {
                        for (PasefMsMsData msmsInfo : pasefFr.getPasefMsMSData()) {
                            LOG.info(" Pasef Frame " + msmsInfo.getFrameId() + " Precursor " + msmsInfo.getPrecursorId() + " Start Scan " + msmsInfo.getStartScan() + " EndScan " + msmsInfo.getEndScan());
                        }
                    }
                    pasefFrames.clear();
                    continue block4;
                }
                case PASEF: {
                    LOG.info(" PASEF : BPC " + fr.getMaxIntensity() + " / TIC " + fr.getSummedIntensity());
                    pasefFrames.add((TimsPASEFFrame)fr);
                    continue block4;
                }
            }
            LOG.info(" NOT Supported MSMS Type " + (Object)((Object)msMsType) + ": BPC " + fr.getMaxIntensity() + " / TIC " + fr.getSummedIntensity());
        }
    }

    public static void readMSFrameInfo(Long fileHdl, List<AbstractTimsFrame> frames) {
        List msFrame = frames.stream().filter(f -> f.getMsmsType().equals((Object)AbstractTimsFrame.MsMsType.MS)).collect(Collectors.toList());
        for (AbstractTimsFrame fr : msFrame) {
            LOG.info("\n Frame " + fr.getId() + "\tBPC: " + fr.getMaxIntensity() + "\tTIC: " + fr.getSummedIntensity() + " Time " + fr.getTime() / 60.0);
        }
    }

    public static void readMSMSDataFromPrecursors(Long fileHdl, int ms1Index) {
        TimstofReader reader = TimstofReader.getTimstofReader();
        List frame1Precs = reader.getPrecursorInfoById(fileHdl).values().stream().filter(p -> p.getParentMsFrame() == ms1Index).collect(Collectors.toList());
        long[] precIds = new long[frame1Precs.size()];
        for (int i = 0; i < frame1Precs.size(); ++i) {
            precIds[i] = ((Precursor)frame1Precs.get(i)).getId();
        }
        MsMsCallbacks.MultipleMsMsData msmsData = new MsMsCallbacks.MultipleMsMsData();
        long error_stat = reader.getTDFLib().tims_read_pasef_msms(fileHdl, precIds, precIds.length, msmsData);
        if (0L == error_stat) {
            LOG.error(" !!! could not get msms spectrum for precursor ids {}", (Object)precIds);
        }
        Map<Long, MsMsCallbacks.MsMsSpectrum> msmsSpectra = msmsData.getMsMsSpectra();
        for (Map.Entry<Long, MsMsCallbacks.MsMsSpectrum> e : msmsSpectra.entrySet()) {
            System.out.printf("msms data, precursor_id %d, number of peaks %d", e.getKey(), e.getValue().nbPeaks).println();
            System.out.println(Arrays.toString(e.getValue().mz_values));
            System.out.println(Arrays.toString(e.getValue().intensity_values));
        }
    }

    private static void cleanFrameData(List<AbstractTimsFrame> frames) {
        frames.forEach(AbstractTimsFrame::clearSpectraData);
    }

    public static void readFramesDataAndClean(Long fileHdl, List<AbstractTimsFrame> allFrames) {
        long start = System.currentTimeMillis();
        long stepClean = 0L;
        TimstofReader reader = TimstofReader.getTimstofReader();
        ArrayList<TimsPASEFFrame> pasefFrames = new ArrayList<TimsPASEFFrame>();
        allFrames.forEach(fr -> {
            if (fr.getMsmsType().equals((Object)AbstractTimsFrame.MsMsType.PASEF)) {
                pasefFrames.add((TimsPASEFFrame)fr);
            }
        });
        reader.fillFramesWithMsMsInfo(fileHdl, pasefFrames);
        long step1 = System.currentTimeMillis();
        LOG.info("End All frames fillFramesWithMsMsInfo: " + (step1 - start));
        List pMsMsFrame = ListUtils.partition(allFrames, (int)2000);
        for (List abstractTimsFrames : pMsMsFrame) {
            reader.fillFramesWithSpectrumData(fileHdl, abstractTimsFrames);
            long step1a = System.currentTimeMillis();
            TimsTofApp.cleanFrameData(abstractTimsFrames);
            long step1b = System.currentTimeMillis();
            stepClean += step1b - step1a;
        }
        long step2 = System.currentTimeMillis();
        LOG.info("End All frames fillFramesWithSpectrumData: " + (step2 - step1));
        LOG.info(" in which clean Frames Data: " + stepClean);
    }

    public static void readMSMSDataFromFrames(Long fileHdl, List<TimsPASEFFrame> msmsFrames) {
        long start = System.currentTimeMillis();
        TimstofReader reader = TimstofReader.getTimstofReader();
        reader.fillFramesWithMsMsInfo(fileHdl, msmsFrames);
        long step1 = System.currentTimeMillis();
        LOG.info("End MS2  fillFramesWithMsMsInfo: " + (step1 - start));
        reader.fillFramesWithSpectrumData(fileHdl, msmsFrames);
        long step2 = System.currentTimeMillis();
        LOG.info("End MS2  fillFramesWithSpectrumData: " + (step2 - step1));
        for (TimsPASEFFrame fr : msmsFrames) {
            List<PasefMsMsData> data = fr.getPasefMsMSData();
            LOG.debug("ms/ms data, frame {}, msmsType {}, number of peaks {}, number PASEF Fr {}", new Object[]{fr.getId(), fr.getMsmsType().getMsMsTypeCode(), fr.getNbrPeaks(), data.size()});
            data.forEach(pasefInfo -> {
                double isolMz = pasefInfo.getIsolationMz();
                Spectrum sp = pasefInfo.getPasefSpectrum();
                if (sp != null) {
                    double[] pasefmasses = sp.getMasses();
                    LOG.debug("\tINFOO\tPasefMsMS\t{}\tmz\t{}\tstart\t{}\tend\t{}\tmasses/intensities size\t{}", new Object[]{fr.getId(), isolMz, pasefInfo.getStartScan(), pasefInfo.getEndScan(), pasefmasses.length});
                    LOG.debug(Arrays.toString(pasefmasses));
                    LOG.debug(Arrays.toString(sp.getIntensities()));
                } else {
                    LOG.debug(" PasefMsMS mz {}, start {}, end {}, NO masses/intensities.", new Object[]{isolMz, pasefInfo.getStartScan(), pasefInfo.getEndScan()});
                }
            });
        }
        long end = System.currentTimeMillis();
        LOG.info("End gal MS2  readMSMSDataFromFrames " + (end - step2));
    }

    public static void readMSDataFromFrames(Long fileHdl, List<TimsMSFrame> msFrames) {
        long start = System.currentTimeMillis();
        TimstofReader reader = TimstofReader.getTimstofReader();
        reader.fillFramesWithSpectrumData(fileHdl, msFrames);
        long step2 = System.currentTimeMillis();
        LOG.info("End MS1  fillFramesWithSpectrumData: " + (step2 - start));
        long end = System.currentTimeMillis();
        LOG.info("End gal MS1  readMSDataFromFrames " + (end - step2));
    }

    private static void fillArrayFromSpectra(Spectrum sp, List<Double> masses, List<Float> intensities) {
        double[] spMasses = sp.getMasses();
        float[] spInten = sp.getIntensities();
        System.out.println(" peaks # " + spInten.length);
        for (int i = 0; i < spMasses.length; ++i) {
            masses.add(spMasses[i]);
            intensities.add(Float.valueOf(spInten[i]));
        }
    }

    public static void readPrecursorInfo(Long fileHdl) {
        TimstofReader reader = TimstofReader.getTimstofReader();
        ObjectCollection allPrec = reader.getPrecursorInfoById(fileHdl).values();
        Map<Integer, List<Precursor>> precByFrame = allPrec.stream().collect(Collectors.groupingBy(Precursor::getParentMsFrame));
        ArrayList<Integer> parentMsFr = new ArrayList<Integer>(precByFrame.keySet());
        parentMsFr.sort(Comparator.naturalOrder());
        for (Integer parentFrId : parentMsFr) {
            StringBuilder sb = new StringBuilder("\n In MS Frame ").append(parentFrId).append(": ");
            List<Precursor> framePrecs = precByFrame.get(parentFrId);
            for (Precursor p : framePrecs) {
                sb.append("\n - Precursor ").append(p.getId());
                sb.append(":\tcharge= ").append(p.getCharge());
                sb.append("\tintensity= ").append(p.getIntensity());
                sb.append("\tmobility(scan number)= ").append(p.getScanNumber());
            }
            LOG.info(sb.toString());
        }
    }

    public static void main(String[] argv) {
        String filePath = MY_SAMPLE_DIR;
        String cmd = "msmsFrame";
        if (argv != null && argv.length >= 2) {
            filePath = argv[0];
            cmd = argv[1];
        } else if (argv != null && argv.length == 1) {
            filePath = argv[0];
        }
        File f = new File(filePath);
        LOG.info("File  " + f.getAbsolutePath() + " exist " + f.exists());
        Long fileHdl = TimstofReader.getTimstofReader().openTimstofFile(f);
        switch (cmd) {
            case "seq": {
                List<AbstractTimsFrame> frames = TimstofReader.getTimstofReader().getTimsFrames(fileHdl);
                LOG.info(" END Read Frame Info ");
                TimsTofApp.readSeqFrame(fileHdl, frames);
                break;
            }
            case "ms": {
                List<AbstractTimsFrame> frames = TimstofReader.getTimstofReader().getTimsFrames(fileHdl);
                LOG.info(" END Read Frame Info ");
                TimsTofApp.readMSFrameInfo(fileHdl, frames);
                break;
            }
            case "precursor": {
                TimsTofApp.readPrecursorInfo(fileHdl);
                break;
            }
            case "msmsPrecursor": {
                TimsTofApp.readMSMSDataFromPrecursors(fileHdl, 1);
                break;
            }
            case "allFrames": {
                List<AbstractTimsFrame> frames = TimstofReader.getTimstofReader().getTimsFrames(fileHdl);
                LOG.info(" END Read Frame Info ");
                TimsTofApp.readFramesDataAndClean(fileHdl, frames);
                break;
            }
            case "msmsFrame": {
                List<AbstractTimsFrame> frames = TimstofReader.getTimstofReader().getTimsFrames(fileHdl);
                LOG.info(" END Read Frame Info ");
                ArrayList<TimsPASEFFrame> ms2Frames = new ArrayList<TimsPASEFFrame>();
                frames.forEach(fr -> {
                    if (fr.getMsmsType().equals((Object)AbstractTimsFrame.MsMsType.PASEF)) {
                        ms2Frames.add((TimsPASEFFrame)fr);
                    }
                });
                TimsTofApp.readMSMSDataFromFrames(fileHdl, ms2Frames);
                break;
            }
            case "msFrame": {
                List<AbstractTimsFrame> frames = TimstofReader.getTimstofReader().getTimsFrames(fileHdl);
                LOG.info(" END Read Frame Info ");
                ArrayList<TimsMSFrame> msFr = new ArrayList<TimsMSFrame>();
                frames.forEach(fr -> {
                    if (fr.getMsmsType().equals((Object)AbstractTimsFrame.MsMsType.MS)) {
                        msFr.add((TimsMSFrame)fr);
                    }
                });
                TimsTofApp.readMSDataFromFrames(fileHdl, msFr);
                break;
            }
            case "fullFrame": {
                TimstofReader.getTimstofReader().getFullTimsFrames(fileHdl);
                LOG.info(" END Read Full Frame Info ");
                break;
            }
            case "singleSpectrum": {
                List<AbstractTimsFrame> frames = TimstofReader.getTimstofReader().getTimsFrames(fileHdl);
                ArrayList<TimsMSFrame> msFrames = new ArrayList<TimsMSFrame>();
                frames.forEach(fr -> {
                    if (fr.getMsmsType().equals((Object)AbstractTimsFrame.MsMsType.MS)) {
                        msFrames.add((TimsMSFrame)fr);
                    }
                });
                TimsTofApp.readMSDataFromFrames(fileHdl, msFrames);
                for (TimsMSFrame tf : msFrames) {
                    tf.getSingleSpectrum(SpectrumGeneratingMethod.SMOOTH);
                }
                break;
            }
        }
    }
}

