/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam;

import fr.proline.core.orm.uds.Aggregation;
import fr.proline.core.orm.uds.FragmentationRule;
import fr.proline.core.orm.uds.FragmentationRuleSet;
import fr.proline.core.orm.uds.InstrumentConfiguration;
import fr.proline.core.orm.uds.PeaklistSoftware;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.SpectrumTitleParsingRule;
import fr.proline.core.orm.uds.UserAccount;
import fr.proline.module.seq.DatabaseAccess;
import fr.proline.repository.IDatabaseConnector;
import fr.proline.studio.Exceptions;
import fr.proline.studio.dam.tasks.data.ptm.PTMDataset;
import fr.proline.studio.dam.tasks.data.ptm.PTMDatasetPair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DatabaseDataManager {
    private static DatabaseDataManager m_singleton = null;
    private InstrumentConfiguration[] m_instruments;
    private FragmentationRuleSet[] m_fragmentationRuleSets;
    private FragmentationRule[] m_fragmentationRules;
    private PeaklistSoftware[] m_peaklistSoftwares;
    private UserAccount[] m_projectUsers;
    private UserAccount m_loggedUser;
    private String m_jdbcURL;
    private String m_jdbcDriver;
    private HashMap<Object, Object> m_serverConnectionProperties;
    private Project m_currentProject;
    private HashMap<Long, PTMDatasetPair> m_ptmDatasetSetPerDatasetId = new HashMap();
    private HashMap<Long, PTMDatasetPair> m_ptmAnnotatedDatasetSetPerDatasetId = new HashMap();
    private HashMap<Aggregation.ChildNature, Aggregation> m_aggregationMap = null;
    private Boolean m_checkDatabaseExists = null;

    private DatabaseDataManager() {
    }

    public static DatabaseDataManager getDatabaseDataManager() {
        if (m_singleton == null) {
            m_singleton = new DatabaseDataManager();
        }
        return m_singleton;
    }

    public void setServerConnectionProperties(HashMap<Object, Object> connProperties) {
        this.m_serverConnectionProperties = connProperties;
    }

    public void setIntruments(List<InstrumentConfiguration> l) {
        this.m_instruments = l.toArray(new InstrumentConfiguration[0]);
    }

    public InstrumentConfiguration[] getInstrumentsArray() {
        return this.m_instruments;
    }

    public InstrumentConfiguration[] getInstrumentsWithNullArray() {
        int length = this.m_instruments.length;
        InstrumentConfiguration[] instrumentsWithNull = new InstrumentConfiguration[length + 1];
        instrumentsWithNull[0] = null;
        System.arraycopy(this.m_instruments, 0, instrumentsWithNull, 1, length);
        return instrumentsWithNull;
    }

    public void setPeaklistSofwares(List<PeaklistSoftware> l) {
        this.m_peaklistSoftwares = l.toArray(new PeaklistSoftware[0]);
    }

    public PeaklistSoftware[] getPeaklistSoftwaresArray() {
        return this.m_peaklistSoftwares;
    }

    public void getParsingRules(HashSet<String> rawFileIdentifierSet, HashSet<String> firstCycleSet, HashSet<String> lastCycleSet, HashSet<String> firstScanSet, HashSet<String> lastScanSet, HashSet<String> firstTimeSet, HashSet<String> lastTimeSet) {
        for (PeaklistSoftware peaklistSoftware : this.m_peaklistSoftwares) {
            SpectrumTitleParsingRule parsingRule = peaklistSoftware.getSpecTitleParsingRule();
            String rule = parsingRule.getRawFileIdentifier();
            if (rule != null && !rule.isEmpty()) {
                rawFileIdentifierSet.add(rule);
            }
            if ((rule = parsingRule.getFirstCycle()) != null && !rule.isEmpty()) {
                firstCycleSet.add(rule);
            }
            if ((rule = parsingRule.getLastCycle()) != null && !rule.isEmpty()) {
                lastCycleSet.add(rule);
            }
            if ((rule = parsingRule.getFirstScan()) != null && !rule.isEmpty()) {
                firstScanSet.add(rule);
            }
            if ((rule = parsingRule.getLastScan()) != null && !rule.isEmpty()) {
                lastScanSet.add(rule);
            }
            if ((rule = parsingRule.getFirstTime()) != null && !rule.isEmpty()) {
                firstTimeSet.add(rule);
            }
            if ((rule = parsingRule.getLastTime()) == null || rule.isEmpty()) continue;
            lastTimeSet.add(rule);
        }
    }

    public PeaklistSoftware[] getPeaklistSoftwaresWithNullArray() {
        int length = this.m_peaklistSoftwares.length;
        PeaklistSoftware[] peaklistSoftwaresWithNull = new PeaklistSoftware[length + 1];
        peaklistSoftwaresWithNull[0] = null;
        System.arraycopy(this.m_peaklistSoftwares, 0, peaklistSoftwaresWithNull, 1, length);
        return peaklistSoftwaresWithNull;
    }

    public void setFragmentationRules(List<FragmentationRule> l) {
        this.m_fragmentationRules = l.toArray(new FragmentationRule[0]);
    }

    public FragmentationRule[] getFragmentationRulesArray() {
        return this.m_fragmentationRules;
    }

    public void setFragmentationRuleSets(List<FragmentationRuleSet> l) {
        this.m_fragmentationRuleSets = l.toArray(new FragmentationRuleSet[0]);
    }

    public FragmentationRuleSet[] getFragmentationRuleSetsArray() {
        return this.m_fragmentationRuleSets;
    }

    public FragmentationRuleSet[] getFragmentationRuleSetsWithNullArray() {
        int length = this.m_fragmentationRuleSets.length;
        FragmentationRuleSet[] fragRuleSetsWithNull = new FragmentationRuleSet[length + 1];
        fragRuleSetsWithNull[0] = null;
        System.arraycopy(this.m_fragmentationRuleSets, 0, fragRuleSetsWithNull, 1, length);
        return fragRuleSetsWithNull;
    }

    public FragmentationRuleSet getFragmentationRuleSet(Long frsId) {
        if (frsId == null) {
            return null;
        }
        for (FragmentationRuleSet frs : this.m_fragmentationRuleSets) {
            if (frs.getId() != frsId.longValue()) continue;
            return frs;
        }
        return null;
    }

    public void setAggregationList(List<Aggregation> l) {
        this.m_aggregationMap = new HashMap();
        for (Aggregation aggregation : l) {
            this.m_aggregationMap.put(aggregation.getChildNature(), aggregation);
        }
    }

    public Aggregation getAggregation(Aggregation.ChildNature childNature) {
        return this.m_aggregationMap.get(childNature);
    }

    public void setProjectUsers(List<UserAccount> l) {
        this.m_projectUsers = l.toArray(new UserAccount[0]);
    }

    public UserAccount[] getProjectUsersArray() {
        return this.m_projectUsers;
    }

    public void setCurrentProject(Project currentProject) {
        if (currentProject == null || !currentProject.equals(this.m_currentProject)) {
            this.m_currentProject = currentProject;
            this.m_ptmDatasetSetPerDatasetId.clear();
        }
    }

    public Project getCurrentProject() {
        return this.m_currentProject;
    }

    public void addLoadedPTMDatasetSet(PTMDatasetPair ptmDSSet) {
        this.m_ptmDatasetSetPerDatasetId.put(ptmDSSet.getDataset().getId(), ptmDSSet);
    }

    public PTMDataset getClustersPTMDatasetForDS(Long dsId) {
        if (this.m_ptmDatasetSetPerDatasetId.containsKey(dsId)) {
            return this.m_ptmDatasetSetPerDatasetId.get(dsId).getClusterPTMDataset();
        }
        return null;
    }

    public PTMDataset getSitesPTMDatasetForDS(Long dsId) {
        if (this.m_ptmDatasetSetPerDatasetId.containsKey(dsId)) {
            return this.m_ptmDatasetSetPerDatasetId.get(dsId).getSitePTMDataset();
        }
        return null;
    }

    public void removeAllPTMDatasetsForDS(Long dsId) {
        if (this.m_ptmDatasetSetPerDatasetId.containsKey(dsId)) {
            this.m_ptmDatasetSetPerDatasetId.remove(dsId);
        }
        if (this.m_ptmAnnotatedDatasetSetPerDatasetId.containsKey(dsId)) {
            this.m_ptmAnnotatedDatasetSetPerDatasetId.remove(dsId);
        }
    }

    public void removeAnnotatedPTMDatasetsForDS(Long dsId) {
        if (this.m_ptmAnnotatedDatasetSetPerDatasetId.containsKey(dsId)) {
            this.m_ptmAnnotatedDatasetSetPerDatasetId.remove(dsId);
        }
    }

    public PTMDatasetPair getPTMDatasetSetForDS(Long dsId) {
        return this.m_ptmDatasetSetPerDatasetId.get(dsId);
    }

    public void addLoadedAnnotatedPTMDatasetSet(PTMDatasetPair ptmDSSet) {
        this.m_ptmAnnotatedDatasetSetPerDatasetId.put(ptmDSSet.getDataset().getId(), ptmDSSet);
    }

    public PTMDataset getAnnotatedClustersPTMDatasetForDS(Long dsId) {
        if (this.m_ptmAnnotatedDatasetSetPerDatasetId.containsKey(dsId)) {
            return this.m_ptmAnnotatedDatasetSetPerDatasetId.get(dsId).getClusterPTMDataset();
        }
        return null;
    }

    public PTMDataset getAnnotatedSitesPTMDatasetForDS(Long dsId) {
        if (this.m_ptmAnnotatedDatasetSetPerDatasetId.containsKey(dsId)) {
            return this.m_ptmAnnotatedDatasetSetPerDatasetId.get(dsId).getSitePTMDataset();
        }
        return null;
    }

    public PTMDatasetPair getAnnotatedPTMDatasetSetForDS(Long dsId) {
        return this.m_ptmAnnotatedDatasetSetPerDatasetId.get(dsId);
    }

    public void setLoggedUser(UserAccount loggedUser) {
        this.m_loggedUser = loggedUser;
    }

    public UserAccount getLoggedUser() {
        return this.m_loggedUser;
    }

    public String getLoggedUserName() {
        return this.m_loggedUser.getLogin();
    }

    public boolean ownProject(Project p) {
        if (p == null) {
            return false;
        }
        return p.getOwner().getId() == this.m_loggedUser.getId();
    }

    public void setUdsJdbcDriver(String jdbcDriver) {
        this.m_jdbcDriver = jdbcDriver;
    }

    public String getUdsJdbcDriver() {
        return this.m_jdbcDriver;
    }

    public void setUdsJdbcURL(String jdbcURL) {
        this.m_jdbcURL = jdbcURL;
    }

    public String getUdsJdbcURL() {
        return this.m_jdbcURL;
    }

    public boolean isSeqDatabaseExists() {
        if (this.m_checkDatabaseExists == null) {
            try {
                IDatabaseConnector seqDatabaseConnector = this.m_serverConnectionProperties != null && !this.m_serverConnectionProperties.isEmpty() ? DatabaseAccess.getSEQDatabaseConnector((boolean)false, this.m_serverConnectionProperties) : DatabaseAccess.getSEQDatabaseConnector((boolean)false);
                this.m_checkDatabaseExists = seqDatabaseConnector == null ? Boolean.FALSE : Boolean.TRUE;
            }
            catch (Throwable e) {
                this.m_checkDatabaseExists = Boolean.FALSE;
            }
        }
        return this.m_checkDatabaseExists;
    }

    public static boolean isAdmin(UserAccount userAccount) {
        boolean isAdmin = false;
        try {
            String userGroup;
            Map map = userAccount.getSerializedPropertiesAsMap();
            if (map != null && (userGroup = (String)map.get("user_group")) != null) {
                isAdmin = userGroup.compareTo(UserAccount.UserGroupType.ADMIN.name()) == 0;
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return isAdmin;
    }
}

