/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.data;

import fr.proline.core.orm.uds.Project;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.AllImportedData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import java.util.List;

public class ProjectIdentificationData
extends AbstractData {
    private Project m_project = null;
    private String m_temporaryName = null;

    public ProjectIdentificationData(Project project) {
        this.m_dataType = AbstractData.DataTypes.PROJECT_IDENTIFICATION;
        this.m_project = project;
    }

    public ProjectIdentificationData(String temporaryName) {
        this.m_dataType = AbstractData.DataTypes.PROJECT_IDENTIFICATION;
        this.m_temporaryName = temporaryName;
    }

    @Override
    public String getName() {
        if (this.m_project != null) {
            return this.m_project.getName();
        }
        if (this.m_temporaryName != null) {
            return this.m_temporaryName;
        }
        return "";
    }

    public void setProject(Project project) {
        this.m_project = project;
        this.m_temporaryName = null;
    }

    public Project getProject() {
        return this.m_project;
    }

    @Override
    public void load(AbstractDatabaseCallback callback, List<AbstractData> list, AbstractDatabaseTask.Priority priority, boolean identificationDataset) {
        list.add(new AllImportedData());
        DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
        task.initLoadParentDataset(this.m_project, list, true);
        if (priority != null) {
            task.setPriority(priority);
        }
        AccessDatabaseThread.getAccessDatabaseThread().addTask(task);
    }
}

