/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.uds.FragmentationRule;
import fr.proline.core.orm.uds.FragmentationRuleSet;
import fr.proline.core.orm.uds.PeaklistSoftware;
import fr.proline.core.orm.uds.SpectrumTitleParsingRule;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public class DatabaseAdminTask
extends AbstractDatabaseTask {
    private long m_peaklistSoftwareId = -1L;
    private String m_name;
    private String m_version;
    private SpectrumTitleParsingRule m_spectrumTitleParsingRule = null;
    private List<FragmentationRule> m_fragmentationRules = null;
    private int m_action;
    private static final int ADD_PEAKLIST_SOFTWARE = 0;
    private static final int MODIFY_PEAKLIST_SOFTWARE = 1;
    private static final int ADD_FRAGMENTATION_RULE_SET = 2;

    public DatabaseAdminTask(AbstractDatabaseCallback callback) {
        super(callback, null);
    }

    public void initAddPeakListSoftware(String name, String version, SpectrumTitleParsingRule spectrumTitleParsingRule) {
        this.setTaskInfo(new TaskInfo(" Add PeakList Software " + name, false, "Database Access", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_name = name;
        this.m_version = version;
        this.m_spectrumTitleParsingRule = spectrumTitleParsingRule;
        this.m_action = 0;
    }

    public void initModifyPeakListSoftware(long id, String name, String version) {
        this.setTaskInfo(new TaskInfo(" Modify PeakList Software " + name, false, "Database Access", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_peaklistSoftwareId = id;
        this.m_name = name;
        this.m_version = version;
        this.m_action = 1;
    }

    public void initAddFragmentationRuleSet(String name, List<FragmentationRule> fragmentationRules) {
        this.setTaskInfo(new TaskInfo(" Add Fragmentation Rule Set " + name, false, "Database Access", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_name = name;
        this.m_fragmentationRules = fragmentationRules;
        this.m_action = 2;
    }

    @Override
    public boolean needToFetch() {
        return true;
    }

    @Override
    public boolean fetchData() {
        switch (this.m_action) {
            case 0: {
                return this.addPeaklistSoftware();
            }
            case 1: {
                return this.modifyPeaklistSoftware();
            }
            case 2: {
                return this.addFragmentationRuleSet();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFragmentationRuleSet() {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            FragmentationRuleSet frs = new FragmentationRuleSet();
            frs.setName(this.m_name);
            frs.setFragmentationRules(new HashSet<FragmentationRule>(this.m_fragmentationRules));
            entityManagerUDS.persist((Object)frs);
            this.reloadFragmentationRuleSets(entityManagerUDS);
            entityManagerUDS.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPeaklistSoftware() {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            entityManagerUDS.persist((Object)this.m_spectrumTitleParsingRule);
            PeaklistSoftware peaklistSoftware = new PeaklistSoftware();
            peaklistSoftware.setName(this.m_name);
            peaklistSoftware.setVersion(this.m_version);
            peaklistSoftware.setSpecTitleParsingRule(this.m_spectrumTitleParsingRule);
            entityManagerUDS.persist((Object)peaklistSoftware);
            this.reloadPeakListSoftwares(entityManagerUDS);
            entityManagerUDS.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifyPeaklistSoftware() {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            PeaklistSoftware peaklistSoftware = (PeaklistSoftware)entityManagerUDS.find(PeaklistSoftware.class, (Object)this.m_peaklistSoftwareId);
            peaklistSoftware.setName(this.m_name);
            peaklistSoftware.setVersion(this.m_version);
            this.reloadPeakListSoftwares(entityManagerUDS);
            entityManagerUDS.getTransaction().commit();
        }
        return true;
    }

    private void reloadPeakListSoftwares(EntityManager entityManagerUDS) {
        TypedQuery peaklistSoftwareQuery = entityManagerUDS.createQuery("SELECT p FROM fr.proline.core.orm.uds.PeaklistSoftware p ORDER BY p.name ASC", PeaklistSoftware.class);
        List peaklistSoftwareList = peaklistSoftwareQuery.getResultList();
        DatabaseDataManager.getDatabaseDataManager().setPeaklistSofwares(peaklistSoftwareList);
    }

    private void reloadFragmentationRuleSets(EntityManager entityManagerUDS) {
        TypedQuery fragRuleSetQuery = entityManagerUDS.createQuery("SELECT frs FROM fr.proline.core.orm.uds.FragmentationRuleSet frs ORDER BY frs.name ASC", FragmentationRuleSet.class);
        List frsList = fragRuleSetQuery.getResultList();
        frsList.stream().forEach(frs -> frs.getFragmentationRules().stream().forEach(fr -> fr.getDescription()));
        DatabaseDataManager.getDatabaseDataManager().setFragmentationRuleSets(frsList);
    }
}

