/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.uds.Aggregation;
import fr.proline.core.orm.uds.FragmentationRule;
import fr.proline.core.orm.uds.FragmentationRuleSet;
import fr.proline.core.orm.uds.InstrumentConfiguration;
import fr.proline.core.orm.uds.PeaklistSoftware;
import fr.proline.core.orm.uds.UserAccount;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.repository.DatabaseConnectorFactory;
import fr.proline.repository.IDatabaseConnector;
import fr.proline.repository.ProlineDatabaseType;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public class DatabaseConnectionTask
extends AbstractDatabaseTask {
    private Map<Object, Object> m_databaseProperties;
    private String m_projectUser;
    private int m_projectId;
    public static int ERROR_USER_UNKNOWN = 1;
    private int action;
    private static int UDS_CONNECTION = 0;
    private static int MSI_CONNECTION = 1;
    private static int UDS_USER_TEST = 4;

    public DatabaseConnectionTask(AbstractDatabaseCallback callback) {
        super(callback, null);
    }

    public void initConnectionToUDS(Map<Object, Object> databaseProperties, String projectUser) {
        this.setTaskInfo(new TaskInfo("Connection to UDS Database", false, "Database Access", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.setPriority(AbstractDatabaseTask.Priority.TOP);
        this.m_databaseProperties = databaseProperties;
        this.m_projectUser = projectUser;
        this.action = UDS_CONNECTION;
    }

    public void initConnectionToMSI(int projectId) {
        this.setTaskInfo(new TaskInfo("Connection to MSI Database", false, "Database Access", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.setPriority(AbstractDatabaseTask.Priority.TOP);
        this.m_projectId = projectId;
        this.action = MSI_CONNECTION;
    }

    public void initCheckProjectUser(String projectUser) {
        this.setTaskInfo(new TaskInfo("Check Project User", false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.setPriority(AbstractDatabaseTask.Priority.TOP);
        this.m_projectUser = projectUser;
        this.action = UDS_USER_TEST;
    }

    @Override
    public boolean needToFetch() {
        return true;
    }

    @Override
    public boolean fetchData() {
        if (this.action == UDS_CONNECTION) {
            try {
                IDatabaseConnector udsConn = DatabaseConnectorFactory.createDatabaseConnectorInstance((ProlineDatabaseType)ProlineDatabaseType.UDS, this.m_databaseProperties);
                DStoreCustomPoolConnectorFactory.getInstance().initialize(udsConn, "Proline STUDIO");
            }
            catch (Exception e) {
                m_logger.error(this.getClass().getSimpleName() + " failed", (Throwable)e);
                this.m_taskError = new TaskError(e.getMessage());
                DStoreCustomPoolConnectorFactory.getInstance().closeAll();
                return false;
            }
            EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();
            try {
                entityManagerUDS.getTransaction().begin();
                TypedQuery userQuery = entityManagerUDS.createQuery("SELECT user FROM fr.proline.core.orm.uds.UserAccount user ORDER BY user.login ASC", UserAccount.class);
                List userList = userQuery.getResultList();
                DatabaseDataManager.getDatabaseDataManager().setProjectUsers(userList);
                entityManagerUDS.getTransaction().commit();
            }
            catch (Exception e) {
                this.m_taskError = new TaskError("Unable to load UserAccount from UDS");
                m_logger.error(this.getClass().getSimpleName() + " failed", (Throwable)e);
                entityManagerUDS.getTransaction().rollback();
                DStoreCustomPoolConnectorFactory.getInstance().closeAll();
                return false;
            }
            if (!this.checkProjectUser()) {
                return false;
            }
            if (!this.loadUDSData(entityManagerUDS)) {
                return false;
            }
            entityManagerUDS.close();
            String udsJdbcDriver = (String)this.m_databaseProperties.get("javax.persistence.jdbc.driver");
            String udsJdbcUrl = (String)this.m_databaseProperties.get("javax.persistence.jdbc.url");
            DatabaseDataManager.getDatabaseDataManager().setUdsJdbcDriver(udsJdbcDriver);
            DatabaseDataManager.getDatabaseDataManager().setUdsJdbcURL(udsJdbcUrl);
        } else if (this.action == UDS_USER_TEST) {
            if (!this.checkProjectUser()) {
                return false;
            }
            EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();
            if (!this.loadUDSData(entityManagerUDS)) {
                return false;
            }
        } else if (this.action == MSI_CONNECTION) {
            try {
                EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector((long)this.m_projectId).createEntityManager();
                entityManagerMSI.close();
            }
            catch (Exception e) {
                m_logger.error(this.getClass().getSimpleName() + " failed", (Throwable)e);
                this.m_taskError = new TaskError(e);
                return false;
            }
        }
        return true;
    }

    private boolean checkProjectUser() {
        DatabaseDataManager udsMgr = DatabaseDataManager.getDatabaseDataManager();
        boolean foundUser = false;
        for (UserAccount account : udsMgr.getProjectUsersArray()) {
            if (this.m_projectUser.compareToIgnoreCase(account.getLogin()) != 0) continue;
            udsMgr.setLoggedUser(account);
            foundUser = true;
            break;
        }
        if (!foundUser) {
            this.m_taskError = new TaskError("Project User " + this.m_projectUser + " is unknown");
            this.m_errorId = ERROR_USER_UNKNOWN;
            return false;
        }
        return true;
    }

    private boolean loadUDSData(EntityManager entityManagerUDS) {
        try {
            entityManagerUDS.getTransaction().begin();
            TypedQuery instrumentQuery = entityManagerUDS.createQuery("SELECT i FROM fr.proline.core.orm.uds.InstrumentConfiguration i ORDER BY i.name ASC", InstrumentConfiguration.class);
            List instrumentList = instrumentQuery.getResultList();
            DatabaseDataManager.getDatabaseDataManager().setIntruments(instrumentList);
            entityManagerUDS.getTransaction().commit();
        }
        catch (Exception e) {
            this.m_taskError = new TaskError("Unable to load Instrument Configurations from UDS");
            m_logger.error(this.getClass().getSimpleName() + " failed", (Throwable)e);
            entityManagerUDS.getTransaction().rollback();
            DStoreCustomPoolConnectorFactory.getInstance().closeAll();
            return false;
        }
        try {
            entityManagerUDS.getTransaction().begin();
            TypedQuery fragRulesQuery = entityManagerUDS.createQuery("SELECT fr FROM fr.proline.core.orm.uds.FragmentationRule fr ORDER BY fr.id ASC", FragmentationRule.class);
            List frList = fragRulesQuery.getResultList();
            DatabaseDataManager.getDatabaseDataManager().setFragmentationRules(frList);
            entityManagerUDS.getTransaction().commit();
        }
        catch (Exception e) {
            this.m_taskError = new TaskError("Unable to load FragmentationRule Configurations from UDS");
            m_logger.error(this.getClass().getSimpleName() + " failed", (Throwable)e);
            entityManagerUDS.getTransaction().rollback();
            DStoreCustomPoolConnectorFactory.getInstance().closeAll();
            return false;
        }
        try {
            entityManagerUDS.getTransaction().begin();
            TypedQuery fragRuleSetsQuery = entityManagerUDS.createQuery("SELECT frs FROM fr.proline.core.orm.uds.FragmentationRuleSet frs ORDER BY frs.name ASC", FragmentationRuleSet.class);
            List frsList = fragRuleSetsQuery.getResultList();
            frsList.stream().forEach(frs -> frs.getFragmentationRules().stream().forEach(fr -> fr.getDescription()));
            DatabaseDataManager.getDatabaseDataManager().setFragmentationRuleSets(frsList);
            entityManagerUDS.getTransaction().commit();
        }
        catch (Exception e) {
            this.m_taskError = new TaskError("Unable to load FragmentationRuleSet Configurations from UDS");
            m_logger.error(this.getClass().getSimpleName() + " failed", (Throwable)e);
            entityManagerUDS.getTransaction().rollback();
            DStoreCustomPoolConnectorFactory.getInstance().closeAll();
            return false;
        }
        try {
            entityManagerUDS.getTransaction().begin();
            TypedQuery peaklistSoftwareQuery = entityManagerUDS.createQuery("SELECT p FROM fr.proline.core.orm.uds.PeaklistSoftware p ORDER BY p.name ASC", PeaklistSoftware.class);
            List peaklistSoftwareList = peaklistSoftwareQuery.getResultList();
            DatabaseDataManager.getDatabaseDataManager().setPeaklistSofwares(peaklistSoftwareList);
            entityManagerUDS.getTransaction().commit();
        }
        catch (Exception e) {
            this.m_taskError = new TaskError("Unable to load Peaklist Softwares from UDS");
            m_logger.error(this.getClass().getSimpleName() + " failed", (Throwable)e);
            entityManagerUDS.getTransaction().rollback();
            DStoreCustomPoolConnectorFactory.getInstance().closeAll();
            return false;
        }
        try {
            entityManagerUDS.getTransaction().begin();
            TypedQuery aggregationQuery = entityManagerUDS.createQuery("SELECT a FROM fr.proline.core.orm.uds.Aggregation a", Aggregation.class);
            List aggregationList = aggregationQuery.getResultList();
            DatabaseDataManager.getDatabaseDataManager().setAggregationList(aggregationList);
            entityManagerUDS.getTransaction().commit();
        }
        catch (Exception e) {
            this.m_taskError = new TaskError("Unable to load Datasets from UDS");
            m_logger.error(this.getClass().getSimpleName() + " failed", (Throwable)e);
            entityManagerUDS.getTransaction().rollback();
            DStoreCustomPoolConnectorFactory.getInstance().closeAll();
            return false;
        }
        return true;
    }
}

