/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideInstance;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.SequenceMatch;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptideSet;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.msi.dto.DSpectrum;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.studio.dam.memory.TransientMemoryCacheManager;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseSlicerTask;
import fr.proline.studio.dam.tasks.DatabaseLoadPeptideMatchTask;
import fr.proline.studio.dam.tasks.DatabasePTMsTask;
import fr.proline.studio.dam.tasks.SubTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class DatabaseLoadPeptidesInstancesTask
extends AbstractDatabaseSlicerTask {
    private final int m_action;
    private static final int LOAD_PEPTIDE_INSTANCE_FOR_PROTEIN_MATCH = 0;
    private static final int LOAD_PEPTIDE_INSTANCES_FOR_RSM = 1;
    private static final int SLICE_SIZE = 1000;
    public static final int SUB_TASK_PTM_DATA = 0;
    public static final int SUB_TASK_PROTEINSET_NAME_LIST = 1;
    public static final int SUB_TASK_MSQUERY = 2;
    public static final int SUB_TASK_SRC_DAT_FILE = 3;
    public static final int SUB_TASK_COUNT = 4;
    private long m_projectId;
    private DProteinMatch m_proteinMatch = null;
    private ArrayList<DProteinMatch> m_proteinMatchArray = null;
    private ArrayList<ResultSummary> m_rsmList = null;
    private ResultSummary m_rsm = null;
    private ArrayList<Long> m_peptideMatchIds = null;
    private HashMap<Long, DPeptideMatch> m_peptideMatchMap = null;
    private ArrayList<Long> m_peptideIds = null;
    private HashMap<Long, Peptide> m_peptideMap = null;

    public DatabaseLoadPeptidesInstancesTask(AbstractDatabaseCallback callback, long projectId, DProteinMatch proteinMatch, ArrayList<ResultSummary> rsmList) {
        super(callback, 4, new TaskInfo("Load Peptide Sets for Protein Match " + proteinMatch.getAccession(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_projectId = projectId;
        this.m_proteinMatch = proteinMatch;
        this.m_proteinMatchArray = null;
        this.m_rsmList = rsmList;
        this.m_action = 0;
    }

    public DatabaseLoadPeptidesInstancesTask(AbstractDatabaseCallback callback, long projectId, ArrayList<DProteinMatch> proteinMatchArray, ArrayList<ResultSummary> rsmList) {
        super(callback, 4, new TaskInfo("Load Peptide Sets for multiple Protein Matches", false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_projectId = projectId;
        this.m_proteinMatch = null;
        this.m_proteinMatchArray = proteinMatchArray;
        this.m_rsmList = rsmList;
        this.m_action = 0;
    }

    public DatabaseLoadPeptidesInstancesTask(AbstractDatabaseCallback callback, long projectId, ResultSummary rsm) {
        super(callback, 4, new TaskInfo("Load Peptides for Identification Summary " + rsm.getId(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_rsm = rsm;
        this.m_action = 1;
    }

    @Override
    public boolean needToFetch() {
        switch (this.m_action) {
            case 0: {
                int size = this.m_rsmList.size();
                for (int i = 0; i < size; ++i) {
                    DProteinMatch pm;
                    ResultSummary rsm = this.m_rsmList.get(i);
                    DProteinMatch dProteinMatch = pm = this.m_proteinMatchArray != null ? this.m_proteinMatchArray.get(i) : this.m_proteinMatch;
                    if (!this.needToFetch(pm, rsm)) continue;
                    return true;
                }
                return false;
            }
            case 1: {
                return this.m_rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getPeptideInstanceArray() == null;
            }
        }
        return false;
    }

    private boolean needToFetch(DProteinMatch proteinMatch, ResultSummary rsm) {
        if (proteinMatch == null) {
            return false;
        }
        DPeptideSet peptideSet = proteinMatch.getPeptideSet(Long.valueOf(rsm.getId()));
        if (peptideSet == null) {
            return true;
        }
        return peptideSet.getPeptideInstances() == null;
    }

    @Override
    public boolean fetchData() {
        if (this.needToFetch()) {
            switch (this.m_action) {
                case 0: {
                    return this.fetchDataForProteinMatch();
                }
                case 1: {
                    return this.fetchDataForRsm();
                }
            }
            return false;
        }
        return this.fetchDataSubTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataSubTask() {
        SubTask subTask = this.m_subTaskManager.getNextSubTask();
        if (subTask == null) {
            return true;
        }
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            switch (subTask.getSubTaskId()) {
                case 0: {
                    this.fetchPTMData(entityManagerMSI, subTask);
                    break;
                }
                case 1: {
                    this.fetchProteinSetName(entityManagerMSI, subTask);
                    break;
                }
                case 2: {
                    DatabaseLoadPeptideMatchTask.fetchMsQuery(entityManagerMSI, subTask, this.m_peptideMatchIds, this.m_peptideMatchMap);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataForRsm() {
        this.m_peptideMap = new HashMap();
        this.m_peptideIds = new ArrayList();
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            boolean mergedData;
            entityManagerMSI.getTransaction().begin();
            ArrayList<PeptideInstance> peptideInstanceList = new ArrayList<PeptideInstance>();
            Query peptideInstancesQuery = entityManagerMSI.createQuery("SELECT pi, pm.id, pm.rank, pm.charge, pm.deltaMoz, pm.experimentalMoz, pm.missedCleavage, pm.score, pm.resultSet.id, p, pm.cdPrettyRank, pm.sdPrettyRank, sp.firstTime, pm.serializedProperties FROM fr.proline.core.orm.msi.PeptideInstance pi, fr.proline.core.orm.msi.PeptideMatch pm, fr.proline.core.orm.msi.Peptide p, fr.proline.core.orm.msi.MsQuery ms, fr.proline.core.orm.msi.Spectrum sp  WHERE pi.resultSummary.id=:rsmId AND pi.bestPeptideMatchId=pm.id AND pm.peptideId=p.id AND pm.msQuery=ms AND ms.spectrum=sp ORDER BY pm.score DESC");
            peptideInstancesQuery.setParameter("rsmId", (Object)this.m_rsm.getId());
            List l = peptideInstancesQuery.getResultList();
            this.m_peptideMatchIds = new ArrayList(l.size());
            this.m_peptideMatchMap = new HashMap();
            for (Object[] resCur : l) {
                PeptideInstance pi = (PeptideInstance)resCur[0];
                Long pmId = (Long)resCur[1];
                Integer pmRank = (Integer)resCur[2];
                Integer pmCharge = (Integer)resCur[3];
                Float pmDeltaMoz = (Float)resCur[4];
                Double pmExperimentalMoz = (Double)resCur[5];
                Integer pmMissedCleavage = (Integer)resCur[6];
                Float pmScore = (Float)resCur[7];
                Long pmResultSetId = (Long)resCur[8];
                Integer pmCdPrettyRank = (Integer)resCur[10];
                Integer pmSdPrettyRank = (Integer)resCur[11];
                Float firstTime = (Float)resCur[12];
                String pmSerializedProp = (String)resCur[13];
                DPeptideMatch pm = new DPeptideMatch(pmId.longValue(), pmRank, pmCharge.intValue(), pmDeltaMoz, pmExperimentalMoz.doubleValue(), pmMissedCleavage.intValue(), pmScore, pmResultSetId.longValue(), pmCdPrettyRank, pmSdPrettyRank, pmSerializedProp);
                pm.setRetentionTime(firstTime);
                this.m_peptideMatchIds.add(pmId);
                this.m_peptideMatchMap.put(pmId, pm);
                Peptide p = (Peptide)resCur[9];
                p.getTransientData().setPeptideReadablePtmStringLoaded();
                this.m_peptideMap.put(p.getId(), p);
                this.m_peptideIds.add(p.getId());
                pi.getTransientData().setBestPeptideMatch(pm);
                pm.setPeptide(p);
                peptideInstanceList.add(pi);
            }
            int nbPeptides = peptideInstanceList.size();
            PeptideInstance[] peptideInstances = peptideInstanceList.toArray(new PeptideInstance[nbPeptides]);
            this.m_rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setPeptideInstanceArray(peptideInstances);
            SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(0, nbPeptides, 1000);
            this.fetchPTMData(entityManagerMSI, subTask);
            subTask = this.m_subTaskManager.sliceATaskAndGetFirst(1, nbPeptides, 1000);
            this.fetchProteinSetName(entityManagerMSI, subTask);
            subTask = this.m_subTaskManager.sliceATaskAndGetFirst(2, nbPeptides, 1000);
            DatabaseLoadPeptideMatchTask.fetchMsQuery(entityManagerMSI, subTask, this.m_peptideMatchIds, this.m_peptideMatchMap);
            ResultSet.Type rsType = this.m_rsm.getResultSet().getType();
            boolean bl = mergedData = rsType == ResultSet.Type.USER || rsType == ResultSet.Type.DECOY_USER;
            if (mergedData) {
                subTask = this.m_subTaskManager.sliceATaskAndGetFirst(3, this.m_peptideMatchMap.size(), 1000);
                DatabaseLoadPeptideMatchTask.fetchSrcDatFile(entityManagerMSI, subTask, this.m_peptideMatchIds, null, null, this.m_peptideMatchMap);
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    private void fetchPTMData(EntityManager entityManagerMSI, SubTask subTask) {
        List sliceOfPeptideMatchIds = subTask.getSubList(this.m_peptideIds);
        DatabasePTMsTask.fillReadablePTMDataForPeptides(entityManagerMSI, this.m_rsm.getResultSet().getId(), this.m_peptideMap, sliceOfPeptideMatchIds);
        DatabasePTMsTask.fillPeptidePTMForPeptides(entityManagerMSI, this.m_peptideMap, sliceOfPeptideMatchIds);
    }

    private void fetchProteinSetName(EntityManager entityManagerMSI, SubTask subTask) {
        List sliceOfPeptideMatchIds = subTask.getSubList(this.m_peptideMatchIds);
        Query proteinSetQuery = entityManagerMSI.createQuery("SELECT typpm.accession, pepm.id FROM fr.proline.core.orm.msi.PeptideMatch pepm, fr.proline.core.orm.msi.PeptideInstance pepi, fr.proline.core.orm.msi.PeptideInstancePeptideMatchMap pi_pm, fr.proline.core.orm.msi.ProteinSet prots, fr.proline.core.orm.msi.PeptideSetPeptideInstanceItem ps_pi, fr.proline.core.orm.msi.PeptideSet peps, fr.proline.core.orm.msi.ProteinMatch typpm WHERE pepm.id IN (:listId) AND pi_pm.peptideMatch=pepm AND pi_pm.resultSummary.id=:rsmId AND pi_pm.peptideInstance=pepi AND ps_pi.peptideInstance=pepi AND ps_pi.peptideSet=peps AND peps.proteinSet=prots AND prots.representativeProteinMatchId = typpm.id AND prots.isValidated=true ORDER BY pepm.id ASC, typpm.accession ASC");
        proteinSetQuery.setParameter("listId", (Object)sliceOfPeptideMatchIds);
        proteinSetQuery.setParameter("rsmId", (Object)(this.m_rsm == null ? -1L : this.m_rsm.getId()));
        ArrayList<String> proteinSetNameArray = new ArrayList<String>();
        long prevPeptideMatchId = -1L;
        List resultList = proteinSetQuery.getResultList();
        for (Object[] resCur : resultList) {
            String proteinName = (String)resCur[0];
            Long peptideMatchId = (Long)resCur[1];
            if (peptideMatchId != prevPeptideMatchId) {
                if (prevPeptideMatchId != -1L) {
                    DPeptideMatch prevPeptideMatch = this.m_peptideMatchMap.get(prevPeptideMatchId);
                    String[] proteinSetNames = proteinSetNameArray.toArray(new String[proteinSetNameArray.size()]);
                    prevPeptideMatch.setProteinSetStringArray(proteinSetNames);
                    proteinSetNameArray.clear();
                    proteinSetNameArray.add(proteinName);
                } else {
                    proteinSetNameArray.add(proteinName);
                }
            } else {
                proteinSetNameArray.add(proteinName);
            }
            prevPeptideMatchId = peptideMatchId;
        }
        if (prevPeptideMatchId != -1L) {
            DPeptideMatch prevPeptideMatch = this.m_peptideMatchMap.get(prevPeptideMatchId);
            String[] proteinSetNames = proteinSetNameArray.toArray(new String[proteinSetNameArray.size()]);
            prevPeptideMatch.setProteinSetStringArray(proteinSetNames);
        }
        for (Long peptideMatchId : sliceOfPeptideMatchIds) {
            DPeptideMatch peptideMatch = this.m_peptideMatchMap.get(peptideMatchId);
            if (peptideMatch.getProteinSetStringArray() != null) continue;
            String[] proteinSetNames = new String[]{};
            peptideMatch.setProteinSetStringArray(proteinSetNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataForProteinMatch() {
        HashMap<Long, Peptide> peptideMap = new HashMap<Long, Peptide>();
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            int size = this.m_rsmList.size();
            for (int i = 0; i < size; ++i) {
                DProteinMatch pm;
                ResultSummary rsm = this.m_rsmList.get(i);
                DProteinMatch dProteinMatch = pm = this.m_proteinMatchArray != null ? this.m_proteinMatchArray.get(i) : this.m_proteinMatch;
                if (!this.needToFetch(pm, rsm)) continue;
                DatabaseLoadPeptidesInstancesTask.fetchPeptideDataForProteinMatch(entityManagerMSI, rsm, pm, peptideMap);
            }
            DatabasePTMsTask.fillPeptidePTMForPeptides(entityManagerMSI, peptideMap, null);
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    public static void fetchPeptideDataForProteinMatch(EntityManager entityManagerMSI, ResultSummary rsm, DProteinMatch proteinMatch, HashMap<Long, Peptide> peptideMap) throws Exception {
        DPeptideSet peptideSet = proteinMatch.getPeptideSet(Long.valueOf(rsm.getId()));
        if (peptideSet == null) {
            TypedQuery peptideSetQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DPeptideSet(ps.id, ps.score, ps.sequenceCount, ps.peptideCount, ps.peptideMatchCount, ps.resultSummaryId) FROM PeptideSet ps, PeptideSetProteinMatchMap ps_to_pm WHERE ps_to_pm.id.proteinMatchId=:proteinMatchId AND ps_to_pm.id.peptideSetId=ps.id AND ps_to_pm.resultSummary.id=:rsmId", DPeptideSet.class);
            peptideSetQuery.setParameter("proteinMatchId", (Object)proteinMatch.getId());
            peptideSetQuery.setParameter("rsmId", (Object)rsm.getId());
            peptideSet = (DPeptideSet)peptideSetQuery.getSingleResult();
            proteinMatch.setPeptideSet(Long.valueOf(rsm.getId()), peptideSet);
        }
        Query peptidesQuery = entityManagerMSI.createQuery("SELECT pi, pm.id, pm.rank, pm.charge, pm.deltaMoz, pm.experimentalMoz, pm.missedCleavage, pm.score, pm.resultSet.id, p, sm, ms.id, ms.initialId, pm.cdPrettyRank, pm.sdPrettyRank, sp.firstTime, sp.precursorIntensity, sp.title, pm.serializedProperties FROM fr.proline.core.orm.msi.PeptideInstance pi, fr.proline.core.orm.msi.PeptideSetPeptideInstanceItem ps_to_pi, fr.proline.core.orm.msi.PeptideMatch pm, fr.proline.core.orm.msi.Peptide p, fr.proline.core.orm.msi.SequenceMatch as sm, fr.proline.core.orm.msi.MsQuery ms, fr.proline.core.orm.msi.Spectrum sp WHERE ps_to_pi.peptideSet.id=:peptideSetId AND ps_to_pi.peptideInstance.id=pi.id AND pi.bestPeptideMatchId=pm.id AND pm.peptideId=p.id AND sm.id.proteinMatchId=:proteinMatchId AND sm.id.peptideId=p.id AND pm.msQuery=ms AND ms.spectrum=sp ORDER BY pm.score DESC");
        peptidesQuery.setParameter("peptideSetId", (Object)peptideSet.getId());
        peptidesQuery.setParameter("proteinMatchId", (Object)proteinMatch.getId());
        HashMap<Long, Peptide> peptideMapForPtm = new HashMap<Long, Peptide>();
        ArrayList<DPeptideInstance> peptideInstanceList = new ArrayList<DPeptideInstance>();
        List l = peptidesQuery.getResultList();
        for (Object[] resCur : l) {
            PeptideInstance pi = (PeptideInstance)resCur[0];
            DPeptideInstance dpi = new DPeptideInstance(pi);
            Long pmId = (Long)resCur[1];
            Integer pmRank = (Integer)resCur[2];
            Integer pmCharge = (Integer)resCur[3];
            Float pmDeltaMoz = (Float)resCur[4];
            Double pmExperimentalMoz = (Double)resCur[5];
            Integer pmMissedCleavage = (Integer)resCur[6];
            Float pmScore = (Float)resCur[7];
            Long pmResultSetId = (Long)resCur[8];
            Integer pmCdPrettyRank = (Integer)resCur[13];
            Integer pmSdPrettyRank = (Integer)resCur[14];
            Float firstTime = (Float)resCur[15];
            Float precursorIntensity = (Float)resCur[16];
            String title = (String)resCur[17];
            String pmSerializedProp = (String)resCur[18];
            DSpectrum spectrum = new DSpectrum();
            spectrum.setFirstTime(firstTime);
            spectrum.setPrecursorIntensity(precursorIntensity);
            spectrum.setTitle(title);
            DPeptideMatch pm = new DPeptideMatch(pmId.longValue(), pmRank, pmCharge.intValue(), pmDeltaMoz, pmExperimentalMoz.doubleValue(), pmMissedCleavage.intValue(), pmScore, pmResultSetId.longValue(), pmCdPrettyRank, pmSdPrettyRank, pmSerializedProp);
            pm.setRetentionTime(firstTime);
            Peptide p = (Peptide)resCur[9];
            peptideMapForPtm.put(p.getId(), p);
            SequenceMatch sm = (SequenceMatch)resCur[10];
            Long msqId = (Long)resCur[11];
            Integer msqInitialId = (Integer)resCur[12];
            DMsQuery msq = new DMsQuery(pmId.longValue(), msqId.longValue(), msqInitialId.intValue(), precursorIntensity);
            msq.setDSpectrum(spectrum);
            dpi.setBestPeptideMatch(pm);
            pm.setSequenceMatch(sm);
            p.getTransientData().setPeptideReadablePtmStringLoaded();
            pm.setPeptide(p);
            pm.setMsQuery(msq);
            peptideInstanceList.add(dpi);
        }
        DatabasePTMsTask.fillReadablePTMDataForPeptides(entityManagerMSI, rsm.getResultSet().getId(), peptideMapForPtm, null);
        int nbPeptides = peptideInstanceList.size();
        DPeptideInstance[] peptideInstances = peptideInstanceList.toArray(new DPeptideInstance[nbPeptides]);
        peptideSet.setPeptideInstances(peptideInstances);
        for (int i = 0; i < nbPeptides; ++i) {
            peptideMap.put(peptideInstances[i].getPeptideId(), peptideInstances[i].getBestPeptideMatch().getPeptide());
        }
        Query proteinGroupsQuery = entityManagerMSI.createQuery("SELECT ps.id, p, pm.id, pm.accession, pm.score, pm.peptideCount, pm.description, pm.geneName, pm.serializedProperties FROM fr.proline.core.orm.msi.ProteinMatch pm, fr.proline.core.orm.msi.ProteinSet ps, fr.proline.core.orm.msi.SequenceMatch sm, fr.proline.core.orm.msi.Peptide p WHERE ps.representativeProteinMatchId=pm.id AND pm.id=sm.id.proteinMatchId AND p.id=sm.id.peptideId AND p.id IN (:peptideIds) AND sm.resultSetId=:rsetId AND ps.resultSummary.id=:rsmId AND ps.isValidated=true");
        proteinGroupsQuery.setParameter("rsmId", (Object)rsm.getId());
        proteinGroupsQuery.setParameter("rsetId", (Object)rsm.getResultSet().getId());
        proteinGroupsQuery.setParameter("peptideIds", peptideMap.keySet());
        l = proteinGroupsQuery.getResultList();
        for (Object[] resCur : l) {
            Long proteinSetId = (Long)resCur[0];
            Peptide p = (Peptide)resCur[1];
            Long proteinMatchId = (Long)resCur[2];
            String accession = (String)resCur[3];
            Float score = (Float)resCur[4];
            Integer peptideCount = (Integer)resCur[5];
            String description = (String)resCur[6];
            String geneName = (String)resCur[7];
            String serializedProperties = (String)resCur[8];
            DProteinMatch pm = new DProteinMatch(proteinMatchId.longValue(), accession, score, peptideCount.intValue(), rsm.getResultSet().getId(), description, geneName, serializedProperties);
            DProteinSet proteinSet = new DProteinSet(proteinSetId.longValue(), proteinMatchId.longValue(), rsm.getId());
            proteinSet.setTypicalProteinMatch(pm);
            ArrayList<DProteinSet> proteinSetArray = p.getTransientData().getProteinSetArray();
            if (proteinSetArray == null) {
                proteinSetArray = new ArrayList<DProteinSet>();
                p.getTransientData().setProteinSetArray(proteinSetArray);
            }
            proteinSetArray.add(proteinSet);
        }
    }
}

