/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DSpectrum;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public class DatabaseLoadSpectrumsTask
extends AbstractDatabaseTask {
    private long m_projectId = -1L;
    private DPeptideMatch m_peptideMatch = null;

    public DatabaseLoadSpectrumsTask(AbstractDatabaseCallback callback, long projectId, DPeptideMatch peptideMatch) {
        super(callback, new TaskInfo("Load Spectrum for Peptide Match " + DatabaseLoadSpectrumsTask.getPeptideName(peptideMatch), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_projectId = projectId;
        this.m_peptideMatch = peptideMatch;
    }

    private static String getPeptideName(DPeptideMatch peptideMatch) {
        Peptide peptide = peptideMatch.getPeptide();
        String name = peptide != null ? peptide.getSequence() : String.valueOf(peptideMatch.getId());
        return name;
    }

    @Override
    public boolean needToFetch() {
        return !this.m_peptideMatch.isMsQuerySet() || !this.m_peptideMatch.getMsQuery().isSpectrumFullySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fetchData() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            if (!this.m_peptideMatch.isMsQuerySet()) {
                TypedQuery msQueryQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DMsQuery(pm.id, msq.id, msq.initialId, s.precursorIntensity) FROM fr.proline.core.orm.msi.PeptideMatch pm, fr.proline.core.orm.msi.MsQuery msq, Spectrum s WHERE pm.msQuery=msq AND pm.id=:peptideMatchId AND msq.spectrum=s", DMsQuery.class);
                msQueryQuery.setParameter("peptideMatchId", (Object)this.m_peptideMatch.getId());
                DMsQuery msq = (DMsQuery)msQueryQuery.getSingleResult();
                this.m_peptideMatch.setMsQuery(msq);
            }
            DMsQuery msQuery = this.m_peptideMatch.getMsQuery();
            TypedQuery spectrumQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DSpectrum(sp.id, sp.firstScan, sp.firstTime, sp.lastTime, sp.intensityList, sp.mozList, sp.precursorCharge, sp.precursorIntensity, sp.precursorMoz, sp.title) FROM fr.proline.core.orm.msi.MsQuery ms, fr.proline.core.orm.msi.Spectrum sp WHERE ms.spectrum=sp AND ms.id=:MsQueryId", DSpectrum.class);
            spectrumQuery.setParameter("MsQueryId", (Object)msQuery.getId());
            List spectrums = spectrumQuery.getResultList();
            if (spectrums.isEmpty()) {
                msQuery.setDSpectrum(null);
            } else {
                msQuery.setDSpectrum((DSpectrum)spectrums.get(0));
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }
}

