/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public class DatabaseVerifySpectrumFromResultSets
extends AbstractDatabaseTask {
    private final List<Long> m_resultSetIDs;
    private final List<Long> m_failedResultSetIDs;
    private final Map<Long, List<Long>> m_emptySpectraPerResultSetIDs;
    private long m_projectID = -1L;

    public DatabaseVerifySpectrumFromResultSets(AbstractDatabaseCallback callback, List<Long> resultSetIDs, long projectID, List<Long> failedRSIDs, Map<Long, List<Long>> emptySpectraPerRSIds) {
        super(callback, new TaskInfo("Verify Spectrum for ResultSet IDs " + resultSetIDs, false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_resultSetIDs = resultSetIDs;
        this.m_projectID = projectID;
        this.m_failedResultSetIDs = failedRSIDs;
        this.m_emptySpectraPerResultSetIDs = emptySpectraPerRSIds;
    }

    @Override
    public boolean needToFetch() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fetchData() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectID).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            TypedQuery spectrumQuery = entityManagerMSI.createQuery("SELECT spc.id, rset.id FROM fr.proline.core.orm.msi.ResultSet AS rset, fr.proline.core.orm.msi.MsiSearch AS msi, fr.proline.core.orm.msi.Peaklist AS pl, Spectrum AS spc WHERE rset.msiSearch = msi AND rset.id IN :rsIds AND msi.peaklist = pl AND spc.peaklistId = pl.id AND (spc.firstTime  is null OR spc.firstTime = 0)  AND (spc.firstCycle  is null OR spc.firstCycle = 0) AND (spc.firstScan  is null OR spc.firstScan = 0) ", Object[].class);
            spectrumQuery.setParameter("rsIds", this.m_resultSetIDs);
            List errSpectrumIDs = spectrumQuery.getResultList();
            if (errSpectrumIDs != null && !errSpectrumIDs.isEmpty()) {
                for (Object[] nextErrSp : errSpectrumIDs) {
                    Long spectrumID = (Long)nextErrSp[0];
                    Long rsId = (Long)nextErrSp[1];
                    List spectraIds = this.m_emptySpectraPerResultSetIDs.getOrDefault(rsId, new ArrayList());
                    spectraIds.add(spectrumID);
                    this.m_emptySpectraPerResultSetIDs.put(rsId, spectraIds);
                    if (this.m_failedResultSetIDs.contains(rsId)) continue;
                    this.m_failedResultSetIDs.add(rsId);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }
}

