/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks.data.ptm;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.msi.SequenceMatch;
import fr.proline.core.orm.msi.dto.DInfoPTM;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.studio.dam.tasks.data.ptm.AbstractJSONPTMSite;
import fr.proline.studio.dam.tasks.data.ptm.AggregatedMasterQuantPeptide;
import fr.proline.studio.dam.tasks.data.ptm.JSONPTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.JSONPTMDataset;
import fr.proline.studio.dam.tasks.data.ptm.JSONPTMSite2;
import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTMDataset {
    protected static final Logger LOG = LoggerFactory.getLogger((String)"ProlineStudio.DAM.Task");
    private DDataset m_dataset;
    private List<PTMSite> m_proteinPTMSites;
    private List<Long> m_leafRSMIds;
    private List<DInfoPTM> m_ptmOfInterest;
    private List<PTMCluster> m_ptmClusters;
    private final Map<Long, Map<Long, List<PTMPeptideInstance>>> m_parentPtmPepInstByPepIdByProtMatchId = new HashMap<Long, Map<Long, List<PTMPeptideInstance>>>();
    private final Map<Long, Map<Long, List<PTMPeptideInstance>>> m_leafPtmPepInstByPepInstIdByProtMatchId = new HashMap<Long, Map<Long, List<PTMPeptideInstance>>>();
    private Map<String, List<Long>> m_allLeafProtMatchesIdPerAccession;

    public PTMDataset(DDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("dataset from which PTM sites are extracted cannot be null");
        }
        this.m_dataset = dataset;
        this.m_ptmOfInterest = new ArrayList<DInfoPTM>();
    }

    public DDataset getDataset() {
        return this.m_dataset;
    }

    public List<Long> getLeafResultSummaryIds() {
        if (this.m_leafRSMIds == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Long>(this.m_leafRSMIds);
    }

    public void setLeafResultSummaryIds(List<Long> l) {
        this.m_leafRSMIds = new ArrayList<Long>(l);
    }

    public boolean isIdentification() {
        return this.m_dataset.isIdentification();
    }

    public boolean isQuantitation() {
        return this.m_dataset.isQuantitation();
    }

    public void addInfoPTM(DInfoPTM ptm) {
        this.m_ptmOfInterest.add(ptm);
    }

    public List<DInfoPTM> getInfoPTMs() {
        return this.m_ptmOfInterest;
    }

    public List<PTMSite> getPTMSites() {
        return this.m_proteinPTMSites;
    }

    public void setPTMSites(List<PTMSite> proteinPTMSites) {
        proteinPTMSites.forEach(site -> site.setDataset(this));
        this.m_proteinPTMSites = proteinPTMSites;
    }

    public List<PTMCluster> getPTMClusters() {
        return this.m_ptmClusters;
    }

    public PTMCluster getPTMCluster(Long clusterId) {
        Optional<PTMCluster> clusterOp = this.m_ptmClusters.stream().filter(c -> c.getId().equals(clusterId)).findFirst();
        if (clusterOp.isPresent()) {
            return clusterOp.get();
        }
        return null;
    }

    public void setPTMClusters(List<PTMCluster> ptmClusters) {
        this.m_ptmClusters = ptmClusters;
    }

    public PTMSite getPTMSite(Long id) {
        Optional<PTMSite> ptmSite = this.m_proteinPTMSites.stream().filter(site -> site.getId().equals(id)).findFirst();
        return ptmSite.orElse(null);
    }

    public void setQuantProteinSets(List<DMasterQuantProteinSet> masterQuantProteinSetList, Map<Long, Long> typicalProteinMatchIdByProteinMatchId) {
        DMasterQuantProteinSet mqps;
        Long typicalPMId;
        HashMap<Long, DMasterQuantProteinSet> mqProteinSetByProteinMatchId = new HashMap<Long, DMasterQuantProteinSet>();
        for (DMasterQuantProteinSet mqps2 : masterQuantProteinSetList) {
            if (mqps2.getProteinSet() == null) continue;
            mqProteinSetByProteinMatchId.put(mqps2.getProteinSet().getProteinMatchId(), mqps2);
        }
        for (PTMSite site : this.m_proteinPTMSites) {
            typicalPMId = typicalProteinMatchIdByProteinMatchId.get(site.getProteinMatch().getId());
            mqps = (DMasterQuantProteinSet)mqProteinSetByProteinMatchId.get(typicalPMId);
            site.setQuantProteinSet(mqps);
        }
        if (this.m_ptmClusters != null) {
            for (PTMCluster cluster : this.m_ptmClusters) {
                typicalPMId = typicalProteinMatchIdByProteinMatchId.get(cluster.getProteinMatch().getId());
                mqps = (DMasterQuantProteinSet)mqProteinSetByProteinMatchId.get(typicalPMId);
                cluster.setQuantProteinSet(mqps);
            }
        }
    }

    public boolean isQuantDataLoaded() {
        if (this.m_ptmClusters == null || this.m_ptmClusters.isEmpty()) {
            return false;
        }
        return this.m_ptmClusters.get(0).getMasterQuantProteinSet() != null;
    }

    public List<PTMPeptideInstance> getLeafPTMPeptideInstances(Long proteinMatchId, Long pepInstId) {
        Map<Long, List<PTMPeptideInstance>> m = this.m_leafPtmPepInstByPepInstIdByProtMatchId.get(proteinMatchId);
        if (m != null) {
            return m.get(pepInstId);
        }
        return Collections.emptyList();
    }

    public void addLeafPTMPeptideInstance(PTMPeptideInstance pepInst, Long proteinMatchId) {
        Map<Long, List<PTMPeptideInstance>> m = this.m_leafPtmPepInstByPepInstIdByProtMatchId.get(proteinMatchId);
        if (m == null) {
            m = new HashMap<Long, List<PTMPeptideInstance>>();
            ArrayList<PTMPeptideInstance> ptmPepInst = new ArrayList<PTMPeptideInstance>();
            ptmPepInst.add(pepInst);
            m.put(pepInst.getPeptideInstance().getId(), ptmPepInst);
        } else if (m.get(pepInst.getPeptideInstance().getId()) == null) {
            ArrayList<PTMPeptideInstance> ptmPepInst = new ArrayList<PTMPeptideInstance>();
            ptmPepInst.add(pepInst);
            m.put(pepInst.getPeptideInstance().getId(), ptmPepInst);
        } else {
            m.get(pepInst.getPeptideInstance().getId()).add(pepInst);
        }
        this.m_leafPtmPepInstByPepInstIdByProtMatchId.put(proteinMatchId, m);
    }

    public Collection<PTMPeptideInstance> getPTMPeptideInstances(Long proteinMatchId) {
        Map<Long, List<PTMPeptideInstance>> m = this.m_parentPtmPepInstByPepIdByProtMatchId.get(proteinMatchId);
        if (m != null) {
            return m.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public PTMPeptideInstance getPTMPeptideInstance(DProteinMatch proteinMatch, DPeptideInstance peptideInstance, Integer protPosition) {
        PTMPeptideInstance foundPtmPepIns;
        List potentialPtmPepInsts;
        Map<Long, List<PTMPeptideInstance>> ptmPepInstanceByPepId;
        List<PTMPeptideInstance> registeredPtmPepInsts;
        Long proteinMatchId = proteinMatch.getId();
        if (!this.m_parentPtmPepInstByPepIdByProtMatchId.containsKey(proteinMatchId)) {
            this.m_parentPtmPepInstByPepIdByProtMatchId.put(proteinMatchId, new HashMap());
        }
        if ((registeredPtmPepInsts = (ptmPepInstanceByPepId = this.m_parentPtmPepInstByPepIdByProtMatchId.get(proteinMatchId)).get(peptideInstance.getPeptideId())) == null) {
            registeredPtmPepInsts = new ArrayList<PTMPeptideInstance>();
        }
        if ((potentialPtmPepInsts = registeredPtmPepInsts.stream().filter(ptmPepInst -> protPosition >= ptmPepInst.getStartPosition() && protPosition <= ptmPepInst.getStopPosition()).collect(Collectors.toList())).isEmpty()) {
            foundPtmPepIns = new PTMPeptideInstance(peptideInstance);
            registeredPtmPepInsts.add(foundPtmPepIns);
            if (peptideInstance.getPeptideMatches() != null) {
                List pepInsSequenceMatches = peptideInstance.getPeptideMatches().stream().map(DPeptideMatch::getSequenceMatch).collect(Collectors.toList());
                for (SequenceMatch sm : pepInsSequenceMatches) {
                    if (protPosition < sm.getId().getStart() || protPosition > sm.getId().getStop()) continue;
                    foundPtmPepIns.setStartPosition(sm.getId().getStart());
                    break;
                }
            }
            ptmPepInstanceByPepId.put(peptideInstance.getPeptideId(), registeredPtmPepInsts);
        } else {
            foundPtmPepIns = (PTMPeptideInstance)potentialPtmPepInsts.get(0);
            if (potentialPtmPepInsts.size() > 1) {
                LOG.warn(" ----- GET PTMPeptideInstance for Prot id " + proteinMatchId + " pep " + peptideInstance.getPeptide().getSequence() + " at position " + protPosition + " FOUND " + potentialPtmPepInsts.size());
            }
        }
        return foundPtmPepIns;
    }

    protected void updateParentPTMPeptideInstanceClusters(boolean updateSiteCount) {
        if (this.m_ptmClusters != null && !this.m_ptmClusters.isEmpty()) {
            this.m_ptmClusters.forEach(ptmC -> {
                Integer[] siteCount = new Integer[]{ptmC.getPTMSitesCount()};
                List<PTMPeptideInstance> ptmPepInsForCluster = ptmC.getParentPTMPeptideInstances();
                ptmPepInsForCluster.forEach(peI -> {
                    peI.addCluster((PTMCluster)ptmC);
                    if (updateSiteCount) {
                        Long peISiteCount = peI.getPTMSites().stream().filter(ptmSite -> this.m_ptmOfInterest.contains(ptmSite.getPTMSpecificity())).count();
                        if ((long)siteCount[0].intValue() < peISiteCount) {
                            siteCount[0] = peISiteCount.intValue();
                        }
                    }
                });
                ptmC.setPTMSitesCount(siteCount[0]);
            });
        }
    }

    public void setLeafProtMatchesIdPerAccession(Map<String, List<Long>> allProtMatchesIdPerAccession) {
        this.m_allLeafProtMatchesIdPerAccession = allProtMatchesIdPerAccession;
    }

    public List<Long> getProtMatchesIdForAccession(String protMatcherAccession) {
        return this.m_allLeafProtMatchesIdPerAccession.getOrDefault(protMatcherAccession, new ArrayList());
    }

    public List<PTMCluster> getColocatedClusters(PTMCluster cluster) {
        ArrayList<PTMCluster> colocatedClusters = new ArrayList<PTMCluster>();
        DProteinMatch pmatch = cluster.getProteinMatch();
        int minStart = -1;
        int maxEnd = -1;
        try {
            minStart = cluster.getParentPTMPeptideInstances().stream().map(pi -> pi.getStartPosition()).min(Comparator.naturalOrder()).get();
            maxEnd = cluster.getParentPTMPeptideInstances().stream().map(pi -> pi.getStopPosition()).max(Comparator.naturalOrder()).get();
        }
        catch (NoSuchElementException e) {
            LOG.error("Errpr getting peptides min/max bounds for cluster", (Throwable)e);
            return colocatedClusters;
        }
        for (PTMCluster c : this.m_ptmClusters) {
            if (!c.getProteinMatch().equals(pmatch) || c.getParentPTMPeptideInstances() == null) continue;
            int clMinStart = c.getParentPTMPeptideInstances().stream().map(pi -> pi.getStartPosition()).min(Comparator.naturalOrder()).get();
            int clMaxEnd = c.getParentPTMPeptideInstances().stream().map(pi -> pi.getStopPosition()).max(Comparator.naturalOrder()).get();
            if (!(minStart <= clMinStart && clMinStart < maxEnd || minStart <= clMaxEnd && clMaxEnd <= maxEnd) && (clMinStart > minStart || minStart >= clMaxEnd)) continue;
            colocatedClusters.add(c);
        }
        return colocatedClusters;
    }

    private boolean areColocalized(PTMCluster firstCluster, PTMCluster secondCluster) {
        if (firstCluster == null || secondCluster == null) {
            return false;
        }
        DProteinMatch pmatch = firstCluster.getProteinMatch();
        if (!pmatch.equals(secondCluster.getProteinMatch())) {
            return false;
        }
        int minStart = -1;
        int maxEnd = -1;
        try {
            minStart = firstCluster.getParentPTMPeptideInstances().stream().map(pi -> pi.getStartPosition()).min(Comparator.naturalOrder()).get();
            maxEnd = firstCluster.getParentPTMPeptideInstances().stream().map(pi -> pi.getStopPosition()).max(Comparator.naturalOrder()).get();
        }
        catch (NoSuchElementException e) {
            LOG.error("Error getting peptides min/max bounds for cluster", (Throwable)e);
            return false;
        }
        if (secondCluster.getParentPTMPeptideInstances() != null) {
            int clMinStart = secondCluster.getParentPTMPeptideInstances().stream().map(pi -> pi.getStartPosition()).min(Comparator.naturalOrder()).get();
            int clMaxEnd = secondCluster.getParentPTMPeptideInstances().stream().map(pi -> pi.getStopPosition()).max(Comparator.naturalOrder()).get();
            if (minStart <= clMinStart && clMinStart < maxEnd || minStart <= clMaxEnd && clMaxEnd <= maxEnd || clMinStart <= minStart && minStart < clMaxEnd) {
                return true;
            }
        }
        return false;
    }

    public boolean mergeClusters(List<PTMCluster> clusters2Merge) {
        if (clusters2Merge == null || clusters2Merge.size() <= 1) {
            return false;
        }
        List finalClusters2Merge = clusters2Merge.stream().filter(c -> c.getSelectionLevel() >= 2).collect(Collectors.toList());
        if (finalClusters2Merge.size() <= 1) {
            return false;
        }
        PTMCluster firstCluster = (PTMCluster)finalClusters2Merge.get(0);
        if ((finalClusters2Merge = finalClusters2Merge.stream().filter(c -> this.areColocalized(firstCluster, (PTMCluster)c)).collect(Collectors.toList())).size() <= 1) {
            return false;
        }
        List<Long> siteIds = firstCluster.getPTMSites().stream().map(PTMSite::getId).collect(Collectors.toList());
        String firstClusterAnnot = firstCluster.getSelectionInfo();
        PTMCluster mergedCluster = new PTMCluster(firstCluster.getId(), firstCluster.getLocalizationConfidence(), firstCluster.getSelectionLevel(), firstCluster.getSelectionNotation(), firstClusterAnnot, siteIds, firstCluster.getPeptideIds(), this);
        mergedCluster.setRepresentativePepMatch(firstCluster.getRepresentativePepMatch());
        StringBuilder selectionInfoSB = new StringBuilder();
        if (StringUtils.isNotEmpty((String)firstClusterAnnot)) {
            selectionInfoSB.append(firstClusterAnnot).append("; ");
        }
        selectionInfoSB.append("Merged clusters : ");
        selectionInfoSB.append(firstCluster.getId()).append("; ");
        HashMap<Long, DMasterQuantPeptide> mqPepByPepInstId = new HashMap<Long, DMasterQuantPeptide>();
        if (this.isQuantitation()) {
            DMasterQuantPeptide finalClusterMQpep = firstCluster.getRepresentativeMQPepMatch();
            if (finalClusterMQpep instanceof AggregatedMasterQuantPeptide) {
                ((AggregatedMasterQuantPeptide)finalClusterMQpep).getAggregatedMQPeptides().forEach(mqPep -> mqPepByPepInstId.put(mqPep.getPeptideInstanceId(), (DMasterQuantPeptide)mqPep));
            } else {
                mqPepByPepInstId.put(finalClusterMQpep.getPeptideInstanceId(), finalClusterMQpep);
            }
        }
        for (int i = 1; i < finalClusters2Merge.size(); ++i) {
            PTMCluster nextCluster = (PTMCluster)finalClusters2Merge.get(i);
            selectionInfoSB.append(nextCluster.getId()).append("; ");
            if (mergedCluster.getPTMSitesCount() < nextCluster.getPTMSitesCount()) {
                mergedCluster.setPTMSitesCount(nextCluster.getPTMSitesCount());
            }
            mergedCluster.addSites(nextCluster.getPTMSites());
            mergedCluster.addPeptideIds(nextCluster.getPeptideIds());
            if (mergedCluster.getLocalizationConfidence().floatValue() < nextCluster.getLocalizationConfidence().floatValue()) {
                mergedCluster.setLocalizationConfidence(nextCluster.getLocalizationConfidence());
            }
            DPeptideMatch currentPepM = mergedCluster.getRepresentativePepMatch();
            DPeptideMatch nextPepM = nextCluster.getRepresentativePepMatch();
            if (currentPepM.getPtmSiteProperties() != null && currentPepM.getPtmSiteProperties().getMascotDeltaScore() != null) {
                if (nextPepM.getPtmSiteProperties() != null && nextPepM.getPtmSiteProperties().getMascotDeltaScore() != null && nextPepM.getPtmSiteProperties().getMascotDeltaScore().floatValue() > currentPepM.getPtmSiteProperties().getMascotDeltaScore().floatValue()) {
                    mergedCluster.setRepresentativePepMatch(nextPepM);
                }
            } else if (nextPepM.getPtmSiteProperties() != null && nextPepM.getPtmSiteProperties().getMascotDeltaScore() != null) {
                mergedCluster.setRepresentativePepMatch(nextPepM);
            }
            nextCluster.getParentPTMPeptideInstances().forEach(ptmPepI -> {
                ptmPepI.addCluster(mergedCluster);
                ptmPepI.removeCluster(nextCluster);
            });
            nextCluster.getLeafPTMPeptideInstances().forEach(ptmPepI -> {
                ptmPepI.addCluster(mergedCluster);
                ptmPepI.removeCluster(nextCluster);
            });
            if (!this.isQuantitation()) continue;
            DMasterQuantPeptide nextClusterMQpep = nextCluster.getRepresentativeMQPepMatch();
            if (nextClusterMQpep instanceof AggregatedMasterQuantPeptide) {
                ((AggregatedMasterQuantPeptide)nextClusterMQpep).getAggregatedMQPeptides().forEach(mqPep -> {
                    if (!mqPepByPepInstId.containsKey(mqPep.getPeptideInstance().getPeptideId())) {
                        mqPepByPepInstId.put(mqPep.getPeptideInstanceId(), (DMasterQuantPeptide)mqPep);
                    }
                });
                continue;
            }
            mqPepByPepInstId.put(nextClusterMQpep.getPeptideInstanceId(), nextClusterMQpep);
        }
        if (this.isQuantitation()) {
            mergedCluster.setRepresentativeMQPepMatch(this.getRepresentativeMQPeptideForCluster(mergedCluster, mqPepByPepInstId));
        }
        mergedCluster.setSelectionInfo(selectionInfoSB.toString());
        int index = this.m_ptmClusters.indexOf(firstCluster);
        this.m_ptmClusters.removeAll(finalClusters2Merge);
        this.m_ptmClusters.add(index, mergedCluster);
        return true;
    }

    public JSONPTMDataset createJSONPTMDataset() throws IllegalAccessException {
        JSONPTMDataset ptmDS = new JSONPTMDataset();
        List<DInfoPTM> ptmInfos = this.getInfoPTMs();
        ArrayList<Long> ptmInfoIds = new ArrayList<Long>();
        for (int i = 0; i < ptmInfos.size(); ++i) {
            if (ptmInfoIds.contains(ptmInfos.get(i).getIdPtm())) continue;
            ptmInfoIds.add(ptmInfos.get(i).getIdPtm());
        }
        ptmDS.ptmIds = ptmInfoIds.toArray(new Long[ptmInfoIds.size()]);
        List<Long> leafRsmIds = this.getLeafResultSummaryIds();
        Long[] rsmIds = new Long[leafRsmIds.size()];
        for (int i = 0; i < leafRsmIds.size(); ++i) {
            rsmIds[i] = leafRsmIds.get(i);
        }
        ptmDS.leafResultSummaryIds = rsmIds;
        List<PTMSite> allSites = this.getPTMSites();
        JSONPTMSite2[] allJSONSites = new JSONPTMSite2[allSites.size()];
        for (int i = 0; i < allSites.size(); ++i) {
            AbstractJSONPTMSite newtPTMSite = allSites.get(i).getJSONPtmSite();
            if (!(newtPTMSite instanceof JSONPTMSite2)) {
                throw new IllegalAccessException("Can't Export old PTM Site informations ");
            }
            allJSONSites[i] = (JSONPTMSite2)newtPTMSite;
        }
        ptmDS.ptmSites = allJSONSites;
        List<PTMCluster> allClusters = this.getPTMClusters();
        JSONPTMCluster[] allJSONClusters = new JSONPTMCluster[allClusters.size()];
        for (int i = 0; i < allClusters.size(); ++i) {
            PTMCluster nextCluster = allClusters.get(i);
            JSONPTMCluster newtPTMCluster = new JSONPTMCluster();
            newtPTMCluster.id = nextCluster.getId();
            newtPTMCluster.selectionLevel = nextCluster.getSelectionLevel();
            if (nextCluster.getSelectionNotation() != null) {
                newtPTMCluster.selectionConfidence = nextCluster.getSelectionNotation();
            }
            if (StringUtils.isNotEmpty((String)nextCluster.getSelectionInfo())) {
                newtPTMCluster.selectionInformation = nextCluster.getSelectionInfo();
            }
            newtPTMCluster.bestPeptideMatchId = nextCluster.getRepresentativePepMatch().getId();
            newtPTMCluster.localizationConfidence = nextCluster.getLocalizationConfidence();
            newtPTMCluster.isomericPeptideIds = new Long[0];
            allSites = nextCluster.getPTMSites();
            Long[] clusterJSONSites = new Long[allSites.size()];
            for (int index = 0; index < allSites.size(); ++index) {
                AbstractJSONPTMSite newtPTMSite = allSites.get(index).getJSONPtmSite();
                if (!(newtPTMSite instanceof JSONPTMSite2)) {
                    throw new IllegalAccessException("Can't Export old PTM Site informations ");
                }
                clusterJSONSites[index] = ((JSONPTMSite2)newtPTMSite).id;
            }
            newtPTMCluster.ptmSiteLocations = clusterJSONSites;
            newtPTMCluster.peptideIds = nextCluster.getPeptideIds().toArray(new Long[0]);
            allJSONClusters[i] = newtPTMCluster;
        }
        ptmDS.ptmClusters = allJSONClusters;
        return ptmDS;
    }

    public DMasterQuantPeptide getRepresentativeMQPeptideForCluster(PTMCluster cluster, Map<Long, DMasterQuantPeptide> mqPepByPepInstId) {
        AggregatedMasterQuantPeptide bestMQPep = null;
        if (cluster.getMasterQuantProteinSet() != null) {
            List<DPeptideInstance> parentPeptideInstances = cluster.getParentPeptideInstances();
            List<DMasterQuantPeptide> mqPeps = parentPeptideInstances.stream().map(parentPepI -> (DMasterQuantPeptide)mqPepByPepInstId.get(parentPepI.getId())).filter(Objects::nonNull).collect(Collectors.toList());
            bestMQPep = new AggregatedMasterQuantPeptide(mqPeps, (DMasterQuantitationChannel)this.m_dataset.getMasterQuantitationChannels().get(0));
        }
        return bestMQPep;
    }
}

