/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.FastaParser;
import org.forester.io.writers.SequenceWriter;
import org.forester.sequence.MolecularSequence;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public final class fasta_split {
    private static final String PRG_NAME = "fasta_split";
    private static final String PRG_VERSION = "1.00";
    private static final String PRG_DATE = "150331";

    public static void main(String[] args) {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        System.out.println();
        if (args.length != 3) {
            fasta_split.argumentsError();
        }
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        String pattern_str = cla.getName(0);
        File infile = cla.getFile(1);
        File outdir = cla.getFile(2);
        Pattern pa = null;
        try {
            pa = Pattern.compile(pattern_str);
        }
        catch (Exception ex) {
            ForesterUtil.fatalError(PRG_NAME, ex.getMessage());
        }
        String error = ForesterUtil.isReadableFile(infile);
        if (!ForesterUtil.isEmpty(error)) {
            ForesterUtil.fatalError(PRG_NAME, error);
        }
        if (!outdir.exists()) {
            new File(outdir.toString()).mkdir();
        }
        if (!outdir.isDirectory()) {
            ForesterUtil.fatalError(PRG_NAME, outdir + " is not a directory");
        }
        List<MolecularSequence> seqs = null;
        try {
            seqs = FastaParser.parse(new FileInputStream(infile));
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (seqs == null || seqs.isEmpty()) {
            ForesterUtil.fatalError(PRG_NAME, infile + " appears empty");
        }
        System.out.println("Read " + seqs.size() + " sequences");
        HashMap output = new HashMap();
        int cc = 0;
        for (MolecularSequence seq : seqs) {
            String key;
            ++cc;
            Matcher m = pa.matcher(seq.getIdentifier());
            if (m.find()) {
                key = m.group(1);
                if (!output.containsKey(key)) {
                    output.put(key, new ArrayList());
                }
                ((List)output.get(key)).add(seq);
                continue;
            }
            System.out.println("warning: " + pattern_str + " not found in sequence \"" + seq.getIdentifier() + "\"");
            key = "unknown";
            if (!output.containsKey("unknown")) {
                output.put("unknown", new ArrayList());
            }
            ((List)output.get("unknown")).add(seq);
        }
        int c = 0;
        for (Map.Entry entry : output.entrySet()) {
            String s = (String)entry.getKey();
            s = s.replace('*', '_');
            File of = new File(outdir.getAbsolutePath().toString() + "/" + s + ".fasta");
            if (of.exists()) {
                ForesterUtil.fatalError(PRG_NAME, of + " already exists");
            }
            System.out.println(++c + ": writing " + of + " [" + ((List)entry.getValue()).size() + " seqs]");
            try {
                SequenceWriter.writeSeqs((List<MolecularSequence>)((List)entry.getValue()), of, SequenceWriter.SEQ_FORMAT.FASTA, 60);
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, e.getMessage());
            }
        }
    }

    private static void argumentsError() {
        System.out.println("fasta_split <pattern> <infile> <outdir>");
        System.out.println("Example: fasta_split \"v-germ=(\\S+)\" tt.fasta outdir");
        System.out.println();
        System.exit(-1);
    }
}

