/*
 * Decompiled with CFR 0.152.
 */
package org.forester.applications;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.forester.io.parsers.FastaParser;
import org.forester.msa.Msa;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;
import org.forester.util.ForesterUtil;

public class aa {
    public static void main(String[] args) {
        try {
            System.out.println("STARTING...");
            List<MolecularSequence> orig = FastaParser.parse(new FileInputStream("C:\\Users\\zma\\Desktop\\RRMa_domains_ext_20.fasta"));
            Msa msa = FastaParser.parseMsa(new FileInputStream("C:\\Users\\zma\\Desktop\\test3_sorted.fasta"));
            HashSet<MolecularSequence> all_found_seqs = new HashSet<MolecularSequence>();
            for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
                String id = msa.getIdentifier(i);
                String id_ = id.substring(0, id.indexOf("_"));
                String range = id.substring(id.indexOf("[") + 1, id.indexOf("]"));
                if (ForesterUtil.isEmpty(id_)) {
                    System.out.println("ERROR: id is empty for: " + id);
                    System.exit(-1);
                }
                if (ForesterUtil.isEmpty(range)) {
                    System.out.println("ERROR: range is empty for: " + id);
                    System.exit(-1);
                }
                int found = 0;
                ArrayList<MolecularSequence> found_seqs = new ArrayList<MolecularSequence>();
                for (MolecularSequence orig_seq : orig) {
                    String orig_seq_id = orig_seq.getIdentifier();
                    if (orig_seq_id.indexOf(id_) < 0 || orig_seq_id.indexOf("[" + range + "]") < 0) continue;
                    ++found;
                    found_seqs.add(orig_seq);
                }
                if (found > 0) {
                    for (MolecularSequence found_seq : found_seqs) {
                        if (found_seq.getLength() < 85) continue;
                        all_found_seqs.add(BasicSequence.createAaSequence(id, found_seq.getMolecularSequenceAsString()));
                    }
                    if (found <= 1) continue;
                    System.out.println(i + ": " + id + "=>" + id_ + " " + range);
                    System.out.println("  found: " + found);
                    for (MolecularSequence found_seq : found_seqs) {
                        System.out.println(found_seq.toString());
                    }
                    continue;
                }
                System.out.println("ERROR: not found: " + id);
                System.exit(-1);
            }
            Object[] fasta_ary = new String[all_found_seqs.size()];
            int i = 0;
            for (MolecularSequence sequence : all_found_seqs) {
                fasta_ary[i] = ">" + sequence.getIdentifier() + "\n" + sequence.getMolecularSequenceAsString();
                System.out.println(sequence);
                ++i;
            }
            Arrays.sort(fasta_ary);
            for (Object element : fasta_ary) {
                System.out.println((String)element);
            }
            System.out.println("DONE.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

