/*
 * Decompiled with CFR 0.152.
 */
package org.forester.applications;

import java.io.File;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class simple_node_processor {
    public static void main(String[] args) {
        File in = null;
        Object out = null;
        try {
            CommandLineArguments cla = null;
            cla = new CommandLineArguments(args);
            in = cla.getFile(0);
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            PhyloXmlParser xml_parser = PhyloXmlParser.createPhyloXmlParserXsdValidating();
            Phylogeny[] phylogenies_0 = factory.create(in, xml_parser);
            Phylogeny phylogeny_0 = phylogenies_0[0];
            PhylogenyNodeIterator it = phylogeny_0.iteratorPostorder();
            int i = 0;
            while (it.hasNext()) {
                PhylogenyNode node = it.next();
                simple_node_processor.processNode(node, i, phylogeny_0);
                ++i;
            }
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static void processNode(PhylogenyNode node, int i, Phylogeny phy) {
        String c;
        Taxonomy t;
        if (node.isExternal() && node.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty((t = node.getNodeData().getTaxonomy()).getTaxonomyCode()) && (c = t.getTaxonomyCode()).indexOf("XX") == 3) {
            System.out.println("FAKE_CODE_TO_ID_MAP.put( \"" + c + "\", " + t.getIdentifier().getValue() + ");");
        }
    }
}

