/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreeFontSet;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.data.NodeDataField;
import org.forester.phylogeny.data.NodeVisualData;
import org.forester.util.ForesterUtil;

public final class Configuration {
    static final String[][] clickto_options = new String[][]{{"Display Node Data", "display"}, {"Collapse/Uncollapse", "display"}, {"Root/Reroot", "display"}, {"Go to Sub-/Super-Tree", "display"}, {"Swap Descendants", "display"}, {"Colorize Node(s)", "display"}, {"Change Node Font(s)", "display"}, {"Colorize Subtree(s)", "display"}, {"Open Sequence DB", "display"}, {"Open PDB", "display"}, {"Open Taxonomy DB", "display"}, {"Launch BLAST", "display"}, {"Cut Subtree", "display"}, {"Copy Subtree", "display"}, {"Paste Subtree", "display"}, {"Delete Subtree/Node", "display"}, {"Add New Node", "display"}, {"Edit Node Data", "display"}, {"Sort Descendants", "display"}, {"List Node Data", "display"}, {"Select Node(s)", "display"}};
    private static final String[][] DEFAULT_SPECIES_COLORS = new String[][]{{"BRAFL", "0x00FFFF"}, {"SPHGR", "0x9620F0"}, {"STRPU", "0x9620F0"}, {"CIOIN", "0xFF1CAE"}, {"CIOSA", "0xFF2CAE"}, {"BOVIN", "0x5C3317"}, {"CANFA", "0x8B2323"}, {"HUMAN", "0xFF2400"}, {"PANTR", "0xCC2400"}, {"MOUSE", "0xFF7F00"}, {"RAT", "0xFFEF00"}, {"MONDO", "0xEE9A49"}, {"ORNAN", "0xCD853F"}, {"XENLA", "0x6BAA23"}, {"XENTR", "0x6BAA23"}, {"CHICK", "0xFFC125"}, {"FUGRU", "0x0000FF"}, {"BRARE", "0x0000DD"}, {"DANRE", "0x0000BB"}, {"TETNG", "0x0000AA"}, {"ORYLA", "0x000088"}, {"GASAC", "0x000066"}, {"CAEEL", "0x666699"}, {"CAEBR", "0xB0B0B0"}, {"DROME", "0x663366"}, {"DROPS", "0x996699"}, {"APIME", "0x7A7700"}, {"AEDAE", "0x8C5900"}, {"TRICA", "0x918E00"}, {"NEMVE", "0x0066CC"}, {"HYDVU", "0x3399FF"}, {"LUBBA", "0xF7B5CB"}, {"GEOCY", "0xF5A0BD"}, {"AMPQE", "0x009966"}, {"SUBDO", "0xC790B9"}, {"MONBE", "0xFC0FC0"}, {"DICPU", "0xFFCC33"}, {"DICDI", "0xFFCC00"}, {"ENTHI", "0x5959AB"}, {"ARATH", "0x00FF00"}, {"POPTR", "0x006400"}, {"VITVI", "0x00CD00"}, {"GLYMA", "0x00FF7F"}, {"ORYSA", "0x008B00"}, {"ORYSJ", "0x008C00"}, {"SORBI", "0x00EE76"}, {"SELMO", "0x238E23"}, {"PHYPA", "0x09F911"}, {"OSTLU", "0x7FFF00"}, {"OSTTA", "0x7FFF00"}, {"OSTRC", "0x7FFF00"}, {"MICPU", "0x66CD00"}, {"MIC99", "0x66CD00"}, {"CHLRE", "0xB3EE3A"}, {"VOLCA", "0xC0FF3E"}, {"CHLSP", "0x6B8E23"}, {"CYAME", "0xD02090"}, {"YEAST", "0xAAAAAA"}, {"BACFR", "0xFF0000"}, {"BACTN", "0xFFFF00"}, {"MYXXD", "0x0000FF"}, {"STIAU", "0x00FFFF"}, {"BACOV", "0x8C5900"}, {"BACUN", "0x66CD00"}, {"PORGI", "0x918E00"}};
    static final int display_node_data = 0;
    static final int collapse_uncollapse = 1;
    static final int reroot = 2;
    static final int subtree = 3;
    static final int swap = 4;
    static final int color_node_font = 5;
    static final int change_node_font = 6;
    static final int color_subtree = 7;
    static final int open_seq_web = 8;
    static final int open_pdb_web = 9;
    static final int open_tax_web = 10;
    static final int blast = 11;
    static final int cut_subtree = 12;
    static final int copy_subtree = 13;
    static final int paste_subtree = 14;
    static final int delete_subtree_or_node = 15;
    static final int add_new_node = 16;
    static final int edit_node_data = 17;
    static final int sort_descendents = 18;
    static final int get_ext_desc_data = 19;
    static final int select_nodes = 20;
    static final String[][] display_options = new String[][]{{"Phylogram", "display", "?"}, {"Node Name", "display", "yes"}, {"Taxonomy Code", "display", "yes"}, {"Seq Annotations", "display", "no"}, {"Confidence Values", "display", "?"}, {"Node Events", "display", "?"}, {"Colorize by Taxonomy", "display", "no"}, {"Colorize by Sequence", "display", "no"}, {"Visual Styles/Branch Colors", "display", "no"}, {"Branch Widths", "display", "no"}, {"Domain Architectures", "display", "no"}, {"Binary Characters", "nodisplay", "no"}, {"Binary Char Counts", "nodisplay", "no"}, {"Seq Name", "display", "yes"}, {"Seq Accession", "display", "no"}, {"Show Internal Data", "display", "yes"}, {"Dyna Hide", "display", "yes"}, {"Taxonomy Scientific", "display", "yes"}, {"Taxonomy Common", "display", "no"}, {"Colorize by Annotation", "display", "no"}, {"Seq Symbol", "display", "yes"}, {"Rollover", "display", "yes"}, {"Relation Confidence", "nodisplay", "no"}, {"Vector Data", "nodisplay", "no"}, {"Taxonomy Images", "display", "no"}, {"Properties", "display", "no"}, {"Gene Name", "display", "yes"}, {"Multiple Seq Alignment", "display", "no"}, {"Branch Length Values", "display", "no"}};
    static final int display_as_phylogram = 0;
    static final int show_node_names = 1;
    static final int show_tax_code = 2;
    static final int show_annotation = 3;
    static final int write_confidence_values = 4;
    static final int write_events = 5;
    static final int color_according_to_species = 6;
    static final int color_according_to_sequence = 7;
    static final int use_style = 8;
    static final int width_branches = 9;
    static final int show_domain_architectures = 10;
    static final int show_binary_characters = 11;
    static final int show_binary_character_counts = 12;
    static final int show_seq_names = 13;
    static final int show_sequence_acc = 14;
    static final int display_internal_data = 15;
    static final int dynamically_hide_data = 16;
    static final int show_taxonomy_scientific_names = 17;
    static final int show_taxonomy_common_names = 18;
    static final int color_according_to_annotation = 19;
    static final int show_seq_symbols = 20;
    static final int node_data_popup = 21;
    static final int show_relation_confidence = 22;
    static final int show_vector_data = 23;
    static final int show_taxonomy_images = 24;
    static final int show_properties = 25;
    static final int show_gene_names = 26;
    static final int show_mol_seqs = 27;
    static final int write_branch_length_values = 28;
    static final String VALIDATE_AGAINST_PHYLOXML_XSD_SCHEMA = "validate_against_phyloxml_xsd_schema";
    private static Hashtable<String, Color> _sequence_colors;
    private static Hashtable<String, Color> _annotation_colors;
    private static Hashtable<String, Color> _domain_colors;
    private static Hashtable<String, Color> _species_colors;
    private static String DEFAULT_FONT_FAMILY;
    private static final int DEPRECATED = -2;
    private static final String DISPLAY_COLOR_KEY = "display_color";
    String config_filename;
    int default_clickto = 0;
    String default_config_filename = "_aptx_configuration_file";
    TreeColorSet tree_color_set;
    TreeFontSet tree_font_set;
    boolean verbose = false;
    private boolean _abbreviate_scientific_names = false;
    private boolean _antialias_screen = true;
    private boolean _background_color_gradient = false;
    private String _base_font_family_name = "";
    private int _base_font_size = -1;
    private Options.CLADOGRAM_TYPE _cladogram_type = Constants.CLADOGRAM_TYPE_DEFAULT;
    private boolean _color_labels_same_as_parent_branch = false;
    private int _default_bootstrap_samples = -1;
    private NodeVisualData.NodeFill _default_node_fill = NodeVisualData.NodeFill.SOLID;
    private NodeVisualData.NodeShape _default_node_shape = NodeVisualData.NodeShape.RECTANGLE;
    private short _default_node_shape_size = (short)4;
    private SortedMap<String, Color> _display_colors = null;
    private boolean _display_sequence_relations = false;
    private boolean _editable = true;
    private NodeDataField _ext_desc_data_to_return = NodeDataField.UNKNOWN;
    private EXT_NODE_DATA_RETURN_ON _ext_node_data_return_on = EXT_NODE_DATA_RETURN_ON.WINODW;
    private int _frame_x_size;
    private int _frame_y_size;
    private int _graphics_export_x = -1;
    private int _graphics_export_y = -1;
    private Color _gui_background_color = Constants.GUI_BACKGROUND_DEFAULT;
    private Color _gui_button_background_color = Constants.BUTTON_BACKGROUND_COLOR_DEFAULT;
    private Color _gui_button_border_color = Constants.BUTTON_BORDER_COLOR_DEFAULT;
    private Color _gui_button_text_color = Constants.BUTTON_TEXT_COLOR_DEFAULT;
    private Color _gui_checkbox_and_button_active_color = Constants.CHECKBOX_AND_BUTTON_ACTIVE_COLOR_DEFAULT;
    private Color _gui_checkbox_text_color = Constants.CHECKBOX_TEXT_COLOR_DEFAULT;
    private Color _gui_menu_background_color = Constants.MENU_BACKGROUND_COLOR_DEFAULT;
    private Color _gui_menu_text_color = Constants.MENU_TEXT_COLOR_DEFAULT;
    private boolean _hide_controls_and_menus = false;
    private boolean _internal_number_are_confidence_for_nh_parsing = false;
    private String _label_for_get_ext_descendents_data = "";
    private int _max_base_font_size = 20;
    private boolean _midpoint_root = false;
    private int _min_base_font_size = 2;
    private double _min_confidence_value = 0.0;
    private boolean _nh_parsing_replace_underscores = false;
    private Options.NODE_LABEL_DIRECTION _node_label_direction = Options.NODE_LABEL_DIRECTION.HORIZONTAL;
    private short _number_of_digits_after_comma_for_branch_length_values = (short)3;
    private short _number_of_digits_after_comma_for_confidence_values = (short)2;
    private short _ov_max_height = (short)80;
    private short _ov_max_width = (short)80;
    private Options.OVERVIEW_PLACEMENT_TYPE _ov_placement = Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT;
    private File _path_to_local_fastme = null;
    private File _path_to_local_mafft = null;
    private File _path_to_local_raxml = null;
    private Options.PHYLOGENY_GRAPHICS_TYPE _phylogeny_graphics_type = Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR;
    private float _print_line_width = 0.5f;
    private boolean _show_annotation_ref_source = true;
    private boolean _show_default_node_shapes_external = false;
    private boolean _show_default_node_shapes_for_marked_nodes = false;
    private boolean _show_default_node_shapes_internal = false;
    private boolean _show_domain_labels = true;
    private boolean _show_overview = true;
    private boolean _show_scale = false;
    private NHXParser.TAXONOMY_EXTRACTION _taxonomy_extraction = NHXParser.TAXONOMY_EXTRACTION.NO;
    private UI _ui = UI.UNKNOWN;
    private boolean _use_tabbed_display = false;
    private boolean _validate_against_phyloxml_xsd_schema = true;
    private Color _vector_data_min_color = Color.BLUE;
    private Color _vector_data_max_color = Color.YELLOW;
    private Color _vector_data_mean_color = Color.WHITE;
    private double _vector_data_height = 12.0;
    private int _vector_data_width = 120;
    private boolean _line_up_renderable_node_data = true;
    private boolean _right_align_domains = false;
    private boolean _allow_thick_strokes = false;

    public Configuration() {
        this(null, false, false, false);
    }

    public Configuration(String cf, boolean is_url, boolean is_applet, boolean verbose) {
        this.config_filename = ForesterUtil.isEmpty(cf) ? this.default_config_filename : cf;
        this.setDisplayColors(new TreeMap<String, Color>());
        this.config_filename = this.config_filename.trim();
        URL u = null;
        if (is_url) {
            try {
                u = new URL(this.config_filename);
                try {
                    InputStreamReader isr = new InputStreamReader(u.openStream());
                    BufferedReader bf = new BufferedReader(isr);
                    this.readConfig(bf);
                    bf.close();
                    ForesterUtil.programMessage("Archaeopteryx", "successfully read from configuration url [" + this.config_filename + "]");
                }
                catch (Exception e) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "failed to read configuration from [" + this.config_filename + "]: " + e.getLocalizedMessage());
                }
            }
            catch (Exception e) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "cannot find or open configuration url [" + this.config_filename + "]");
            }
        } else {
            File f = new File(this.config_filename);
            if (!f.exists()) {
                f = new File(this.config_filename + ".txt");
            }
            if (f.exists() && f.canRead()) {
                try {
                    BufferedReader bf = new BufferedReader(new FileReader(f));
                    this.readConfig(bf);
                    bf.close();
                }
                catch (Exception e) {
                    if (verbose) {
                        ForesterUtil.printWarningMessage("Archaeopteryx", "failed to read configuration from [" + this.config_filename + "]: " + e);
                    }
                }
            } else if (verbose) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "cannot find or open configuration file [" + this.config_filename + "]");
            }
        }
    }

    public String getBaseFontFamilyName() {
        return this._base_font_family_name;
    }

    public int getDefaultBootstrapSamples() {
        return this._default_bootstrap_samples;
    }

    public NodeVisualData.NodeFill getDefaultNodeFill() {
        return this._default_node_fill;
    }

    public NodeVisualData.NodeShape getDefaultNodeShape() {
        return this._default_node_shape;
    }

    public short getDefaultNodeShapeSize() {
        return this._default_node_shape_size;
    }

    public NodeDataField getExtDescNodeDataToReturn() {
        return this._ext_desc_data_to_return;
    }

    public EXT_NODE_DATA_RETURN_ON getExtNodeDataReturnOn() {
        return this._ext_node_data_return_on;
    }

    public int getFrameXSize() {
        return this._frame_x_size;
    }

    public int getFrameYSize() {
        return this._frame_y_size;
    }

    public String getLabelForGetExtDescendentsData() {
        return this._label_for_get_ext_descendents_data;
    }

    public File getPathToLocalFastme() {
        return this._path_to_local_fastme;
    }

    public File getPathToLocalMafft() {
        return this._path_to_local_mafft;
    }

    public File getPathToLocalRaxml() {
        return this._path_to_local_raxml;
    }

    public double getVectorDataHeight() {
        return this._vector_data_height;
    }

    public Color getVectorDataMaxColor() {
        return this._vector_data_max_color;
    }

    public Color getVectorDataMeanColor() {
        return this._vector_data_mean_color;
    }

    public Color getVectorDataMinColor() {
        return this._vector_data_min_color;
    }

    public int getVectorDataWidth() {
        return this._vector_data_width;
    }

    public boolean isAbbreviateScientificTaxonNames() {
        return this._abbreviate_scientific_names;
    }

    public boolean isAllowThickStrokes() {
        return this._allow_thick_strokes;
    }

    public boolean isBackgroundColorGradient() {
        return this._background_color_gradient;
    }

    public boolean isColorByTaxonomicGroup() {
        return false;
    }

    public boolean isColorLabelsSameAsParentBranch() {
        return this._color_labels_same_as_parent_branch;
    }

    public final boolean isLineUpRendarableNodeData() {
        return this._line_up_renderable_node_data;
    }

    public boolean isMidpointReroot() {
        return this._midpoint_root;
    }

    public final boolean isRightLineUpDomains() {
        return this._right_align_domains;
    }

    public boolean isShowAnnotationRefSource() {
        return this._show_annotation_ref_source;
    }

    public boolean isShowDefaultNodeShapesExternal() {
        return this._show_default_node_shapes_external;
    }

    public boolean isShowDefaultNodeShapesForMarkedNodes() {
        return this._show_default_node_shapes_for_marked_nodes;
    }

    public boolean isShowDefaultNodeShapesInternal() {
        return this._show_default_node_shapes_internal;
    }

    public boolean isShowDomainLabels() {
        return this._show_domain_labels;
    }

    public void putDisplayColors(String key, Color color) {
        this.getDisplayColors().put(key, color);
    }

    public void setAbbreviateScientificTaxonNames(boolean abbreviate_scientific_names) {
        this._abbreviate_scientific_names = abbreviate_scientific_names;
    }

    public void setAddTaxonomyImagesCB(boolean b) {
        Configuration.display_options[24][1] = b ? "yes" : "no";
    }

    public void setBackgroundColorGradient(boolean background_color_gradient) {
        this._background_color_gradient = background_color_gradient;
    }

    public void setBaseFontFamilyName(String base_font_family_name) {
        this._base_font_family_name = base_font_family_name;
    }

    public void setBaseFontSize(int base_font_size) {
        this._base_font_size = base_font_size;
    }

    public void setColorizeBranches(boolean b) {
        Configuration.display_options[8][2] = b ? "yes" : "no";
    }

    public void setColorLabelsSameAsParentBranch(boolean color_labels_same_as_parent_branch) {
        this._color_labels_same_as_parent_branch = color_labels_same_as_parent_branch;
    }

    public void setDefaultNodeFill(NodeVisualData.NodeFill default_node_fill) {
        this._default_node_fill = default_node_fill;
    }

    public void setDefaultNodeShape(NodeVisualData.NodeShape default_node_shape) {
        this._default_node_shape = default_node_shape;
    }

    public void setDefaultNodeShapeSize(short default_node_shape_size) {
        this._default_node_shape_size = default_node_shape_size;
    }

    public void setDisplayAsPhylogram(boolean b) {
        Configuration.display_options[0][2] = b ? "yes" : "no";
    }

    public void setDisplayColors(SortedMap<String, Color> display_colors) {
        this._display_colors = display_colors;
    }

    public void setDisplayConfidenceValues(boolean b) {
        Configuration.display_options[4][2] = b ? "yes" : "no";
    }

    public void setDisplayGeneNames(boolean b) {
        Configuration.display_options[26][2] = b ? "yes" : "no";
    }

    public void setDisplayInternalData(boolean b) {
        Configuration.display_options[15][2] = b ? "yes" : "no";
    }

    public void setDisplayMultipleSequenceAlignment(boolean b) {
        Configuration.display_options[27][2] = b ? "yes" : "no";
    }

    public void setDisplayNodeNames(boolean b) {
        Configuration.display_options[1][2] = b ? "yes" : "no";
    }

    public void setDisplaySequenceAcc(boolean b) {
        Configuration.display_options[14][2] = b ? "yes" : "no";
    }

    public void setDisplaySequenceNames(boolean b) {
        Configuration.display_options[13][2] = b ? "yes" : "no";
    }

    public void setDisplaySequenceRelations(boolean display_sequence_relations) {
        this._display_sequence_relations = display_sequence_relations;
    }

    public void setDisplaySequenceSymbols(boolean b) {
        Configuration.display_options[20][2] = b ? "yes" : "no";
    }

    public void setDisplayTaxonomyCode(boolean b) {
        Configuration.display_options[2][2] = b ? "yes" : "no";
    }

    public void setDisplayTaxonomyCommonNames(boolean b) {
        Configuration.display_options[18][2] = b ? "yes" : "no";
    }

    public void setDisplayTaxonomyImages(boolean b) {
        Configuration.display_options[24][2] = b ? "yes" : "no";
    }

    public void setDisplayTaxonomyScientificNames(boolean b) {
        Configuration.display_options[17][2] = b ? "yes" : "no";
    }

    public void setDynamicallyHideData(boolean b) {
        Configuration.display_options[16][2] = b ? "yes" : "no";
    }

    public void setExtDescNodeDataToReturn(NodeDataField ext_desc_data_to_return) {
        this._ext_desc_data_to_return = ext_desc_data_to_return;
    }

    public void setFrameXSize(int frame_x_size) {
        this._frame_x_size = frame_x_size;
    }

    public void setFrameYSize(int frame_y_size) {
        this._frame_y_size = frame_y_size;
    }

    public final void setLineUpRendarableNodeData(boolean line_up_renderable_node_data) {
        this._line_up_renderable_node_data = line_up_renderable_node_data;
    }

    public void setMidpointReroot(boolean midpoint_root) {
        this._midpoint_root = midpoint_root;
    }

    public void setMinConfidenceValue(double min_confidence_value) {
        this._min_confidence_value = min_confidence_value;
    }

    public void setNodeLabelDirection(Options.NODE_LABEL_DIRECTION node_label_direction) {
        this._node_label_direction = node_label_direction;
    }

    public void setNumberOfDigitsAfterCommaForBranchLengthValue(short number_of_digits_after_comma_for_branch_length_values) {
        this._number_of_digits_after_comma_for_branch_length_values = number_of_digits_after_comma_for_branch_length_values;
    }

    public void setNumberOfDigitsAfterCommaForConfidenceValues(short number_of_digits_after_comma_for_confidence_values) {
        this._number_of_digits_after_comma_for_confidence_values = number_of_digits_after_comma_for_confidence_values;
    }

    public void setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE phylogeny_graphics_type) {
        this._phylogeny_graphics_type = phylogeny_graphics_type;
    }

    public void setPrintLineWidth(float print_line_width) {
        this._print_line_width = print_line_width;
    }

    public void setReplaceUnderscoresInNhParsing(boolean nh_parsing_replace_underscores) {
        this._nh_parsing_replace_underscores = nh_parsing_replace_underscores;
    }

    public final void setRightLineUpDomains(boolean right_align_domains) {
        this._right_align_domains = right_align_domains;
    }

    public void setShowDefaultNodeShapesExternal(boolean show_default_node_shapes_external) {
        this._show_default_node_shapes_external = show_default_node_shapes_external;
    }

    public void setShowDefaultNodeShapesForMarkedNodes(boolean show_default_node_shapes_for_marked_nodes) {
        this._show_default_node_shapes_for_marked_nodes = show_default_node_shapes_for_marked_nodes;
    }

    public void setShowDefaultNodeShapesInternal(boolean show_default_node_shapes_internal) {
        this._show_default_node_shapes_internal = show_default_node_shapes_internal;
    }

    public void setShowDomainLabels(boolean show_domain_labels) {
        this._show_domain_labels = show_domain_labels;
    }

    public void setShowScale(boolean show_scale) {
        this._show_scale = show_scale;
    }

    public void setUseStyle(boolean b) {
        Configuration.display_options[8][2] = b ? "yes" : "no";
    }

    private int getClickToIndex(String name) {
        int index = -1;
        if (name.equals("edit_info")) {
            index = 0;
            ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [edit_info] is deprecated, use [display node data] instead");
        } else if (name.equals("display_node_data")) {
            index = 0;
        } else if (name.equals("collapse_uncollapse")) {
            index = 1;
        } else if (name.equals("reroot")) {
            index = 2;
        } else if (name.equals("subtree")) {
            index = 3;
        } else if (name.equals("swap")) {
            index = 4;
        } else if (name.equals("sort_descendants")) {
            index = 18;
        } else if (name.equals("get_ext_descendents_data")) {
            index = 19;
        } else {
            if (name.equals("display_sequences")) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [display_sequences] is deprecated");
                return -2;
            }
            if (name.equals("open_seq_web")) {
                index = 8;
            } else if (name.equals("open_pdb_web")) {
                index = 9;
            } else if (name.equals("open_tax_web")) {
                index = 10;
            } else if (name.equals("blast")) {
                index = 11;
            } else if (name.equals("cut_subtree")) {
                index = 12;
            } else if (name.equals("copy_subtree")) {
                index = 13;
            } else if (name.equals("paste_subtree")) {
                index = 14;
            } else if (name.equals("delete")) {
                index = 15;
            } else if (name.equals("add_new_node")) {
                index = 16;
            } else if (name.equals("edit_node_data")) {
                index = 17;
            } else if (name.equals("select_nodes")) {
                index = 20;
            } else {
                if (name.equals("display_node_popup")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [display_node_popup] is deprecated");
                    return -2;
                }
                if (name.equals("custom_option")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [custom_option] is deprecated");
                    return -2;
                }
                if (name.equals("color_subtree")) {
                    index = 7;
                } else if (name.equals("change_node_font")) {
                    index = 6;
                } else if (name.equals("color_node_font")) {
                    index = 5;
                } else if (name.equals("color_subtree")) {
                    index = 7;
                }
            }
        }
        return index;
    }

    private final void initSpeciesColors() {
        _species_colors = new Hashtable();
        for (String[] s : DEFAULT_SPECIES_COLORS) {
            _species_colors.put(s[0], Color.decode(s[1]));
        }
    }

    private boolean parseBoolean(String str) {
        String my_str = str.trim().toLowerCase();
        if (my_str.equals("yes") || my_str.equals("true")) {
            return true;
        }
        if (my_str.equals("no") || my_str.equals("false")) {
            return false;
        }
        ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse boolean value from [" + str + "]");
        return false;
    }

    private double parseDouble(String str) {
        double d = 0.0;
        try {
            d = Double.parseDouble(str.trim());
        }
        catch (Exception e) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse double from [" + str + "]");
            d = 0.0;
        }
        return d;
    }

    private float parseFloat(String str) {
        float f = 0.0f;
        try {
            f = Float.parseFloat(str.trim());
        }
        catch (Exception e) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse float from [" + str + "]");
            f = 0.0f;
        }
        return f;
    }

    private int parseInt(String str) {
        int i = -1;
        try {
            i = Integer.parseInt(str.trim());
        }
        catch (Exception e) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse integer from [" + str + "]");
            i = -1;
        }
        return i;
    }

    private short parseShort(String str) {
        int i = -1;
        try {
            i = Short.parseShort(str.trim());
        }
        catch (Exception e) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse short from [" + str + "]");
            i = -1;
        }
        return (short)i;
    }

    private void processFontFamily(StringTokenizer st) {
        String[] fonts;
        this.setBaseFontFamilyName("");
        String font_str = ((String)st.nextElement()).trim();
        for (String font : fonts = font_str.split(",+")) {
            font = font.replace('_', ' ').trim();
            if (Arrays.binarySearch(AptxUtil.getAvailableFontFamiliesSorted(), font) < 0) continue;
            this.setBaseFontFamilyName(font);
            break;
        }
    }

    private void readConfig(BufferedReader conf_in) throws IOException {
        String line;
        do {
            if ((line = conf_in.readLine()) == null || (line = line.trim()).startsWith("#") || ForesterUtil.isEmpty(line)) continue;
            line = line.replaceAll("\\s+", "\t");
            StringTokenizer st = new StringTokenizer(line, "\t");
            this.setKeyValue(st);
        } while (line != null);
    }

    private void setAntialiasScreen(boolean antialias_screen) {
        this._antialias_screen = antialias_screen;
    }

    private void setCladogramType(Options.CLADOGRAM_TYPE cladogram_type) {
        this._cladogram_type = cladogram_type;
    }

    private void setDefaultBootstrapSamples(int default_bootstrap_samples) {
        this._default_bootstrap_samples = default_bootstrap_samples;
    }

    private void setEditable(boolean editable) {
        this._editable = editable;
    }

    private void setExtNodeDataReturnOn(EXT_NODE_DATA_RETURN_ON ext_node_data_return_on) {
        this._ext_node_data_return_on = ext_node_data_return_on;
    }

    private void setGraphicsExportX(int graphics_export_x) {
        this._graphics_export_x = graphics_export_x;
    }

    private void setGraphicsExportY(int graphics_export_y) {
        this._graphics_export_y = graphics_export_y;
    }

    private void setInternalNumberAreConfidenceForNhParsing(boolean internal_number_are_confidence_for_nh_parsing) {
        this._internal_number_are_confidence_for_nh_parsing = internal_number_are_confidence_for_nh_parsing;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setKeyValue(StringTokenizer st) {
        String key = ((String)st.nextElement()).replace(':', ' ').trim().toLowerCase();
        if (!st.hasMoreElements()) {
            return;
        }
        if (key.equals("default_click_to")) {
            String clickto_name = (String)st.nextElement();
            this.default_clickto = this.getClickToIndex(clickto_name);
            if (this.default_clickto == -1) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "invalid value [" + clickto_name + "] for [default_click_to]");
                this.default_clickto = 0;
                return;
            }
            if (this.default_clickto != -2) return;
            return;
        } else {
            if (key.equals("native_ui")) {
                String my_str = ((String)st.nextElement()).trim().toLowerCase();
                if (my_str.equals("yes") || my_str.equals("true")) {
                    this._ui = UI.NATIVE;
                    return;
                }
                if (my_str.equals("no") || my_str.equals("false")) {
                    this._ui = UI.CROSSPLATFORM;
                    return;
                }
                if (my_str.equals("?")) {
                    this._ui = UI.UNKNOWN;
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse yes/no/? value from [" + my_str + "]");
                this._ui = UI.UNKNOWN;
                return;
            }
            if (key.equals(VALIDATE_AGAINST_PHYLOXML_XSD_SCHEMA)) {
                this.setValidatePhyloXmlAgainstSchema(this.parseBoolean((String)st.nextElement()));
                return;
            }
            if (key.equals("antialias_screen")) {
                this.setAntialiasScreen(this.parseBoolean((String)st.nextElement()));
                return;
            }
            if (key.equals("phylogeny_graphics_type")) {
                String type_str = ((String)st.nextElement()).trim();
                if (type_str.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX.toString())) {
                    this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
                    return;
                }
                if (type_str.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED.toString())) {
                    this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
                    return;
                }
                if (type_str.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE.toString())) {
                    this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
                    return;
                }
                if (type_str.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED.toString())) {
                    this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
                    return;
                }
                if (type_str.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR.toString())) {
                    this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
                    return;
                }
                if (type_str.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR.toString())) {
                    this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
                    return;
                }
                if (type_str.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED.toString())) {
                    this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
                    return;
                }
                if (type_str.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR.toString())) {
                    this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
                    return;
                }
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + type_str + "] for [phylogeny_graphics_type]");
                return;
            }
            if (key.equals("min_confidence_value")) {
                String mcv_str = ((String)st.nextElement()).trim();
                double d = this.parseDouble(mcv_str);
                this.setMinConfidenceValue(d);
                return;
            }
            if (key.equals("font_family")) {
                this.processFontFamily(st);
                return;
            }
            if (key.equals("font_size")) {
                String size_str = ((String)st.nextElement()).trim();
                int i = this.parseInt(size_str);
                if (i <= 0) return;
                this.setBaseFontSize(i);
                return;
            }
            if (key.equals("font_size_min")) {
                String size_str = ((String)st.nextElement()).trim();
                int i = this.parseInt(size_str);
                if (i <= 0) return;
                this.setMinBaseFontSize(i);
                return;
            }
            if (key.equals("font_size_max")) {
                String size_str = ((String)st.nextElement()).trim();
                int i = this.parseInt(size_str);
                if (i <= 1) return;
                this.setMaxBaseFontSize(i);
                return;
            }
            if (key.equals("graphics_export_x")) {
                String str = ((String)st.nextElement()).trim();
                int i = this.parseInt(str);
                if (i <= 0) return;
                this.setGraphicsExportX(i);
                return;
            }
            if (key.equals("graphics_export_y")) {
                String str = ((String)st.nextElement()).trim();
                int i = this.parseInt(str);
                if (i <= 0) return;
                this.setGraphicsExportY(i);
                return;
            }
            if (key.equals("pdf_export_line_width")) {
                String str = ((String)st.nextElement()).trim();
                float f = this.parseFloat(str);
                if (f > 0.0f) {
                    this.setPrintLineWidth(f);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "value for [pdf_export_line_width] cannot be zero or negative");
                return;
            }
            if (key.equals("window_initial_size_x")) {
                String str = ((String)st.nextElement()).trim();
                int i = this.parseInt(str);
                if (i <= 0) return;
                this.setFrameXSize(i);
                return;
            }
            if (key.equals("window_initial_size_y")) {
                String str = ((String)st.nextElement()).trim();
                int i = this.parseInt(str);
                if (i <= 0) return;
                this.setFrameYSize(i);
                return;
            }
            if (key.equals("default_number_of_bootstrap_resamples")) {
                String str = ((String)st.nextElement()).trim();
                int i = this.parseInt(str);
                if (i >= 0) {
                    this.setDefaultBootstrapSamples(i);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "value for [default_number_of_bootstrap_resamples] cannot be negative");
                return;
            }
            if (key.equals("mafft_local")) {
                String str = ((String)st.nextElement()).trim();
                if (ForesterUtil.isEmpty(str)) return;
                this.setPathToLocalMafft(new File(str));
                return;
            }
            if (key.equals("fastme_local")) {
                String str = ((String)st.nextElement()).trim();
                if (ForesterUtil.isEmpty(str)) return;
                this.setPathToLocalFastme(new File(str));
                return;
            }
            if (key.equals("raxml_local")) {
                String str = ((String)st.nextElement()).trim();
                if (ForesterUtil.isEmpty(str)) return;
                this.setPathToLocalRaxml(new File(str));
                return;
            }
            if (key.equals("show_scale")) {
                this.setShowScale(this.parseBoolean((String)st.nextElement()));
                return;
            }
            if (key.equals("show_overview")) {
                this.setShowOverview(this.parseBoolean((String)st.nextElement()));
                return;
            }
            if (key.equals("background_gradient")) {
                this.setBackgroundColorGradient(this.parseBoolean((String)st.nextElement()));
                return;
            }
            if (key.equals("color_labels_same_as_branch_length_values")) {
                this.setColorLabelsSameAsParentBranch(this.parseBoolean((String)st.nextElement()));
                return;
            }
            if (key.equals("show_domain_labels")) {
                this.setShowDomainLabels(this.parseBoolean((String)st.nextElement()));
                return;
            }
            if (key.equals("show_seq_annotation_ref_sources")) {
                this.setShowAnnotationRefSource(this.parseBoolean((String)st.nextElement()));
                return;
            }
            if (key.equals("abbreviate_scientific_names")) {
                this.setAbbreviateScientificTaxonNames(this.parseBoolean((String)st.nextElement()));
                return;
            }
            if (key.equals("cladogram_type")) {
                String type_str = ((String)st.nextElement()).trim();
                if (type_str.equalsIgnoreCase(Options.CLADOGRAM_TYPE.NON_LINED_UP.toString())) {
                    this.setCladogramType(Options.CLADOGRAM_TYPE.NON_LINED_UP);
                    return;
                }
                if (type_str.equalsIgnoreCase(Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP.toString())) {
                    this.setCladogramType(Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
                    return;
                }
                if (type_str.equalsIgnoreCase(Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP.toString())) {
                    this.setCladogramType(Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + type_str + "] for [cladogram_type]");
                return;
            }
            if (key.equals("non_lined_up_cladogram")) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [non_lined_up_cladogram] is deprecated, use [cladogram_type] instead");
                return;
            }
            if (key.equals("hide_controls_and_menus")) {
                this._hide_controls_and_menus = this.parseBoolean((String)st.nextElement());
                return;
            }
            if (key.equals("use_tabbed_display")) {
                this._use_tabbed_display = this.parseBoolean((String)st.nextElement());
                return;
            }
            if (key.equals("overview_width")) {
                short i = this.parseShort((String)st.nextElement());
                this.setOvMaxWidth(i);
                return;
            }
            if (key.equals("overview_height")) {
                short i = this.parseShort((String)st.nextElement());
                this.setOvMaxHeight(i);
                return;
            }
            if (key.equals("overview_placement_type")) {
                String type_str = ((String)st.nextElement()).trim();
                if (type_str.equalsIgnoreCase(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT.toTag())) {
                    this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT);
                    return;
                }
                if (type_str.equalsIgnoreCase(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_RIGHT.toTag())) {
                    this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_RIGHT);
                    return;
                }
                if (type_str.equalsIgnoreCase(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_LEFT.toTag())) {
                    this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_LEFT);
                    return;
                }
                if (type_str.equalsIgnoreCase(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_RIGHT.toTag())) {
                    this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_RIGHT);
                    return;
                }
                this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT);
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + type_str + "] for [overview_placement_type]");
                return;
            }
            if (key.equals("node_label_direction")) {
                String type_str = ((String)st.nextElement()).trim();
                if (type_str.equalsIgnoreCase(Options.NODE_LABEL_DIRECTION.HORIZONTAL.toString())) {
                    this.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
                    return;
                }
                if (type_str.equalsIgnoreCase(Options.NODE_LABEL_DIRECTION.RADIAL.toString())) {
                    this.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.RADIAL);
                    return;
                }
                this.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + type_str + "] for [node_label_direction]");
                return;
            }
            if (key.equals("branch_length_value_digits")) {
                short i = this.parseShort(((String)st.nextElement()).trim());
                if (i >= 0) {
                    this.setNumberOfDigitsAfterCommaForBranchLengthValue(i);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "illegal value [" + i + "] for [branch_length_value_digits]");
                return;
            }
            if (key.equals("confidence_value_digits")) {
                short i = this.parseShort(((String)st.nextElement()).trim());
                if (i >= 0) {
                    this.setNumberOfDigitsAfterCommaForConfidenceValues(i);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "illegal value [" + i + "] for [confidence_value_digits]");
                return;
            }
            if (key.equals("allow_editing")) {
                this.setEditable(this.parseBoolean((String)st.nextElement()));
                return;
            }
            if (key.equals("display_sequence_relations")) {
                this.setDisplaySequenceRelations(this.parseBoolean((String)st.nextElement()));
                return;
            }
            if (key.equals("replace_underscores_in_nh_parsing")) {
                boolean r = this.parseBoolean((String)st.nextElement());
                if (r && this.getTaxonomyExtraction() != NHXParser.TAXONOMY_EXTRACTION.NO) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "attempt to extract taxonomies and replace underscores at the same time");
                    return;
                }
                this.setReplaceUnderscoresInNhParsing(r);
                return;
            }
            if (key.equals("taxonomy_extraction_in_nh_parsing")) {
                String s = (String)st.nextElement();
                if (s.equalsIgnoreCase("no")) {
                    this.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.NO);
                } else if (s.equalsIgnoreCase("pfam_relaxed")) {
                    this.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_RELAXED);
                } else if (s.equalsIgnoreCase("pfam_strict")) {
                    this.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_STRICT);
                } else if (s.equalsIgnoreCase("aggressive")) {
                    this.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
                } else {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value for \"taxonomy_extraction_in_nh_parsing\": " + s + " (must be either: no, pfam_relaxed, pfam_strict, or aggressive)");
                }
                if (this.getTaxonomyExtraction() == NHXParser.TAXONOMY_EXTRACTION.NO) return;
                if (!this.isReplaceUnderscoresInNhParsing()) return;
                ForesterUtil.printWarningMessage("Archaeopteryx", "attempt to extract taxonomies and replace underscores at the same time");
                return;
            }
            if (key.equals("internal_labels_are_confidence_values")) {
                this.setInternalNumberAreConfidenceForNhParsing(this.parseBoolean((String)st.nextElement()));
                return;
            }
            if (key.equals("gui_background_color")) {
                this._gui_background_color = Color.decode((String)st.nextElement());
                return;
            }
            if (key.equals("gui_checkbox_text_color")) {
                this._gui_checkbox_text_color = Color.decode((String)st.nextElement());
                return;
            }
            if (key.equals("gui_checkbox_and_button_active_color")) {
                this._gui_checkbox_and_button_active_color = Color.decode((String)st.nextElement());
                return;
            }
            if (key.equals("gui_button_text_color")) {
                this._gui_button_text_color = Color.decode((String)st.nextElement());
                return;
            }
            if (key.equals("gui_button_background_color")) {
                this._gui_button_background_color = Color.decode((String)st.nextElement());
                return;
            }
            if (key.equals("gui_menu_background_color")) {
                this._gui_menu_background_color = Color.decode((String)st.nextElement());
                return;
            }
            if (key.equals("gui_menu_text_color")) {
                this._gui_menu_text_color = Color.decode((String)st.nextElement());
                return;
            }
            if (key.equals("gui_button_border_color")) {
                this._gui_button_border_color = Color.decode((String)st.nextElement());
                return;
            }
            if (key.equals("show_default_node_shapes_internal")) {
                this.setShowDefaultNodeShapesInternal(this.parseBoolean(((String)st.nextElement()).trim()));
                return;
            }
            if (key.equals("show_default_node_shapes_external")) {
                this.setShowDefaultNodeShapesExternal(this.parseBoolean(((String)st.nextElement()).trim()));
                return;
            }
            if (key.equals("show_node_shapes_for_nodes_with_vis_data")) {
                this.setShowDefaultNodeShapesForMarkedNodes(this.parseBoolean(((String)st.nextElement()).trim()));
                return;
            }
            if (key.equals("default_node_size")) {
                short i = this.parseShort(((String)st.nextElement()).trim());
                this.setDefaultNodeShapeSize(i);
                return;
            }
            if (key.equals("default_node_fill")) {
                String fill_str = ((String)st.nextElement()).trim();
                if (fill_str.equalsIgnoreCase(NodeVisualData.NodeFill.NONE.toString())) {
                    this.setDefaultNodeFill(NodeVisualData.NodeFill.NONE);
                    return;
                }
                if (fill_str.equalsIgnoreCase(NodeVisualData.NodeFill.GRADIENT.toString())) {
                    this.setDefaultNodeFill(NodeVisualData.NodeFill.GRADIENT);
                    return;
                }
                if (fill_str.equalsIgnoreCase(NodeVisualData.NodeFill.SOLID.toString())) {
                    this.setDefaultNodeFill(NodeVisualData.NodeFill.SOLID);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + fill_str + "] for [default_node_fill]");
                return;
            }
            if (key.equals("default_node_shape")) {
                String shape_str = ((String)st.nextElement()).trim();
                if (shape_str.equalsIgnoreCase(NodeVisualData.NodeShape.CIRCLE.toString())) {
                    this.setDefaultNodeShape(NodeVisualData.NodeShape.CIRCLE);
                    return;
                }
                if (shape_str.equalsIgnoreCase(NodeVisualData.NodeShape.RECTANGLE.toString())) {
                    this.setDefaultNodeShape(NodeVisualData.NodeShape.RECTANGLE);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + shape_str + "] for [default_node_shape]");
                return;
            }
            if (key.equals("midpoint_reroot")) {
                this.setMidpointReroot(this.parseBoolean((String)st.nextElement()));
                return;
            }
            if (key.equals("list_node_data_field") || key.equals("ext_descendents_data_to_return")) {
                String s = ((String)st.nextElement()).trim();
                if (s.equalsIgnoreCase("node_name")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.NODE_NAME);
                    return;
                }
                if (s.equalsIgnoreCase("sequence_acc")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.SEQUENCE_ACC);
                    return;
                }
                if (s.equalsIgnoreCase("sequence_mol_seq_fasta")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.SEQUENCE_MOL_SEQ_FASTA);
                    return;
                }
                if (s.equalsIgnoreCase("sequence_name")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.SEQUENCE_NAME);
                    return;
                }
                if (s.equalsIgnoreCase("gene_name")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.GENE_NAME);
                    return;
                }
                if (s.equalsIgnoreCase("sequence_symbol")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.SEQUENCE_SYMBOL);
                    return;
                }
                if (s.equalsIgnoreCase("taxonomy_scientific_name")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.TAXONOMY_SCIENTIFIC_NAME);
                    return;
                }
                if (s.equalsIgnoreCase("taxonomy_code")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.TAXONOMY_CODE);
                    return;
                }
                if (s.equalsIgnoreCase("user_selected")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.UNKNOWN);
                    return;
                }
                if (s.equalsIgnoreCase("domains")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.DOMAINS_ALL);
                    return;
                }
                if (s.equalsIgnoreCase("domains_collapsed")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.DOMAINS_COLLAPSED_PER_PROTEIN);
                    return;
                }
                if (s.equalsIgnoreCase("seq_annotations")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.SEQ_ANNOTATIONS);
                    return;
                }
                if (s.equalsIgnoreCase("go_term_ids")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.GO_TERM_IDS);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + s + "] for [ext_descendents_data_to_return]");
                return;
            }
            if (key.equals("list_node_data_custom_label") || key.equals("label_for_get_ext_descendents_data")) {
                String s = ((String)st.nextElement()).trim();
                if (ForesterUtil.isEmpty(s)) return;
                if (s.length() <= 1) return;
                this.setLabelForGetExtDescendentsData(s.replaceAll("_", " "));
                return;
            }
            if (key.equals("list_node_data_in") || key.equals("ext_descendents_data_to_return_on")) {
                String s = ((String)st.nextElement()).trim().toLowerCase();
                if (s.equals("console")) {
                    this.setExtNodeDataReturnOn(EXT_NODE_DATA_RETURN_ON.CONSOLE);
                    return;
                }
                if (s.equals("window")) {
                    this.setExtNodeDataReturnOn(EXT_NODE_DATA_RETURN_ON.WINODW);
                    return;
                }
                if (s.equals("buffer_only")) {
                    this.setExtNodeDataReturnOn(EXT_NODE_DATA_RETURN_ON.BUFFER_ONLY);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + s + "] for [ext_descendents_data_to_return_on]");
                return;
            }
            if (key.equals("vector_data_min_color")) {
                this._vector_data_min_color = Color.decode((String)st.nextElement());
                return;
            }
            if (key.equals("vector_data_max_color")) {
                this._vector_data_max_color = Color.decode((String)st.nextElement());
                return;
            }
            if (key.equals("vector_data_mean_color")) {
                this._vector_data_mean_color = Color.decode((String)st.nextElement());
                return;
            }
            if (key.equals("vector_data_width")) {
                this._vector_data_width = this.parseShort((String)st.nextElement());
                if (this._vector_data_width >= 1) return;
                this._vector_data_width = 120;
                return;
            }
            if (key.equals("vector_data_height")) {
                this._vector_data_height = this.parseShort((String)st.nextElement());
                if (!(this._vector_data_height < 1.0)) return;
                this._vector_data_height = 12.0;
                return;
            }
            if (key.equals("line_up_renderable_data")) {
                this.setLineUpRendarableNodeData(this.parseBoolean((String)st.nextElement()));
                return;
            }
            if (key.equals("right_align_domain_architectures")) {
                this.setRightLineUpDomains(this.parseBoolean((String)st.nextElement()));
                return;
            }
            if (key.equals("allow_thick_strokes")) {
                this._allow_thick_strokes = this.parseBoolean((String)st.nextElement());
                return;
            }
            if (st.countTokens() >= 2) {
                int key_index = -1;
                if (key.equals("phylogram")) {
                    key_index = 0;
                } else if (key.equals("rollover")) {
                    key_index = 21;
                } else if (key.equals("color_according_to_species")) {
                    key_index = 6;
                } else if (key.equals("color_according_to_sequence")) {
                    key_index = 7;
                } else if (key.equals("show_node_names")) {
                    key_index = 1;
                } else if (key.equals("show_taxonomy_code")) {
                    key_index = 2;
                } else if (key.equals("write_confidence_values")) {
                    key_index = 4;
                } else if (key.equals("write_branch_length_values")) {
                    key_index = 28;
                } else if (key.equals("write_events")) {
                    key_index = 5;
                } else if (key.equals("use_visual_styles")) {
                    key_index = 8;
                } else if (key.equals("color_branches")) {
                    key_index = 8;
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [color_branches] is deprecated, use [use_visual_styles] instead");
                } else if (key.equals("width_branches")) {
                    key_index = 9;
                } else if (key.equals("show_domain_architectures")) {
                    key_index = 10;
                } else if (key.equals("show_msa")) {
                    key_index = 27;
                } else if (key.equals("show_annotations")) {
                    key_index = 3;
                } else if (key.equals("show_binary_characters")) {
                    key_index = 11;
                } else if (key.equals("show_binary_character_counts")) {
                    key_index = 12;
                } else if (key.equals("show_seq_names")) {
                    key_index = 13;
                } else if (key.equals("show_gene_names")) {
                    key_index = 26;
                } else if (key.equals("show_seq_symbols")) {
                    key_index = 20;
                } else if (key.equals("show_seq_acc")) {
                    key_index = 14;
                } else if (key.equals("display_internal_data")) {
                    key_index = 15;
                } else if (key.equals("dynamically_hide_data")) {
                    key_index = 16;
                } else if (key.equals("show_taxonomy_scientific_names")) {
                    key_index = 17;
                } else if (key.equals("show_taxonomy_common_names")) {
                    key_index = 18;
                } else if (key.equals("show_taxonomy_images")) {
                    key_index = 24;
                } else if (key.equals("color_according_to_annotation")) {
                    key_index = 19;
                } else if (key.equals("show_vector_data")) {
                    key_index = 23;
                } else if (key.equals("show_properties")) {
                    key_index = 25;
                } else if (key.equals("show_relation_confidence")) {
                    key_index = 22;
                }
                if (key_index >= 0) {
                    Configuration.display_options[key_index][1] = (String)st.nextElement();
                    Configuration.display_options[key_index][2] = (String)st.nextElement();
                    return;
                }
                if (key_index == -2) {
                    return;
                }
                if (key.equals("click_to")) {
                    String click_to_name = (String)st.nextElement();
                    key_index = this.getClickToIndex(click_to_name);
                    if (key_index >= 0) {
                        Configuration.clickto_options[key_index][1] = (String)st.nextElement();
                        return;
                    }
                    if (key_index == -2) {
                        return;
                    }
                    ForesterUtil.printWarningMessage("Archaeopteryx", "unknown click-to option: " + click_to_name);
                    return;
                }
                if (key.equals("species_color")) {
                    this.getSpeciesColors().put(((String)st.nextElement()).replace('_', ' '), Color.decode((String)st.nextElement()));
                    return;
                }
                if (key.equals("sequence_color")) {
                    this.getSequenceColors().put(((String)st.nextElement()).replace('_', ' '), Color.decode((String)st.nextElement()));
                    return;
                }
                if (key.equals("domain_color")) {
                    this.getDomainColors().put((String)st.nextElement(), Color.decode((String)st.nextElement()));
                    return;
                }
                if (key.equals("annotation_color")) {
                    this.getAnnotationColors().put((String)st.nextElement(), Color.decode((String)st.nextElement()));
                    return;
                }
                if (key.equals("function_color")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [function_color] is deprecated");
                    return;
                }
                if (key.equals(DISPLAY_COLOR_KEY)) {
                    this.putDisplayColors((String)st.nextElement(), Color.decode((String)st.nextElement()));
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown configuration key [" + key + "] in: " + this.config_filename);
                return;
            }
            ForesterUtil.printWarningMessage("Archaeopteryx", "unknown configuration key [" + key + "] in: " + this.config_filename);
        }
    }

    private void setLabelForGetExtDescendentsData(String label_for_get_ext_descendents_data) {
        this._label_for_get_ext_descendents_data = label_for_get_ext_descendents_data;
    }

    private void setMaxBaseFontSize(int max_base_font_size) {
        this._max_base_font_size = max_base_font_size;
    }

    private void setMinBaseFontSize(int min_base_font_size) {
        this._min_base_font_size = min_base_font_size;
    }

    private void setOvMaxHeight(short ov_max_height) {
        this._ov_max_height = ov_max_height;
    }

    private void setOvMaxWidth(short ov_max_width) {
        this._ov_max_width = ov_max_width;
    }

    private void setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE ov_placement) {
        this._ov_placement = ov_placement;
    }

    private void setPathToLocalFastme(File path_to_local_fastme) {
        this._path_to_local_fastme = path_to_local_fastme;
    }

    private void setPathToLocalMafft(File path_to_local_mafft) {
        this._path_to_local_mafft = path_to_local_mafft;
    }

    private void setPathToLocalRaxml(File path_to_local_raxml) {
        this._path_to_local_raxml = path_to_local_raxml;
    }

    private void setShowAnnotationRefSource(boolean b) {
        this._show_annotation_ref_source = b;
    }

    private void setShowOverview(boolean show_overview) {
        this._show_overview = show_overview;
    }

    private void setValidatePhyloXmlAgainstSchema(boolean validate_against_phyloxml_xsd_schema) {
        this._validate_against_phyloxml_xsd_schema = validate_against_phyloxml_xsd_schema;
    }

    boolean displaySequenceRelations() {
        return this._display_sequence_relations;
    }

    boolean doCheckOption(int which) {
        return display_options[which][2].equalsIgnoreCase("yes") || display_options[which][2].equalsIgnoreCase("true");
    }

    boolean doDisplayClickToOption(int which) {
        return clickto_options[which][1].equalsIgnoreCase("display");
    }

    boolean doDisplayOption(int which) {
        return display_options[which][1].equalsIgnoreCase("display");
    }

    boolean doGuessCheckOption(int which) {
        return display_options[which][2].equals("?");
    }

    Map<String, Color> getAnnotationColors() {
        if (_annotation_colors == null) {
            _annotation_colors = new Hashtable();
        }
        return _annotation_colors;
    }

    int getBaseFontSize() {
        return this._base_font_size;
    }

    Options.CLADOGRAM_TYPE getCladogramType() {
        return this._cladogram_type;
    }

    int getClickToOptionsCount() {
        return clickto_options.length;
    }

    String getClickToTitle(int which) {
        return clickto_options[which][0];
    }

    int getDefaultDisplayClicktoOption() {
        return this.default_clickto;
    }

    SortedMap<String, Color> getDisplayColors() {
        return this._display_colors;
    }

    String getDisplayTitle(int which) {
        return display_options[which][0];
    }

    Map<String, Color> getDomainColors() {
        if (_domain_colors == null) {
            _domain_colors = new Hashtable();
        }
        return _domain_colors;
    }

    int getGraphicsExportX() {
        return this._graphics_export_x;
    }

    int getGraphicsExportY() {
        return this._graphics_export_y;
    }

    Color getGuiBackgroundColor() {
        return this._gui_background_color;
    }

    Color getGuiButtonBackgroundColor() {
        return this._gui_button_background_color;
    }

    Color getGuiButtonBorderColor() {
        return this._gui_button_border_color;
    }

    Color getGuiButtonTextColor() {
        return this._gui_button_text_color;
    }

    Color getGuiCheckboxAndButtonActiveColor() {
        return this._gui_checkbox_and_button_active_color;
    }

    Color getGuiCheckboxTextColor() {
        return this._gui_checkbox_text_color;
    }

    Color getGuiMenuBackgroundColor() {
        return this._gui_menu_background_color;
    }

    Color getGuiMenuTextColor() {
        return this._gui_menu_text_color;
    }

    int getMaxBaseFontSize() {
        return this._max_base_font_size;
    }

    int getMinBaseFontSize() {
        return this._min_base_font_size;
    }

    double getMinConfidenceValue() {
        return this._min_confidence_value;
    }

    Options.NODE_LABEL_DIRECTION getNodeLabelDirection() {
        return this._node_label_direction;
    }

    short getNumberOfDigitsAfterCommaForBranchLengthValues() {
        return this._number_of_digits_after_comma_for_branch_length_values;
    }

    short getNumberOfDigitsAfterCommaForConfidenceValues() {
        return this._number_of_digits_after_comma_for_confidence_values;
    }

    short getOvMaxHeight() {
        return this._ov_max_height;
    }

    short getOvMaxWidth() {
        return this._ov_max_width;
    }

    Options.OVERVIEW_PLACEMENT_TYPE getOvPlacement() {
        return this._ov_placement;
    }

    Options.PHYLOGENY_GRAPHICS_TYPE getPhylogenyGraphicsType() {
        return this._phylogeny_graphics_type;
    }

    float getPrintLineWidth() {
        return this._print_line_width;
    }

    Hashtable<String, Color> getSequenceColors() {
        if (_sequence_colors == null) {
            _sequence_colors = new Hashtable();
        }
        return _sequence_colors;
    }

    Hashtable<String, Color> getSpeciesColors() {
        if (_species_colors == null) {
            this.initSpeciesColors();
        }
        return _species_colors;
    }

    final NHXParser.TAXONOMY_EXTRACTION getTaxonomyExtraction() {
        return this._taxonomy_extraction;
    }

    boolean isAntialiasScreen() {
        return this._antialias_screen;
    }

    boolean isDrawAsPhylogram() {
        return this.doCheckOption(0);
    }

    boolean isEditable() {
        return this._editable;
    }

    boolean isHideControlPanelAndMenubar() {
        return this._hide_controls_and_menus;
    }

    boolean isInternalNumberAreConfidenceForNhParsing() {
        return this._internal_number_are_confidence_for_nh_parsing;
    }

    boolean isReplaceUnderscoresInNhParsing() {
        return this._nh_parsing_replace_underscores;
    }

    boolean isShowOverview() {
        return this._show_overview;
    }

    boolean isShowScale() {
        return this._show_scale;
    }

    final boolean isUseNativeUI() {
        if (this._ui == UI.UNKNOWN && ForesterUtil.isMac()) {
            this._ui = UI.NATIVE;
        }
        return this._ui == UI.NATIVE;
    }

    boolean isUseTabbedDisplay() {
        return this._use_tabbed_display;
    }

    boolean isValidatePhyloXmlAgainstSchema() {
        return this._validate_against_phyloxml_xsd_schema;
    }

    final void setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION taxonomy_extraction) {
        this._taxonomy_extraction = taxonomy_extraction;
    }

    static String getDefaultFontFamilyName() {
        return DEFAULT_FONT_FAMILY;
    }

    static {
        DEFAULT_FONT_FAMILY = "";
        for (String font_name : Constants.DEFAULT_FONT_CHOICES) {
            if (Arrays.binarySearch(AptxUtil.getAvailableFontFamiliesSorted(), font_name) < 0) continue;
            DEFAULT_FONT_FAMILY = font_name;
            break;
        }
        if (ForesterUtil.isEmpty(DEFAULT_FONT_FAMILY)) {
            DEFAULT_FONT_FAMILY = Constants.DEFAULT_FONT_CHOICES[Constants.DEFAULT_FONT_CHOICES.length - 1];
        }
    }

    static enum TRIPLET {
        FALSE,
        TRUE,
        UNKNOWN;

    }

    public static enum UI {
        CROSSPLATFORM,
        NATIVE,
        NIMBUS,
        UNKNOWN;

    }

    public static enum EXT_NODE_DATA_RETURN_ON {
        BUFFER_ONLY,
        CONSOLE,
        WINODW;

    }
}

