/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.text.SimpleDateFormat;
import java.util.Calendar;

public final class ProcessRunning {
    private static long count = 0L;
    private final long _id;
    private final String _name;
    private final String _start;

    public long getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getStart() {
        return this._start;
    }

    public String toString() {
        return this.getName() + " [id=" + this.getId() + "] [start=" + this.getStart() + "]";
    }

    static synchronized ProcessRunning createInstance(String name) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        return new ProcessRunning(count++, name, sdf.format(cal.getTime()));
    }

    private ProcessRunning(long id, String name, String start) {
        if (id < 0L) {
            throw new IllegalArgumentException("process id cannot be negative");
        }
        this._id = id;
        this._name = name;
        this._start = start;
    }
}

